/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.rptclient.gr.rptclient.query.QuerySolutionVO;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class QuerySolutionDAO {
    public static QuerySolutionVO getQuerySolutionVO(String id) throws Exception {
        QuerySolutionVO vo = new QuerySolutionVO();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FName, FEntityViewInfo, FParentUIName, FIsUserDefaultSolu,");
        sql.append(" FSolutionType from t_eas_querySolution where fid = ?");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{id});
        if (!rowSet.next()) {
            return null;
        }
        vo.setName(rowSet.getString("FName"));
        vo.setEntityView(rowSet.getString("FEntityViewInfo"));
        vo.setParentUIName(rowSet.getString("FParentUIName"));
        vo.setIsUserDefaultSolu(rowSet.getBoolean("FIsUserDefaultSolu"));
        vo.setSolutionType(SolutionTypeEnum.getEnum((String)rowSet.getString("FSolutionType")));
        vo.setId(id);
        return vo;
    }

    public static List getQuerySolutionByType(String parentUIName) throws Exception {
        ArrayList<QuerySolutionVO> result = new ArrayList<QuerySolutionVO>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FName, FEntityViewInfo, FParentUIName, FIsUserDefaultSolu,");
        sql.append(" FSolutionType from t_eas_querySolution where FParentUIName = ?");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{parentUIName});
        while (rowSet.next()) {
            QuerySolutionVO vo = new QuerySolutionVO();
            vo.setName(rowSet.getString("FName"));
            vo.setEntityView(rowSet.getString("FEntityViewInfo"));
            vo.setParentUIName(rowSet.getString("FParentUIName"));
            vo.setIsUserDefaultSolu(rowSet.getBoolean("FIsUserDefaultSolu"));
            vo.setSolutionType(SolutionTypeEnum.getEnum((String)rowSet.getString("FSolutionType")));
            vo.setId(rowSet.getString("FId"));
            result.add(vo);
        }
        return result;
    }

    public static String getSameNameSolutionID(String name, String parentUIName) throws BOSException {
        String sql = "select FId from t_eas_querySolution where FName = ? and FParentUIName = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{name, parentUIName});
        try {
            if (rowSet.next()) {
                return rowSet.getString("FId");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    public static QuerySolutionVO getSameNameSolution(String name, String parentUIName) throws Exception {
        String id = QuerySolutionDAO.getSameNameSolutionID(name, parentUIName);
        if (id != null) {
            return QuerySolutionDAO.getQuerySolutionVO(id);
        }
        return null;
    }

    public static QuerySolutionVO getUserDefaultSolutionByType(String parentUIName) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FName, FEntityViewInfo, FParentUIName, FIsUserDefaultSolu,");
        sql.append(" FSolutionType from t_eas_querySolution where FParentUIName = ?");
        sql.append(" and FIsUserDefaultSolu = 1");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{parentUIName});
        QuerySolutionVO vo = null;
        if (rowSet.next()) {
            vo = new QuerySolutionVO();
            vo.setName(rowSet.getString("FName"));
            vo.setEntityView(rowSet.getString("FEntityViewInfo"));
            vo.setParentUIName(rowSet.getString("FParentUIName"));
            vo.setIsUserDefaultSolu(rowSet.getBoolean("FIsUserDefaultSolu"));
            vo.setSolutionType(SolutionTypeEnum.getEnum((String)rowSet.getString("FSolutionType")));
            vo.setId(rowSet.getString("FId"));
        }
        return vo;
    }

    public static void addNew(QuerySolutionVO vo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_eas_querySolution ");
        sql.append("(FId, FName, FEntityViewInfo, FParentUIName, FIsUserDefaultSolu, ");
        sql.append(" FSolutionType) values(?,?,?,?,?,?)");
        Object[] params = new Object[]{Uuid.create().toString(), vo.getName(), vo.getEntityView(), vo.getParentUIName(), vo.getIsUserDefaultSolu() ? new Integer(1) : new Integer(0), Integer.valueOf(vo.getSolutionType().getValue())};
        DbUtil.execute(sql.toString(), params);
    }

    public static void store(QuerySolutionVO vo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_eas_querySolution ");
        sql.append(" set FName = ?, FEntityViewInfo = ?, ");
        sql.append(" FParentUIName = ?, FIsUserDefaultSolu = ?, ");
        sql.append(" FSolutionType = ? where FId = ?");
        Object[] params = new Object[]{vo.getName(), vo.getEntityView(), vo.getParentUIName(), vo.getIsUserDefaultSolu() ? new Integer(1) : new Integer(0), Integer.valueOf(vo.getSolutionType().getValue()), vo.getId()};
        DbUtil.execute(sql.toString(), params);
    }

    public static void delete(String id) throws BOSException {
        String sql = "delete t_eas_querySolution where FId = ?";
        DbUtil.execute(sql, new Object[]{id});
    }
}

