/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.tools.ftp;

import com.kingdee.eas.rptclient.gr.tools.ftp.FileInfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FTPSearch
extends Thread {
    String _host;
    static final int PORT = 21;
    ServerSocket ss;
    Socket _ds;
    Socket _sc;
    PrintStream _out;
    String _hostAddress;
    BufferedReader _in;
    BufferedReader _dataIn;
    String _reply;
    protected StringBuffer _log = new StringBuffer(10000);
    Vector _result;
    String _user;
    String _pass;

    public FTPSearch(String ip, String user, String pass) {
        this._host = ip;
        this._user = user;
        this._pass = pass;
        this._result = new Vector();
    }

    public FTPSearch(String ip) {
        this._host = ip;
        this._user = "anonymous";
        this._pass = "name_zm@sohu.com";
        this._result = new Vector();
    }

    protected boolean login() throws UnknownHostException, IOException {
        boolean successful = false;
        StringBuffer reply = new StringBuffer();
        this._sc = new Socket(this._host, 21);
        this._hostAddress = this._sc.getLocalAddress().getHostAddress().replace('.', ',');
        this._sc.setSoTimeout(15000);
        this._out = new PrintStream(this._sc.getOutputStream(), true);
        this._in = new BufferedReader(new InputStreamReader(this._sc.getInputStream()));
        reply.append(this.readReply().trim());
        if (reply.toString().startsWith("220") && this.comm("USER " + this._user) && this.comm("PASS " + this._pass)) {
            successful = true;
        }
        this.comm("TYPE A");
        return successful;
    }

    protected String getCurrentDir() throws IOException {
        String currentDir = null;
        if (this.comm("PWD")) {
            StringTokenizer st = new StringTokenizer(this._reply);
            st.nextToken();
            StringBuffer rtDir = new StringBuffer(st.nextToken());
            currentDir = rtDir.substring(1, rtDir.length() - 1);
        }
        return currentDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search() throws IOException, InterruptedException {
        try {
            try {
                for (int i = 0; i < 5 && !this.login(); ++i) {
                    System.out.println("Wait 10 seconds to try again...");
                    FTPSearch.sleep(10000L);
                }
                this.scan();
                this.logout();
            }
            catch (IOException iOException) {
                Object var3_4 = null;
                PrintStream out = new PrintStream(new FileOutputStream("Log.txt"));
                out.println(this._log);
                out.close();
                this.printResult("result.txt");
                return;
            }
            Object var3_3 = null;
            PrintStream out = new PrintStream(new FileOutputStream("Log.txt"));
            out.println(this._log);
            out.close();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            PrintStream out = new PrintStream(new FileOutputStream("Log.txt"));
            out.println(this._log);
            out.close();
            this.printResult("result.txt");
            throw throwable;
        }
        this.printResult("result.txt");
    }

    protected void scan() throws IOException {
        String temp;
        Vector<String> fileNames = new Vector<String>();
        this.tellPort();
        this.comm("LIST -R");
        try {
            this._ds = this.ss.accept();
            System.out.println(this.ss.toString());
        }
        catch (IOException ex) {
            this.ss.close();
        }
        this._dataIn = new BufferedReader(new InputStreamReader(this._ds.getInputStream()));
        System.out.println("Scanning now.Please waiting......");
        try {
            temp = "";
            while ((temp = this._dataIn.readLine()) != null) {
                fileNames.add(temp);
                if (temp != null) continue;
                break;
            }
        }
        catch (InterruptedIOException ex) {
            System.out.println("Caught InterruptedIOException1:" + ex);
        }
        try {
            do {
                temp = this._in.readLine();
                this._log.append(temp + "r");
                System.out.println(temp);
            } while (this._in.ready());
        }
        catch (InterruptedIOException ex) {
            System.out.println("Caught InterruptedIOException2:" + ex);
        }
        this._result = fileNames;
    }

    public Vector getResult() {
        return this._result;
    }

    public StringBuffer getLog() {
        return this._log;
    }

    public static Vector parse() throws FileNotFoundException, IOException {
        Vector<FileInfo> result = new Vector<FileInfo>();
        FileInputStream fileIn = new FileInputStream("result.txt");
        BufferedReader fReader = new BufferedReader(new InputStreamReader(fileIn));
        String dir = "/";
        System.out.println("Parsing now.Please wait......");
        while (fReader.ready()) {
            String cont;
            String description;
            String temp = fReader.readLine();
            StringTokenizer tt = new StringTokenizer(temp);
            if (tt.countTokens() == 1) {
                dir = temp.startsWith("/") ? temp.replace(':', ' ').trim() + "/" : "/" + temp.replace(':', ' ').trim() + "/";
            }
            if (!temp.equals("") && (temp.startsWith("-") || temp.startsWith("b") || temp.startsWith("c") || temp.startsWith("l"))) {
                for (int i = 0; i < 4; ++i) {
                    tt.nextToken();
                }
                description = "";
                for (int i = 0; i < 4; ++i) {
                    description = description + tt.nextToken() + " ";
                }
                cont = "";
                do {
                    cont = cont + tt.nextToken() + " ";
                } while (tt.hasMoreTokens());
                result.add(new FileInfo(dir + cont.trim(), description.trim()));
                continue;
            }
            if (temp.startsWith("d")) {
                for (int i = 0; i < 4; ++i) {
                    tt.nextToken();
                }
                description = "";
                for (int i = 0; i < 4; ++i) {
                    description = description + tt.nextToken() + " ";
                }
                cont = "";
                do {
                    cont = cont + tt.nextToken() + " ";
                } while (tt.hasMoreTokens());
                result.add(new FileInfo(dir + cont.trim() + "/", description.trim()));
                continue;
            }
            if (!temp.equals("")) continue;
        }
        return result;
    }

    protected void logout() throws IOException {
        this.comm("QUIT");
    }

    protected void printResult(String resultFile) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(resultFile));
        int len = this._result.size();
        for (int i = 0; i < len; ++i) {
            out.println(this._result.elementAt(i));
        }
        out.close();
    }

    protected boolean comm(String command) throws IOException {
        boolean success = false;
        this._out.println(command);
        System.out.println("<COMMAND>" + command);
        this._log.append("<COMMAND>" + command + "r");
        this._reply = this.readReply();
        if (command.startsWith("USER")) {
            success = this._reply.startsWith("331");
        } else if (command.startsWith("PASS")) {
            success = this._reply.startsWith("230");
            try {
                this.readReply();
            }
            catch (InterruptedIOException interruptedIOException) {}
        } else if (command.equals("TYPE A")) {
            success = this._reply.startsWith("200");
        } else if (command.startsWith("PORT")) {
            success = this._reply.startsWith("200");
        } else if (command.startsWith("LIST")) {
            success = this._reply.startsWith("150");
        } else if (command.startsWith("NLST")) {
            success = this._reply.startsWith("150");
        } else if (command.equals("PWD")) {
            success = this._reply.startsWith("257");
        } else if (command.startsWith("STAT")) {
            success = this._reply.startsWith("211");
        } else if (command.equals("SYST")) {
            success = this._reply.startsWith("215");
        } else if (command.startsWith("SITE")) {
            success = this._reply.startsWith("214");
        } else if (command.equals("QUIT")) {
            success = this._reply.startsWith("221");
        }
        return success;
    }

    public static void printVector(Vector vct) {
        int size = vct.size();
        for (int i = 0; i < size; ++i) {
            System.out.println(vct.elementAt(i));
        }
    }

    protected String readReply() throws IOException, InterruptedIOException {
        StringBuffer reply = new StringBuffer();
        do {
            reply.append(this._in.readLine() + "r");
        } while (this._in.ready());
        System.out.println(reply);
        this._log.append(reply);
        this._reply = reply.toString();
        return this._reply;
    }

    private int getDataPort() {
        int port = this._sc.getLocalPort() + 1;
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tellPort() throws IOException {
        int port = this.getDataPort();
        System.out.println("Get data port:" + port);
        int x = (int)Math.round((double)(port / 256) - 0.5);
        int y = port - x * 256;
        try {
            this.ss = new ServerSocket(port);
        }
        catch (IOException ex) {
            System.out.println("IOException in Method tellPort() in Class ftpc--" + ex);
        }
        this.comm("PORT " + this._hostAddress + "," + x + "," + y);
    }

    public static void main(String[] arg) {
        try {
            FTPSearch client = new FTPSearch("202.114.2.2");
            client.search();
            client.parse();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

