/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.fi.rpt.client.NameEditUI;
import com.kingdee.eas.rptclient.newrpt.client.designer.AbstractNameEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComponent;

public class NameEditUI
extends AbstractNameEditUI {
    private static final long serialVersionUID = -1L;
    private Hashtable option = null;
    private String uITitle = null;
    private boolean verifyText = false;
    private NameEditUI.VerifyListener verifyListener;

    public NameEditUI() throws Exception {
    }

    public NameEditUI(String strTitle, String strLabel, String strEdit) throws Exception {
        this.uITitle = strTitle;
        if (strLabel == null) {
            throw new Exception("label name is null!");
        }
        this.kDLabelConName.setName(strLabel);
        this.kDTextField1.setText(strEdit);
        if (strEdit != null && strEdit.length() > 0) {
            this.kDTextField1.setSelectionStart(0);
            this.kDTextField1.setSelectionEnd(strEdit.length());
        }
    }

    public String getUITitle() {
        return this.uITitle;
    }

    public void loadFields() {
        if (this.option != null) {
            String name = (String)this.option.get("edit");
            if (name != null && name.length() > 0) {
                this.kDTextField1.setText(name);
                this.kDTextField1.setSelectionStart(0);
                this.kDTextField1.setSelectionEnd(name.length());
            }
            this.setUITitle((String)this.option.get("title"));
        }
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        Map context = this.getUIContext();
        if (context != null) {
            this.option = (Hashtable)context.get("para");
        }
        this.loadFields();
        this.onLoad();
    }

    public void storeFields() {
        String name = this.kDTextField1.getText();
        this.option.put("edit", name);
    }

    private boolean verify() {
        boolean isfileName;
        String name = this.kDTextField1.getText();
        if (this.verifyListener != null) {
            return this.verifyListener.verify((JComponent)((Object)this), name);
        }
        if (name != null && name.length() > 0 && !(isfileName = StringUtils.isFileName((String)name))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"nuFileName"));
            this.kDTextField1.requestFocus();
            return false;
        }
        return true;
    }

    protected void kDBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.option.put("action", "cancel");
        this.disposeUIWindow();
    }

    protected void kDBtnComm_actionPerformed(ActionEvent e) throws Exception {
        this.option.put("action", "confirm");
        if (this.verifyText) {
            if (this.verify()) {
                this.storeFields();
                this.disposeUIWindow();
            }
        } else {
            this.storeFields();
            this.disposeUIWindow();
        }
    }

    public void onLoad() {
        this.kDTextField1.setMaxLength(80);
        this.option = (Hashtable)this.getUIContext().get("para");
        if (this.option == null) {
            this.option = new Hashtable();
            this.getUIContext().put("para", this.option);
        }
        String strTitle = (String)this.option.get("title");
        String strLabel = (String)this.option.get("label");
        String strEdit = (String)this.option.get("edit");
        Boolean verify = (Boolean)this.option.get("verify");
        this.verifyText = verify == null ? false : verify;
        this.uITitle = strTitle;
        if (strLabel != null) {
            this.kDLabelConName.setName(strLabel);
            this.kDLabelConName.setBoundLabelText(strLabel);
        }
        this.kDTextField1.setText(strEdit);
        if (strEdit != null && strEdit.length() > 0) {
            this.kDTextField1.setSelectionStart(0);
            this.kDTextField1.setSelectionEnd(strEdit.length());
        }
    }

    public Hashtable getOption() {
        return this.option;
    }

    public void setVerifyListener(NameEditUI.VerifyListener listener) {
        this.verifyListener = listener;
    }
}

