/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynamicTemplateUtility;
import com.kingdee.eas.rptclient.newrpt.client.designer.CompanyFiller;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportDesigner;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportSettingUI;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportSheetManagerListener;
import com.kingdee.eas.rptclient.newrpt.client.designer.SheetManagerUI;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.DesignerConstants;
import com.kingdee.eas.rptclient.newrpt.designer.check.CompanyFillUI;
import com.kingdee.eas.rptclient.newrpt.designer.check.IRptCheckListener;
import com.kingdee.eas.rptclient.newrpt.designer.check.ReportCheckHelper;
import com.kingdee.eas.rptclient.newrpt.designer.check.RptCheckUI;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.SpreadHelper;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;

public class ReportActionManager {
    private ReportDesigner designer;
    private Map actionMapping = new HashMap(5);
    private final SpreadContext spreadContainer;
    public static final String Report_Check_wizard = "Report_Check_wizard";
    public static final String Report_Check = "Report_Check";
    public static final String Company_Fill = "Company_Fill";
    public static final String Sheet_Manager = "Sheet_Manager";
    public static final String Exit = "Exit";
    public static final String CLEAR_ITEM = "CLEAR_ITEM";
    public static final String REPORT_SETTING = "REPORT_SETTING";
    public static final String Export = "Export";
    public static final String Import = "Import";
    public static final String Sheet_Protection = "Sheet_Protection";
    public static final String Book_Protection = "Book_Protection";
    static /* synthetic */ Class class$com$kingdee$eas$rptclient$newrpt$client$designer$ReportSettingUI;

    public ReportActionManager(SpreadContext spreadContainer) {
        this.spreadContainer = spreadContainer;
    }

    public AbstractAction getAction(String actionName) {
        Object action = this.spreadContainer.getActionManager().getAction(actionName);
        if (action != null) {
            return action;
        }
        action = (AbstractAction)this.actionMapping.get(actionName);
        if (action != null) {
            return action;
        }
        if (Company_Fill.equals(actionName)) {
            action = this.createCompanyFillAction();
        } else if (Report_Check_wizard.equals(actionName)) {
            action = this.createReportCheckWizardAction();
        } else if (Report_Check.equals(actionName)) {
            action = this.createReportCheckAction();
        } else if (Sheet_Manager.equals(actionName)) {
            action = this.createSheetManagerAction();
        } else if (Exit.equals(actionName)) {
            action = this.createExitAction();
        } else if (CLEAR_ITEM.equals(actionName)) {
            action = this.createClearItemFormulaAction();
        } else if (REPORT_SETTING.equals(actionName)) {
            action = this.createReportSettingAction();
        } else if (Import.equalsIgnoreCase(actionName)) {
            action = new ImportAction();
        } else if (Export.equalsIgnoreCase(actionName)) {
            action = new ExportAction();
        } else if (Sheet_Protection.equalsIgnoreCase(actionName)) {
            action = new SheetProtectionAction();
        } else if (Book_Protection.equalsIgnoreCase(actionName)) {
            action = new BookProtectionAction();
        } else {
            return null;
        }
        this.actionMapping.put(actionName, action);
        return action;
    }

    public AbstractAction getReportCheckWizardAction() {
        return this.getAction(Report_Check_wizard);
    }

    public AbstractAction getReportCheckAction() {
        return this.getAction(Report_Check);
    }

    public AbstractAction getCompanyFillAction() {
        return this.getAction(Company_Fill);
    }

    public AbstractAction getSheetManagerAction() {
        return this.getAction(Sheet_Manager);
    }

    public AbstractAction getExitAction() {
        return this.getAction(Exit);
    }

    public AbstractAction getClearItemFormulaAction() {
        return this.getAction(CLEAR_ITEM);
    }

    public AbstractAction getReportSettingAction() {
        return this.getAction(REPORT_SETTING);
    }

    private AbstractAction createReportCheckWizardAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RptCheckUI instance = RptCheckUI.getInstance((Component)((Object)ReportActionManager.this.designer), null);
                instance.setRptCheckListener(new IRptCheckListener(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public RptCheckExpTank loadRptCheckExpTank() {
                        return BookProperties.loadFromSpread(ReportActionManager.access$200(1.access$100(this.this$1)).getBook()).getOperationSchema().getExpTank();
                    }

                    public List loadSheetNames() {
                        return SpreadHelper.getAllSheetsName(ReportActionManager.access$200(1.access$100(this.this$1)));
                    }

                    public void restoreCheckExpTank(RptCheckExpTank exps) {
                        BookProperties loadFromSpread = BookProperties.loadFromSpread(ReportActionManager.access$200(1.access$100(this.this$1)).getBook());
                        loadFromSpread.getOperationSchema().setExpTank(exps);
                        loadFromSpread.restoreToSpread(ReportActionManager.access$200(1.access$100(this.this$1)).getBook());
                    }
                });
                if (instance != null) {
                    instance.open();
                }
            }

            static /* synthetic */ ReportActionManager access$100(1 x0) {
                return x0.ReportActionManager.this;
            }
        };
        return action;
    }

    private AbstractAction createReportCheckAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RptCheckExpTank expTank = BookProperties.loadFromSpread(ReportActionManager.this.getSpread().getBook()).getOperationSchema().getExpTank();
                try {
                    if (expTank == null || expTank.getExpressions() == null || expTank.getExpressions().size() < 1) {
                        MsgBox.showInfo((Component)ReportActionManager.this.getSpread(), (String)ResourceHelper.getActionMessageResource("ReportActionManager.0"));
                        return;
                    }
                    Book book = SpreadHelper.copySpread(ReportActionManager.this.getSpread()).getBook();
                    String string = ReportCheckHelper.checkReport(book, ReportActionManager.this.designer.getDataProvider(), expTank, Locale.getDefault());
                    if (string == null) {
                        MsgBox.showInfo((Component)ReportActionManager.this.getSpread(), (String)ResourceHelper.getActionMessageResource("ReportActionManager.4"));
                    } else {
                        AdvMsgBox box = AdvMsgBox.createAdvMsgBox((Component)ReportActionManager.this.getSpread(), (String)ResourceHelper.getActionMessageResource("ReportActionManager.2"), (String)ResourceHelper.getActionMessageResource("ReportActionManager.3"), (String)string, (int)1, (int)8188);
                        box.show();
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)ReportActionManager.this.getSpread(), (Throwable)e1);
                }
            }
        };
        return action;
    }

    private AbstractAction createCompanyFillAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Sheet sheet = ReportActionManager.this.getSpread().getBook().getActiveSheet();
                if (sheet != null) {
                    ArrayList basePointList = DynamicTemplateUtility.getBasePointList(sheet);
                    Point basePoint = null;
                    int col = sheet.getActiveCol();
                    int row = sheet.getActiveRow();
                    if (col >= 0 && row >= 0) {
                        basePoint = new Point(col, row);
                        if (basePointList.size() > 0 && (basePoint = DynamicTemplateUtility.getBasePoint(sheet, basePoint, basePointList)) == null && basePointList.size() == 1) {
                            basePoint = (Point)basePointList.get(0);
                        }
                    } else if (basePointList.size() > 0) {
                        basePoint = (Point)basePointList.get(0);
                    }
                    if (basePoint == null) {
                        MsgBox.showError((Component)((Object)ReportActionManager.this.designer), (String)"\u5f53\u524d\u70b9\u4e0d\u5728\u53ef\u7528\u8303\u56f4\u5185");
                        return;
                    }
                }
                CompanyFillUI instance = CompanyFillUI.getInstance((Component)((Object)ReportActionManager.this.designer), null);
                instance.setFillListener(new CompanyFiller(ReportActionManager.this.getSpread()));
                if (instance != null) {
                    instance.showWindow();
                }
            }
        };
        return action;
    }

    private AbstractAction createSheetManagerAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SheetManagerUI managerUI = SheetManagerUI.createUI((Object)ReportActionManager.this.designer, ReportActionManager.this.getSpread());
                    managerUI.setMaintainListener(new ReportSheetManagerListener(ReportActionManager.this.getSpread()));
                    managerUI.showWindow();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle(e1);
                }
            }
        };
        return action;
    }

    private AbstractAction createExitAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ReportActionManager.this.designer.destory();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        action.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_quit"));
        return action;
    }

    private AbstractAction createClearItemFormulaAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ReportActionManager.this.getSpread().getBook().getSelectionRange().clear(false, false, false, DesignerConstants.CONTENT_CLEAR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        return action;
    }

    private AbstractAction createReportSettingAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    HashMap<String, ReportCalculateErrorProvider> ctx = new HashMap<String, ReportCalculateErrorProvider>();
                    BookProperties p = BookProperties.loadFromSpread(ReportActionManager.this.spreadContainer.getSpread().getBook());
                    ReportCalculateErrorProvider errorp = p.getErrorProvider();
                    if (errorp == null) {
                        errorp = new ReportCalculateErrorProvider();
                    }
                    p.setErrorProvider(errorp);
                    ctx.put("RPT_ERRORHANDLER", errorp);
                    ReportSettingUI set = (ReportSettingUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)((Object)ReportActionManager.this.designer), (class$com$kingdee$eas$rptclient$newrpt$client$designer$ReportSettingUI == null ? (class$com$kingdee$eas$rptclient$newrpt$client$designer$ReportSettingUI = ReportActionManager.class$("com.kingdee.eas.rptclient.newrpt.client.designer.ReportSettingUI")) : class$com$kingdee$eas$rptclient$newrpt$client$designer$ReportSettingUI).getName(), ctx);
                    set.showWindow();
                    p.restoreToSpread(ReportActionManager.this.spreadContainer.getSpread().getBook());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        return action;
    }

    protected ReportDesigner getDesigner() {
        return this.designer;
    }

    protected void setDesigner(ReportDesigner designer) {
        this.designer = designer;
    }

    private KDSpread getSpread() {
        return this.spreadContainer.getSpread();
    }

    abstract class BasicIOAction
    extends AbstractAction {
        public static final String KDF = "kdf";
        public static final String XLS = "xls";
        public static final String XML = "xml";
        protected KDFileChooser _fileChooser;

        BasicIOAction() {
        }

        protected String addExtension(String fileName, String extension) {
            if (fileName.endsWith(extension)) {
                return fileName;
            }
            return fileName + "." + extension;
        }

        protected KDFileChooser getFileChooser() {
            if (this._fileChooser == null) {
                this._fileChooser = this.createFileChooser();
            }
            return this._fileChooser;
        }

        protected KDFileChooser createFileChooser() {
            KDFileChooser fc = new KDFileChooser();
            fc.addChoosableFileFilter((FileFilter)new SimpleFileFilter(XLS, ResourceHelper.getMenuResource("MenuManager.136")));
            fc.addChoosableFileFilter((FileFilter)new SimpleFileFilter(XML, ResourceHelper.getMenuResource("MenuManager.140")));
            return fc;
        }
    }

    class ImportAction
    extends BasicIOAction {
        ImportAction() {
        }

        public void actionPerformed(ActionEvent e) {
            KDFileChooser chooser = this.getFileChooser();
            chooser.setDialogTitle(ResourceHelper.getMenuResource("MenuManager.import"));
            int result = chooser.showOpenDialog((Component)ReportActionManager.this.spreadContainer);
            if (result == 0) {
                try {
                    File file = chooser.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    String ext = FileUtil.getExtension((File)file);
                    String str = ResourceHelper.getMenuResource("MenuManager.nosupported");
                    KDSpread spread = ReportActionManager.this.spreadContainer.getSpread();
                    if ("xls".equalsIgnoreCase(ext)) {
                        KDSBook kdsbook = POIXlsReader.parse((String)fileName);
                        if (kdsbook != null) {
                            Book book = KDSBookToBook.traslate((KDSBook)kdsbook);
                            ReportActionManager.this.spreadContainer.setBook(book);
                        } else {
                            WindowUtil.msgboxInfo((Object)str, (String)str, (Component)spread);
                        }
                    } else {
                        ReportActionManager.this.spreadContainer.setBook(IOHelper.loadFile((String)fileName));
                    }
                    ReportActionManager.this.designer.initVarialbes();
                    ReportActionManager.this.designer.initCalculateContext();
                }
                catch (Exception e2) {
                    ExceptionHandler.handle(e2);
                }
            }
        }
    }

    class ExportAction
    extends BasicIOAction {
        ExportAction() {
        }

        public void actionPerformed(ActionEvent e) {
            KDSpread spread = ReportActionManager.this.spreadContainer.getSpread();
            KDFileChooser chooser = this.getFileChooser();
            chooser.setDialogTitle(ResourceHelper.getMenuResource("MenuManager.savefile"));
            int result = chooser.showSaveDialog((Component)spread);
            if (result == 0) {
                try {
                    FileFilter filter = chooser.getFileFilter();
                    File file = chooser.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    if (filter instanceof SimpleFileFilter) {
                        SimpleFileFilter sff = (SimpleFileFilter)filter;
                        if (sff.acceptExtension("xml")) {
                            fileName = this.addExtension(fileName, "xml");
                            IOHelper.saveToFile((Book)spread.getBook(), (String)fileName);
                        } else if (sff.acceptExtension("xls")) {
                            fileName = this.addExtension(fileName, "xls");
                            KDSBook kdsbook = BookToKDSBook.traslate((Book)spread.getBook());
                            new ExportManager().exportToExcel(kdsbook, fileName);
                        }
                    } else {
                        IOHelper.saveToFile((Book)spread.getBook(), (String)fileName);
                    }
                }
                catch (Exception e2) {
                    ExceptionHandler.handle(e2);
                }
            }
        }
    }

    private class BookProtectionAction
    extends AbstractAction {
        BookProtectionAction() {
            this.init();
        }

        public void actionPerformed(ActionEvent e) {
            BookProtection protection = ReportActionManager.this.spreadContainer.getSpread().getBook().getProtection();
            if (protection.isProtected()) {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("UnProtectBook").actionPerformed(e);
            } else {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("Show_ProtectBook_Wizzard").actionPerformed(e);
            }
            this.init();
        }

        private void init() {
            BookProtection protection = ReportActionManager.this.spreadContainer.getSpread().getBook().getProtection();
            if (protection.isProtected()) {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.UnProtectBook"));
            } else {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.ProtectBook"));
            }
        }
    }

    private class SheetProtectionAction
    extends AbstractAction {
        SheetProtectionAction() {
            this.init();
        }

        public void actionPerformed(ActionEvent e) {
            Protection protection = ReportActionManager.this.spreadContainer.getBook().getActiveSheet().getSheetOption().getProtection(false);
            if (protection.isProtected()) {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("UnProtectSheet").actionPerformed(e);
            } else {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("Show_ProtectSheet_Wizzard").actionPerformed(e);
            }
            this.init();
        }

        private void init() {
            Protection protection = ReportActionManager.this.spreadContainer.getBook().getActiveSheet().getSheetOption().getProtection(false);
            if (protection != null && protection.isProtected()) {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.UnProtectSheet"));
            } else {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.ProtectSheet"));
            }
        }
    }
}

