/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer.render;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.rptclient.newrpt.client.designer.render.IRenderProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class DefaultItemRenderProvider
implements IRenderProvider {
    public static final int LEFT_TOP = 0;
    public static final int RIGHT_TOP = 1;
    public static final int RIGHT_BOTTOM = 2;
    public static final int LEFT_BOTTOM = 3;
    private static final IBasicRender lrt = new TriangleRender(Color.GRAY, 1, false);

    public IBasicRender getRender(Cell cell, int viewMode) {
        Object obj = cell.getUserObjectValue("ITEM");
        if (obj == null) {
            return null;
        }
        return lrt;
    }

    public static IBasicRender getLeftTopRender(Color c) {
        return new TriangleRender(c, 0, true);
    }

    public static IBasicRender getRightTopRender(Color c) {
        return lrt;
    }

    public static IBasicRender getRightBottomRender(Color c) {
        return new TriangleRender(c, 2, true);
    }

    public static IBasicRender getLeftBottomRender(Color c) {
        return new TriangleRender(c, 3, true);
    }

    protected static final class TriangleRender
    implements IBasicRender {
        private final Color c;
        private final boolean isFill;
        private final int type;

        public TriangleRender(Color c, int type, boolean isFill) {
            this.c = c;
            this.type = type;
            this.isFill = isFill;
        }

        public void draw(Graphics graphics, Shape clip, Object arg2, Style arg3) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            switch (this.type) {
                case 0: {
                    this.drawLTCorner(graphics, this.c, bd);
                    break;
                }
                case 1: {
                    this.drawRTCorner(graphics, this.c, bd);
                    break;
                }
                case 2: {
                    this.drawRBCorner(graphics, this.c, bd);
                    break;
                }
                case 3: {
                    this.drawLBCorner(graphics, this.c, bd);
                }
            }
            graphics.setColor(cl);
        }

        private void drawLTCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x;
            int y = bd.y;
            int offset = 6;
            if (!this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x, x + offset, x};
            int[] dy = new int[]{y, y, y + offset};
            graphics.setColor(color);
            if (this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }

        private void drawRTCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x + bd.width;
            int y = bd.y - 1;
            int offset = 6;
            if (!this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x - offset, x, x};
            int[] dy = new int[]{y, y, y + offset};
            graphics.setColor(color);
            if (this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }

        private void drawRBCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x + bd.width;
            int y = bd.y + bd.height;
            int offset = 6;
            if (!this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x - offset, x, x};
            int[] dy = new int[]{y, y, y - offset};
            graphics.setColor(color);
            if (this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }

        private void drawLBCorner(Graphics graphics, Color color, Rectangle bd) {
            int x = bd.x + bd.width;
            int y = bd.y;
            int offset = 6;
            if (this.isFill) {
                ++offset;
            }
            int[] dx = new int[]{x, x + offset, x};
            int[] dy = new int[]{y, y, y - offset};
            graphics.setColor(color);
            if (!this.isFill) {
                graphics.fillPolygon(dx, dy, 3);
            } else {
                graphics.drawPolygon(dx, dy, 3);
            }
        }
    }
}

