/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaGlobalValidators;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaValidator;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.IRptDataPublisher;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormula;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaCategory;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaDataType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaEnumType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaInfoSource;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaRelaxType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaSourceFactory;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptOperObject;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RptFormulaComp {
    private static RptFormulaComp compInst = null;
    private static boolean isLoaded = false;
    public static Locale locale = null;
    HashMap formulas = new HashMap(16, 0.75f);
    HashMap formulaTypes = new HashMap(16, 0.75f);
    HashMap dataTypes = new HashMap(16, 0.75f);
    HashMap formulaCategory = new HashMap(2, 0.75f);
    private RptFormula curFormula;
    private RptFormulaCategory curCategory;
    public static final String FM_ITEM = "Item";
    public static final String LBL_ROOT = "formulas_declaration";
    public static final String LBL_ALIAS = "alias";
    public static final String LBL_LOCALNAME = "local_name";
    public static final String LBL_COMMENTS = "comments";
    public static final String LBL_COMMENT = "comment";
    public static final String LBL_FORMULAS = "formulas";
    public static final String LBL_FORMULA = "formula";
    public static final String LBL_PARAMS = "params";
    public static final String LBL_PARAM = "param";
    public static final String LBL_TYPES = "types";
    public static final String LBL_RELAXTYPE = "type";
    public static final String LBL_ENUMTYPE = "enum";
    public static final String LBL_ENUMENTRY = "entry";
    public static final String LBL_FORMULATPYES = "formulatypes";
    public static final String LBL_FORMULATPYE = "formulatype";
    public static final String LBL_FORMULACATEGORYS = "formulacategory";
    public static final String LBL_FORMULACATEGORY = "category";
    public static final String LBL_FORMULAWIZARD = "wizard";
    public static final String ATTR_PARAM_STRICTREQUIRED = "strictRequired";
    public static final String ATTR_FORMULAWIZARD_DEF = "com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizardUI";
    public static final String ATTR_ELEMENTNAME = "name";
    public static final String ATTR_COMMENTLANE = "language";
    public static final String ATTR_FORMULARETURN = "type";
    public static final String ATTR_FORMULATYPE = "return";
    public static final String ATTR_FORMULACATE = "category";
    public static final String ATTR_FORMULAGROUP = "group";
    public static final String ATTR_PARAMTYPE = "type";
    public static final String ATTR_ENUMSOURCE = "source";
    public static final String ATTR_PARAMENABLED = "enabled";
    public static final String ATTR_PARAMISNEED = "required";
    public static final String ATTR_PARAMDEFVAL = "default";
    public static final String ATTR_PARAMISREPEAT = "repeat";
    public static final String ATTR_ORIGINTYPE = "origin";
    public static final String ATTR_EXCLUDES = "excludes";
    public static final String ATTR_MAXVALUE = "max";
    public static final String ATTR_MINVALUE = "min";
    public static final String ATTR_FORMULATYPEKIND = "kind";
    public static final String ATTR_FORMULATYPE_DEF = "amount";
    public static final String ATTR_FORMULACATE_DEF = "financial";
    public static final String ATTR_FORMULAGROUP_DEF = "$";
    public static final String ATTR_FORMULACATE_ALL = "all formulas";
    public static final String ATTR_PARAMTYPE_DEF = "string";
    public static final String ATTR_COMMENTLANE_DEF = "default";
    public static final String ATTR_FORMULARETURN_DEF = "default";
    public static final boolean ATTR_PARAMISNEED_DEF = true;
    public static final int ATTR_PARAMISREPEAT_DEF = 1;
    public static final String ATTR_ORIGINTYPE_DEF = "string";
    public static final String ATTR_ORIGINTYPE_STRING = "string";
    public static final String ATTR_ORIGINTYPE_DATE = "date";
    public static final String ATTR_ORIGINTYPE_DATETIME = "datetime";
    public static final String ATTR_ORIGINTYPE_BOOL = "boolean";
    public static final String ATTR_ORIGINTYPE_NUMBER = "integer";
    public static final String ATTR_ORIGINTYPE_AMOUNT = "amount";
    public static final String ATTR_ORIGINTYPE_COMMON = "common";
    public static final String ATTR_ORIGINTYPE_ANYTYPE = "anytype";
    public static final String ATTR_BIZPROMPT_QUERY = "query";
    public static final String ATTR_BIZPROMPT_EDITFM = "edit_fm";
    public static final String ATTR_BIZPROMPT_DEPYFM = "display_fm";
    public static final String ATTR_BIZPROMPT_CMTFM = "commit_fm";
    public static final String ATTR_BIZPROMPT_SELECTOR = "selector";
    public static final String ATTR_BIZPROMPT_HINT = "prompt_hint";
    public static final String ATTR_BIZPROMPT_ITEM = "context_item";
    public static final String ATTR_INQUIRY_ONFOCUS = "inquiryOnFocus";
    public static final String ATTR_FORMULATYPEKIND_DEF = "cell_value";
    public static final String ATTR_LANGUAGE_DEF = "en_US";
    public static final String ATTR_NAMELANE_DEF = "default";
    public static final String ATTR_LANGUAGE_CHS = "zh_CN";
    public static final String ATTR_LANGUAGE_CHT = "zh_TW";
    public static final String ATTR_LANGUAGE_ENU = "en_US";
    public static final String ATTR_GLOBAL_VALIDATOR = "global-validators";
    public static final String ATTR_VALIDATOR = "validator";
    public static final String ATTR_PROVIDER = "provider";
    public static final String ATTR_METHOD = "method";
    public static final String ATTR_STRICT = "strict";
    public static final String ATTR_METHODPARAM = "methodParam";
    public static final String ATTR_PARAM = "param";
    public static final String ATTR_VALIDATIONS = "validations";
    public static final String ATTR_VALIDATION = "validation";
    public static final String ATTR_DEPENDS = "depends";
    public static final String ATTR_VAR = "var";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_OVERLEAP = "overleap";
    private FormulaGlobalValidators globalValidators = null;

    public static void main(String[] args) throws Exception {
        RptFormulaComp fc = RptFormulaComp.getInstance();
        fc.load();
        fc.unLoad();
    }

    private RptFormulaComp() {
    }

    public static RptFormulaComp getInstance() {
        return compInst == null ? (compInst = new RptFormulaComp()) : compInst;
    }

    public RptFormula getCurFormula() {
        return this.curFormula;
    }

    public RptFormulaCategory getCurCategory() {
        if (this.curCategory == null) {
            this.curCategory = (RptFormulaCategory)this.formulaCategory.get(ATTR_FORMULACATE_ALL);
        }
        return this.curCategory;
    }

    public void setCurCategory(RptFormulaCategory category) {
        this.curCategory = category;
    }

    public void setCurFormula(RptFormula formula) {
        this.curFormula = formula;
    }

    public RptFormulaDataType getDataType(String name) {
        if (name == null) {
            return null;
        }
        return (RptFormulaDataType)this.dataTypes.get(name.toLowerCase());
    }

    public Collection getFormulas() {
        return this.formulas.values();
    }

    public RptFormula getFormula(String name) throws Exception {
        isLoaded = this.load();
        if (name == null) {
            return null;
        }
        return (RptFormula)this.formulas.get(name.toLowerCase());
    }

    public RptFormula getFormulaByAlias(String name) {
        Iterator fms = this.formulas.values().iterator();
        RptFormula fm = null;
        while (fms.hasNext() && ((fm = (RptFormula)fms.next()) == null || !fm.isNamedAs(name))) {
        }
        return fm;
    }

    public Collection getFormulaTypes() {
        return this.formulaTypes.values();
    }

    public Collection getFormulaCategory() {
        return this.formulaCategory.values();
    }

    public Collection getFormulasByCategory(String cateName) {
        boolean isAll = StringUtil.isEmptyString((String)cateName);
        ArrayList<RptFormula> res = new ArrayList<RptFormula>(16);
        Iterator fms = this.formulas.values().iterator();
        while (fms.hasNext()) {
            RptFormula f = (RptFormula)fms.next();
            if (!isAll && (f.getCategory() == null || !f.getCategory().equalsIgnoreCase(cateName)) || StringUtil.isEmptyString((String)f.getCategory())) continue;
            res.add(f);
        }
        Collections.sort(res, RptOperObject.getComparator());
        return res;
    }

    public boolean load() throws Exception {
        if (!isLoaded) {
            isLoaded = this.loadRaw(0);
        }
        return isLoaded;
    }

    public boolean refresh() throws Exception {
        return this.clear() && this.loadRaw(2);
    }

    public boolean unLoad() {
        isLoaded = false;
        return this.clear();
    }

    private boolean loadRaw(int fmSrcType) throws Exception {
        RptFormulaInfoSource source = RptFormulaSourceFactory.getSource(fmSrcType);
        return source != null && source.open() && this.readSource(source) && source.close();
    }

    private boolean clear() {
        Iterator fms = this.formulas.values().iterator();
        while (fms.hasNext()) {
            ((RptFormula)fms.next()).clear();
        }
        this.formulas.clear();
        Iterator dts = this.dataTypes.values().iterator();
        while (dts.hasNext()) {
            ((RptFormulaDataType)dts.next()).clear();
        }
        this.dataTypes.clear();
        Iterator fts = this.formulaTypes.values().iterator();
        while (fts.hasNext()) {
            ((RptFormulaType)fts.next()).clear();
        }
        this.formulaTypes.clear();
        this.formulaCategory.clear();
        return true;
    }

    private boolean readSource(RptFormulaInfoSource source) throws Exception {
        boolean result = false;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.newSAXParser().parse((InputSource)source, (DefaultHandler)new SourceHandler());
            result = this.dataRelating();
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
        return result;
    }

    private boolean dataRelating() {
        Iterator fms = this.formulas.values().iterator();
        while (fms.hasNext()) {
            String g = ((RptFormula)fms.next()).getCategory();
            if (g == null || g.length() == 0) {
                g = ATTR_FORMULACATE_DEF;
            }
            if (this.isCategoryExist(g = g.toLowerCase())) continue;
            this.formulaCategory.put(g, new RptFormulaCategory(g));
        }
        return true;
    }

    private boolean isCategoryExist(String name) {
        Iterator gps = this.formulaCategory.values().iterator();
        while (gps.hasNext()) {
            RptFormulaCategory g = (RptFormulaCategory)gps.next();
            if (!g.isNamedAs(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isLoaded() {
        return false;
    }

    public static Locale getlocale() {
        return locale;
    }

    public static String getLanguage() {
        String l = LocaleUtils.getDefaultLocale().toString();
        if (l.equalsIgnoreCase("l1")) {
            return "en_US";
        }
        if (l.equalsIgnoreCase("l2")) {
            return ATTR_LANGUAGE_CHS;
        }
        if (l.equalsIgnoreCase("l3")) {
            return ATTR_LANGUAGE_CHT;
        }
        return "en_US";
    }

    public FormulaValidator getValidator(String name) {
        return this.globalValidators == null ? null : this.globalValidators.getValidator(name);
    }

    static {
        locale = new Locale("l2");
    }

    protected class SourceHandler
    extends DefaultHandler
    implements IRptDataPublisher {
        private int valueStatus;
        private int stackLevel;
        private StringBuffer curValue;
        private RptOperObject sucker;
        private static final int VS_NONE = 0;
        private static final int VS_INNER = 1;
        private static final int VS_HEAD = 2;

        protected SourceHandler() {
        }

        private void resetAll(boolean binit) {
            this.valueStatus = 0;
            this.stackLevel = 0;
            this.curValue = binit ? new StringBuffer(128) : null;
        }

        private void resetValue() {
            if (this.valueStatus != 0) {
                this.valueStatus = 0;
                this.curValue.setLength(0);
            }
        }

        public void endDocument() {
            this.resetAll(false);
            this.sucker = null;
        }

        public void startDocument() {
            this.resetAll(true);
            this.sucker = null;
        }

        public void characters(char[] ch, int start, int length) {
            if (this.valueStatus == 2 || this.valueStatus == 1) {
                this.valueStatus = 1;
                this.curValue.append(ch, start, length);
            }
        }

        public void characters() {
            if (this.sucker == null) {
                return;
            }
            int len = this.curValue.length();
            int start = 0;
            int end = 0;
            for (start = 0; start < len - 1 && this.curValue.charAt(start) <= ' '; ++start) {
            }
            for (end = len - 1; end > start; --end) {
                if (this.curValue.charAt(end) <= ' ') continue;
                if (end == len - 1) break;
                ++end;
                break;
            }
            this.sucker.goContent(this.curValue.substring(start, end + 1));
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.stackLevel <= 2) {
                this.sucker = null;
            }
            --this.stackLevel;
            if (this.valueStatus == 1) {
                this.characters();
            }
            this.resetValue();
            if (this.sucker != null) {
                this.sucker.goOut(qName);
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ++this.stackLevel;
            this.resetValue();
            this.valueStatus = 2;
            if (this.stackLevel == 2) {
                this.sucker = null;
            } else if (this.stackLevel == 3) {
                this.sucker = qName.equalsIgnoreCase(RptFormulaComp.LBL_FORMULA) ? new RptFormula(qName, this) : (qName.equalsIgnoreCase("type") ? new RptFormulaRelaxType(qName, this) : (qName.equalsIgnoreCase(RptFormulaComp.LBL_ENUMTYPE) ? new RptFormulaEnumType(qName, this) : (qName.equalsIgnoreCase(RptFormulaComp.LBL_FORMULATPYE) ? new RptFormulaType(qName, this) : (qName.equalsIgnoreCase("category") ? new RptFormulaCategory(qName, this) : (qName.equalsIgnoreCase(RptFormulaComp.ATTR_GLOBAL_VALIDATOR) ? new FormulaGlobalValidators(qName, this) : null)))));
            }
            if (this.sucker != null) {
                this.sucker.goInto(qName, atts);
            }
        }

        public void error(SAXParseException e) throws SAXException {
            super.error(e);
            this.resetValue();
        }

        public void fatalError(SAXParseException e) throws SAXException {
            super.fatalError(e);
            this.resetValue();
        }

        public void warning(SAXParseException e) throws SAXException {
            super.warning(e);
            this.resetValue();
        }

        public void keep(RptOperObject ob) {
            this.sucker = ob;
        }

        public void publish(RptOperObject ob) {
            HashMap curChain = null;
            if (ob instanceof RptFormula) {
                curChain = RptFormulaComp.this.formulas;
            } else if (ob instanceof RptFormulaDataType) {
                curChain = RptFormulaComp.this.dataTypes;
            } else if (ob instanceof RptFormulaType) {
                curChain = RptFormulaComp.this.formulaTypes;
            } else if (ob instanceof RptFormulaCategory) {
                curChain = RptFormulaComp.this.formulaCategory;
            } else if (ob instanceof FormulaGlobalValidators) {
                RptFormulaComp.this.globalValidators = (FormulaGlobalValidators)ob;
            }
            if (curChain != null) {
                curChain.put(ob.getName().toLowerCase(), ob);
            }
        }
    }
}

