/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.functionimpl;

import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.eas.rptclient.gr.rptclient.EasCurrency;
import com.kingdee.eas.rptclient.gr.rptclient.K3Currency;
import com.kingdee.eas.rptclient.newrpt.functionimpl.FunctionDAO;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public class CalculateContext {
    private static CalculateContext ctx;
    private Map SDSNMapping;
    private String defaultSDSN;
    private Map currencyMapping;
    private IErrorProvider errorProvider;

    private CalculateContext() {
    }

    public void initSDSNMapping(Connection conn) {
        try {
            CalculateContext.ctx.SDSNMapping = FunctionDAO.getAcctEntry(conn);
            this.currencyMapping = FunctionDAO.getCurrencyMapping(conn);
        }
        catch (Exception e) {
            CalculateContext.ctx.SDSNMapping = new HashMap();
        }
    }

    public String getK3CurrencyNumber(String easCurrencyNumber) {
        if (this.currencyMapping == null) {
            return null;
        }
        EasCurrency easCurrency = (EasCurrency)this.currencyMapping.get(easCurrencyNumber);
        if (easCurrency == null) {
            return null;
        }
        K3Currency currency = easCurrency.getK3Currency();
        if (currency == null) {
            return null;
        }
        return currency.getK3CurrencyNumber();
    }

    public static CalculateContext getInstance() {
        if (ctx == null) {
            ctx = new CalculateContext();
        }
        return ctx;
    }

    public String getSDSNByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return this.defaultSDSN;
        }
        return (String)this.SDSNMapping.get(name);
    }

    public String getDefaultSDSN() {
        return this.defaultSDSN;
    }

    public void setDefaultSDSN(String sdsn) {
        this.defaultSDSN = sdsn;
    }

    public Map getCurrencyMapping() {
        return this.currencyMapping;
    }

    public void setErrorProvider(IErrorProvider ee) {
        this.errorProvider = ee;
    }

    public IErrorProvider getErrorProvider() {
        return this.errorProvider;
    }
}

