/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class MultiThreadExecuteImpl {
    private static Logger logger = Logger.getLogger((String)MultiThreadExecuteImpl.class.getName());
    private int threadCount = 1;
    private AtomicInteger exeThreadCount = new AtomicInteger(0);
    private boolean isRecReslut = false;
    private boolean isEnd = false;
    public LinkedBlockingQueue<Job> jobQueue = new LinkedBlockingQueue();
    public LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();

    public MultiThreadExecuteImpl(int threadCount, boolean isRecReslut) {
        this.threadCount = threadCount;
        this.isRecReslut = isRecReslut;
    }

    public void setAddJobEnd(boolean isEnd) {
        this.isEnd = isEnd;
    }

    public void addJob(Job job) throws BOSException, EASBizException {
        try {
            if (this.threadCount <= 1 && job != null) {
                Object obj = job.run(job.params);
                if (this.isRecReslut) {
                    this.resultQueue.add(obj);
                }
                return;
            }
            this.jobQueue.add(job);
            if (this.exeThreadCount.get() < this.threadCount) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            while (!MultiThreadExecuteImpl.this.isEnd || !MultiThreadExecuteImpl.this.jobQueue.isEmpty()) {
                                if (!MultiThreadExecuteImpl.this.jobQueue.isEmpty()) {
                                    Job job = (Job)MultiThreadExecuteImpl.this.jobQueue.remove();
                                    Object obj = job.run(job.params);
                                    if (!MultiThreadExecuteImpl.this.isRecReslut) continue;
                                    MultiThreadExecuteImpl.this.resultQueue.add(obj);
                                    continue;
                                }
                                Thread.sleep(50L);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)"addJob error.", (Throwable)ex);
                        }
                        finally {
                            MultiThreadExecuteImpl.this.exeThreadCount.decrementAndGet();
                        }
                    }
                };
                this.exeThreadCount.incrementAndGet();
                thread.start();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public boolean isExecutEnd() {
        return this.exeThreadCount.get() == 0;
    }

    public void waitExecuteEnd() {
        try {
            while (!this.isExecutEnd()) {
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            logger.error((Object)"waitExecuteEnd", (Throwable)e);
        }
    }

    public LinkedBlockingQueue getResultQueue() {
        return this.resultQueue;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public class Job {
        public Object[] params = null;

        public Job(Object[] params) {
            this.params = params;
        }

        public Object run(Object[] params) throws Exception {
            return null;
        }
    }
}

