/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt;

import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import java.util.HashSet;
import java.util.Set;

public class PermissionHelper {
    public static final String PERM_RPT_VIEW = "rpt_report_view";
    public static final String PERM_RPT_ADDNEW = "rpt_report_addnew";
    public static final String PERM_RPT_EDIT = "rpt_report_update";
    public static final String PERM_RPT_DELETE = "rpt_report_delete";
    public static final String PERM_RPT_COMMIT = "rpt_report_commit";
    public static final String PERM_RPT_AUDIT = "rpt_report_audit";
    public static final String PERM_RPT_CALC = "rpt_report_calculate";
    public static final String PERM_TMPL_VIEW = "rpt_template_view";
    public static final String PERM_TMPL_ADDNEW = "rpt_template_addnew";
    public static final String PERM_TMPL_EDIT = "rpt_template_update";
    public static final String PERM_PROF_RPT_VIEW = "prof_rpt_view";
    public static final String PERM_PROF_RPT_EDIT = "prof_rpt_update";
    public static final String PERM_PROF_RPT_COMMIT = "prof_rpt_commited";
    public static final String PERM_PROF_RPT_AUDIT = "prof_rpt_audit";
    public static final String PERM_PROF_TMPL_VIEW = "prof_tmpl_view";
    public static final String ERM_PROF_TMPL_EDIT = "prof_tmpl_update";
    public static final String PERM_PROF_INTEXCHQUERY_VIEW = "mcsl_interitemdata_view";
    public static final String PERM_PROF_INTEXCHCHCK_VIEW = "mcsl_interacctcheckCompany_view";
    public static final String PERM_PROF_INTEXCHCHCK_DIFF = "mcsl_interacctcheckcompany_diff";
    public static final String PERM_PROF_INTEXCHCHCK_APPR = "mcsl_interacctcheckcompany_appr";
    public static final String PERM_PROF_INTEXCHCHCK_PRINT = "mcsl_interacctcheckcompany_print";
    public static final String PERM_PROF_INTEXCHCHCK_CHECK = "mcsl_interacctcheckcompany_check";
    public static final String PERM_PROF_INTEXCHCHCK_AUDIT = "mcsl_interacctcheckcompany_audit";
    private static final Set<OrgType> SupportOrgTypeSet = new HashSet<OrgType>();

    public static String[] getProfIntExchCheckPermItemsArr() {
        return new String[]{PERM_PROF_INTEXCHCHCK_VIEW, PERM_PROF_INTEXCHCHCK_DIFF, PERM_PROF_INTEXCHCHCK_APPR, PERM_PROF_INTEXCHCHCK_PRINT, PERM_PROF_INTEXCHCHCK_CHECK, PERM_PROF_INTEXCHCHCK_AUDIT};
    }

    private static String[] getFIRptBasePermArr() {
        return new String[]{PERM_RPT_VIEW, PERM_RPT_ADDNEW, PERM_RPT_EDIT, PERM_RPT_DELETE, PERM_RPT_AUDIT};
    }

    private static String[] getFITmplBasePermArr() {
        return new String[]{PERM_TMPL_VIEW, PERM_TMPL_ADDNEW, PERM_TMPL_EDIT};
    }

    private static String[] getProfRptBasePermArr() {
        return new String[]{PERM_PROF_RPT_VIEW, PERM_PROF_RPT_EDIT, PERM_PROF_RPT_AUDIT};
    }

    private static String[] getProfTmplBasePermArr() {
        return new String[]{PERM_PROF_TMPL_VIEW, ERM_PROF_TMPL_EDIT};
    }

    public static String[] getRptBasePermArrByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        int typeVal = orgType.getValue();
        switch (typeVal) {
            case 1: {
                return PermissionHelper.getFIRptBasePermArr();
            }
            case 6: {
                return PermissionHelper.getProfRptBasePermArr();
            }
        }
        return null;
    }

    private static void checkSupport(OrgType orgType) {
        if (!SupportOrgTypeSet.contains(orgType)) {
            throw new RuntimeException("Not support OrgType:" + (orgType == null ? "NULL" : orgType.getAlias()));
        }
    }

    public static String[] getTmplBasePermArrByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        int typeVal = orgType.getValue();
        switch (typeVal) {
            case 1: {
                return PermissionHelper.getFITmplBasePermArr();
            }
            case 6: {
                return PermissionHelper.getProfTmplBasePermArr();
            }
        }
        return null;
    }

    public static String getEditPermNameByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        if (RptNewUIUtil.isFiOrgType(orgType)) {
            return PERM_RPT_EDIT;
        }
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return PERM_PROF_RPT_EDIT;
        }
        return null;
    }

    public static String getDeletePermNameByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        if (RptNewUIUtil.isFiOrgType(orgType)) {
            return PERM_RPT_DELETE;
        }
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return PERM_PROF_RPT_EDIT;
        }
        return null;
    }

    public static String getAddNewPermNameByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        if (RptNewUIUtil.isFiOrgType(orgType)) {
            return PERM_RPT_ADDNEW;
        }
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return PERM_PROF_RPT_EDIT;
        }
        return null;
    }

    public static String getCommitPermNameByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        if (RptNewUIUtil.isFiOrgType(orgType)) {
            return PERM_RPT_COMMIT;
        }
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return PERM_PROF_RPT_COMMIT;
        }
        return null;
    }

    public static String getAuditedPermNameByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        if (RptNewUIUtil.isFiOrgType(orgType)) {
            return PERM_RPT_AUDIT;
        }
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return PERM_PROF_RPT_AUDIT;
        }
        return null;
    }

    public static String getCalculatePermNameByOrgType(OrgType orgType) {
        PermissionHelper.checkSupport(orgType);
        if (RptNewUIUtil.isFiOrgType(orgType)) {
            return PERM_RPT_CALC;
        }
        if (OrgType.ProfitCenter.equals((Object)orgType)) {
            return PERM_PROF_RPT_EDIT;
        }
        return null;
    }

    static {
        SupportOrgTypeSet.add(OrgType.Company);
        SupportOrgTypeSet.add(OrgType.ProfitCenter);
    }
}

