/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslrptChatGptFacadeFactory;
import com.kingdee.eas.fi.newrpt.GptFilterInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptItemDataAnalysiseImpl
implements Serializable {
    private static final Logger logger = Logger.getLogger(RptItemDataAnalysiseImpl.class);
    public static String yearStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"nian", (Locale)ContextUtils.getLocaleFromEnv());
    public static String periodStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"qi1", (Locale)ContextUtils.getLocaleFromEnv());
    public static String quartStr = RptPeriodTypeEnum.QUARTERLY.getAlias().substring(0, 1);
    private boolean isOneDataElement = true;
    private boolean isOneValueType = true;

    public static RptItemDataAnalysiseImpl getInstance() {
        return new RptItemDataAnalysiseImpl();
    }

    public Map getItemDatas(Context ctx, ReportBaseInfo rptInfo, GptFilterInfo gptInputInfo, List<ItemFormula> itemFormulas) throws Exception {
        if (rptInfo != null && itemFormulas != null && !itemFormulas.isEmpty() && gptInputInfo != null && (GptFilterInfo.AnalysisType.YoY.equals((Object)gptInputInfo.getAnalysisType()) || GptFilterInfo.AnalysisType.MoM.equals((Object)gptInputInfo.getAnalysisType()))) {
            Map map;
            String tmpTbl = null;
            try {
                this.initFormula(itemFormulas);
                SQLBuilder sqlb = new SQLBuilder();
                tmpTbl = this.buildSql(ctx, rptInfo, gptInputInfo, itemFormulas, sqlb);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlb.getSQL(), (Object[])sqlb.getParams());
                map = this.buildResult(rowSet, rptInfo.getPeriodType());
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"getItemDatas error", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!DebugLogger.isDebug && !StringUtils.isEmpty(tmpTbl)) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTbl);
                    }
                    throw throwable;
                }
            }
            if (!DebugLogger.isDebug && !StringUtils.isEmpty((String)tmpTbl)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmpTbl);
            }
            return map;
        }
        return null;
    }

    public void initFormula(List<ItemFormula> itemFormulas) {
        String curDataElementNumber = null;
        int valueType = -1;
        for (ItemFormula itemFormula : itemFormulas) {
            if (itemFormula == null) continue;
            if (curDataElementNumber == null && itemFormula.getDataElementNumber() != null) {
                curDataElementNumber = itemFormula.getDataElementNumber();
            } else if (curDataElementNumber != null && !curDataElementNumber.equals(itemFormula.getDataElementNumber())) {
                this.isOneDataElement = false;
            }
            if (valueType == -1 && itemFormula.getValueType() >= 0) {
                valueType = itemFormula.getValueType();
                continue;
            }
            if (valueType == itemFormula.getValueType()) continue;
            this.isOneValueType = false;
        }
    }

    public Map buildResult(IRowSet rowSet, RptPeriodTypeEnum periodType) throws Exception {
        StringBuffer str = new StringBuffer();
        LinkedHashMap result = new LinkedHashMap();
        while (rowSet.next()) {
            str.setLength(0);
            str.append(rowSet.getInt("fyear")).append(yearStr);
            if (!RptPeriodTypeEnum.YEARLY.equals((Object)periodType)) {
                if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType)) {
                    str.append(rowSet.getInt("fperiod")).append(quartStr);
                } else {
                    str.append(rowSet.getInt("fperiod")).append(periodStr);
                }
            }
            String yearPeriodStr = str.toString();
            HashMap<String, BigDecimal> datas = (HashMap<String, BigDecimal>)result.get(yearPeriodStr);
            BigDecimal value = rowSet.getBigDecimal("fmoney");
            if (value == null) continue;
            if (datas == null) {
                datas = new HashMap<String, BigDecimal>();
                result.put(yearPeriodStr, datas);
            }
            str.setLength(0);
            str.append(rowSet.getString("fitemname"));
            if (!this.isOneDataElement) {
                str.append(rowSet.getString("fdataelementname"));
            }
            if (!this.isOneValueType) {
                str.append(ValueTypeEnum.getEnum((int)rowSet.getInt("fvalueType")).getAlias());
            }
            datas.put(str.toString(), rowSet.getBigDecimal("fmoney"));
        }
        return result;
    }

    public String buildSql(Context ctx, ReportBaseInfo rptInfo, GptFilterInfo gptInputInfo, List<ItemFormula> itemFormulas, SQLBuilder sqlb) throws Exception {
        int[] yearPeriod;
        String tmpTable = null;
        String lang = ctx.getLocale().getLanguage();
        String itemName = "fitemName_" + lang;
        String dataElementName = "fdataelementname_" + lang;
        sqlb.append("select fyear,fperiod,").append(itemName).append(" fitemname,fvalueType,").append(dataElementName);
        sqlb.append(" fdataelementname,sum(fvalue) fmoney \n");
        sqlb.append(" from t_csl_rptitemdata item \n");
        sqlb.append(" where item.fisadjusted in(0,1) \n");
        if (GptFilterInfo.AnalysisType.YoY.equals((Object)gptInputInfo.getAnalysisType())) {
            yearPeriod = RPTDateUtil.getRptYearAndPeriod((int)rptInfo.getYear(), (int)rptInfo.getPeriod(), (int)rptInfo.getPeriodType().getValue(), (int)gptInputInfo.getSearchPeriod(), (int)0, (boolean)true);
            int startYear = yearPeriod[0] > rptInfo.getYear() ? rptInfo.getYear() : yearPeriod[0];
            int endYear = yearPeriod[0] > rptInfo.getYear() ? yearPeriod[0] : rptInfo.getYear();
            sqlb.append(" and item.fyear>=?          ", (Object)startYear);
            sqlb.append(" and item.fyear<=?          ", (Object)endYear);
            sqlb.append(" and item.fperiod=?   ", (Object)rptInfo.getPeriod());
        } else {
            yearPeriod = RPTDateUtil.getRptYearAndPeriod((int)rptInfo.getYear(), (int)rptInfo.getPeriod(), (int)rptInfo.getPeriodType().getValue(), (int)0, (int)gptInputInfo.getSearchPeriod(), (boolean)true);
            int startYear = -1;
            int endYear = -1;
            int startPeriod = -1;
            int endPeriod = -1;
            if (gptInputInfo.getSearchPeriod() > 0) {
                startYear = rptInfo.getYear();
                endYear = yearPeriod[0];
                startPeriod = rptInfo.getPeriod();
                endPeriod = yearPeriod[1];
            } else {
                startYear = yearPeriod[0];
                endYear = rptInfo.getYear();
                startPeriod = yearPeriod[1];
                endPeriod = rptInfo.getPeriod();
            }
            if (startYear == endYear) {
                sqlb.append(" and (item.fyear=? ", (Object)startYear).append(" and item.fperiod>=? ", (Object)startPeriod).append(" and item.fperiod<=? )", (Object)endPeriod);
            } else {
                sqlb.append(" and (item.fyear=? ", (Object)startYear).append(" and item.fperiod>=? ", (Object)startPeriod);
                sqlb.append(" or item.fyear=?", (Object)endYear).append("  and item.fperiod<=? ", (Object)endPeriod);
                sqlb.append(" or item.fyear>? ", (Object)startYear).append(" and item.fyear<? )  \n", (Object)endYear);
            }
        }
        if (rptInfo.getPeriodType() != null) {
            sqlb.append(" and item.fperiodType=? \n", (Object)rptInfo.getPeriodType().getValue());
        }
        if (rptInfo.getSourceType() != null) {
            if (rptInfo.getSourceType().getValue() == 1 || rptInfo.getSourceType().getValue() == 7) {
                sqlb.append(" and item.fdatasource in(1,7) \n");
            } else {
                sqlb.append(" and item.fdatasource=? \n", (Object)rptInfo.getSourceType().getValue());
            }
        }
        FullOrgUnitInfo companyInfo = null;
        if (rptInfo instanceof ReportInfo) {
            companyInfo = rptInfo.getCompany();
        } else if (rptInfo instanceof CslReportInfo) {
            companyInfo = ((CslReportInfo)rptInfo).getOrgUnit();
        }
        if (companyInfo != null) {
            if (companyInfo.getId() != null) {
                sqlb.append(" and item.fcompanyId=?  \n", (Object)companyInfo.getId().toString());
            } else if (!StringUtils.isEmpty((String)companyInfo.getNumber())) {
                sqlb.append(" and item.fcompanyNumber=? \n", (Object)companyInfo.getNumber());
            }
        }
        if (rptInfo.getCurrency() != null) {
            if (rptInfo.getCurrency().getId() != null) {
                sqlb.append(" and item.ftargetcurrencyId=?  \n", (Object)rptInfo.getCurrency().getId().toString());
            } else if (!StringUtils.isEmpty((String)rptInfo.getCurrency().getNumber())) {
                sqlb.append(" and item.ftargetcurrencyNum=? \n", (Object)rptInfo.getCurrency().getNumber());
            }
        }
        if (itemFormulas != null && !itemFormulas.isEmpty()) {
            if (itemFormulas.size() <= 10) {
                this.buildItemFilter(ctx, itemFormulas, sqlb, "item.fitemNumber", "item.fdataelementNum", "item.fvalueType", false);
            } else {
                tmpTable = this.buildItemFilter(ctx, itemFormulas, sqlb, "item.fitemNumber", "item.fdataelementNum", "item.fvalueType", true);
                if (tmpTable != null) {
                    sqlb.append(" and exists(select 1 from ").append(tmpTable).append(" tmp where tmp.FitemNumber=item.fitemNumber ");
                    sqlb.append("         and tmp.FdataElement=item.fdataelementNum and tmp.fvalueType=item.fvalueType) \n ");
                }
            }
        }
        sqlb.append(" group by fyear,fperiod,").append(itemName).append(",").append(dataElementName).append(",fvalueType");
        sqlb.append(" order by fyear,fperiod,").append(itemName).append(",").append(dataElementName).append(",fvalueType");
        return tmpTable;
    }

    public String buildItemFilter(Context ctx, List<ItemFormula> itemFormulas, SQLBuilder sqlb, String itemNumField, String dataElementNumField, String valueTypeField, boolean isUserTmp) throws Exception {
        if (!isUserTmp) {
            int i = 0;
            SQLBuilder curSql = new SQLBuilder();
            for (ItemFormula itemFormula : itemFormulas) {
                if (StringUtils.isEmpty((String)itemFormula.getItemNumber()) || StringUtils.isEmpty((String)itemFormula.getDataElementNumber())) continue;
                if (curSql.getSQL().length() > 0) {
                    curSql.append(" or ");
                }
                curSql.append("(").append(itemNumField).append(" =? ", (Object)itemFormula.getItemNumber()).append(" and ").append(dataElementNumField).append(" =? ", (Object)itemFormula.getDataElementNumber()).append(" and ").append(valueTypeField).append("=? )", (Object)itemFormula.getValueType());
                ++i;
            }
            if (curSql.getSQL().length() > 0) {
                sqlb.append(" and (").append(curSql).append(") ");
            }
        } else {
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_ItemFormula(FitemNumber nvarchar(80),FdataElement nvarchar(80),fvaluetype int)");
            String sql = " insert into " + tempTable + "(FitemNumber,FdataElement,fvaluetype) values(?,?,?)";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (ItemFormula itemFormula : itemFormulas) {
                if (StringUtils.isEmpty((String)itemFormula.getItemNumber()) || StringUtils.isEmpty((String)itemFormula.getDataElementNumber())) continue;
                paramsList.add(new Object[]{itemFormula.getItemNumber(), itemFormula.getDataElementNumber(), itemFormula.getValueType()});
            }
            if (!paramsList.isEmpty()) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            }
            return tempTable;
        }
        return null;
    }

    public Map getRptItemInfoForGpt(IObjectValue object, Book book, Map gptInput) {
        HashMap<String, Map> result = new HashMap<String, Map>();
        try {
            if (object != null && book != null && object instanceof ReportBaseInfo) {
                ReportBaseInfo rpt = (ReportBaseInfo)object;
                GptFilterInfo gptInfo = this.getGptInfo(gptInput);
                List<ItemFormula> itemFormulas = this.getItemFormulas(book, gptInfo);
                if (itemFormulas == null || itemFormulas.isEmpty()) {
                    result.put("newdata", new HashMap());
                    return result;
                }
                Map rptDatas = null;
                if (GptFilterInfo.AnalysisType.Analysis.equals((Object)gptInfo.getAnalysisType())) {
                    rptDatas = this.getItemDatasByItemFormula(rpt, itemFormulas);
                } else if (GptFilterInfo.AnalysisType.YoY.equals((Object)gptInfo.getAnalysisType()) || GptFilterInfo.AnalysisType.MoM.equals((Object)gptInfo.getAnalysisType())) {
                    ReportBaseInfo curRpt = (ReportBaseInfo)rpt.clone();
                    curRpt.setData(null);
                    rptDatas = CslrptChatGptFacadeFactory.getRemoteInstance().getItemDatas(curRpt, gptInfo, itemFormulas);
                }
                if (rptDatas != null && !rptDatas.isEmpty()) {
                    result.put("newdata", rptDatas);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (result.isEmpty()) {
            result.put("newdata", new HashMap());
        }
        return result;
    }

    public Map<String, Map<String, BigDecimal>> getItemDatasByItemFormula(ReportBaseInfo rpt, List<ItemFormula> itemFormulas) throws Exception {
        if (itemFormulas != null && !itemFormulas.isEmpty()) {
            HashSet<String> itemNumbers = new HashSet<String>();
            HashMap<String, String> dataElements = new HashMap<String, String>();
            for (ItemFormula itemFormula : itemFormulas) {
                String itemNumber = itemFormula.getItemNumber();
                itemNumbers.add(itemNumber);
                String dataElementNum = itemFormula.getDataElementNumber();
                dataElements.put(dataElementNum, DataElementProvider.getDataElementName((String)dataElementNum));
            }
            Map<String, String> itemNameMap = this.getItemNameMap(itemNumbers);
            boolean isOneDataElement = dataElements.size() == 1;
            HashMap<String, BigDecimal> rptDatas = new HashMap<String, BigDecimal>();
            StringBuffer nameStr = new StringBuffer();
            for (ItemFormula itemFormula : itemFormulas) {
                nameStr.setLength(0);
                nameStr.append(itemNameMap.get(itemFormula.getItemNumber()));
                if (!isOneDataElement) {
                    nameStr.append((String)dataElements.get(itemFormula.getDataElementNumber()));
                }
                if (!this.isOneValueType) {
                    nameStr.append(ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getAlias());
                }
                if (itemFormula.getValue() == null) continue;
                rptDatas.put(nameStr.toString(), itemFormula.getValue());
            }
            HashMap<String, Map<String, BigDecimal>> result = new HashMap<String, Map<String, BigDecimal>>();
            if (rptDatas != null && !rptDatas.isEmpty()) {
                String yearPeriodStr = rpt.getYear() + yearStr;
                if (!RptPeriodTypeEnum.YEARLY.equals((Object)rpt.getPeriodType())) {
                    yearPeriodStr = RptPeriodTypeEnum.QUARTERLY.equals((Object)rpt.getPeriodType()) ? yearPeriodStr + rpt.getPeriod() + quartStr : yearPeriodStr + rpt.getPeriod() + periodStr;
                }
                result.put(yearPeriodStr, rptDatas);
            }
            return result;
        }
        return null;
    }

    public Map<String, String> getItemNameMap(Set<String> itemNumbers) throws Exception {
        HashMap<String, String> itemNameMap = new HashMap<String, String>();
        if (!itemNumbers.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", itemNumbers, CompareType.INCLUDE));
            view.getSelector().add("number");
            view.getSelector().add("name");
            RPTItemCollection coll = RPTItemFactory.getRemoteInstance().getRPTItemCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                itemNameMap.put(coll.get(i).getNumber(), coll.get(i).getName());
            }
        }
        return itemNameMap;
    }

    public List<ItemFormula> getItemFormulas(Book book, GptFilterInfo gptInfo) {
        Range range;
        ArrayList<ItemFormula> itemFormulas = new ArrayList<ItemFormula>();
        if (!GptFilterInfo.AnalysisType.NoRecognition.equals((Object)gptInfo.getAnalysisType()) && (range = book.getActiveSelectionRange()) != null) {
            Sheet.ICellsIterator iter = range.getIterator(false);
            this.getCellsIteratorItemFormulas(iter, itemFormulas, gptInfo.getAnalysisType());
        }
        return itemFormulas;
    }

    public void getCellsIteratorItemFormulas(Sheet.ICellsIterator iter, List<ItemFormula> itemFormulas, GptFilterInfo.AnalysisType analysisType) {
        if (iter != null) {
            boolean isAnalysis = GptFilterInfo.AnalysisType.Analysis.equals((Object)analysisType);
            String curDataElementNumber = null;
            int valueType = -1;
            while (iter.hasNext()) {
                Object obj;
                Cell cell = iter.next();
                if (cell == null || (obj = cell.getUserObjectValue("ITEM")) == null || !(obj instanceof ItemFormula)) continue;
                ItemFormula itemFormula = (ItemFormula)obj;
                if (isAnalysis && cell.getValue() != null && cell.getValue().getValue() instanceof BigDecimal) {
                    itemFormula.setValue((BigDecimal)cell.getValue().getValue());
                }
                if (curDataElementNumber == null) {
                    curDataElementNumber = itemFormula.getDataElementNumber();
                } else if (!curDataElementNumber.equals(itemFormula.getDataElementNumber())) {
                    this.isOneDataElement = false;
                }
                if (valueType == -1) {
                    valueType = itemFormula.getValueType();
                } else if (valueType != itemFormula.getValueType()) {
                    this.isOneValueType = false;
                }
                itemFormulas.add(itemFormula);
            }
        }
    }

    public GptFilterInfo getGptInfo(Map gptInput) {
        GptFilterInfo info = new GptFilterInfo();
        Object obj = gptInput.get("analysisType");
        if (obj != null && obj instanceof String) {
            GptFilterInfo.AnalysisType type = null;
            if ("2".equals((String)obj)) {
                type = GptFilterInfo.AnalysisType.YoY;
            } else if ("3".equals((String)obj)) {
                type = GptFilterInfo.AnalysisType.MoM;
            } else if ("1".equals((String)obj)) {
                type = GptFilterInfo.AnalysisType.Analysis;
            } else if ("0".equals((String)obj)) {
                type = GptFilterInfo.AnalysisType.NoRecognition;
            }
            info.setAnalysisType(type);
        }
        if ((obj = gptInput.get("searchPeriod")) != null) {
            info.setSearchPeriod(Integer.valueOf(obj.toString()));
        }
        if (info.getSearchPeriod() > 0) {
            info.setSearchPeriod(info.getSearchPeriod() - 1);
        } else if (info.getSearchPeriod() < 0) {
            info.setSearchPeriod(info.getSearchPeriod() + 1);
        }
        obj = gptInput.get("text");
        if (obj != null) {
            info.setText(obj.toString());
        }
        return info;
    }

    public static void test(Context ctx, ReportBaseInfo rptInfo) {
        try {
            Book book = rptInfo.getBook();
            Sheet sheet = book.getSheet(0);
            int col = 2;
            ArrayList<ItemFormula> itemFormulas = new ArrayList<ItemFormula>();
            for (int i = 5; i < 20; ++i) {
                Object obj = sheet.getRange(i, col).getUserObject("ITEM");
                if (obj == null || !(obj instanceof ItemFormula)) continue;
                itemFormulas.add((ItemFormula)obj);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

