/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kml.BookToKml;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SpreadHelper {
    public static Sheet copySheet(Book rsbook, Sheet res) throws Exception {
        return SpreadHelper.copySheet(rsbook, res, false);
    }

    public static Sheet copySheet(Book rsbook, Sheet res, boolean discardFormula) throws Exception {
        Book book = Book.Manager.getNewBook(null, (int)1);
        book.setCalculate(false);
        Sheet sheet = book.getSheet(0);
        sheet.copySheetFrom(res);
        sheet.setName(res.getSheetName());
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            cell.setUserObject("ITEM", null);
            if (!discardFormula) continue;
            Variant value = cell.getValue();
            cell.setFormula(null);
            cell.setValue(value);
        }
        return sheet;
    }

    public static Book copyBook(Book book) throws Exception {
        return SpreadHelper.copyBook(book, false);
    }

    public static Book copyBook(Book book, boolean discardFormula) throws Exception {
        return SpreadHelper.copyBook(book, null, discardFormula);
    }

    public static Book copyBook(Book book, ICalculateContextProvider context, boolean discardFormula) throws Exception {
        return SpreadHelper.copyBook(book, context, discardFormula, false);
    }

    public static Book copyBook(Book book, ICalculateContextProvider context, boolean discardFormula, boolean isCopySheet) throws Exception {
        isCopySheet = true;
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        Book newBook = Book.Manager.getNewBook(null, (int)0);
        newBook.setCalculate(false);
        newBook.getUndoManager().enable(false);
        newBook.setComment(book.getComment());
        if (context != null) {
            FormulaDefinition.registerFormulaToBook(newBook, context);
        }
        int size = book.getNames().size();
        for (int i = 0; i < size; ++i) {
            Expr newExpr;
            NamedObjectNode no = book.getNames().getObjectNode(i);
            if (!no.isVisible()) continue;
            Expr oldExpr = no.getExpr();
            Expr expr = newExpr = oldExpr == null ? null : oldExpr.getCopy();
            if (newExpr != null) {
                IExprNode[] nodes = newExpr.getNodes();
                for (int j = nodes.length - 1; j >= 0; --j) {
                    IExprNode node = nodes[j];
                    if (!(node instanceof CellBlockNode)) continue;
                    CellBlockNode newNode = CellBlockNode.getClone((CellBlockNode)((CellBlockNode)node));
                    newNode.setSheet(((CellBlockNode)node).getSheet());
                    newNode.setRefs(null);
                    nodes[j] = newNode;
                }
            }
            newBook.getNames().insert((Object)new NamedObjectNode(no.getName(), newExpr, newBook, null));
        }
        Sheet newSheet = null;
        Sheet oldSheet = null;
        SortedUserObjectArray userObjArr = null;
        Object[] userObjs = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            oldSheet = book.getSheet(i);
            if (isCopySheet) {
                newSheet = new Sheet(newBook, oldSheet.getSheetName());
                newSheet.copySheetFrom(oldSheet);
                newSheet.setComment(oldSheet.getComment());
                userObjArr = oldSheet.getUserObjects();
                if (userObjArr != null) {
                    userObjs = userObjArr.getArray();
                    for (int j = 0; j < userObjs.length; ++j) {
                        if (userObjs[j] == null) continue;
                        newSheet.setUserObject(((UserObject)userObjs[j]).getKey(), ((UserObject)userObjs[j]).getValue());
                    }
                }
            }
            newBook.addSheet(newSheet);
        }
        properties.restoreToBook(newBook);
        newBook.setActiveSheet(book.getActiveSheet().getSheetName());
        return newBook;
    }

    public static Sheet sumSpreadSheet(Book book, List sheetNames, String templateSheetName) throws Exception {
        if (sheetNames == null || sheetNames.size() < 1) {
            return null;
        }
        Sheet sheet = book.getSheet(templateSheetName);
        sheetNames.remove(templateSheetName);
        if (sheet == null) {
            throw new Exception("Choose one sheet at least");
        }
        SumcalcRange sumRange = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE");
        if (sumRange == null || sumRange.size() < 1) {
            throw new Exception("Sum range must be set.");
        }
        Sheet template = SpreadHelper.copySheet(book, sheet);
        String appropriateSheetName = SpreadHelper.getAppropriateSheetName("Sum", SpreadHelper.getAllSheetsName(book));
        template.setName(appropriateSheetName);
        for (int i = 0; i < sheetNames.size(); ++i) {
            Sheet work = book.getSheet((String)sheetNames.get(i));
            for (int j = 0; j < sumRange.size(); ++j) {
                CellBlock site = sumRange.getCellBlock(j);
                for (int k = site.getRow(); k <= site.getRow2(); ++k) {
                    for (int g = site.getCol(); g <= site.getCol2(); ++g) {
                        Cell workCell = work.getCell(k, g, false);
                        if (workCell == null) continue;
                        Cell templateCell = template.getCell(k, g, true);
                        try {
                            BigDecimal addend = workCell.getValue().toBigDecimal();
                            BigDecimal augend = templateCell.getValue().toBigDecimal();
                            templateCell.setValue(new Variant((Object)addend.add(augend)));
                            continue;
                        }
                        catch (SyntaxErrorException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return template;
    }

    public static String getAppropriateSheetName(String base, List sheetNames) {
        String result = base;
        int count = 1;
        while (sheetNames.contains(result)) {
            result = base + count;
            ++count;
        }
        return result;
    }

    public static List getAllSheetsName(Book book) {
        ArrayList<String> result = new ArrayList<String>();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            result.add(book.getSheet(i).getSheetName());
        }
        return result;
    }

    public static Sheet findSheetByID(Book book, String id) {
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sh = book.getSheet(i);
            if (!id.equalsIgnoreCase(sh.getID())) continue;
            return sh;
        }
        return null;
    }

    public static File toExcelFile(Book book) throws Exception {
        if (book != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eas_temp_report", ".xls");
            path = tempFile.getCanonicalPath();
            try {
                KDSBook kds = BookToKDSBook.traslate((Book)book);
                exportM.exportToExcel(kds, path);
            }
            catch (POIExportException e9) {
                throw new Exception(RptUtil.getResourceSince51((String)"cannotTransExcel"));
            }
            return new File(path);
        }
        return null;
    }

    public static File toXmlFile(Book book, String[] sheetNames, String fileName) throws Exception {
        if (book == null) {
            return null;
        }
        String path = null;
        if (fileName == null) {
            File tempFile = File.createTempFile("eas_temp_report", ".xls");
            path = tempFile.getCanonicalPath();
        } else {
            path = fileName;
        }
        BookIOController bookio = new BookIOController();
        bookio.setForExcel(true);
        bookio.setShouldClone(false);
        bookio.setShouldReplaceSuffix(true);
        BookToKml kml = new BookToKml();
        kml.setBookIOController(bookio);
        kml.export(book, path, sheetNames);
        return new File(path);
    }

    public static File toHTMLFile(Book book) throws Exception {
        if (book != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eas_temp_report", ".html");
            path = tempFile.getCanonicalPath();
            KDSBook kds = BookToKDSBook.traslate((Book)book);
            PrintableBook prtbook = new PrintableBook(kds);
            exportM.exportToHtmlFile(prtbook, path);
            File file = new File(path);
            return file;
        }
        return null;
    }
}

