/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.TemplateItemListNewUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RptRelCheckageCheckUtil {
    private static final Logger logger = Logger.getLogger(RptRelCheckageCheckUtil.class);

    public static Map checkRelUnConfirmedCheckageData(Context ctx, List<String> rptIds) throws BOSException, EASBizException {
        OneToManyMap failRpt_Bills = new OneToManyMap(2);
        try {
            ArrayList multiPeriodRptParams = new ArrayList();
            Map<String, String> relTemplateId_rptIds = RptRelCheckageCheckUtil.getRelTemplates(ctx, rptIds, multiPeriodRptParams);
            if (relTemplateId_rptIds != null && !relTemplateId_rptIds.isEmpty()) {
                OneToManyMap tmpItemListTblNames = TemplateItemListNewUtil.getTemplateItemListTableNameByGroup(ctx, relTemplateId_rptIds.keySet());
                RptRelCheckageCheckUtil.checkExistRptItemMap(ctx, (Map)tmpItemListTblNames, relTemplateId_rptIds, (Map)failRpt_Bills);
                RptRelCheckageCheckUtil.checkNotExistRptItemMap(ctx, (Map)tmpItemListTblNames, relTemplateId_rptIds, (Map)failRpt_Bills);
            }
            if (!multiPeriodRptParams.isEmpty()) {
                RptRelCheckageCheckUtil.checkMultiPeriodRpt(ctx, multiPeriodRptParams, (Map)failRpt_Bills);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getRelCheckageDataUnConfirmedRptIds error", (Throwable)e);
            throw new BOSException("getRelCheckageDataUnConfirmedRptIds error", (Throwable)e);
        }
        return failRpt_Bills;
    }

    public static List buildCheckRelCheckagedataResult(Context ctx, Map unPassRpt_Bills, List reportIds, boolean isCheck) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        try {
            if (unPassRpt_Bills != null && !unPassRpt_Bills.isEmpty()) {
                Map<String, String> unPassRpt_msgMap = RptRelCheckageCheckUtil.buildUnPassMsg(ctx, unPassRpt_Bills);
                if (isCheck) {
                    for (Object rptId : unPassRpt_Bills.keySet()) {
                        HashMap<String, Object> checkResult = new HashMap<String, Object>();
                        checkResult.put("KEY_ID", rptId);
                        checkResult.put("KEY_CHECK_FLAG", false);
                        checkResult.put("KEY_CHECK_MESSAGE", unPassRpt_msgMap.get(rptId));
                        result.add(checkResult);
                    }
                } else {
                    for (Object rptId : reportIds) {
                        HashMap<String, Object> checkResult = new HashMap<String, Object>();
                        checkResult.put("KEY_ID", rptId);
                        String msg = unPassRpt_msgMap.get(rptId);
                        checkResult.put("KEY_CHECK_FLAG", msg == null);
                        checkResult.put("KEY_CHECK_MESSAGE", msg);
                        result.add(checkResult);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BOSException("billCheckRelCheckagedataResult error", (Throwable)e);
        }
        return result;
    }

    public static Map<String, String> buildUnPassMsg(Context ctx, Map failRpt_Bills) throws Exception {
        HashMap<String, String> rptId_msgMap = new HashMap<String, String>();
        if (!failRpt_Bills.isEmpty()) {
            String resource = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"537_rptRelaCheckageData", (Locale)ctx.getOriginLocale());
            MessageFormat format = new MessageFormat(resource);
            SQLBuilder sql = new SQLBuilder();
            String name = "fname_" + ctx.getLocale();
            sql.append(" select rpt.fname rptName,tmp.fname tmpName,unit.").append(name).append(" unitName,curr.");
            sql.append(name).append(" currencyName,rpt.fyear,rpt.fperiod,rpt.fid \n");
            sql.append(" from t_csl_cslreport rpt  \n");
            sql.append(" inner join t_org_baseunit unit on unit.fid=rpt.forgunitid  \n");
            sql.append(" inner join t_bd_currency curr on curr.fid=rpt.fcurrencyid  \n");
            sql.append(" inner join t_rpt_template tmp on tmp.fid=rpt.ftemplateid  \n");
            sql.append(" where rpt.fid in ", failRpt_Bills.keySet()).append("\n");
            sql.append(" order by tmp.fnumber ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            StringBuffer msg = new StringBuffer();
            while (rowSet.next()) {
                msg.setLength(0);
                String rptId = rowSet.getString("fid");
                String unitName = rowSet.getString("unitName");
                String rptName = rowSet.getString("rptName");
                String tmpName = rowSet.getString("tmpName");
                int year = rowSet.getInt("fyear");
                int period = rowSet.getInt("fperiod");
                String currencyName = rowSet.getString("currencyName");
                msg.append(format.format(new Object[]{unitName, rptName, tmpName, String.valueOf(year), period, currencyName}));
                for (Object billNumber : (Collection)failRpt_Bills.get(rptId)) {
                    msg.append(billNumber).append("<br>");
                }
                rptId_msgMap.put(rptId, msg.toString());
            }
        }
        return rptId_msgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMultiPeriodRpt(Context ctx, List multiPeriodRptParams, Map failRpt_Bills) throws Exception {
        String tmpTblName = null;
        TempTablePool tempTbPool = null;
        try {
            tempTbPool = TempTablePool.getInstance((Context)ctx);
            tmpTblName = tempTbPool.createTempTable("create table t_csl_noMonthRpt(frptid varchar(44),ftemplateid varchar(44),fyear int,fstartperiod int, fendperiod int)");
            SQLBuilder sql = new SQLBuilder();
            sql.append(" insert into ").append(tmpTblName).append("(frptid,ftemplateid,fyear,fstartperiod,fendperiod) ");
            sql.append(" values(?,?,?,?,?)");
            DbUtil.executeBatch((Context)ctx, (String)sql.getSQL(), (List)multiPeriodRptParams);
            sql.reset();
            RptRelCheckageCheckUtil.buildExistRptItemMapSql(sql, null, null, "t_csl_templetitemlist", tmpTblName);
            sql.append("\n union \n");
            RptRelCheckageCheckUtil.buildNotExistRptItemMapSql(sql, null, null, "t_csl_templetitemlist", tmpTblName);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            while (rowSet != null && rowSet.next()) {
                failRpt_Bills.put(rowSet.getString("rptId"), rowSet.getString("fnumber"));
            }
        }
        finally {
            if (!DebugLogger.isDebug && !StringUtils.isEmpty((CharSequence)tmpTblName)) {
                tempTbPool.releaseTable(tmpTblName);
            }
        }
    }

    public static void checkExistRptItemMap(Context ctx, Map tmpItemListTblNames, Map relTemplateId_rptIds, Map failRpt_Bills) throws Exception {
        if (tmpItemListTblNames != null && !tmpItemListTblNames.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            HashSet rptIds = new HashSet();
            for (Object tmpItemListTbl : tmpItemListTblNames.keySet()) {
                if (!rptIds.isEmpty()) {
                    sql.append(" \n union \n ");
                }
                rptIds.clear();
                for (Object templateId : (Collection)tmpItemListTblNames.get(tmpItemListTbl)) {
                    rptIds.addAll((Collection)relTemplateId_rptIds.get(templateId));
                }
                RptRelCheckageCheckUtil.buildExistRptItemMapSql(sql, (Collection)tmpItemListTblNames.get(tmpItemListTbl), rptIds, (String)tmpItemListTbl, null);
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            while (rowSet != null && rowSet.next()) {
                failRpt_Bills.put(rowSet.getString("rptId"), rowSet.getString("fnumber"));
            }
        }
    }

    public static void buildExistRptItemMapSql(SQLBuilder sql, Collection templateIds, Collection rptIds, String tmpItemListTbl, String multiPeriodTmpTbl) throws Exception {
        boolean isMonthRpt = StringUtils.isEmpty((CharSequence)multiPeriodTmpTbl);
        sql.append(" select distinct billHead.fnumber,rpt.fid rptId \n");
        sql.append(" from ").append(tmpItemListTbl).append(" tmpItmLst \n");
        sql.append(" inner join T_Csl_RPTItem rptitem on rptitem.fnumber=tmpItmLst.fItemNumber   \n");
        sql.append(" inner join T_Csl_RPTItemMap itemMap on itemMap.frptItemId=rptitem.fid and itemMap.fdataelement=tmpItmLst.fdataelement \n");
        sql.append(" inner join T_Csl_RPTItemAccount itemAcc on itemAcc.frptitemMapId=itemMap.fid  \n");
        sql.append(" inner join t_csl_checkagebill bill on bill.FCheckAccountId=itemAcc.fcheckaccountId \n");
        sql.append(" inner join T_Csl_CheckageBillCompany billCom on billCom.fid=bill.FBillCompanyId \n");
        sql.append(" inner join T_Csl_CheckageBillHead billHead on billHead.fid=bill.FBillHeadId \n");
        sql.append(" inner join t_csl_cslreport rpt on rpt.fyear=bill.fyear and bill.fcompanyId=rpt.forgUnitId and rpt.fcurrencyId=bill.fcurrencyId ");
        if (isMonthRpt) {
            sql.append("      and rpt.fperiodtype=3 and rpt.fperiod=bill.fperiod \n");
        } else {
            sql.append("\n  inner join ").append(multiPeriodTmpTbl).append(" tbl on tbl.frptId=rpt.fid and bill.fperiod>=tbl.fstartPeriod and bill.fperiod<=tbl.fendPeriod \n");
        }
        sql.append(" inner join t_rpt_template tmp on tmp.fid=").append(isMonthRpt ? "rpt" : "tbl").append(".ftemplateid and (tmp.fid=tmpItmLst.ftemplateid or tmp.fgrouptemplateid=tmpItmLst.ftemplateid) \n");
        sql.append(" where billCom.FConfirmStatus=?  \n", (Object)0);
        if (isMonthRpt) {
            sql.append(" and tmpItmLst.ftemplateId in ", templateIds);
            sql.append(" and rpt.fid in ", rptIds);
        } else {
            sql.append(" and tmpItmLst.ftemplateId in (select distinct ftemplateid from ").append(multiPeriodTmpTbl).append(") \n");
        }
        sql.append(" and (itemAcc.fdc=1 and bill.FDebit is not null or itemAcc.fdc=-1 and bill.FCredit is not null) \n");
        sql.append(" and tmpItmLst.fvaluetype in(1)  \n ");
        sql.append(" and itemMap.fisfree=0 \n");
    }

    public static void checkNotExistRptItemMap(Context ctx, Map tmpItemListTblNames, Map relTemplateId_rptIds, Map failRpt_Bills) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        HashSet rptIds = new HashSet();
        for (Object tmpItemListTbl : tmpItemListTblNames.keySet()) {
            if (!rptIds.isEmpty()) {
                sql.append(" \n union \n ");
            }
            rptIds.clear();
            for (Object templateId : (Collection)tmpItemListTblNames.get(tmpItemListTbl)) {
                rptIds.addAll((Collection)relTemplateId_rptIds.get(templateId));
            }
            RptRelCheckageCheckUtil.buildNotExistRptItemMapSql(sql, (Collection)tmpItemListTblNames.get(tmpItemListTbl), rptIds, (String)tmpItemListTbl, null);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        while (rowSet != null && rowSet.next()) {
            failRpt_Bills.put(rowSet.getString("rptId"), rowSet.getString("fnumber"));
        }
    }

    public static void buildNotExistRptItemMapSql(SQLBuilder sql, Collection templateIds, Collection rptIds, String tmpItemListTbl, String noMonthTmpTbl) throws Exception {
        boolean isMonthRpt = StringUtils.isEmpty((CharSequence)noMonthTmpTbl);
        sql.append(" select distinct billHead.fnumber,rpt.fid rptId \n");
        sql.append(" from ").append(tmpItemListTbl).append(" tmpItmLst \n");
        sql.append(" inner join T_Csl_RPTItem rptitem on rptitem.fnumber=tmpItmLst.fItemNumber   \n");
        sql.append(" inner join T_Csl_CheckageAccount checkAcc on checkAcc.fitemNumber=tmpItmLst.fItemNumber and checkAcc.FDataElement=tmpItmLst.fdataelement  ");
        sql.append("    and checkAcc.FItemType=?  \n", (Object)1);
        sql.append(" inner join t_csl_checkagebill bill on bill.FCheckAccountId=checkAcc.fid \n");
        sql.append(" inner join T_Csl_CheckageBillCompany billCom on billCom.fid=bill.FBillCompanyId \n");
        sql.append(" inner join T_Csl_CheckageBillHead billHead on billHead.fid=bill.FBillHeadId \n");
        sql.append(" inner join t_csl_cslreport rpt on rpt.fyear=bill.fyear and bill.fcompanyId=rpt.forgUnitId and rpt.fcurrencyId=bill.fcurrencyId ");
        if (isMonthRpt) {
            sql.append("      and rpt.fperiodtype=3 and rpt.fperiod=bill.fperiod \n");
        } else {
            sql.append("\n  inner join ").append(noMonthTmpTbl).append(" tbl on tbl.frptId=rpt.fid and bill.fperiod>=tbl.fstartPeriod and bill.fperiod<=tbl.fendPeriod \n");
        }
        sql.append(" inner join t_rpt_template tmp on tmp.fid=").append(isMonthRpt ? "rpt" : "tbl").append(".ftemplateid and (tmp.fid=tmpItmLst.ftemplateid or tmp.fgrouptemplateid=tmpItmLst.ftemplateid) \n");
        sql.append(" left join T_Csl_RPTItemMap itemMap on itemMap.frptItemId=rptitem.fid and itemMap.fdataelement=tmpItmLst.fdataelement and itemMap.fisfree=0 \n");
        sql.append(" where billCom.FConfirmStatus=?  \n", (Object)0);
        if (isMonthRpt) {
            sql.append(" and tmpItmLst.ftemplateId in ", templateIds);
            sql.append(" and rpt.fid in ", rptIds);
        } else {
            sql.append(" and tmpItmLst.ftemplateId in (select distinct ftemplateid from ").append(noMonthTmpTbl).append(") \n");
        }
        sql.append(" and tmpItmLst.fvaluetype in(1)  \n ");
        sql.append(" and itemMap.fid is null \n");
    }

    public static Map<String, String> getRelTemplates(Context ctx, List<String> rptIds, List multiPeriodRptParams) throws Exception {
        if (rptIds != null && !rptIds.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select cslrpt.fid rptId, case when tmp.fgrouptemplateid is null then tmp.fid else tmp.fgrouptemplateid end tmpId,cslrpt.fperiodType,cslrpt.fyear,cslrpt.fperiod,rpt.fissupportadjust \n");
            sql.append("from T_Csl_CheckageOrgRelTemplate rel \n");
            sql.append(" inner join t_rpt_template tmp on tmp.fgroup=rel.FTemplateGroup  \n");
            sql.append(" inner join t_csl_cslreport cslrpt on cslrpt.ftemplateid=tmp.fid and cslrpt.FORGUNITID=rel.FCHECKAGECOMPANYID \n");
            sql.append(" left join t_rpt_report rpt on rpt.fcslreportid=cslrpt.fid  \n");
            sql.append(" where cslrpt.fid in ", rptIds);
            sql.append(" and cslrpt.fperiodType>=3 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
            OneToManyMap relTemplateMap = new OneToManyMap(2);
            while (rowSet != null && rowSet.next()) {
                int periodType = rowSet.getInt("fperiodType");
                int year = rowSet.getInt("fyear");
                int period = rowSet.getInt("fperiod");
                int issupportadjust = rowSet.getInt("fissupportadjust");
                if (periodType == 3) {
                    if (issupportadjust == 1 && period == 12) {
                        multiPeriodRptParams.add(new Object[]{rowSet.getString("rptId"), rowSet.getString("tmpId"), year, 12, 13});
                        continue;
                    }
                    relTemplateMap.put(rowSet.getString("tmpId"), rowSet.getString("rptId"));
                    continue;
                }
                int[] yearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType)), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int[] lastYearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType)), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int endPeriod = lastYearPeriod[1];
                if (issupportadjust == 1 && endPeriod == 12) {
                    endPeriod = 13;
                }
                multiPeriodRptParams.add(new Object[]{rowSet.getString("rptId"), rowSet.getString("tmpId"), year, yearPeriod[1], endPeriod});
            }
            return relTemplateMap;
        }
        return null;
    }
}

