/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceCheckLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ToleranceUtil {
    private MessageFormat toleranceMsgFormat = null;
    private MessageFormat companyDiffMsgFormat = null;
    private MessageFormat checkNumberMsgFormat = null;
    private DecimalFormat f = new DecimalFormat("#,##0.######");

    public static ToleranceUtil getInstance() {
        return new ToleranceUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String>[] batchCheckTolerance(Context ctx, Set<String> companyIds, String companyIdTmpTableName, int year, int period, String currencyId, boolean isOnlyCheckToler) throws Exception {
        if (companyIds != null || companyIdTmpTableName != null) {
            ParamTempTblService service = null;
            try {
                if (companyIdTmpTableName == null && companyIds.size() > 30) {
                    service = ParamTempTblService.getDefaultInstance((Context)ctx, companyIds, null);
                    companyIdTmpTableName = service.getTmpTableName();
                }
                SQLBuilder sql = new SQLBuilder();
                sql.reset();
                sql.append(" select distinct comDiff.FCompanyId,unit.fname_").append((Object)ctx.getLocale()).append(" unitName,");
                sql.append(" toler.FOrgUnitId,unit.fnumber,comDiff.sumDiff,toler.toleranceValue ");
                if (!isOnlyCheckToler) {
                    sql.append(",(comDiff.sumDiff-comDiff.sumSingleDiff) unIncludeSingDiff ");
                }
                sql.append(" from (");
                sql.append(" \tselect sum(abs(isnull(billHead.FCOMPANYDIFF,0))) sumDiff,billCompany.FCompanyId  ");
                if (!isOnlyCheckToler) {
                    sql.append(",sum(case when fisunilateralreconciliation=1 then abs(billHead.FCOMPANYDIFF) else 0 end) sumSingleDiff ");
                }
                sql.append("\tfrom t_csl_checkagebillhead billHead  \n");
                sql.append(" \tinner join (");
                sql.append(" \t\tselect distinct head.fid,bill.FCompanyId,acctMap.fisunilateralreconciliation ");
                sql.append(" \t\tfrom t_csl_checkagebill bill \n");
                sql.append(" \t\tinner join t_csl_checkagebillhead head on head.fid=bill.FBILLHEADID \n");
                sql.append(" \t\tinner join T_Csl_AccountMap acctMap on acctMap.fid=head.FAccountMapId  \n");
                sql.append("  \t\twhere bill.FYear=? ", (Object)year);
                sql.append("   \t\tand bill.FPeriod=? ", (Object)period).append(" and ");
                ToleranceUtil.setCompanyFilter(sql, companyIdTmpTableName, companyIds, "bill.FCompanyId");
                if (!StringUtils.isEmpty((CharSequence)currencyId)) {
                    sql.append("   \tand bill.fcurrencyId=? ", (Object)currencyId);
                }
                sql.append(" \t\tunion ");
                sql.append(" \t\tselect distinct head.fid,bill.FtargetCompanyId FCompanyId,acctMap.fisunilateralreconciliation ");
                sql.append(" \t\tfrom t_csl_checkagebill bill \n");
                sql.append(" \t\tinner join t_csl_checkagebillhead head on head.fid=bill.FBILLHEADID \n");
                sql.append(" \t\tinner join T_Csl_AccountMap acctMap on acctMap.fid=head.FAccountMapId \n");
                sql.append("  \t\twhere bill.FYear=? ", (Object)year);
                sql.append("   \t\tand bill.FPeriod=? ", (Object)period).append(" and ");
                ToleranceUtil.setCompanyFilter(sql, companyIdTmpTableName, companyIds, "bill.FtargetCompanyId");
                if (!StringUtils.isEmpty((CharSequence)currencyId)) {
                    sql.append("   \tand bill.fcurrencyId=? ", (Object)currencyId);
                }
                sql.append(" \t) billCompany on billCompany.fid=billHead.fid ");
                sql.append(" \tgroup by billCompany.FCompanyId ");
                sql.append(") comDiff ");
                sql.append(" inner join t_org_baseunit unit on unit.fid=comDiff.FCompanyId  \n");
                sql.append(isOnlyCheckToler ? " inner join " : " left join ").append(" ( ");
                sql.append(" \tselect sum(abs(FValue)) toleranceValue,FOrgUnitId ");
                sql.append(" \tfrom T_Csl_Tolerance where ");
                ToleranceUtil.setCompanyFilter(sql, companyIdTmpTableName, companyIds, "FOrgUnitId");
                sql.append(" \tand FToleranceType=? ", (Object)ToleranceTypeEnum.all);
                sql.append("\t group by FOrgUnitId ");
                sql.append(") toler on toler.FOrgUnitId=comDiff.FCompanyId ");
                sql.append(" where ");
                if (!isOnlyCheckToler) {
                    sql.append("  (toler.FOrgUnitId is null and comDiff.sumDiff-comDiff.sumSingleDiff<>0 ) or");
                }
                sql.append("  (toler.FOrgUnitId is not null and comDiff.sumDiff>toler.toleranceValue )");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                HashMap<String, String> noPassTolerCompany = new HashMap<String, String>();
                HashMap<String, String> noPassDiffCompany = new HashMap<String, String>();
                StringBuffer msg = new StringBuffer();
                MessageFormat diffBigTolerFormat = null;
                MessageFormat diffFormat = null;
                while (rowSet.next()) {
                    msg.setLength(0);
                    boolean ishasSetToler = !StringUtils.isEmpty((CharSequence)rowSet.getString("FOrgUnitId"));
                    msg.append(rowSet.getString("fnumber")).append("-").append(rowSet.getString("unitName"));
                    if (ishasSetToler) {
                        if (diffBigTolerFormat == null) {
                            diffBigTolerFormat = new MessageFormat(AccountCheckUtil.getResourceString(ctx, "543_diffBigToler", null));
                        }
                        msg.append("[").append(diffBigTolerFormat.format(new Object[]{rowSet.getString("sumDiff"), rowSet.getString("toleranceValue")})).append("]");
                        noPassTolerCompany.put(rowSet.getString("FCompanyId"), msg.toString());
                        continue;
                    }
                    if (diffFormat == null) {
                        diffFormat = new MessageFormat(AccountCheckUtil.getResourceString(ctx, "544_diffValue", null));
                    }
                    msg.append("[").append(diffFormat.format(new Object[]{rowSet.getString("unIncludeSingDiff")})).append("]");
                    noPassDiffCompany.put(rowSet.getString("FCompanyId"), msg.toString());
                }
                Map[] mapArray = new Map[]{noPassTolerCompany, noPassDiffCompany};
                return mapArray;
            }
            finally {
                if (service != null && !DebugLogger.isDebug) {
                    service.release();
                }
            }
        }
        return null;
    }

    public static void setCompanyFilter(SQLBuilder sql, String companyIdTmpTableName, Set<String> companyIds, String field) throws Exception {
        sql.append(field).append(" in ");
        if (companyIdTmpTableName != null) {
            sql.append(" (select id from ").append(companyIdTmpTableName).append(") ");
        } else {
            sql.append(" ", companyIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>>[] batchCheckToleranceForGLClosePeriod(Context ctx, Set<String> companyIds, int year, int period) throws Exception {
        if (companyIds != null && !companyIds.isEmpty()) {
            Map<String, Map<String, String>>[] mapArray;
            block8: {
                String billHeadTmpTable;
                block9: {
                    ParamTempTblService service = null;
                    billHeadTmpTable = null;
                    try {
                        Map<String, Map<String, String>>[] result;
                        String companyIdTmpTableName = null;
                        if (companyIds.size() > 30) {
                            service = ParamTempTblService.getDefaultInstance((Context)ctx, companyIds, null);
                            companyIdTmpTableName = service.getTmpTableName();
                        }
                        billHeadTmpTable = ToleranceUtil.getBillHeadTmpTable(ctx, companyIds, companyIdTmpTableName, year, period, null);
                        Map<String, TolerParamEnum> tolerCheckParams = this.getTolerCheckParams(ctx, companyIds, companyIdTmpTableName);
                        mapArray = result = this.checkCheckToleranceByCompany(ctx, companyIds, companyIdTmpTableName, billHeadTmpTable, tolerCheckParams, year, period);
                        if (DebugLogger.isDebug) break block8;
                        if (service == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!DebugLogger.isDebug) {
                            if (service != null) {
                                service.release();
                            }
                            if (!StringUtils.isEmpty(billHeadTmpTable)) {
                                TempTablePool.getInstance((Context)ctx).releaseTable(billHeadTmpTable);
                            }
                        }
                        throw throwable;
                    }
                    service.release();
                }
                if (!StringUtils.isEmpty((CharSequence)billHeadTmpTable)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(billHeadTmpTable);
                }
            }
            return mapArray;
        }
        return null;
    }

    public static String getBillHeadTmpTable(Context ctx, Set<String> companyIds, String companyIdTmpTableName, int year, int period, String currencyId) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("create table t_csl_billHead(fid varchar(44),fcompanyId varchar(44),fsmallCompanyId varchar(44),fbigCompanyId varchar(44),fcurrencyId varchar(44)) ");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTableName = pool.createTempTable(sql.getSQL());
        try {
            sql.reset();
            sql.append(" insert into ").append(tmpTableName).append("(fid,fcompanyId,fbigCompanyId,fsmallCompanyId,fcurrencyId) ");
            sql.append(" \t\tselect distinct head.fid,bill.FCompanyId,case when bill.FCompanyId>bill.FtargetCompanyId then bill.FCompanyId else bill.FtargetCompanyId end fbigCompanyId,");
            sql.append("         case when bill.FCompanyId>bill.FtargetCompanyId then bill.FtargetCompanyId else bill.FCompanyId end fsmallCompanyId,bill.fcurrencyId");
            sql.append(" \t\tfrom t_csl_checkagebill bill \n");
            sql.append(" \t\tinner join t_csl_checkagebillhead head on head.fid=bill.FBILLHEADID \n");
            sql.append("  \t\twhere bill.FYear=? ", (Object)year);
            sql.append("        and head.FCompanyDiff<>0 ");
            sql.append("   \t\tand bill.FPeriod=? ", (Object)period).append(" and ");
            ToleranceUtil.setCompanyFilter(sql, companyIdTmpTableName, companyIds, "bill.FCompanyId");
            if (!StringUtils.isEmpty((CharSequence)currencyId)) {
                sql.append("   \tand bill.fcurrencyId=? ", (Object)currencyId);
            }
            sql.append(" \t\tunion ");
            sql.append(" \t\tselect distinct head.fid,bill.FtargetCompanyId FCompanyId,case when bill.FCompanyId>bill.FtargetCompanyId then bill.FCompanyId else bill.FtargetCompanyId end fbigCompanyId,");
            sql.append("         case when bill.FCompanyId>bill.FtargetCompanyId then bill.FtargetCompanyId else bill.FCompanyId end fsmallCompanyId,bill.fcurrencyId");
            sql.append(" \t\tfrom t_csl_checkagebill bill \n");
            sql.append(" \t\tinner join t_csl_checkagebillhead head on head.fid=bill.FBILLHEADID \n");
            sql.append("  \t\twhere bill.FYear=? ", (Object)year);
            sql.append("        and head.FCompanyDiff<>0 ");
            sql.append("   \t\tand bill.FPeriod=? ", (Object)period).append(" and ");
            ToleranceUtil.setCompanyFilter(sql, companyIdTmpTableName, companyIds, "bill.FtargetCompanyId");
            if (!StringUtils.isEmpty((CharSequence)currencyId)) {
                sql.append("   \tand bill.fcurrencyId=? ", (Object)currencyId);
            }
            DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        }
        catch (Throwable e) {
            if (tmpTableName != null) {
                pool.releaseTable(tmpTableName);
            }
            throw new Exception(e);
        }
        return tmpTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>>[] checkCheckToleranceByCompany(Context ctx, Set<String> companyIds, String companyIdTmpTableName, String billHeadTmpTable, Map<String, TolerParamEnum> tolerCheckParams, int year, int period) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("delete from T_Csl_ToleranceCheckLog where fyear=?", (Object)year);
        sql.append(" and fperiod=?", (Object)period).append(" and ");
        ToleranceUtil.setCompanyFilter(sql, companyIdTmpTableName, companyIds, "fcompanyId");
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        Map<String, ToleranceInfo>[] tolerConfigMaps = ToleranceUtil.getCompanyToleranceConfig(ctx, tolerCheckParams);
        Map<String, ToleranceInfo> checkOneOwnCompanyTolerConfig = tolerConfigMaps[0];
        Map<String, ToleranceInfo> checkOneTwoCompanyTolerConfig = tolerConfigMaps[1];
        Map<String, ToleranceInfo> checkAllTolerConfig = tolerConfigMaps[2];
        sql.reset();
        String name = "fname_" + ctx.getLocale();
        sql.append(" select abs(isnull(billHead.FCOMPANYDIFF,0)) diff, billCompany.FCompanyId,billCompany.fcurrencyId,billCompany.fsmallCompanyId,billCompany.fbigcompanyId,billHead.fid,");
        sql.append(" billHead.FAccountMapId,accountMap.FIsUnilateralReconciliation isSingCheck,smallUnit.").append(name).append(" smallComName,bigUnit.").append(name).append(" bigComName ");
        sql.append(",currency.").append(name).append(" currencyName,billHead.fnumber \n");
        sql.append(" from t_csl_checkagebillhead billHead  \n");
        sql.append(" inner join T_Csl_AccountMap accountMap on accountMap.fid=billHead.FAccountMapId \n");
        sql.append(" inner join ").append(billHeadTmpTable).append(" billCompany on billCompany.fid=billHead.fid \n");
        sql.append(" inner join t_org_baseunit smallUnit on smallUnit.fid=billCompany.fsmallCompanyId \n");
        sql.append(" inner join t_org_baseunit bigUnit on bigUnit.fid=billCompany.fbigcompanyId \n");
        sql.append(" inner join t_bd_currency currency on currency.fid=billCompany.fcurrencyId \n");
        sql.append(" order by billCompany.FCompanyId,billHead.fid ");
        String bosType = new ToleranceCheckLogInfo().getBOSType().toString();
        String insertLogSql = "insert into T_Csl_ToleranceCheckLog(fid,FBillHeadId,FBillDiff,FSingleToleranceId,FSingleValue,FCompanyId,FAllToleranceId,FIsCheckDiff,FYear,Fperiod,fcreatorId,fcreatetime) values(newbosId('" + bosType + "'),?,?,?,?,?,?,?,?,?,?,?)";
        SqlParams sp = new SqlParams();
        Connection con = EJBFactory.getConnection((Context)ctx);
        HashMap<String, Map<String, String>> noPassOneTolerCompany = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> noPassAllTolerCompany = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> noPassDiffCompany = new HashMap<String, Map<String, String>>();
        try {
            int from = 0;
            int lenth = 3000;
            RptRowSet rst = null;
            ArrayList logParams = new ArrayList();
            HashMap<String, DiffInfo> catchCompanyDiffMap = new HashMap<String, DiffInfo>();
            HashMap<String, DiffInfo> catchCheckAllTolerMap = new HashMap<String, DiffInfo>();
            while (rst == null || rst != null && rst.getRowCount() >= lenth) {
                rst = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (SqlParams)sp, (int)from, (int)lenth, (Connection)con);
                while (rst.next()) {
                    boolean isHandleCompanyDiff;
                    String companyId = rst.getString("FCompanyId");
                    TolerParamEnum paramEnum = tolerCheckParams.get(companyId);
                    if (TolerParamEnum.checkOne.equals((Object)paramEnum)) {
                        this.handleParamCheckOne(ctx, rst, logParams, catchCompanyDiffMap, noPassOneTolerCompany, checkOneOwnCompanyTolerConfig, checkOneTwoCompanyTolerConfig, year, period, true);
                        continue;
                    }
                    if (TolerParamEnum.checkAll.equals((Object)paramEnum)) {
                        isHandleCompanyDiff = !this.handleParamCheckAll(ctx, rst, logParams, catchCheckAllTolerMap, checkAllTolerConfig, year, period);
                        if (!isHandleCompanyDiff) continue;
                        this.handleCompanyDiff(ctx, rst, logParams, catchCompanyDiffMap, year, period);
                        continue;
                    }
                    if (TolerParamEnum.checkOneAndAll.equals((Object)paramEnum)) {
                        isHandleCompanyDiff = !this.handleParamCheckAll(ctx, rst, logParams, catchCheckAllTolerMap, checkAllTolerConfig, year, period);
                        this.handleParamCheckOne(ctx, rst, logParams, catchCompanyDiffMap, noPassOneTolerCompany, checkOneOwnCompanyTolerConfig, checkOneTwoCompanyTolerConfig, year, period, isHandleCompanyDiff);
                        continue;
                    }
                    this.handleCompanyDiff(ctx, rst, logParams, catchCompanyDiffMap, year, period);
                }
                if (!logParams.isEmpty()) {
                    DbUtil.executeBatch((Context)ctx, (String)insertLogSql, logParams);
                    logParams.clear();
                }
                from += lenth;
            }
            if (!catchCheckAllTolerMap.isEmpty()) {
                for (DiffInfo diffInfo : catchCheckAllTolerMap.values()) {
                    this.buildNoPassMap(ctx, noPassAllTolerCompany, diffInfo.companyId, diffInfo, true, true);
                }
            }
            if (!catchCompanyDiffMap.isEmpty()) {
                for (DiffInfo diffInfo : catchCompanyDiffMap.values()) {
                    this.buildNoPassMap(ctx, noPassDiffCompany, diffInfo.companyId, diffInfo, false, false);
                }
            }
        }
        finally {
            if (con != null) {
                SQLUtils.cleanup((Connection)con);
            }
        }
        return new Map[]{noPassOneTolerCompany, noPassAllTolerCompany, noPassDiffCompany};
    }

    public boolean handleParamCheckAll(Context ctx, RptRowSet rst, List logParams, Map<String, DiffInfo> catchCheckAllTolerMap, Map<String, ToleranceInfo> checkAllTolerConfig, int year, int period) throws Exception {
        String companyId = rst.getString("FCompanyId");
        ToleranceInfo tolerInfo = checkAllTolerConfig.get(companyId);
        if (tolerInfo != null) {
            this.handleCheckAll(ctx, rst, tolerInfo, logParams, catchCheckAllTolerMap, year, period);
            return true;
        }
        return false;
    }

    public void handleParamCheckOne(Context ctx, RptRowSet rst, List logParams, Map<String, DiffInfo> catchCompanyDiffMap, Map<String, Map<String, String>> noPassTolerCompany, Map<String, ToleranceInfo> checkOneOwnCompanyTolerConfig, Map<String, ToleranceInfo> checkOneTwoCompanyTolerConfig, int year, int period, boolean isHandleCompanyDiff) throws Exception {
        String companyId = rst.getString("FCompanyId");
        String smallCompanyId = rst.getString("fsmallCompanyId");
        String bigCompanyId = rst.getString("fbigcompanyId");
        String accountMapId = rst.getString("FAccountMapId");
        StringBuffer companyKey = new StringBuffer();
        companyKey.append(smallCompanyId.compareTo(bigCompanyId) <= 0 ? smallCompanyId + bigCompanyId : bigCompanyId + smallCompanyId);
        companyKey.append(accountMapId);
        ToleranceInfo tolerInfo = checkOneTwoCompanyTolerConfig.get(companyKey.toString());
        boolean isCheckOneTwo = true;
        if (tolerInfo == null) {
            companyKey.setLength(0);
            companyKey.append(companyId).append(accountMapId);
            tolerInfo = checkOneOwnCompanyTolerConfig.get(companyKey.toString());
            isCheckOneTwo = false;
        }
        if (tolerInfo != null) {
            this.handleCheckOne(ctx, rst, tolerInfo, logParams, noPassTolerCompany, year, period, isCheckOneTwo);
        } else if (isHandleCompanyDiff) {
            this.handleCompanyDiff(ctx, rst, logParams, catchCompanyDiffMap, year, period);
        }
    }

    public void handleCheckAll(Context ctx, RptRowSet rst, ToleranceInfo tolerInfo, List params, Map<String, DiffInfo> catchCheckAllTolerMap, int year, int period) throws Exception {
        String companyId = rst.getString("FCompanyId");
        String currencyId = rst.getString("fcurrencyId");
        String checkAllKey = companyId + currencyId;
        DiffInfo diffInfo = catchCheckAllTolerMap.get(checkAllKey);
        if (diffInfo == null) {
            diffInfo = new DiffInfo();
            String currencyName = rst.getString("currencyName");
            diffInfo.number = rst.getString("fnumber");
            diffInfo.companyId = companyId;
            diffInfo.currencyName = currencyName;
            diffInfo.diffValue = rst.getBigDecimal("diff");
            diffInfo.tolerValue = tolerInfo.getValue();
            diffInfo.companyName = companyId.equals(rst.getString("fsmallCompanyId")) ? rst.getString("smallComName") : rst.getString("bigComName");
            catchCheckAllTolerMap.put(checkAllKey, diffInfo);
        } else {
            diffInfo.diffValue = rst.getBigDecimal("diff").add(diffInfo.diffValue);
        }
        params.add(this.buildTolerLog(ctx, rst, year, period, tolerInfo, DiffTypeEnum.checkAllToler));
    }

    public void handleCompanyDiff(Context ctx, RptRowSet rst, List params, Map<String, DiffInfo> catchCompanyDiffMap, int year, int period) throws Exception {
        int isSingCheck = rst.getInt("isSingCheck");
        if (isSingCheck == 1) {
            return;
        }
        String companyId = rst.getString("FCompanyId");
        String currencyId = rst.getString("fcurrencyId");
        String diffKey = companyId + currencyId;
        DiffInfo diffInfo = catchCompanyDiffMap.get(diffKey);
        if (diffInfo == null) {
            diffInfo = new DiffInfo();
            String currencyName = rst.getString("currencyName");
            diffInfo.companyId = companyId;
            diffInfo.currencyName = currencyName;
            diffInfo.diffValue = rst.getBigDecimal("diff");
            diffInfo.number = rst.getString("fnumber");
            diffInfo.companyName = companyId.equals(rst.getString("fsmallCompanyId")) ? rst.getString("smallComName") : rst.getString("bigComName");
            catchCompanyDiffMap.put(diffKey, diffInfo);
        } else {
            diffInfo.diffValue = rst.getBigDecimal("diff").add(diffInfo.diffValue);
        }
        params.add(this.buildTolerLog(ctx, rst, year, period, null, DiffTypeEnum.companyDiff));
    }

    public void handleCheckOne(Context ctx, RptRowSet rst, ToleranceInfo tolerInfo, List params, Map<String, Map<String, String>> noPassTolerCompany, int year, int period, boolean isCheckOneTwo) throws Exception {
        if (tolerInfo != null) {
            BigDecimal diff = rst.getBigDecimal("diff");
            String companyId = rst.getString("FCompanyId");
            String smallCompanyId = rst.getString("fsmallCompanyId");
            if (tolerInfo.getValue().compareTo(diff) < 0) {
                DiffInfo diffInfo = new DiffInfo();
                diffInfo.number = rst.getString("fnumber");
                boolean isOwnSmall = companyId.equals(smallCompanyId);
                String string = diffInfo.companyName = isOwnSmall ? rst.getString("smallComName") : rst.getString("bigComName");
                if (isCheckOneTwo) {
                    diffInfo.tarCompanyName = isOwnSmall ? rst.getString("bigComName") : rst.getString("smallComName");
                }
                diffInfo.currencyName = rst.getString("currencyName");
                diffInfo.diffValue = diff;
                diffInfo.tolerValue = tolerInfo.getValue();
                String mapKey = companyId;
                this.buildNoPassMap(ctx, noPassTolerCompany, mapKey, diffInfo, true, false);
                params.add(this.buildTolerLog(ctx, rst, year, period, tolerInfo, DiffTypeEnum.checkOneToler));
            }
        }
    }

    public void buildNoPassMap(Context ctx, Map<String, Map<String, String>> noPassMap, String mapKey, DiffInfo diffInfo, boolean isTolerance, boolean isCheckAllTolerance) throws Exception {
        if (isTolerance && diffInfo.diffValue.compareTo(diffInfo.tolerValue) > 0 || !isTolerance && diffInfo.diffValue.compareTo(BigDecimal.ZERO) > 0) {
            String curMsg;
            StringBuffer msg = new StringBuffer();
            Map<String, String> subMap = noPassMap.get(mapKey);
            if (subMap == null) {
                subMap = new HashMap<String, String>();
                noPassMap.put(mapKey, subMap);
            }
            String subMapKey = diffInfo.companyName;
            if (isTolerance && !StringUtils.isEmpty((CharSequence)diffInfo.tarCompanyName)) {
                String string = subMapKey = diffInfo.tarCompanyName.compareTo(diffInfo.companyName) > 0 ? diffInfo.companyName + "-" + diffInfo.tarCompanyName : diffInfo.companyName + "-" + diffInfo.tarCompanyName;
            }
            if (!StringUtils.isEmpty((CharSequence)(curMsg = subMap.get(subMapKey)))) {
                msg.append(curMsg).append("\n");
            }
            if (isTolerance) {
                if (this.toleranceMsgFormat == null) {
                    String toleranceMsgRes = AccountCheckUtil.getResourceString(ctx, "558_bigTolerance", null);
                    this.toleranceMsgFormat = new MessageFormat(toleranceMsgRes);
                }
                msg.append(this.toleranceMsgFormat.format(new Object[]{diffInfo.currencyName, this.formatBigDecimal(diffInfo.diffValue), this.formatBigDecimal(diffInfo.tolerValue)}));
                if (!isCheckAllTolerance) {
                    if (this.checkNumberMsgFormat == null) {
                        String checkNumberMsgRes = AccountCheckUtil.getResourceString(ctx, "CheckWorkTableNumber", null);
                        this.checkNumberMsgFormat = new MessageFormat(checkNumberMsgRes);
                    }
                    msg.append("\n").append(this.checkNumberMsgFormat.format(new Object[]{diffInfo.number}));
                }
            } else {
                if (this.companyDiffMsgFormat == null) {
                    String companyDiffMsgRes = AccountCheckUtil.getResourceString(ctx, "559_companyDiff", null);
                    this.companyDiffMsgFormat = new MessageFormat(companyDiffMsgRes);
                }
                msg.append(this.companyDiffMsgFormat.format(new Object[]{diffInfo.currencyName, this.formatBigDecimal(diffInfo.diffValue)}));
            }
            subMap.put(subMapKey, msg.toString());
        }
    }

    public String formatBigDecimal(BigDecimal value) {
        return this.f.format(value);
    }

    public Object[] buildTolerLog(Context ctx, RptRowSet rst, int year, int period, ToleranceInfo tolerInfo, DiffTypeEnum diffTypeEnum) throws Exception {
        Object[] param = new Object[11];
        int i = 0;
        param[i++] = rst.getString("fid");
        param[i++] = rst.getBigDecimal("diff");
        if (diffTypeEnum.equals((Object)DiffTypeEnum.checkOneToler)) {
            param[i++] = tolerInfo.getId().toString();
            param[i++] = tolerInfo.getValue();
        } else {
            param[i++] = null;
            param[i++] = 0;
        }
        param[i++] = rst.getString("FCompanyId");
        param[i++] = DiffTypeEnum.checkAllToler.equals((Object)diffTypeEnum) ? tolerInfo.getId().toString() : null;
        param[i++] = DiffTypeEnum.companyDiff.equals((Object)diffTypeEnum) ? Integer.valueOf(1) : Integer.valueOf(0);
        param[i++] = year;
        param[i++] = period;
        param[i++] = ctx.getCaller().toString();
        param[i++] = new Timestamp(new Date().getTime());
        return param;
    }

    public static Map<String, ToleranceInfo>[] getCompanyToleranceConfig(Context ctx, Map<String, TolerParamEnum> tolerCheckParams) throws Exception {
        Set<String> curCheckAllCompanys;
        OneToManyMap tolerParamGroupMap = new OneToManyMap(2);
        for (Map.Entry<String, TolerParamEnum> entry : tolerCheckParams.entrySet()) {
            tolerParamGroupMap.put(entry.getValue(), entry.getKey());
        }
        Set checkOneCompanys = (Set)tolerParamGroupMap.get((Object)TolerParamEnum.checkOne);
        Set checkAllCompanys = (Set)tolerParamGroupMap.get((Object)TolerParamEnum.checkAll);
        Set checkOneAndAllCompanys = (Set)tolerParamGroupMap.get((Object)TolerParamEnum.checkOneAndAll);
        Map<String, ToleranceInfo>[] checkOneConfigMaps = null;
        HashMap checkAllConfigMap = null;
        Set<String> curCheckOneCompanys = ToleranceUtil.mergeSet(checkOneCompanys, checkOneAndAllCompanys);
        if (!curCheckOneCompanys.isEmpty()) {
            checkOneConfigMaps = ToleranceUtil.getToleranceConfig(ctx, curCheckOneCompanys, true);
        }
        if (!(curCheckAllCompanys = ToleranceUtil.mergeSet(checkAllCompanys, checkOneAndAllCompanys)).isEmpty()) {
            checkAllConfigMap = ToleranceUtil.getToleranceConfig(ctx, curCheckAllCompanys, false)[0];
        }
        HashMap checkOwnCompanyConfigMap = checkOneConfigMaps == null || checkOneConfigMaps.length < 1 ? new HashMap() : checkOneConfigMaps[0];
        HashMap checkTwoCompanyConfigMap = checkOneConfigMaps == null || checkOneConfigMaps.length < 2 ? new HashMap() : checkOneConfigMaps[1];
        return new Map[]{checkOwnCompanyConfigMap, checkTwoCompanyConfigMap, checkAllConfigMap == null ? new HashMap() : checkAllConfigMap};
    }

    public static Set<String> mergeSet(Set<String> set, Set<String> otherSet) throws Exception {
        if (set != null && otherSet != null) {
            set.addAll(otherSet);
            return set;
        }
        if (set != null) {
            return set;
        }
        if (otherSet != null) {
            return otherSet;
        }
        return new HashSet<String>();
    }

    public static Map<String, ToleranceInfo>[] getToleranceConfig(Context ctx, Set<String> companyIds, boolean isCheckOne) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct fid,FOrgUnitId,ftarOrgUnitId,FAccountMapId,FValue \n");
        sql.append(" from T_Csl_Tolerance  \n");
        sql.append(" where FToleranceType=? ", (Object)(isCheckOne ? 0 : 1));
        if (isCheckOne) {
            sql.append(" and (FOrgUnitId in ", companyIds);
            sql.append(" or ftarOrgUnitId in ", companyIds).append(")");
        } else {
            sql.append(" and FOrgUnitId in ", companyIds);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        HashMap<String, ToleranceInfo> checkOneToleranceConfigs = null;
        HashMap<String, ToleranceInfo> checkTwoToleranceConfigs = null;
        HashMap<String, ToleranceInfo> checkAllToleranceConfigs = null;
        if (isCheckOne) {
            checkOneToleranceConfigs = new HashMap<String, ToleranceInfo>();
            checkTwoToleranceConfigs = new HashMap<String, ToleranceInfo>();
        } else {
            checkAllToleranceConfigs = new HashMap<String, ToleranceInfo>();
        }
        StringBuffer companyKey = new StringBuffer();
        while (rowSet.next()) {
            String orgUnitId = rowSet.getString("FOrgUnitId");
            String tarOrgUnitId = rowSet.getString("ftarOrgUnitId");
            String FAccountMapId = rowSet.getString("FAccountMapId");
            ToleranceInfo info = new ToleranceInfo();
            info.setId(BOSUuid.read((String)rowSet.getString("fid")));
            info.setValue(rowSet.getBigDecimal("FValue"));
            companyKey.setLength(0);
            if (isCheckOne) {
                if (!StringUtils.isEmpty((CharSequence)tarOrgUnitId)) {
                    companyKey.append(orgUnitId.compareTo(tarOrgUnitId) > 0 ? tarOrgUnitId + orgUnitId : orgUnitId + tarOrgUnitId).append(FAccountMapId);
                    checkTwoToleranceConfigs.put(companyKey.toString(), info);
                    continue;
                }
                companyKey.append(orgUnitId).append(FAccountMapId);
                checkOneToleranceConfigs.put(companyKey.toString(), info);
                continue;
            }
            if (checkAllToleranceConfigs == null) continue;
            checkAllToleranceConfigs.put(orgUnitId, info);
        }
        if (isCheckOne) {
            return new Map[]{checkOneToleranceConfigs, checkTwoToleranceConfigs};
        }
        return new Map[]{checkAllToleranceConfigs};
    }

    public Map<String, TolerParamEnum> getTolerCheckParams(Context ctx, Set<String> companyIds, String companyIdTmpTableName) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        String paramNumber = "GR_CSL_DZPT_ORGClosingDifferenceCheckMethod";
        Locale locale = ctx.getLocale();
        sql.append(" select item.FOrgUnitId,item.fvalue_").append((Object)locale).append(" paramValue ");
        sql.append("from t_bas_param param \n");
        sql.append(" inner join t_bas_paramItem item on param.fid=item.fkeyid ");
        sql.append(" where param.fnumber=?", (Object)paramNumber).append(" and ");
        ToleranceUtil.setCompanyFilter(sql, companyIdTmpTableName, companyIds, "item.FOrgUnitId");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        HashMap<String, TolerParamEnum> tolerCheckParams = new HashMap<String, TolerParamEnum>();
        while (rowSet.next()) {
            String paramValue = rowSet.getString("paramValue");
            TolerParamEnum tolerParamEnum = null;
            if (paramValue.equals("0")) {
                tolerParamEnum = TolerParamEnum.checkOne;
            } else if (paramValue.equals("1")) {
                tolerParamEnum = TolerParamEnum.checkAll;
            } else if (paramValue.equals("2")) {
                tolerParamEnum = TolerParamEnum.checkOneAndAll;
            }
            tolerCheckParams.put(rowSet.getString("FOrgUnitId"), tolerParamEnum);
        }
        for (String companyId : companyIds) {
            if (tolerCheckParams.containsKey(companyId)) continue;
            tolerCheckParams.put(companyId, TolerParamEnum.checkAll);
        }
        return tolerCheckParams;
    }

    public static class DiffInfo {
        public String number = null;
        public String companyId = null;
        public String currencyName = null;
        public String companyName = null;
        public String tarCompanyName = null;
        public BigDecimal tolerValue = null;
        public BigDecimal diffValue = null;
    }

    public static enum DiffTypeEnum {
        checkOneToler,
        checkAllToler,
        companyDiff;

    }

    public static enum TolerParamEnum {
        checkOne,
        checkAll,
        checkOneAndAll;

    }
}

