/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessReportInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccessReportProcessUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccessReportMenuManage;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.client.report.ReportProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AccessReportProcessUI
extends AbstractAccessReportProcessUI {
    private static final long serialVersionUID = -1321922155018057081L;
    private static final Logger logger = CoreUIObject.getLogger(AccessReportProcessUI.class);

    public AccessReportProcessUI() throws Exception {
        this.setVariableProvider(new IReportVariableProvider(){

            @Override
            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initSheetReservedVariables(sheetName, RptPeriodTypeEnum.MONTHLY);
                variables.addAll(init, false);
            }

            @Override
            public void initReportDefaultVariable(ReportVariables variables) {
            }
        });
    }

    private ReportInfo getReportInfo() throws EASBizException, BOSException, IOException {
        ReportInfo report = new ReportInfo();
        AccessReportInfo accessReportInfo = (AccessReportInfo)this.getUIContext().get("accessReport");
        int year = accessReportInfo.getYear();
        report.setYear(year);
        int period = accessReportInfo.getPeriod();
        report.setPeriod((short)period);
        String currencyId = accessReportInfo.getCurrencyId();
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        report.setCurrency(currency);
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)accessReportInfo.getCompanyId()));
        company.setNumber(accessReportInfo.getCompanyNumber());
        report.setCompany(company);
        report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        Book book = (Book)this.getUIContext().get("INIT_BOOK");
        report.setBook(book);
        return report;
    }

    @Override
    public void onLoad() throws Exception {
        ReportInfo report = this.getReportInfo();
        this.setMenuStrategy(new AccessReportMenuManage());
        this.setBookProvider((IBookProvider)new ReportProvider(report));
        this.setPropertyAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        super.onLoad();
        Book book = this.getBook();
        AccessReportInfo accessReportInfo = (AccessReportInfo)this.getUIContext().get("accessReport");
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)accessReportInfo.getCompanyId()));
        company.setNumber(accessReportInfo.getCompanyNumber());
        report.setCompany(company);
        this.setIncludePosted(report, book);
        book.getSheet(0).getColRange(0, 0).setColumnHidden(true);
        book.getSheet(0).getColRange(1, 1).setColumnWidth(200);
        this.getUIMenuBar().setVisible(false);
        this.actionSave.setVisible(false);
        this.actionSheetManager.setVisible(false);
        this.actionReportCheck.setVisible(false);
        this.actionReportRound.setVisible(false);
    }

    private void setIncludePosted(ReportInfo report, Book book) throws EASBizException, BOSException {
        CheckageCompanyInfo checkageCompanyInfo = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyInfo("select isIncludingUnPosted where company = '" + report.getCompany().getId().toString() + "'");
        boolean includePosted = checkageCompanyInfo.isIsIncludingUnPosted();
        String sheetName = book.getSheetName(0);
        VariableEntry includePostedEntry = this.getVariables().get("IncludePosted", sheetName);
        if (includePostedEntry == null) {
            includePostedEntry = new VariableEntry("IncludePosted", sheetName, 2, String.valueOf(includePosted), true);
        } else {
            includePostedEntry.setValue(String.valueOf(includePosted));
            includePostedEntry.setType(1);
        }
        this.getVariables().addOrReplace(includePostedEntry);
        this.getVariables().add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
    }

    @Override
    public String getUITitle() {
        String title = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"276_title");
        return title;
    }
}

