/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessReportCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessReportFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessReportInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccessReportUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccessReportProcessUI;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccessReportUI
extends AbstractAccessReportUI {
    private static final long serialVersionUID = -995623318053588780L;
    private static final Logger logger = CoreUIObject.getLogger(AccessReportUI.class);
    private static final String COMPANYNUMBERKEY = "companyNumber";
    private static final String COMPANYNAMEKEY = "companyName";
    private static final String ACCESSDETAILKEY = "accessDetail";
    private static final String RESULTKEY = "result";
    private static final String CREATORKEY = "creator";
    private static final String CREATETIMEKEY = "createTime";
    private static final int ACCESSDETAILINDEX = 2;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getColumn(ACCESSDETAILKEY).getStyleAttributes().setFontColor(Color.blue);
        this.tblMain.getColumn(ACCESSDETAILKEY).getStyleAttributes().setUnderline(true);
        this.actionAddNew.setVisible(false);
        this.actionQuery.setVisible(false);
        this.actionView.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRefresh.setVisible(false);
        this.actionLocate.setVisible(false);
        this.menuEdit.setVisible(false);
        this.initReport();
    }

    private void initReport() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (this.getUIContext().containsKey("companyIds")) {
            Set companyIds = (Set)this.getUIContext().get("companyIds");
            filter.getFilterItems().add(new FilterItemInfo("companyId", (Object)companyIds, CompareType.INCLUDE));
        }
        int year = (Integer)this.getUIContext().get("year");
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)year));
        int period = (Integer)this.getUIContext().get("period");
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period));
        String currencyId = (String)this.getUIContext().get("currencyId");
        filter.getFilterItems().add(new FilterItemInfo("currencyId", (Object)currencyId));
        view.getSorter().add(new SorterItemInfo(COMPANYNUMBERKEY));
        AccessReportCollection accessReports = AccessReportFactory.getRemoteInstance().getAccessReportCollection(view);
        if (accessReports != null && !accessReports.isEmpty()) {
            Iterator it = accessReports.iterator();
            while (it.hasNext()) {
                AccessReportInfo accessReport = (AccessReportInfo)it.next();
                this.initTable(accessReport);
            }
        }
    }

    private void initTable(AccessReportInfo accessReport) {
        IRow row = this.tblMain.addRow();
        row.setUserObject((Object)accessReport);
        String companyNumber = accessReport.getCompanyNumber();
        row.getCell(COMPANYNUMBERKEY).setValue((Object)companyNumber);
        String companyName = accessReport.getCompanyName();
        row.getCell(COMPANYNAMEKEY).setValue((Object)companyName);
        String detail = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"275_detail");
        row.getCell(ACCESSDETAILKEY).setValue((Object)detail);
        row.getCell(ACCESSDETAILKEY).setUserObject((Object)accessReport.getData());
        String result = accessReport.getResult();
        row.getCell(RESULTKEY).setValue((Object)result);
        String creatorId = accessReport.getCreator().getId().toString();
        try {
            UserInfo user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(creatorId));
            row.getCell(CREATORKEY).setValue((Object)user.getName());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Timestamp createTime = accessReport.getCreateTime();
        row.getCell(CREATETIMEKEY).setValue((Object)createTime);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            int colIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
            if (colIndex == 2 && this.tblMain.getCell(rowIndex, colIndex).getValue() != null) {
                byte[] data = (byte[])this.tblMain.getCell(rowIndex, colIndex).getUserObject();
                Book book = IOHelper.unpackBook((byte[])data);
                AccessReportInfo accessReport = (AccessReportInfo)this.tblMain.getRow(rowIndex).getUserObject();
                UIContext context = new UIContext();
                context.put((Object)"INIT_BOOK", (Object)book);
                context.put((Object)"accessReport", (Object)accessReport);
                context.put((Object)"Owner", (Object)this);
                IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AccessReportProcessUI.class.getName(), (Map)context, null, OprtState.VIEW);
                window.show();
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getKeyFieldName() {
        return COMPANYNUMBERKEY;
    }

    public int getSelectedRowCount(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        return selectRows.length;
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if ("menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuItemCopy".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
    }
}

