/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ConfirmStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.IAccountCheckFacade;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountCheckDiffHandleUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountCheckWorktableUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class AccountCheckDiffHandleUI
extends AbstractAccountCheckDiffHandleUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountCheckDiffHandleUI.class);
    private int iCurrencyPrecision = 2;
    private ItemTypeEnum itemTypeEnum = ItemTypeEnum.account;
    private Set<String> hasPermissionOrgSet = null;
    private Map<String, Boolean> headIsUnilateralMap = new HashMap<String, Boolean>();
    private Map<String, Set<String>> headAndCompanyIsConfrimMap = new HashMap<String, Set<String>>();
    private IRow selectEntryRow = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntry.getGroupManager().setGroup(true);
        this.kdtEntry.getColumn("billheadId").setGroup(true);
        this.kdtEntry.getColumn("number").setGroup(true);
        this.kdtEntry.getColumn("companyName").setGroup(true);
        this.kdtEntry.getColumn("tarCompanyName").setGroup(true);
        this.kdtEntry.getColumn("billheadId").setMergeable(true);
        this.kdtEntry.getColumn("number").setMergeable(true);
        this.kdtEntry.getColumn("companyName").setMergeable(true);
        this.kdtEntry.getColumn("tarCompanyName").setMergeable(true);
    }

    @Override
    protected void init() throws Exception {
        this.kdtEntry.checkParsed();
        this.kdtEntry.getSelectManager().setSelectMode(2);
        this.kdtEntryDetails.checkParsed();
        this.hiddenEntryDetails();
        Map context = this.getUIContext();
        if (context.containsKey("itemTypeEnum")) {
            this.itemTypeEnum = (ItemTypeEnum)((Object)context.get("itemTypeEnum"));
        }
        if (this.itemTypeEnum == ItemTypeEnum.rptItem) {
            this.kdtEntryDetails.getColumn("balTypeName").getStyleAttributes().setHided(true);
            this.kdtEntryDetails.getColumn("dataElement").getStyleAttributes().setHided(false);
        }
        this.iCurrencyPrecision = (Integer)context.get("currencyPrecision");
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        formatField.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        formatField.setMinimumValue((Comparable)new BigDecimal("-999999999999999.999999"));
        formatField.setPrecision(this.iCurrencyPrecision);
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kdtEntryDetails.getColumn("confirmDebit").setEditor((ICellEditor)dcEditor);
        this.kdtEntryDetails.getColumn("confirmCredit").setEditor((ICellEditor)dcEditor);
        Set billHeadSet = (Set)context.get("billHeadSet");
        if (billHeadSet != null && !billHeadSet.isEmpty()) {
            this.initEntries(billHeadSet);
        }
        this.kdtEntry.getStyleAttributes().setLocked(true);
        this.kdtEntryDetails.getStyleAttributes().setLocked(true);
        this.comboDiffMode.setEnabled(false);
        this.kdtEntryDetails.getGroupManager().setGroup(true);
        this.kdtEntryDetails.getColumn("company").setGroup(true);
        this.kdtEntryDetails.getColumn("company").setMergeable(true);
        this.kdtEntryDetails.getColumn("tarCompany").setGroup(true);
        this.kdtEntryDetails.getColumn("tarCompany").setMergeable(true);
        KDTextField textField = new KDTextField();
        textField.setMaxLength(2000);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
        this.kdtEntryDetails.getColumn("remark").getStyleAttributes().setHided(false);
        this.kdtEntryDetails.getColumn("remark").setEditor((ICellEditor)cellEditor);
        this.kdtEntryDetails.getScriptManager().setScriptDisabled(true);
        this.hasPermissionOrgSet = (Set)context.get("hasPermissionOrgSet");
        this.kdtEntry.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    KDTSelectBlock pre = e.getPrevSelectBlock();
                    if (pre != null && pre.getBeginRow() >= 0 && AccountCheckDiffHandleUI.this.isDataChange(AccountCheckDiffHandleUI.this.kdtEntryDetails) && MsgBox.showConfirm2New((Component)((Object)AccountCheckDiffHandleUI.this), (String)AccountCheckUtil.getResourceString(null, "565_lostData", null)) != 0) {
                        AccountCheckDiffHandleUI.this.kdtEntry.getSelectManager().select(pre, false);
                        AccountCheckDiffHandleUI.this.kdtEntry.scrollToVisible(pre.getBeginRow(), 0);
                        return;
                    }
                    KDTSelectBlock b = e.getSelectBlock();
                    int startRow = b.getBeginRow();
                    if (startRow == b.getEndRow()) {
                        IRow row = AccountCheckDiffHandleUI.this.kdtEntry.getRow(b.getBeginRow());
                        AccountCheckDiffHandleUI.this.selectEntryRow = row;
                        String billHeadId = (String)row.getCell("billheadId").getValue();
                        String companyId = (String)row.getCell("companyID").getValue();
                        AccountCheckDiffHandleUI.this.reSetSplitPane(null);
                        AccountCheckDiffHandleUI.this.initEntryDetails(billHeadId, companyId);
                        AccountCheckDiffHandleUI.this.changeControlStatus();
                        AccountCheckDiffHandleUI.this.txtDescription.setText((String)row.getCell("diffRemark").getValue());
                    } else {
                        AccountCheckDiffHandleUI.this.selectEntryRow = null;
                        AccountCheckDiffHandleUI.this.hiddenEntryDetails();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"tableSelectChanged error.", (Throwable)ex);
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
        if (this.kdtEntry.getRowCount() > 0) {
            this.kdtEntry.getSelectManager().add(0, 0);
        }
        final AccountCheckDiffHandleUI ui = this;
        this.kdtEntryDetails.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AccountCheckDiffHandleUI.this.selectkdtEntryDetails(e);
            }
        });
        this.kdtEntryDetails.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                AccountCheckDiffHandleUI.this.oneEqualsInputed = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void editStopped(KDTEditEvent e) {
                if (AccountCheckDiffHandleUI.this.isTriget && e.getValue() != null && !e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() != null) {
                    AccountCheckDiffHandleUI.this.isTriget = false;
                    try {
                        String columnKey = AccountCheckDiffHandleUI.this.kdtEntryDetails.getColumnKey(e.getColIndex());
                        if ("confirmDebit".equals(columnKey) || "confirmCredit".equals(columnKey)) {
                            if (e.getValue() != null) {
                                String curValue = e.getValue().toString().trim();
                                boolean isEqual = curValue.startsWith("=");
                                if (isEqual) {
                                    curValue = curValue.substring(1);
                                }
                                if (!AccountCheckUtil.isBigDecimal((Component)((Object)ui), curValue)) {
                                    AccountCheckDiffHandleUI.this.kdtEntryDetails.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                                    return;
                                }
                                if (isEqual) {
                                    BigDecimal cellValue = StringUtils.isEmpty((String)curValue) ? BigDecimal.ZERO : new BigDecimal(curValue);
                                    AccountCheckDiffHandleUI.this.kdtEntryDetails.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)cellValue);
                                }
                                if (BigDecimal.ZERO.compareTo((BigDecimal)AccountCheckDiffHandleUI.this.kdtEntryDetails.getCell(e.getRowIndex(), e.getColIndex()).getValue()) != 0) {
                                    AccountCheckDiffHandleUI.this.kdtEntryDetails.getCell(e.getRowIndex(), "confirmCredit".equals(columnKey) ? "confirmDebit" : "confirmCredit").setValue((Object)BigDecimal.ZERO);
                                }
                            }
                            AccountCheckDiffHandleUI.this.refreshDetailTotal("confirmCredit".equals(columnKey) ? "confirmDebit" : "confirmCredit");
                            AccountCheckDiffHandleUI.this.refreshDetailTotal(columnKey);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"tableSelectChanged error.", (Throwable)ex);
                        ExceptionHandler.handle((Throwable)ex);
                    }
                    finally {
                        AccountCheckDiffHandleUI.this.oneEqualsInputed = false;
                        AccountCheckDiffHandleUI.this.isTriget = true;
                    }
                }
                AccountCheckDiffHandleUI.this.oneEqualsInputed = false;
            }
        });
        KeyStroke ks = KeyStroke.getKeyStroke(61, 0);
        String strKey = "InterUI.EQUALS";
        this.getActionMap().remove(strKey);
        this.getActionMap().put(strKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AccountCheckDiffHandleUI.this.setCellDiffValue(true);
                }
                catch (Exception e1) {
                    AccountCheckDiffHandleUI.this.handUIException(e1);
                }
            }
        });
        this.getInputMap(2).put(ks, strKey);
    }

    private void selectkdtEntryDetails(KDTSelectEvent e) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntryDetails);
        for (int i = 0; i < selectRows.length; ++i) {
            if (selectRows[i] < 0) continue;
            if (this.minTotalIndex == selectRows[i]) {
                this.btnChangeDc.setEnabled(false);
                this.btnDiff.setEnabled(false);
                this.btnZero.setEnabled(false);
                break;
            }
            IRow row = this.kdtEntryDetails.getRow(selectRows[i]);
            Map infoMap = (Map)row.getUserObject();
            boolean enable = infoMap == null || !"true".equals(infoMap.get("noPermission"));
            this.btnChangeDc.setEnabled(enable);
            this.btnDiff.setEnabled(enable);
            this.btnZero.setEnabled(enable);
            break;
        }
    }

    private void changeControlStatus() {
        Map infoMap;
        boolean canSubmit = false;
        for (CheckageBillInfo info : this.billDetails) {
            infoMap = (Map)info.get("infoMap");
            if (infoMap != null && ("true".equals(infoMap.get("noPermission")) || "true".equals(infoMap.get("isConfirmed")))) continue;
            canSubmit = true;
            break;
        }
        this.menuItemSubmit.setEnabled(canSubmit);
        this.btnSubmit.setEnabled(canSubmit);
        this.btnChangeDc.setEnabled(canSubmit);
        this.btnDiff.setEnabled(canSubmit);
        this.btnZero.setEnabled(canSubmit);
        this.txtDescription.setEnabled(canSubmit);
        for (int i = 0; i < this.kdtEntryDetails.getRowCount(); ++i) {
            if (this.minTotalIndex == i) continue;
            IRow row = this.kdtEntryDetails.getRow(i);
            infoMap = (Map)row.getUserObject();
            boolean hasPermission = infoMap == null || !"true".equals(infoMap.get("noPermission"));
            boolean selfNotLock = infoMap == null || !"true".equals(infoMap.get("selfLock"));
            boolean isEnabled = hasPermission && selfNotLock;
            row.getCell("confirmDebit").getStyleAttributes().setLocked(!isEnabled);
            row.getCell("confirmCredit").getStyleAttributes().setLocked(!isEnabled);
            row.getCell("remark").getStyleAttributes().setLocked(!isEnabled);
        }
        this.selectkdtEntryDetails(null);
    }

    protected void setDetailRow(Set<String> confirmCompanySet, IRow row, CheckageBillInfo bill, boolean isDiffHandle) throws Exception {
        if (!isDiffHandle) {
            row.getCell("companyNumber").setValue((Object)bill.getCompany().getNumber());
            row.getCell("company").setValue((Object)bill.getCompany().getName());
            row.getCell("tarCompanyNumber").setValue((Object)bill.getTargetCompany().getNumber());
            row.getCell("tarCompany").setValue((Object)bill.getTargetCompany().getName());
            row.getCell("itemNumber").setValue((Object)bill.getItemNumber());
            row.getCell("itemName").setValue((Object)bill.getItemName());
            row.getCell("balTypeName").setValue((Object)bill.getBalType());
            if (this.itemTypeEnum == ItemTypeEnum.rptItem) {
                row.getCell("dataElement").setValue((Object)DataElementProvider.getDataElementInfo((int)bill.getDataElement()));
            }
            row.getCell("debit").setValue((Object)bill.getDebit());
            row.getCell("credit").setValue((Object)bill.getCredit());
            row.getCell("id").setValue((Object)bill.getId().toString());
            this.debitTotal = this.debitTotal.add(AccountCheckUtil.getValue(bill.getDebit()));
            this.creditTotal = this.creditTotal.add(AccountCheckUtil.getValue(bill.getCredit()));
            this.confirmDebitTotal = this.confirmDebitTotal.add(AccountCheckUtil.getValue(bill.getConfirmDebit()));
            this.confirmCreditTotal = this.confirmCreditTotal.add(AccountCheckUtil.getValue(bill.getConfirmCredit()));
        }
        row.getCell("confirmDebit").setValue((Object)bill.getConfirmDebit());
        row.getCell("confirmCredit").setValue((Object)bill.getConfirmCredit());
        row.getCell("remark").setValue((Object)bill.getRemark());
        String confirmStatusStr = ConfirmStatusEnum.unconfirm.getAlias();
        if (confirmCompanySet != null && confirmCompanySet.contains(bill.getCompany().getId().toString())) {
            confirmStatusStr = ConfirmStatusEnum.confirm.getAlias();
        }
        row.getCell("confirmStatus").setValue((Object)confirmStatusStr);
        if (!this.hasPermissionOrgSet.contains(bill.getCompany().getId().toString()) || confirmCompanySet != null && confirmCompanySet.contains(bill.getCompany().getId().toString())) {
            HashMap<String, String> rowInfoMap = (HashMap<String, String>)row.getUserObject();
            if (rowInfoMap == null) {
                rowInfoMap = new HashMap<String, String>();
            }
            rowInfoMap.put("noPermission", "true");
            row.setUserObject(rowInfoMap);
            HashMap<String, String> infoMap = new HashMap<String, String>();
            if (!this.hasPermissionOrgSet.contains(bill.getCompany().getId().toString())) {
                row.getStyleAttributes().setBackground(Color.decode("#F0E9FA"));
                infoMap.put("noPermission", "true");
            } else {
                infoMap.remove("noPermission");
            }
            if (confirmCompanySet != null && confirmCompanySet.contains(bill.getCompany().getId().toString())) {
                infoMap.put("isConfirmed", "true");
            } else {
                infoMap.remove("isConfirmed");
            }
            bill.put("infoMap", infoMap);
        } else if (bill.isExistCheckItem()) {
            row.getCell("confirmDebit").getStyleAttributes().setLocked(false);
            row.getCell("confirmCredit").getStyleAttributes().setLocked(false);
            row.getCell("remark").getStyleAttributes().setLocked(false);
        } else {
            HashMap<String, String> infoMap = (HashMap<String, String>)row.getUserObject();
            if (infoMap == null) {
                infoMap = new HashMap<String, String>();
            }
            infoMap.put("selfLock", "true");
            row.setUserObject(infoMap);
            row.getStyleAttributes().setBackground(Color.decode("#CCCCCC"));
        }
    }

    public void initEntryDetails(String billHeadId, String companyId) throws Exception {
        if (billHeadId != null && companyId != null) {
            if (this.billHeadId != null && !this.billHeadId.equals(billHeadId) || this.billHeadId == null) {
                this.kdtEntryDetails.removeRows();
                this.billDataCatchMap.clear();
                this.billHeadId = billHeadId;
                this.id_rowIndexs.clear();
                this.debitTotal = BigDecimal.ZERO;
                this.creditTotal = BigDecimal.ZERO;
                this.confirmDebitTotal = BigDecimal.ZERO;
                this.confirmCreditTotal = BigDecimal.ZERO;
                IRow row = null;
                ArrayList<String> billHeadIds = new ArrayList<String>();
                billHeadIds.add(billHeadId);
                Map billMap = AccountCheckFacadeFactory.getRemoteInstance().getCheckageBills(billHeadIds, companyId);
                List resultList = (List)billMap.get(billHeadId);
                ArrayList<CheckageBillInfo> tarCompanyList = new ArrayList<CheckageBillInfo>();
                boolean selfAllHaveNoAccountId = true;
                boolean tarAllHaveNoAccountId = true;
                for (int i = 0; i < resultList.size(); ++i) {
                    CheckageBillInfo info = (CheckageBillInfo)resultList.get(i);
                    CheckageBillCompanyInfo billCompany = info.getBillCompany();
                    if (billCompany != null && 1 == billCompany.getConfirmStatus().getValue()) {
                        CompanyOrgUnitInfo company;
                        Set<String> confirmCompanySet = this.headAndCompanyIsConfrimMap.get(billHeadId);
                        if (confirmCompanySet == null) {
                            confirmCompanySet = new HashSet<String>();
                            this.headAndCompanyIsConfrimMap.put(billHeadId, confirmCompanySet);
                        }
                        if ((company = info.getCompany()) != null && company.getId() != null) {
                            confirmCompanySet.add(company.getId().toString());
                        }
                    }
                    if (Boolean.TRUE.equals(info.get("isTarCompany"))) {
                        tarCompanyList.add(info);
                        if (!tarAllHaveNoAccountId || !info.isExistCheckItem()) continue;
                        tarAllHaveNoAccountId = false;
                        continue;
                    }
                    if (!selfAllHaveNoAccountId || !info.isExistCheckItem()) continue;
                    selfAllHaveNoAccountId = false;
                }
                resultList.removeAll(tarCompanyList);
                resultList.addAll(tarCompanyList);
                this.billDetails = resultList;
                if (this.billDetails != null && !this.billDetails.isEmpty()) {
                    Set<String> confirmCompanySet = this.headAndCompanyIsConfrimMap.get(billHeadId);
                    for (CheckageBillInfo bill : this.billDetails) {
                        row = this.kdtEntryDetails.addRow();
                        this.setDetailRow(confirmCompanySet, row, bill, false);
                        this.id_rowIndexs.put(bill.getId().toString(), row.getRowIndex());
                        this.catchBillData(row);
                    }
                    row = this.kdtEntryDetails.addRow();
                    this.initMinTotalRow(row);
                    row.getStyleAttributes().setLocked(true);
                    this.kdtEntryDetails.getGroupManager().group();
                }
            }
        } else {
            this.billDetails = null;
        }
    }

    private void initEntries(Set<String> billHeadSet) throws EASBizException, BOSException {
        this.kdtEntry.removeRows();
        HashMap<String, Set<String>> infoMap = new HashMap<String, Set<String>>();
        infoMap.put("billHeadSet", billHeadSet);
        List billCompanyInfoList = AccountCheckFacadeFactory.getRemoteInstance().getBillCompanyInfoList(infoMap);
        IRow row = null;
        if (billCompanyInfoList != null && !billCompanyInfoList.isEmpty()) {
            boolean isUnilateral = false;
            for (int i = 0; i < billCompanyInfoList.size(); ++i) {
                row = this.kdtEntry.addRow();
                Map map = (Map)billCompanyInfoList.get(i);
                String headId = (String)map.get("billheadId");
                isUnilateral = "true".equals(map.get("isUnilateral"));
                this.headIsUnilateralMap.put(headId, isUnilateral);
                row.getCell("billheadId").setValue((Object)headId);
                row.getCell("number").setValue(map.get("number"));
                row.getCell("checkOwner").setValue((Object)((String)map.get("companyName") + "-" + (String)map.get("tarCompanyName")));
                row.getCell("companyID").setValue(map.get("companyID"));
                row.getCell("companyName").setValue(map.get("companyName"));
                row.getCell("tarCompanyID").setValue(map.get("tarCompanyID"));
                row.getCell("tarCompanyName").setValue(map.get("tarCompanyName"));
                row.getCell("itemType").setValue(map.get("itemType"));
                row.getCell("confirmSt").setValue(map.get("confirmSt"));
                row.getCell("diffRemark").setValue(map.get("diffRemark"));
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<CheckageBillInfo> list = new ArrayList<CheckageBillInfo>();
        HashMap<String, LinkedList<Integer>> companyAndListIndexMap = new HashMap<String, LinkedList<Integer>>();
        int i = 0;
        StringBuilder noPermission_detailSbInfo = new StringBuilder();
        HashSet<String> checkedCompanySet = new HashSet<String>();
        for (CheckageBillInfo info : this.billDetails) {
            String companyId = info.getCompany().getId().toString();
            Map dataInfoMap = (Map)info.get("infoMap");
            if (dataInfoMap != null && ("true".equals(dataInfoMap.get("noPermission")) || "true".equals(dataInfoMap.get("isConfirmed")))) {
                if (checkedCompanySet.contains(companyId) || !"true".equals(dataInfoMap.get("noPermission"))) continue;
                noPermission_detailSbInfo.append(AccountCheckUtil.getResourceString(null, "hasNoAccountCheckPermission", new Object[]{info.getCompany().getName()})).append("\n");
                checkedCompanySet.add(companyId);
                continue;
            }
            LinkedList<Integer> indexList = (LinkedList<Integer>)companyAndListIndexMap.get(companyId);
            if (indexList == null) {
                indexList = new LinkedList<Integer>();
                companyAndListIndexMap.put(companyId, indexList);
            }
            indexList.add(i++);
            list.add(info);
        }
        HashSet noConfirmPermissionOrgSet = null;
        StringBuilder infoSb = new StringBuilder();
        StringBuilder noDiffHandlePermissionSb = new StringBuilder();
        StringBuilder noConfrimPermission_detailSbInfo = new StringBuilder();
        Set companySet = companyAndListIndexMap.keySet();
        if (companySet != null && !companySet.isEmpty()) {
            List indexList;
            IObjectPK[] pkArray = new IObjectPK[companySet.size()];
            int x = 0;
            for (String companyIdStr : companySet) {
                pkArray[x++] = new ObjectUuidPK(companyIdStr);
            }
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            Set havePermissionOrgSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, pkArray, "csl_checkwork_diffHandle");
            HashSet noDiffHandlePermissionOrgSet = new HashSet(companySet);
            noDiffHandlePermissionOrgSet.removeAll(havePermissionOrgSet);
            Set haveConfirmPermissionOrgSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, pkArray, "csl_checkwork_confirm");
            noConfirmPermissionOrgSet = new HashSet(companySet);
            noConfirmPermissionOrgSet.removeAll(haveConfirmPermissionOrgSet);
            for (String orgId : noDiffHandlePermissionOrgSet) {
                indexList = (List)companyAndListIndexMap.get(orgId);
                if (indexList == null || indexList.isEmpty()) continue;
                checkedCompanySet.add(orgId);
                noDiffHandlePermissionSb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoPermission"), ((CheckageBillInfo)list.get((Integer)indexList.get(0))).getCompany().getName(), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"diffHandle_Permission"))).append("\n");
                for (int y = 0; y < indexList.size(); ++y) {
                    list.set((Integer)indexList.get(y), null);
                }
            }
            for (String orgId : noConfirmPermissionOrgSet) {
                if (checkedCompanySet.contains(orgId)) continue;
                indexList = (List)companyAndListIndexMap.get(orgId);
                if (indexList != null && !indexList.isEmpty()) {
                    noConfrimPermission_detailSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoPermission"), ((CheckageBillInfo)list.get((Integer)indexList.get(0))).getCompany().getName(), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"confirm_Permission"))).append("\n");
                }
                checkedCompanySet.add(orgId);
            }
        }
        int year = (Integer)this.getUIContext().get("year");
        int period = (Integer)this.getUIContext().get("period");
        String currencyId = (String)this.getUIContext().get("currency");
        StringBuilder submitCompanySbInfo = new StringBuilder();
        HashSet<String> submitCompanyInfoSet = new HashSet<String>();
        HashSet<String> submitCompanyIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("companyId"));
        sic.add(new SelectorItemInfo("status"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)year));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period));
        filter.getFilterItems().add(new FilterItemInfo("currencyId", (Object)currencyId));
        view.setFilter(filter);
        CheckageCompanyStatusCollection checkageCompanyStatusCollection = CheckageCompanyStatusFactory.getRemoteInstance().getCheckageCompanyStatusCollection(view);
        if (checkageCompanyStatusCollection != null && !checkageCompanyStatusCollection.isEmpty()) {
            for (int x = 0; x < checkageCompanyStatusCollection.size(); ++x) {
                CheckageCompanyStatusInfo statusInfo = checkageCompanyStatusCollection.get(x);
                if (!companySet.contains(statusInfo.getCompanyId()) || 0 == statusInfo.getStatus().getValue()) continue;
                submitCompanyIdSet.add(statusInfo.getCompanyId());
            }
        }
        StringBuilder unCheckOutCompanySbInfo = new StringBuilder();
        ArrayList<CheckageBillInfo> hasDataList = new ArrayList<CheckageBillInfo>();
        HashSet<String> unCheckOutCompanySet = new HashSet<String>();
        if (list != null && !list.isEmpty()) {
            for (int x = 0; x < list.size(); ++x) {
                CheckageBillInfo checkageBillInfo = (CheckageBillInfo)list.get(x);
                if (checkageBillInfo == null) continue;
                CompanyOrgUnitInfo company = checkageBillInfo.getCompany();
                boolean canConfirmUnCheckOutData = CSLParamUtil.getParamBooleanValue(null, (String)company.getId().toString(), (String)"GR_CSL_DZPT_CanConfirmUnCheckOutData");
                if (!canConfirmUnCheckOutData) {
                    PeriodInfo currentPeriod = GlUtils.getCurrentPeriod(null, (String)company.getId().toString());
                    if (currentPeriod == null) continue;
                    int curYear = currentPeriod.getPeriodYear();
                    int curPeriod = currentPeriod.getPeriodNumber();
                    if (year > curYear || year == curYear && period >= curPeriod) {
                        if (x == 0) {
                            unCheckOutCompanySbInfo.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"conNotConfrimUnCheckOutCompany"));
                            unCheckOutCompanySbInfo.append("\n");
                        }
                        if (unCheckOutCompanySet.contains(company.getId().toString())) continue;
                        unCheckOutCompanySbInfo.append(company.getNumber()).append("-").append(company.getName());
                        unCheckOutCompanySbInfo.append("\n");
                        unCheckOutCompanySet.add(company.getId().toString());
                        continue;
                    }
                }
                if (submitCompanyIdSet.contains(company.getId().toString())) {
                    if (submitCompanyInfoSet.isEmpty()) {
                        submitCompanySbInfo.append(AccountCheckUtil.getResourceString(null, "dataDiff_dataSubmited", null)).append("\n");
                    }
                    if (!submitCompanyInfoSet.contains(company.getId().toString())) {
                        submitCompanySbInfo.append(company.getName()).append("\n");
                    }
                    submitCompanyInfoSet.add(company.getId().toString());
                    continue;
                }
                hasDataList.add(checkageBillInfo);
            }
        }
        if ((list = hasDataList) == null || list.isEmpty()) {
            if (noDiffHandlePermissionSb.length() > 0) {
                infoSb.append((CharSequence)noDiffHandlePermissionSb).append("\n");
            }
            if (noPermission_detailSbInfo.length() > 0) {
                infoSb.append((CharSequence)noPermission_detailSbInfo).append("\n");
            }
            if (noConfrimPermission_detailSbInfo.length() > 0) {
                infoSb.append((CharSequence)noConfrimPermission_detailSbInfo).append("\n");
            }
            if (unCheckOutCompanySbInfo.length() > 0) {
                infoSb.append((CharSequence)unCheckOutCompanySbInfo).append("\n");
            }
            if (submitCompanySbInfo.length() > 0) {
                infoSb.append((CharSequence)submitCompanySbInfo).append("\n");
            }
            if (infoSb.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"106diffHandleFail"), (String)infoSb.toString(), (int)1);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"canSaveForNoData"));
            }
            return;
        }
        HashMap<String, String> orgOutToleranceSbMap = new HashMap<String, String>();
        HashSet<String> canConfirmCompanyIdSet = null;
        HashSet<String> canNotConfirmCompanyIdSet = new HashSet<String>();
        IRow selectedRow = KDTableUtil.getSelectedRow((KDTable)this.kdtEntry);
        String billheadId = (String)selectedRow.getCell("billheadId").getValue();
        if (BigDecimal.ZERO.compareTo(this.txtConfirmDiffVal.getBigDecimalValue()) != 0) {
            if (!MsgBox.isYes((int)MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"isSumbmitDiffData"), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"dataHasDiff", (Object[])new Object[]{selectedRow.getCell("number").getValue()})))) {
                return;
            }
            boolean canNotConfirmWhenDataDifference = CSLParamUtil.getParamBooleanValue(null, (String)"GR_CSL_DZPT_CannotConfirmWhenDataDifference");
            if (canNotConfirmWhenDataDifference) {
                canConfirmCompanyIdSet = new HashSet<String>();
                ArrayList<String> selfCompanyInfoList = null;
                ArrayList<String> tarCompanyInfoList = null;
                String companyID = (String)selectedRow.getCell("companyID").getValue();
                String companyName = (String)selectedRow.getCell("companyName").getValue();
                String tarCompanyID = (String)selectedRow.getCell("tarCompanyID").getValue();
                String preCompanyName = "";
                for (int x = 0; x < this.kdtEntryDetails.getRowCount() && (selfCompanyInfoList == null || tarCompanyInfoList == null); ++x) {
                    if (this.minTotalIndex == x) continue;
                    IRow row = this.kdtEntryDetails.getRow(x);
                    String entryCompanyName = (String)row.getCell("company").getValue();
                    boolean isConfirm = ConfirmStatusEnum.confirm.getAlias().equals((String)row.getCell("confirmStatus").getValue());
                    if ("".equals(preCompanyName) || preCompanyName.equals(entryCompanyName)) {
                        if (selfCompanyInfoList == null) {
                            selfCompanyInfoList = new ArrayList(3);
                            selfCompanyInfoList.add(companyName.equals(entryCompanyName) ? companyID : tarCompanyID);
                            selfCompanyInfoList.add(isConfirm ? "true" : "false");
                            selfCompanyInfoList.add(companyName.equals(entryCompanyName) ? tarCompanyID : companyID);
                        }
                    } else if (tarCompanyInfoList == null) {
                        tarCompanyInfoList = new ArrayList(3);
                        tarCompanyInfoList.add(!companyName.equals(entryCompanyName) ? tarCompanyID : companyID);
                        tarCompanyInfoList.add(isConfirm ? "true" : "false");
                        tarCompanyInfoList.add(!companyName.equals(entryCompanyName) ? companyID : tarCompanyID);
                    }
                    preCompanyName = entryCompanyName;
                }
                if (selfCompanyInfoList == null && tarCompanyInfoList != null) {
                    selfCompanyInfoList = new ArrayList<String>(3);
                    selfCompanyInfoList.add((String)tarCompanyInfoList.get(2));
                    selfCompanyInfoList.add((String)tarCompanyInfoList.get(1));
                    selfCompanyInfoList.add((String)tarCompanyInfoList.get(0));
                } else if (tarCompanyInfoList == null && selfCompanyInfoList != null) {
                    tarCompanyInfoList = new ArrayList<String>(3);
                    tarCompanyInfoList.add((String)selfCompanyInfoList.get(2));
                    tarCompanyInfoList.add((String)selfCompanyInfoList.get(1));
                    tarCompanyInfoList.add((String)selfCompanyInfoList.get(0));
                }
                boolean isUnilateral = this.headIsUnilateralMap.containsKey(billheadId) && this.headIsUnilateralMap.get(billheadId) != false;
                String unitStr = null;
                BigDecimal companyDiff = this.txtConfirmDiffVal.getBigDecimalValue();
                if (selfCompanyInfoList != null) {
                    FullOrgUnitInfo tarUnit;
                    if (isUnilateral && selfCompanyInfoList.size() >= 3) {
                        BigDecimal toleranceVal_IsNotNull = null;
                        BigDecimal toleranceVal_IsNull = null;
                        companyID = (String)selfCompanyInfoList.get(0);
                        tarCompanyID = (String)selfCompanyInfoList.get(2);
                        String oql = "select orgUnit,orgUnit.name,tarOrgUnit,tarOrgUnit.name,value where ((orgUnit='" + companyID + "' and tarOrgUnit='" + tarCompanyID + "') or (orgUnit='" + tarCompanyID + "' and tarOrgUnit='" + companyID + "') or (orgUnit='" + companyID + "' and tarOrgUnit is null)) and toleranceType=" + 0 + " and accountMap in(select FAccountMapId from T_Csl_CheckageBillHead where fid='" + billheadId + "')";
                        ToleranceCollection toleranceCollection = ToleranceFactory.getRemoteInstance().getToleranceCollection(oql);
                        BigDecimal toleranceVal = null;
                        if (toleranceCollection != null && !toleranceCollection.isEmpty()) {
                            for (int x = 0; x < toleranceCollection.size(); ++x) {
                                ToleranceInfo toleranceInfo = toleranceCollection.get(x);
                                FullOrgUnitInfo ownUnit = toleranceInfo.getOrgUnit();
                                tarUnit = toleranceInfo.getTarOrgUnit();
                                unitStr = ownUnit.getName();
                                if (StringUtils.isEmpty((String)unitStr)) {
                                    if (tarUnit != null) {
                                        unitStr = tarUnit.getName();
                                    }
                                } else if (tarUnit != null && !StringUtils.isEmpty((String)tarUnit.getName())) {
                                    unitStr = unitStr + "-" + toleranceInfo.getTarOrgUnit().getName();
                                }
                                if (tarUnit != null && tarUnit.getId() != null) {
                                    toleranceVal_IsNotNull = toleranceInfo.getValue();
                                    break;
                                }
                                toleranceVal_IsNull = toleranceInfo.getValue();
                            }
                            toleranceVal = toleranceVal_IsNotNull != null ? toleranceVal_IsNotNull : toleranceVal_IsNull;
                        } else {
                            canConfirmCompanyIdSet.add(companyID);
                        }
                        if (toleranceVal != null) {
                            if (companyDiff.abs().compareTo(toleranceVal.abs()) <= 0) {
                                canConfirmCompanyIdSet.add(companyID);
                            } else {
                                canNotConfirmCompanyIdSet.add(companyID);
                                if (!checkedCompanySet.contains(companyID)) {
                                    orgOutToleranceSbMap.put(unitStr, AccountCheckUtil.getResourceString(null, "orgOutOneTolerance_unDiff", new Object[]{unitStr}));
                                }
                            }
                        }
                    } else if (tarCompanyInfoList != null) {
                        String info;
                        String companyID_1 = (String)selfCompanyInfoList.get(0);
                        boolean companyConfirm_1 = "true".equals(selfCompanyInfoList.get(1));
                        BigDecimal toleranceVal_OwnAndTarValue = null;
                        String toleranceVal_OwnAndTarUnitName = null;
                        BigDecimal toleranceVal_1 = null;
                        BigDecimal toleranceVal_IsNull = null;
                        String toleranceUnitName_1 = "";
                        String companyID_2 = (String)tarCompanyInfoList.get(0);
                        boolean companyConfirm_2 = "true".equals(tarCompanyInfoList.get(1));
                        BigDecimal toleranceVal_2 = null;
                        BigDecimal toleranceVal_TarIsNull = null;
                        String toleranceUnitName_2 = "";
                        String oql = "select value,orgUnit,orgUnit.name,tarOrgUnit,tarOrgUnit.name where ((orgUnit='" + companyID_1 + "' and tarOrgUnit='" + companyID_2 + "') or (orgUnit='" + companyID_1 + "' and tarOrgUnit is null) or (orgUnit='" + companyID_2 + "' and tarOrgUnit='" + companyID_1 + "') or (orgUnit='" + companyID_2 + "' and tarOrgUnit is null) ) and toleranceType=" + 0 + " and accountMap in(select FAccountMapId from T_Csl_CheckageBillHead where fid='" + billheadId + "')";
                        ToleranceCollection toleranceCollection = ToleranceFactory.getRemoteInstance().getToleranceCollection(oql);
                        if (toleranceCollection != null && !toleranceCollection.isEmpty()) {
                            for (int x = 0; x < toleranceCollection.size(); ++x) {
                                ToleranceInfo toleranceInfo = toleranceCollection.get(x);
                                FullOrgUnitInfo ownUnit = toleranceInfo.getOrgUnit();
                                tarUnit = toleranceInfo.getTarOrgUnit();
                                if (tarUnit != null) {
                                    toleranceVal_OwnAndTarValue = toleranceInfo.getValue();
                                    toleranceVal_OwnAndTarUnitName = ownUnit.getName() + "-" + tarUnit.getName();
                                    break;
                                }
                                if (companyID_1.equals(ownUnit.getId().toString())) {
                                    toleranceVal_IsNull = toleranceInfo.getValue();
                                    toleranceUnitName_1 = ownUnit.getName();
                                    continue;
                                }
                                if (!companyID_2.equals(ownUnit.getId().toString())) continue;
                                toleranceVal_TarIsNull = toleranceInfo.getValue();
                                toleranceUnitName_2 = ownUnit.getName();
                            }
                            toleranceVal_1 = toleranceVal_OwnAndTarValue != null ? toleranceVal_OwnAndTarValue : toleranceVal_IsNull;
                            toleranceVal_2 = toleranceVal_OwnAndTarValue != null ? toleranceVal_OwnAndTarValue : toleranceVal_TarIsNull;
                        }
                        boolean isAddDiffInfo = false;
                        if (!companyConfirm_1 && !companyConfirm_2) {
                            if (toleranceVal_1 != null) {
                                if (companyDiff.abs().compareTo(toleranceVal_1.abs()) <= 0) {
                                    canConfirmCompanyIdSet.add(companyID_1);
                                } else {
                                    canNotConfirmCompanyIdSet.add(companyID_1);
                                    if (!checkedCompanySet.contains(companyID_1)) {
                                        unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_1;
                                        orgOutToleranceSbMap.put(unitStr, AccountCheckUtil.getResourceString(null, "orgOutOneTolerance_unDiff", new Object[]{unitStr}));
                                    }
                                }
                            } else {
                                canNotConfirmCompanyIdSet.add(companyID_1);
                                if (!isAddDiffInfo && !checkedCompanySet.contains(companyID_1)) {
                                    unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_1;
                                    info = AccountCheckUtil.getResourceString(null, "confirmFail_dataDiff", null) + "\n" + AccountCheckUtil.getResourceString(null, "dataHasDiffForNumber", new Object[]{selectedRow.getCell("number").getValue()});
                                    orgOutToleranceSbMap.put(unitStr, info);
                                    isAddDiffInfo = true;
                                }
                            }
                            if (toleranceVal_2 != null) {
                                if (companyDiff.abs().compareTo(toleranceVal_2.abs()) <= 0) {
                                    canConfirmCompanyIdSet.add(companyID_2);
                                } else {
                                    canNotConfirmCompanyIdSet.add(companyID_2);
                                    if (!checkedCompanySet.contains(companyID_2)) {
                                        unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_2;
                                        orgOutToleranceSbMap.put(unitStr, AccountCheckUtil.getResourceString(null, "orgOutOneTolerance_unDiff", new Object[]{unitStr}));
                                    }
                                }
                            } else {
                                canNotConfirmCompanyIdSet.add(companyID_2);
                                if (!isAddDiffInfo && !checkedCompanySet.contains(companyID_2)) {
                                    unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_2;
                                    info = AccountCheckUtil.getResourceString(null, "confirmFail_dataDiff", null) + "\n" + AccountCheckUtil.getResourceString(null, "dataHasDiffForNumber", new Object[]{selectedRow.getCell("number").getValue()});
                                    orgOutToleranceSbMap.put(unitStr, info);
                                    isAddDiffInfo = true;
                                }
                            }
                        } else if (!companyConfirm_1 && companyConfirm_2) {
                            if (toleranceVal_1 != null && companyDiff.abs().compareTo(toleranceVal_1.abs()) <= 0 && toleranceVal_2 != null && companyDiff.abs().compareTo(toleranceVal_2.abs()) <= 0) {
                                canConfirmCompanyIdSet.add(companyID_1);
                            } else if (toleranceVal_1 != null && toleranceVal_2 != null) {
                                canNotConfirmCompanyIdSet.add(companyID_1);
                                if (!checkedCompanySet.contains(companyID_1)) {
                                    unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_1;
                                    orgOutToleranceSbMap.put(unitStr, AccountCheckUtil.getResourceString(null, "orgOutOneTolerance_unDiff", new Object[]{unitStr}));
                                }
                            } else {
                                canNotConfirmCompanyIdSet.add(companyID_1);
                                if (!isAddDiffInfo && !checkedCompanySet.contains(companyID_1)) {
                                    unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_1;
                                    info = AccountCheckUtil.getResourceString(null, "confirmFail_dataDiff", null) + "\n" + AccountCheckUtil.getResourceString(null, "dataHasDiffForNumber", new Object[]{selectedRow.getCell("number").getValue()});
                                    orgOutToleranceSbMap.put(unitStr, info);
                                    isAddDiffInfo = true;
                                }
                            }
                        } else if (companyConfirm_1 && !companyConfirm_2) {
                            if (toleranceVal_1 != null && companyDiff.abs().compareTo(toleranceVal_1.abs()) <= 0 && toleranceVal_2 != null && companyDiff.abs().compareTo(toleranceVal_2.abs()) <= 0) {
                                canConfirmCompanyIdSet.add(companyID_2);
                            } else if (toleranceVal_1 != null && toleranceVal_2 != null) {
                                canNotConfirmCompanyIdSet.add(companyID_2);
                                if (!checkedCompanySet.contains(companyID_2)) {
                                    unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_2;
                                    orgOutToleranceSbMap.put(unitStr, AccountCheckUtil.getResourceString(null, "orgOutOneTolerance_unDiff", new Object[]{unitStr}));
                                }
                            } else {
                                canNotConfirmCompanyIdSet.add(companyID_2);
                                if (!isAddDiffInfo && !checkedCompanySet.contains(companyID_2)) {
                                    unitStr = toleranceVal_OwnAndTarUnitName != null ? toleranceVal_OwnAndTarUnitName : toleranceUnitName_2;
                                    info = AccountCheckUtil.getResourceString(null, "confirmFail_dataDiff", null) + "\n" + AccountCheckUtil.getResourceString(null, "dataHasDiffForNumber", new Object[]{selectedRow.getCell("number").getValue()});
                                    orgOutToleranceSbMap.put(unitStr, info);
                                    isAddDiffInfo = true;
                                }
                            }
                        }
                    }
                }
            }
        }
        for (CheckageBillInfo billDetail : list) {
            int index = (Integer)this.id_rowIndexs.get(billDetail.getId().toString());
            billDetail.setConfirmCredit(AccountCheckUtil.getValue(this.kdtEntryDetails.getCell(index, "confirmCredit").getValue()));
            billDetail.setConfirmDebit(AccountCheckUtil.getValue(this.kdtEntryDetails.getCell(index, "confirmDebit").getValue()));
            Object remark = this.kdtEntryDetails.getCell(index, "remark").getValue();
            String curRemark = null;
            if (remark != null && (curRemark = remark.toString()).length() > 2000) {
                curRemark = curRemark.substring(0, 2000);
            }
            billDetail.setRemark(curRemark);
        }
        if (noConfirmPermissionOrgSet != null && !noConfirmPermissionOrgSet.isEmpty()) {
            canNotConfirmCompanyIdSet.addAll(noConfirmPermissionOrgSet);
        }
        HashSet<String> confirmCompanySet = null;
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("diffRemark", this.txtDescription.getText());
        infoMap.put("canNotConfirmCompanyIdSet", canNotConfirmCompanyIdSet);
        infoMap.put("billheadId", billheadId);
        IAccountCheckFacade iAccountCheckFacade = AccountCheckFacadeFactory.getRemoteInstance();
        StringBuilder confirmedInfoSb = new StringBuilder();
        try {
            Map resultMap = iAccountCheckFacade.saveDiff(list, infoMap);
            confirmCompanySet = (HashSet<String>)resultMap.get("confirmCompanySet");
            Map confirmedInfoMap = (Map)resultMap.get("confirmedInfoMap");
            if (confirmedInfoMap != null && !confirmedInfoMap.isEmpty()) {
                Set confirmedCompanySet = confirmedInfoMap.keySet();
                if (confirmCompanySet == null) {
                    confirmCompanySet = new HashSet<String>();
                }
                confirmCompanySet.addAll(confirmedCompanySet);
                Iterator confirmedInfoIt = confirmedInfoMap.values().iterator();
                while (confirmedInfoIt.hasNext()) {
                    confirmedInfoSb.append((String)confirmedInfoIt.next()).append("\n");
                }
            }
        }
        catch (Exception e1) {
            if ("lockFail".equals(e1.getMessage())) {
                String description = AccountCheckUtil.getResourceString(null, "cantParallelDiff", null);
                MsgBox.showError((String)description);
                return;
            }
            throw e1;
        }
        if (canConfirmCompanyIdSet != null && canConfirmCompanyIdSet.isEmpty() && orgOutToleranceSbMap.isEmpty()) {
            String title = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"confirmFail_dataDiff");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"dataHasDiffForNumber", (Object[])new Object[]{selectedRow.getCell("number").getValue()}), (int)1);
            return;
        }
        infoSb.setLength(0);
        if (noDiffHandlePermissionSb.length() > 0) {
            infoSb.append((CharSequence)noDiffHandlePermissionSb).append("\n");
        }
        if (noPermission_detailSbInfo.length() > 0) {
            infoSb.append((CharSequence)noPermission_detailSbInfo).append("\n");
        }
        if (noConfrimPermission_detailSbInfo.length() > 0) {
            infoSb.append((CharSequence)noConfrimPermission_detailSbInfo).append("\n");
        }
        if (submitCompanySbInfo.length() > 0) {
            infoSb.append((CharSequence)submitCompanySbInfo).append("\n");
        }
        if (!orgOutToleranceSbMap.isEmpty()) {
            Iterator iterator = orgOutToleranceSbMap.values().iterator();
            while (iterator.hasNext()) {
                infoSb.append((String)iterator.next()).append("\n");
            }
        }
        if (confirmedInfoSb.length() > 0) {
            infoSb.append((CharSequence)confirmedInfoSb).append("\n");
        }
        if (infoSb.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"107partDataFail"), (String)infoSb.toString(), (int)1);
        } else {
            this.billDataCatchMap.clear();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        }
        this.afterSubmit(confirmCompanySet);
    }

    private void afterSubmit(Set<String> confirmCompanySet) {
        if (confirmCompanySet != null && !confirmCompanySet.isEmpty() && this.selectEntryRow != null) {
            Map<String, String> infoMap;
            String billHeadId = (String)this.selectEntryRow.getCell("billheadId").getValue();
            Set<String> confirmCompanyIdSet = this.headAndCompanyIsConfrimMap.get(billHeadId);
            if (confirmCompanyIdSet == null) {
                confirmCompanyIdSet = new HashSet<String>();
                this.headAndCompanyIsConfrimMap.put(billHeadId, confirmCompanyIdSet);
            }
            confirmCompanyIdSet.addAll(confirmCompanySet);
            this.selectEntryRow.getCell("confirmSt").setValue((Object)ConfirmStatusEnum.confirm.getAlias());
            HashSet<String> confirmCompanyNameSet = new HashSet<String>();
            String companyID = (String)this.selectEntryRow.getCell("companyID").getValue();
            String companyName = (String)this.selectEntryRow.getCell("companyName").getValue();
            String tarCompanyID = (String)this.selectEntryRow.getCell("tarCompanyID").getValue();
            String tarCompanyName = (String)this.selectEntryRow.getCell("tarCompanyName").getValue();
            if (confirmCompanyIdSet.contains(companyID)) {
                confirmCompanyNameSet.add(companyName);
            }
            if (confirmCompanyIdSet.contains(tarCompanyID)) {
                confirmCompanyNameSet.add(tarCompanyName);
            }
            for (int i = 0; i < this.kdtEntryDetails.getRowCount(); ++i) {
                IRow row;
                if (this.minTotalIndex == i || !confirmCompanyNameSet.contains(companyName = (String)(row = this.kdtEntryDetails.getRow(i)).getCell("company").getValue())) continue;
                infoMap = (Map)row.getUserObject();
                if (infoMap == null) {
                    infoMap = new HashMap();
                }
                infoMap.put("noPermission", "true");
                row.setUserObject(infoMap);
                row.getCell("confirmDebit").getStyleAttributes().setLocked(true);
                row.getCell("confirmCredit").getStyleAttributes().setLocked(true);
                row.getCell("remark").getStyleAttributes().setLocked(true);
                row.getCell("confirmStatus").setValue((Object)ConfirmStatusEnum.confirm.getAlias());
            }
            for (CheckageBillInfo info : this.billDetails) {
                if (!confirmCompanyNameSet.contains(info.getCompany().getName())) continue;
                infoMap = (HashMap<String, String>)info.get("infoMap");
                if (infoMap == null) {
                    infoMap = new HashMap<String, String>();
                }
                infoMap.put("isConfirmed", "true");
                info.put("infoMap", infoMap);
            }
            this.changeControlStatus();
        }
    }

    @Override
    public void actionChangeDc_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntryDetails);
        if (selectRows == null || selectRows.length <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        boolean hasCompanyChoose = false;
        BigDecimal fOne = new BigDecimal(-1);
        for (int rowIndex : selectRows) {
            IRow row;
            Map infoMap;
            if (this.minTotalIndex == rowIndex || (infoMap = (Map)(row = this.kdtEntryDetails.getRow(rowIndex)).getUserObject()) != null && ("true".equals(infoMap.get("noPermission")) || "true".equals(infoMap.get("selfLock")))) continue;
            hasCompanyChoose = true;
            BigDecimal confirmDebit = fOne.multiply((BigDecimal)row.getCell("confirmDebit").getValue());
            row.getCell("confirmDebit").setValue((Object)fOne.multiply((BigDecimal)row.getCell("confirmCredit").getValue()));
            row.getCell("confirmCredit").setValue((Object)confirmDebit);
        }
        if (hasCompanyChoose) {
            this.refreshDetailTotal("confirmDebit");
            this.refreshDetailTotal("confirmCredit");
        }
    }

    @Override
    public void actionDiffMoney_actionPerformed(ActionEvent e) throws Exception {
        super.actionDiffMoney_actionPerformed(e);
    }

    @Override
    public void actionZero_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntryDetails);
        if (selectRows == null || selectRows.length <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        boolean hasCompanyChoose = false;
        BigDecimal zero = BigDecimal.ZERO;
        for (int rowIndex : selectRows) {
            IRow row;
            Map infoMap;
            if (this.minTotalIndex == rowIndex || (infoMap = (Map)(row = this.kdtEntryDetails.getRow(rowIndex)).getUserObject()) != null && ("true".equals(infoMap.get("noPermission")) || "true".equals(infoMap.get("selfLock")))) continue;
            hasCompanyChoose = true;
            row.getCell("confirmDebit").setValue((Object)zero);
            row.getCell("confirmCredit").setValue((Object)zero);
        }
        if (hasCompanyChoose) {
            this.refreshDetailTotal("confirmDebit");
            this.refreshDetailTotal("confirmCredit");
        }
    }

    @Override
    protected void setCellDiffValue(boolean isEqual) throws Exception {
        if (this.oneEqualsInputed || !isEqual) {
            KDTSelectManager manager = this.kdtEntryDetails.getSelectManager();
            int rowIndex = manager.getActiveRowIndex();
            if (!isEqual) {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntryDetails);
                if (rows == null || rows.length <= 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                    return;
                }
                boolean hasCompanyChoose = false;
                for (int i = 0; i < rows.length; ++i) {
                    IRow row = this.kdtEntryDetails.getRow(rows[i]);
                    Map infoMap = (Map)row.getUserObject();
                    if (infoMap != null && ("true".equals(infoMap.get("noPermission")) || "true".equals(infoMap.get("selfLock")))) continue;
                    rowIndex = rows[i];
                    hasCompanyChoose = true;
                    break;
                }
                if (!hasCompanyChoose) {
                    return;
                }
            }
            int columnIndex = manager.getActiveColumnIndex();
            int creditColIndex = this.kdtEntryDetails.getColumn("confirmCredit").getColumnIndex();
            int debitColIndex = this.kdtEntryDetails.getColumn("confirmDebit").getColumnIndex();
            if (rowIndex != this.minTotalIndex && (isEqual && (creditColIndex == columnIndex || debitColIndex == columnIndex) || !isEqual)) {
                BigDecimal totleDiff = this.txtConfirmDiffVal.getBigDecimalValue();
                IRow row = this.kdtEntryDetails.getRow(rowIndex);
                BigDecimal rowDiff = AccountCheckUtil.getValue(row.getCell("confirmDebit").getValue()).subtract(AccountCheckUtil.getValue(row.getCell("confirmCredit").getValue()));
                BigDecimal diff = rowDiff.subtract(totleDiff);
                if (isEqual) {
                    if (debitColIndex == columnIndex) {
                        row.getCell("confirmDebit").setValue((Object)diff);
                        row.getCell("confirmCredit").setValue((Object)BigDecimal.ZERO);
                    } else {
                        row.getCell("confirmCredit").setValue((Object)diff.multiply(new BigDecimal(-1)));
                        row.getCell("confirmDebit").setValue((Object)BigDecimal.ZERO);
                    }
                } else if (diff.compareTo(BigDecimal.ZERO) >= 0) {
                    row.getCell("confirmDebit").setValue((Object)diff);
                    row.getCell("confirmCredit").setValue((Object)BigDecimal.ZERO);
                } else {
                    row.getCell("confirmCredit").setValue((Object)diff.multiply(new BigDecimal(-1)));
                    row.getCell("confirmDebit").setValue((Object)BigDecimal.ZERO);
                }
                this.refreshDetailTotal("confirmDebit");
                this.refreshDetailTotal("confirmCredit");
            }
            this.oneEqualsInputed = false;
        }
    }

    @Override
    public void disposeUIWindow() {
        super.disposeUIWindow();
        try {
            Object obj = this.getUIContext().get("Owner");
            if (obj instanceof AccountCheckWorktableUI) {
                ((AccountCheckWorktableUI)((Object)obj)).actionRefresh_actionPerformed(null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"disposeUIWindow error.", (Throwable)e);
        }
    }
}

