/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CompareCharEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ConfirmStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountCheckFilterUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.CheckageCompanyF7UI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AccountCheckFilterUI
extends AbstractAccountCheckFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountCheckFilterUI.class);
    private String selectAll = null;
    @Deprecated
    protected Set selectedSelfCompanyIds = new HashSet();
    private Set companyIdRange = null;
    protected Set selectedTarCompanyIds = new HashSet();

    public AccountCheckFilterUI() throws Exception {
        this.selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComp();
        this.initMyListener();
    }

    private void initMyListener() {
        this.comboItemType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountCheckFilterUI.this.changeItemType(e);
            }
        });
        this.autoCheckSchmCom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    AccountCheckFilterUI.this.changeSchm(AccountCheckFilterUI.this.autoCheckSchmCom.getSelectedItem());
                }
                catch (Exception e1) {
                    logger.error((Object)"schm_change_error", (Throwable)e1);
                }
            }
        });
        this.periodTypeCom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AccountCheckFilterUI.this.updateYearAndPeriod();
                }
            }
        });
        this.yearCom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AccountCheckFilterUI.this.changeYearAndPeriod(e);
            }
        });
        this.periodCom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AccountCheckFilterUI.this.changeYearAndPeriod(e);
            }
        });
        this.cmbDiffType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccountCheckFilterUI.this.cmbDiffTypeChange(e);
            }
        });
    }

    private void cmbDiffTypeChange(ItemEvent e) {
        Object diffType = this.cmbDiffType.getSelectedItem();
        boolean isSelectCompare = diffType instanceof CompareCharEnum;
        if (!isSelectCompare) {
            this.kDDiffValue.setValue(null);
        }
        this.kDDiffValue.setEnabled(isSelectCompare);
    }

    private void changeItemType(ActionEvent e) {
        ItemTypeEnum selectItemType = (ItemTypeEnum)((Object)this.comboItemType.getSelectedItem());
        if (ItemTypeEnum.account == selectItemType) {
            this.autoCheckSchmCom.setEnabled(true);
        } else {
            this.autoCheckSchmCom.setEnabled(false);
            this.autoCheckSchmCom.setSelectedIndex(0);
        }
    }

    private void changeYearAndPeriod(ChangeEvent e) {
    }

    private void updateYearAndPeriod() {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.periodTypeCom.getSelectedItem();
        if (periodTypeEnum == null) {
            return;
        }
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodTypeEnum)) {
            CslRptUIUtil.setSpineRange((KDSpinner)this.periodCom, (int)1, (int)13, (boolean)true, (boolean)true);
            this.periodCom.setValue((Object)1, false);
        } else if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodTypeEnum)) {
            CslRptUIUtil.setSpineRange((KDSpinner)this.periodCom, (int)1, (int)4, (boolean)true, (boolean)true);
            this.periodCom.setValue((Object)1, false);
        } else if (RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodTypeEnum)) {
            CslRptUIUtil.setSpineRange((KDSpinner)this.periodCom, (int)1, (int)2, (boolean)true, (boolean)true);
            this.periodCom.setValue((Object)1, false);
        } else if (RptPeriodTypeEnum.YEARLY.equals((Object)periodTypeEnum)) {
            CslRptUIUtil.setSpineRange((KDSpinner)this.periodCom, (int)1, (int)1, (boolean)true, (boolean)true);
            this.periodCom.setValue((Object)1, false);
        }
    }

    private void changeSchm(Object selectSchmObj) throws BOSException {
        this.tarTable.removeRows();
        this.selectedTarCompanyIds.clear();
        if ("".equals(selectSchmObj)) {
            this.periodTypeCom.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
            this.periodTypeCom.setEnabled(false);
            this.companyIdRange = null;
        } else {
            this.periodTypeCom.setEnabled(true);
            if (this.companyIdRange == null) {
                this.companyIdRange = new HashSet();
            } else {
                this.companyIdRange.clear();
            }
            AutoCheckSchmInfo selectSchm = (AutoCheckSchmInfo)selectSchmObj;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scheme", (Object)selectSchm.getId().toString()));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.code"));
            view.setSelector(sic);
            AutoCheckSchmCompEntryCollection autoCheckSchmCompEntryCollection = AutoCheckSchmCompEntryFactory.getRemoteInstance().getAutoCheckSchmCompEntryCollection(view);
            if (autoCheckSchmCompEntryCollection != null && !autoCheckSchmCompEntryCollection.isEmpty()) {
                for (int i = 0; i < autoCheckSchmCompEntryCollection.size(); ++i) {
                    AutoCheckSchmCompEntryInfo autoCheckSchmCompEntryInfo = autoCheckSchmCompEntryCollection.get(i);
                    String companyId = autoCheckSchmCompEntryInfo.getCompany().getId().toString();
                    this.selectedTarCompanyIds.add(companyId);
                    this.companyIdRange.add(companyId);
                    IRow addRow = this.tarTable.addRow();
                    addRow.getCell("id").setValue((Object)companyId);
                    addRow.getCell("companyName").setValue((Object)autoCheckSchmCompEntryInfo.getCompany().getName());
                    addRow.getCell("companyNumber").setValue((Object)autoCheckSchmCompEntryInfo.getCompany().getNumber());
                    addRow.getCell("code").setValue((Object)autoCheckSchmCompEntryInfo.getCompany().getCode());
                }
            }
        }
    }

    private void initComp() throws Exception {
        this.tarTable.checkParsed();
        this.tarTable.getStyleAttributes().setLocked(true);
        this.tarTable.getSelectManager().setSelectMode(10);
        AccountCheckUtil.initItemTypeDefaultValue(this.comboItemType);
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        String creatOrgUnitIDStr = currentFIUnit.getId().toString();
        AutoCheckSchmCollection autoCheckSchmCollection = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmCollection("select id,name where creatOrgUnit='" + creatOrgUnitIDStr + "'");
        this.autoCheckSchmCom.addItem((Object)"");
        if (autoCheckSchmCollection != null && !autoCheckSchmCollection.isEmpty()) {
            for (int i = 0; i < autoCheckSchmCollection.size(); ++i) {
                AutoCheckSchmInfo autoCheckSchmInfo = autoCheckSchmCollection.get(i);
                this.autoCheckSchmCom.addItem((Object)autoCheckSchmInfo);
            }
        }
        this.comboDataSource.addItem((Object)this.selectAll);
        this.comboDataSource.addItems(DataSourceEnum.getEnumList().toArray());
        this.comfirmStCom.addItem((Object)this.selectAll);
        this.comfirmStCom.addItem((Object)ConfirmStatusEnum.confirm);
        this.comfirmStCom.addItem((Object)ConfirmStatusEnum.unconfirm);
        this.auditStCom.addItem((Object)this.selectAll);
        this.auditStCom.addItem((Object)AuditedStatusEnum.AUDITED);
        this.auditStCom.addItem((Object)AuditedStatusEnum.UNAUDITED);
        this.periodTypeCom.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.periodTypeCom.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.periodTypeCom.addItem((Object)RptPeriodTypeEnum.SEMIYEARLY);
        this.periodTypeCom.addItem((Object)RptPeriodTypeEnum.YEARLY);
        this.cmbDiffType.removeAllItems();
        this.cmbDiffType.addItem((Object)"");
        this.cmbDiffType.addItems(CompareCharEnum.getEnumList().toArray());
        this.kDDiffValue.setMinimumValue((Comparable)new BigDecimal("-999999999999999.999999"));
        this.kDDiffValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        this.kDDiffValue.setSupportedEmpty(true);
        this.kDDiffValue.setEnabled(false);
        this.comboItemType.setSelectedItem((Object)ItemTypeEnum.rptItem);
        this.currencyCom.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC()));
        CurrencyInfo currCurrency = RptNewUIUtil.getCompanyBasicCurrency(OrgType.Company, creatOrgUnitIDStr);
        this.currencyCom.setSelectedItem((Object)currCurrency);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("isfree"));
        sic.add(new SelectorItemInfo("freeTime"));
        CheckageCompanyCollection checkageCompanyCollection = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyCollection(view);
        int[] yearPeriod = RptNewUIUtil.getFICurrPeriod(currentFIUnit);
        CslRptUIUtil.setSpineRange((KDSpinner)this.yearCom, (int)1900, (int)2999, (boolean)true, (boolean)true);
        this.yearCom.setValue((Object)yearPeriod[0], false);
        CslRptUIUtil.setSpineRange((KDSpinner)this.periodCom, (int)1, (int)13, (boolean)true, (boolean)true);
        this.periodCom.setValue((Object)yearPeriod[1], false);
        if (checkageCompanyCollection != null && !checkageCompanyCollection.isEmpty()) {
            String yearPeriodStr = RptUtil.getYearPeriod((int)yearPeriod[0], (int)yearPeriod[1], (int)yearPeriod[0], (int)yearPeriod[1]);
            IObjectPK[] orgPKs = new IObjectPK[checkageCompanyCollection.size()];
            for (int i = 0; i < checkageCompanyCollection.size(); ++i) {
                CheckageCompanyInfo chInfo = checkageCompanyCollection.get(i);
                CompanyOrgUnitInfo company = chInfo.getCompany();
                String companyId = company.getId().toString();
                orgPKs[i] = new ObjectStringPK(companyId);
            }
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            Set havePermissionOrgSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, orgPKs, "csl_checkwork_view");
            Map fiscal = AccountCheckFacadeFactory.getRemoteInstance().getFiscal(havePermissionOrgSet);
            if (fiscal != null) {
                int minYear = (Integer)fiscal.get("minYear");
                int maxYear = (Integer)fiscal.get("maxYear");
                int minPeriod = (Integer)fiscal.get("minPeriod");
                CslRptUIUtil.setSpineRange((KDSpinner)this.yearCom, (int)minYear, (int)maxYear, (boolean)true, (boolean)true);
                yearPeriod[0] = yearPeriod[0] < minYear ? minYear : (yearPeriod[0] > maxYear ? maxYear : yearPeriod[0]);
                this.yearCom.setValue((Object)yearPeriod[0], false);
                CslRptUIUtil.setSpineRange((KDSpinner)this.periodCom, (int)minPeriod, (int)13, (boolean)true, (boolean)true);
                this.periodCom.setValue((Object)yearPeriod[1], false);
            }
        }
        this.changeSchm(this.autoCheckSchmCom.getSelectedItem());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void addSelf_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.selectedSelfCompanyIds != null && !this.selectedSelfCompanyIds.isEmpty()) {
            HashSet selectCompanySet = new HashSet();
            selectCompanySet.addAll(this.selectedSelfCompanyIds);
            uiContext.put((Object)"selectedOrgIds", selectCompanySet);
        }
        if (this.companyIdRange != null) {
            uiContext.put((Object)"selfCompanyIdRange", (Object)this.companyIdRange);
        }
        uiContext.put((Object)"UITitle", (Object)AccountCheckUtil.getResourceString(null, "selectTarCompany", null));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CheckageCompanyF7UI.class.getName(), (Map)uiContext);
        CheckageCompanyF7UI f7ui = (CheckageCompanyF7UI)uiWindow.getUIObject();
        f7ui.getUIWindow().show();
        if (!f7ui.isCancel()) {
            this.selfTable.removeRows();
            this.selectedSelfCompanyIds.clear();
            Collection returnValue = f7ui.getReturnValue();
            if (returnValue != null && !returnValue.isEmpty()) {
                for (CompanyOrgUnitInfo companyInfo : returnValue) {
                    this.selectedSelfCompanyIds.add(companyInfo.getId().toString());
                    IRow addRow = this.selfTable.addRow();
                    addRow.getCell("id").setValue((Object)companyInfo.getId().toString());
                    addRow.getCell("companyName").setValue((Object)companyInfo.getName());
                    addRow.getCell("companyNumber").setValue((Object)companyInfo.getNumber());
                }
            }
        }
    }

    @Override
    protected void removeSelf_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.selfTable);
        Arrays.sort(selectRows);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.selectedSelfCompanyIds.remove(this.selfTable.getRow(selectRows[i]).getCell("id").getValue());
            this.selfTable.removeRow(selectRows[i]);
        }
    }

    @Override
    protected void addTar_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.selectedTarCompanyIds != null && !this.selectedTarCompanyIds.isEmpty()) {
            HashSet selectCompanySet = new HashSet();
            selectCompanySet.addAll(this.selectedTarCompanyIds);
            uiContext.put((Object)"selectedOrgIds", selectCompanySet);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CheckageCompanyF7UI.class.getName(), (Map)uiContext);
        CheckageCompanyF7UI f7ui = (CheckageCompanyF7UI)uiWindow.getUIObject();
        f7ui.getUIWindow().show();
        if (!f7ui.isCancel()) {
            this.tarTable.removeRows();
            this.selectedTarCompanyIds.clear();
            Collection returnValue = f7ui.getReturnValue();
            if (returnValue != null && !returnValue.isEmpty()) {
                for (CompanyOrgUnitInfo companyInfo : returnValue) {
                    this.selectedTarCompanyIds.add(companyInfo.getId().toString());
                    IRow addRow = this.tarTable.addRow();
                    addRow.getCell("id").setValue((Object)companyInfo.getId().toString());
                    addRow.getCell("companyName").setValue((Object)companyInfo.getName());
                    addRow.getCell("companyNumber").setValue((Object)companyInfo.getNumber());
                    addRow.getCell("code").setValue((Object)companyInfo.getCode());
                }
            }
        }
    }

    @Override
    protected void removeTar_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tarTable);
        Arrays.sort(selectRows);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.selectedTarCompanyIds.remove(this.tarTable.getRow(selectRows[i]).getCell("id").getValue());
            this.tarTable.removeRow(selectRows[i]);
        }
    }

    public FilterInfo getFilterInfo() {
        CurrencyInfo currCurrency;
        RptPeriodTypeEnum typeEnum;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuilder sbFormula = new StringBuilder();
        Object selectedItem = this.autoCheckSchmCom.getSelectedItem();
        if (!"".equals(selectedItem) && selectedItem != null) {
            AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)selectedItem;
            this.filterInfo.getFilterItems().add(new FilterItemInfo("schm", (Object)autoCheckSchmInfo.getId().toString()));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if ((typeEnum = (RptPeriodTypeEnum)this.periodTypeCom.getSelectedItem()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)typeEnum.getValue()));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if ((currCurrency = (CurrencyInfo)this.currencyCom.getSelectedItem()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)currCurrency.getId().toString()));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        this.filterInfo.getFilterItems().add(new FilterItemInfo("year", (Object)this.yearCom.getIntegerVlaue()));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        this.filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)this.periodCom.getIntegerVlaue()));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        if (!this.selectAll.equals(this.comfirmStCom.getSelectedItem())) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("comfirmSt", (Object)((ConfirmStatusEnum)((Object)this.comfirmStCom.getSelectedItem())).getValue()));
        } else {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("comfirmSt", (Object)-1));
        }
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        Object diffType = this.cmbDiffType.getSelectedItem();
        if (diffType instanceof CompareCharEnum) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("diffType", (Object)((CompareCharEnum)((Object)this.cmbDiffType.getSelectedItem())).getValue()));
        } else {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("diffType", (Object)""));
        }
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        this.filterInfo.getFilterItems().add(new FilterItemInfo("diffValue", (Object)this.kDDiffValue.getBigDecimalValue()));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        if (!this.selectAll.equals(this.auditStCom.getSelectedItem())) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("auditSt", (Object)((AuditedStatusEnum)this.auditStCom.getSelectedItem()).getValue()));
        } else {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("auditSt", (Object)-1));
        }
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        this.filterInfo.getFilterItems().add(new FilterItemInfo("itemType", (Object)((ItemTypeEnum)((Object)this.comboItemType.getSelectedItem())).getValue()));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        if (!this.selectAll.equals(this.comboDataSource.getSelectedItem())) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataSource", (Object)((DataSourceEnum)((Object)this.comboDataSource.getSelectedItem())).getValue()));
        } else {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataSource", (Object)-1));
        }
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        if (this.tarTable.getRowCount() > 0) {
            HashSet<Object> tarCompanySet = new HashSet<Object>();
            for (int i = 0; i < this.tarTable.getRowCount(); ++i) {
                tarCompanySet.add(this.tarTable.getRow(i).getCell("id").getValue());
            }
            this.filterInfo.getFilterItems().add(new FilterItemInfo("tarCompany", tarCompanySet, CompareType.INCLUDE));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if (sbFormula.length() > 0) {
            int index = sbFormula.lastIndexOf(" and ");
            this.filterInfo.setMaskString(sbFormula.substring(0, index).toString());
        } else if (this.filterInfo.containsKey("maskString")) {
            this.filterInfo.remove("maskString");
        }
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            Object compareValue = filterItemInfo.getCompareValue();
            if ("schm".equals(propertyName)) {
                try {
                    AutoCheckSchmCompEntryCollection autoCheckSchmCompEntryCollection;
                    AutoCheckSchmCollection autoCheckSchmCollection = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmCollection("select id,name where id='" + compareValue + "'");
                    if (autoCheckSchmCollection != null && !autoCheckSchmCollection.isEmpty()) {
                        this.autoCheckSchmCom.setSelectedItem((Object)autoCheckSchmCollection.get(0));
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("scheme", compareValue));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("company.id"));
                    sic.add(new SelectorItemInfo("company.number"));
                    sic.add(new SelectorItemInfo("company.name"));
                    view.setSelector(sic);
                    if (this.companyIdRange == null) {
                        this.companyIdRange = new HashSet();
                    }
                    if ((autoCheckSchmCompEntryCollection = AutoCheckSchmCompEntryFactory.getRemoteInstance().getAutoCheckSchmCompEntryCollection(view)) == null || autoCheckSchmCompEntryCollection.isEmpty()) continue;
                    for (int x = 0; x < autoCheckSchmCompEntryCollection.size(); ++x) {
                        AutoCheckSchmCompEntryInfo autoCheckSchmCompEntryInfo = autoCheckSchmCompEntryCollection.get(x);
                        String companyId = autoCheckSchmCompEntryInfo.getCompany().getId().toString();
                        this.companyIdRange.add(companyId);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"loadData_autoCheckSchmCollection_error", (Throwable)e);
                    continue;
                }
            }
            if ("periodType".equals(propertyName)) {
                this.periodTypeCom.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)((Integer)compareValue)));
                continue;
            }
            if ("currency".equals(propertyName)) {
                try {
                    CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select id,number,name,precision where id='" + compareValue + "'");
                    if (currencyCollection == null || currencyCollection.isEmpty()) continue;
                    this.currencyCom.setSelectedItem((Object)currencyCollection.get(0));
                }
                catch (Exception e) {
                    logger.error((Object)"loadData_getCurrencyCollection_error", (Throwable)e);
                }
                continue;
            }
            if ("year".equals(propertyName)) {
                this.yearCom.setValue(compareValue);
                continue;
            }
            if ("period".equals(propertyName)) {
                this.periodCom.setValue(compareValue);
                continue;
            }
            if ("comfirmSt".equals(propertyName)) {
                ConfirmStatusEnum ConfirmStEnum = ConfirmStatusEnum.getEnum((Integer)compareValue);
                if (ConfirmStEnum != null) {
                    this.comfirmStCom.setSelectedItem((Object)ConfirmStEnum);
                    continue;
                }
                this.comfirmStCom.setSelectedItem((Object)this.selectAll);
                continue;
            }
            if ("diffType".equals(propertyName)) {
                if ("".equals(compareValue)) {
                    this.cmbDiffType.setSelectedItem((Object)"");
                    continue;
                }
                this.cmbDiffType.setSelectedItem((Object)CompareCharEnum.getEnum((String)compareValue));
                continue;
            }
            if ("diffValue".equals(propertyName)) {
                this.kDDiffValue.setValue(compareValue);
                continue;
            }
            if ("auditSt".equals(propertyName)) {
                AuditedStatusEnum auditedStEnum = AuditedStatusEnum.getEnum((int)((Integer)compareValue));
                if (auditedStEnum != null) {
                    this.auditStCom.setSelectedItem((Object)auditedStEnum);
                    continue;
                }
                this.auditStCom.setSelectedItem((Object)this.selectAll);
                continue;
            }
            if ("itemType".equals(propertyName)) {
                this.comboItemType.setSelectedItem((Object)ItemTypeEnum.getEnum((Integer)compareValue));
                continue;
            }
            if ("dataSource".equals(propertyName)) {
                DataSourceEnum dataSourceEnum = DataSourceEnum.getEnum((Integer)compareValue);
                if (dataSourceEnum != null) {
                    this.comboDataSource.setSelectedItem((Object)dataSourceEnum);
                    continue;
                }
                this.comboDataSource.setSelectedItem((Object)this.selectAll);
                continue;
            }
            if (!"tarCompany".equals(propertyName)) continue;
            this.tarTable.removeRows();
            this.selectedTarCompanyIds.clear();
            try {
                CompanyOrgUnitCollection companyOrgUnitCollection = this.getFullOrgUnitCol((Set)compareValue);
                if (companyOrgUnitCollection == null || companyOrgUnitCollection.isEmpty()) continue;
                for (int x = 0; x < companyOrgUnitCollection.size(); ++x) {
                    CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(x);
                    this.selectedTarCompanyIds.add(companyOrgUnitInfo.getId().toString());
                    IRow addRow = this.tarTable.addRow();
                    addRow.getCell("id").setValue((Object)companyOrgUnitInfo.getId().toString());
                    addRow.getCell("companyName").setValue((Object)companyOrgUnitInfo.getName());
                    addRow.getCell("companyNumber").setValue((Object)companyOrgUnitInfo.getNumber());
                    addRow.getCell("code").setValue((Object)companyOrgUnitInfo.getCode());
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"loadData_getTarCompanyOrgUnitCollection_error", (Throwable)e);
            }
        }
    }

    protected CompanyOrgUnitCollection getFullOrgUnitCol(Set companySet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("code"));
        view.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)companySet, CompareType.INCLUDE));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
    }

    public void clear() {
        try {
            CurrencyInfo currCurrency = RptNewUIUtil.getCompanyBasicCurrency(OrgType.Company, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            this.currencyCom.setSelectedItem((Object)currCurrency);
        }
        catch (Exception e) {
            logger.error((Object)"clear_getCompanyBasicCurrency error.", (Throwable)e);
        }
        AccountCheckUtil.initItemTypeDefaultValue(this.comboItemType);
        this.autoCheckSchmCom.setSelectedIndex(0);
        this.periodTypeCom.setSelectedIndex(0);
        this.periodTypeCom.setEnabled(false);
        this.comfirmStCom.setSelectedItem((Object)this.selectAll);
        this.cmbDiffType.setSelectedIndex(0);
        this.kDDiffValue.setValue(null);
        this.auditStCom.setSelectedIndex(0);
        this.comboDataSource.setSelectedIndex(0);
        this.periodTypeCom.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.periodTypeCom.setEnabled(false);
        this.companyIdRange = null;
        this.selectedTarCompanyIds.clear();
        this.tarTable.removeRows();
    }
}

