/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ImportFromRptParamInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountCheckImportFromReportUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.CheckageCompanyF7UI;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class AccountCheckImportFromReportUI
extends AbstractAccountCheckImportFromReportUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountCheckImportFromReportUI.class);
    protected Set selectedCompanyIds = new HashSet();
    protected Set selectedTemplateIds = new HashSet();
    private Set<String> CheckageCompanyIdSet = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
    }

    private void initControl() throws Exception {
        this.cmbTemplateType.addItem((Object)RptTmpTypeEnum.GROUPCOMMREPORT);
        this.cmbTemplateType.addItem((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT);
        this.cmbTemplateType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccountCheckImportFromReportUI.this.changeTemplateType(e);
            }
        });
        this.cmbPeriodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.cmbPeriodType.setEnabled(false);
        this.cmbCurrency.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC()));
        this.chkIsAudited.setSelected(true);
        this.queryCheckageCompany();
        this.companyTable.checkParsed();
        this.companyTable.getStyleAttributes().setLocked(true);
        this.templateTable.checkParsed();
        this.templateTable.getStyleAttributes().setLocked(true);
        this.sheetTable.checkParsed();
        this.sheetTable.getStyleAttributes().setLocked(true);
        this.sheetTable.getColumn("select").getStyleAttributes().setLocked(false);
    }

    private void changeTemplateType(ItemEvent e) {
        this.templateTable.removeRows();
        this.sheetTable.removeRows();
    }

    private void queryCheckageCompany() throws TaskExternalException {
        if (this.CheckageCompanyIdSet != null) {
            return;
        }
        this.CheckageCompanyIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("company"));
        try {
            CheckageCompanyCollection checkageCompanyCollection = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyCollection(view);
            if (checkageCompanyCollection != null && !checkageCompanyCollection.isEmpty()) {
                for (int i = 0; i < checkageCompanyCollection.size(); ++i) {
                    this.CheckageCompanyIdSet.add(checkageCompanyCollection.get(i).getCompany().getId().toString());
                }
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void btnChooseCompany_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"UITitle", (Object)AccountCheckUtil.getResourceString(null, "AccountCheckImportReportCompanyF7", null));
        if (this.selectedCompanyIds != null && !this.selectedCompanyIds.isEmpty()) {
            HashSet selectCompanySet = new HashSet();
            selectCompanySet.addAll(this.selectedCompanyIds);
            uiContext.put((Object)"selectedOrgIds", selectCompanySet);
        }
        if (this.CheckageCompanyIdSet != null) {
            uiContext.put((Object)"selfCompanyIdRange", this.CheckageCompanyIdSet);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CheckageCompanyF7UI.class.getName(), (Map)uiContext);
        CheckageCompanyF7UI f7ui = (CheckageCompanyF7UI)uiWindow.getUIObject();
        f7ui.getUIWindow().show();
        if (!f7ui.isCancel()) {
            this.companyTable.removeRows();
            this.selectedCompanyIds.clear();
            Collection returnValue = f7ui.getReturnValue();
            if (returnValue != null && !returnValue.isEmpty()) {
                for (CompanyOrgUnitInfo companyInfo : returnValue) {
                    this.selectedCompanyIds.add(companyInfo.getId().toString());
                    IRow addRow = this.companyTable.addRow();
                    addRow.getCell("id").setValue((Object)companyInfo.getId().toString());
                    addRow.getCell("companyName").setValue((Object)companyInfo.getName());
                    addRow.getCell("companyNumber").setValue((Object)companyInfo.getNumber());
                }
            }
        }
    }

    @Override
    protected void btnDelCompany_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.companyTable);
        Arrays.sort(selectRows);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.selectedCompanyIds.remove(this.companyTable.getRow(selectRows[i]).getCell("id").getValue());
            this.companyTable.removeRow(selectRows[i]);
        }
    }

    @Override
    protected void btnChooseTemplate_actionPerformed(ActionEvent e) throws Exception {
        block6: {
            List sheets;
            HashSet<String> selectTemplateIdSewt;
            block7: {
                RptTmpTypeEnum rptTmpTypeEnum = (RptTmpTypeEnum)this.cmbTemplateType.getSelectedItem();
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("templateType", rptTmpTypeEnum.getValue());
                Map checkImportForReportTemplate = AccountCheckFacadeFactory.getRemoteInstance().getCheckImportForReportTemplate(params);
                Set ids = (Set)checkImportForReportTemplate.get("ids");
                KDCommonPromptDialog dlg = new KDCommonPromptDialog();
                QueryAgent queryAgent = new QueryAgent();
                queryAgent.setQueryInfoPK(MetaDataPK.create((String)"com.kingdee.eas.fi.newrpt.accountcheck.TemplateForImportFromReportQuery"));
                queryAgent.setEnabledMultiSelection(true);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                queryAgent.setSelectorCollection(sic);
                dlg.setQueryInfo(queryAgent.getQueryInfo());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("templateType", (Object)rptTmpTypeEnum.getValue()));
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)3));
                if (ids != null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
                }
                view.setFilter(filter);
                SorterItemCollection st = new SorterItemCollection();
                SorterItemInfo sortItem = new SorterItemInfo("id");
                sortItem.setSortType(SortType.ASCEND);
                st.add(sortItem);
                view.setSorter(st);
                dlg.setEntityViewInfo(view);
                dlg.setSelectorCollection(queryAgent.getSelectorCollection());
                dlg.setQueryExecutor(queryAgent.getQueryExecutor());
                dlg.setEnabledMultiSelection(queryAgent.isEnabledMultiSelection());
                dlg.setReturnValueType(queryAgent.getReturnValueType());
                dlg.show();
                selectTemplateIdSewt = new HashSet<String>();
                if (dlg.isCanceled()) break block6;
                HashMap tempInfoMap = new HashMap();
                boolean isGroupCommreport = 6 == rptTmpTypeEnum.getValue();
                Object[] objs = (Object[])dlg.getData();
                for (int i = 0; i < objs.length; ++i) {
                    TemplateInfo info = (TemplateInfo)objs[i];
                    String id = info.getId().toString();
                    if (this.selectedTemplateIds.contains(id)) continue;
                    selectTemplateIdSewt.add(id);
                    this.selectedTemplateIds.add(id);
                    IRow templateAddRow = this.templateTable.addRow();
                    templateAddRow.getCell("templateNumber").setValue((Object)info.getNumber());
                    templateAddRow.getCell("templateName").setValue((Object)info.getName());
                    templateAddRow.getCell("templateType").setValue((Object)info.getTemplateType());
                    templateAddRow.getCell("id").setValue((Object)id);
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(info.getNumber());
                    list.add(info.getName());
                    list.add(id);
                    tempInfoMap.put(id, list);
                }
                if (selectTemplateIdSewt.isEmpty()) {
                    return;
                }
                if (!isGroupCommreport) break block7;
                HashSet<Integer> reportClassSet = new HashSet<Integer>();
                reportClassSet.add(51);
                reportClassSet.add(10);
                reportClassSet.add(20);
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add(new SelectorItemInfo("id"));
                selectorItemCollection.add(new SelectorItemInfo("report"));
                selectorItemCollection.add(new SelectorItemInfo("sheetName"));
                view.setSelector(selectorItemCollection);
                FilterInfo filterInfo = new FilterInfo();
                viewInfo.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("report", selectTemplateIdSewt, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("reportClass", reportClassSet, CompareType.INCLUDE));
                SorterItemCollection sort = new SorterItemCollection();
                SorterItemInfo sorterItemInfo = new SorterItemInfo("id");
                sorterItemInfo.setSortType(SortType.ASCEND);
                sort.add(sorterItemInfo);
                viewInfo.setSorter(sort);
                RptSheetParamCollection rptSheetParamCollection = RptSheetParamFactory.getRemoteInstance().getRptSheetParamCollection(viewInfo);
                if (rptSheetParamCollection == null || rptSheetParamCollection.isEmpty()) break block6;
                for (int i = 0; i < rptSheetParamCollection.size(); ++i) {
                    RptSheetParamInfo rptSheetParamInfo = rptSheetParamCollection.get(i);
                    String templateId = rptSheetParamInfo.getReport().getId().toString();
                    String sheetName = rptSheetParamInfo.getSheetName();
                    List list = (List)tempInfoMap.get(templateId);
                    if (list == null) continue;
                    IRow sheetAddRow = this.sheetTable.addRow();
                    sheetAddRow.getCell("select").setValue((Object)false);
                    sheetAddRow.getCell("templateNumber").setValue(list.get(0));
                    sheetAddRow.getCell("templateName").setValue(list.get(1));
                    sheetAddRow.getCell("sheetName").setValue((Object)sheetName);
                    sheetAddRow.getCell("templateId").setValue(list.get(2));
                    sheetAddRow.getCell("id").setValue((Object)rptSheetParamInfo.getId().toString());
                }
                break block6;
            }
            if (selectTemplateIdSewt != null && !selectTemplateIdSewt.isEmpty() && (sheets = AccountCheckFacadeFactory.getRemoteInstance().getDyTemplateSheets(selectTemplateIdSewt)) != null && !sheets.isEmpty()) {
                for (Object sheet : sheets) {
                    String[] curSheet = (String[])sheet;
                    IRow sheetAddRow = this.sheetTable.addRow();
                    sheetAddRow.getCell("select").setValue((Object)false);
                    sheetAddRow.getCell("templateNumber").setValue((Object)curSheet[0]);
                    sheetAddRow.getCell("templateName").setValue((Object)curSheet[1]);
                    sheetAddRow.getCell("sheetName").setValue((Object)curSheet[2]);
                    sheetAddRow.getCell("templateId").setValue((Object)curSheet[3]);
                    sheetAddRow.getCell("id").setValue((Object)curSheet[4]);
                }
            }
        }
    }

    @Override
    protected void btnDelTemplate_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.templateTable);
        Arrays.sort(selectRows);
        HashSet<String> deleteIdSet = new HashSet<String>();
        for (i = selectRows.length - 1; i >= 0; --i) {
            deleteIdSet.add((String)this.templateTable.getRow(selectRows[i]).getCell("id").getValue());
            this.selectedTemplateIds.remove((String)this.templateTable.getRow(selectRows[i]).getCell("id").getValue());
            this.templateTable.removeRow(selectRows[i]);
        }
        if (deleteIdSet.size() > 0) {
            for (i = this.sheetTable.getRowCount() - 1; i >= 0; --i) {
                if (!deleteIdSet.contains(this.sheetTable.getRow(i).getCell("templateId").getValue())) continue;
                this.sheetTable.removeRow(i);
            }
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.sheetTable, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    protected void btnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.sheetTable, (String)"select", (Boolean)Boolean.FALSE);
    }

    public ImportFromRptParamInfo getImportParams() {
        ImportFromRptParamInfo params = new ImportFromRptParamInfo();
        params.currencyId = ((CurrencyInfo)this.cmbCurrency.getSelectedItem()).getId().toString();
        params.importMode = this.cmbDataImportType.getSelectedIndex();
        boolean isWeaving = this.chkIsWeaving.isSelected();
        boolean isAudited = this.chkIsAudited.isSelected();
        int index = 0;
        if (isWeaving || isAudited) {
            int[] rptAuditStatus = new int[isWeaving && isAudited ? 2 : 1];
            if (isWeaving) {
                rptAuditStatus[index++] = 1;
            }
            if (isAudited) {
                rptAuditStatus[index++] = 2;
            }
            params.rptAuditStatus = rptAuditStatus;
        }
        boolean isCommited = this.chkIsCommited.isSelected();
        boolean isReceived = this.chkIsReceived.isSelected();
        index = 0;
        if (isCommited || isReceived) {
            int[] rptCommitStatus = new int[isCommited && isReceived ? 2 : 1];
            if (isCommited) {
                rptCommitStatus[index++] = 2;
            }
            if (isReceived) {
                rptCommitStatus[index++] = 3;
            }
            params.rptCommitStatus = rptCommitStatus;
        }
        if (params.rptAuditStatus == null && params.rptCommitStatus == null) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_rptStNull", null));
            SysUtil.abort();
        }
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        for (int i = 0; i < this.companyTable.getRowCount(); ++i) {
            orgUnitIds.add((String)this.companyTable.getRow(i).getCell("id").getValue());
        }
        params.orgUnitIds = orgUnitIds;
        if (params.orgUnitIds == null || params.orgUnitIds.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_companyNull", null));
            SysUtil.abort();
        }
        OneToManyMap templates = new OneToManyMap();
        for (int i = 0; i < this.sheetTable.getRowCount(); ++i) {
            IRow row = this.sheetTable.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            templates.put(row.getCell("templateId").getValue(), row.getCell("sheetName").getValue());
        }
        params.templates = templates;
        if (params.templates == null || params.templates.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_tmpNull", null));
            SysUtil.abort();
        }
        return params;
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuilder sbFormula = new StringBuilder();
        int selectedTemplateTypeIndex = this.cmbTemplateType.getSelectedIndex();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("templateType", (Object)selectedTemplateTypeIndex));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        CurrencyInfo selectedCurrency = (CurrencyInfo)this.cmbCurrency.getSelectedItem();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)selectedCurrency.getId().toString()));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        int selectedDataImportTypeIndex = this.cmbDataImportType.getSelectedIndex();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("dataImportType", (Object)selectedDataImportTypeIndex));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        boolean isWeaving = this.chkIsWeaving.isSelected();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isWeaving", (Object)isWeaving));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        boolean isAudited = this.chkIsAudited.isSelected();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isAudited", (Object)isAudited));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        boolean isCommited = this.chkIsCommited.isSelected();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isCommited", (Object)isCommited));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        boolean isReceived = this.chkIsReceived.isSelected();
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isReceived", (Object)isReceived));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < this.companyTable.getRowCount(); ++i) {
            companyIdSet.add((String)this.companyTable.getRow(i).getCell("id").getValue());
        }
        if (companyIdSet.size() > 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("companyIdSet", companyIdSet, CompareType.INCLUDE));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        HashSet<String> templateIdSet = new HashSet<String>();
        for (int i = 0; i < this.templateTable.getRowCount(); ++i) {
            templateIdSet.add((String)this.templateTable.getRow(i).getCell("id").getValue());
        }
        if (templateIdSet.size() > 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("templateIdSet", templateIdSet, CompareType.INCLUDE));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        HashSet<String> selectSheetIdSet = new HashSet<String>();
        HashSet<String> noSelectSheetIdSet = new HashSet<String>();
        for (int i = 0; i < this.sheetTable.getRowCount(); ++i) {
            IRow row = this.sheetTable.getRow(i);
            if (Boolean.TRUE.equals(row.getCell("select").getValue())) {
                selectSheetIdSet.add((String)row.getCell("id").getValue());
                continue;
            }
            noSelectSheetIdSet.add((String)row.getCell("id").getValue());
        }
        if (selectSheetIdSet.size() > 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("selectSheetIdSet", selectSheetIdSet, CompareType.INCLUDE));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if (noSelectSheetIdSet.size() > 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("noSelectSheetIdSet", noSelectSheetIdSet, CompareType.INCLUDE));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if (sbFormula.length() > 0) {
            int index = sbFormula.lastIndexOf(" and ");
            this.filterInfo.setMaskString(sbFormula.substring(0, index).toString());
        } else if (this.filterInfo.containsKey("maskString")) {
            this.filterInfo.remove("maskString");
        }
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        Set selectSheetIdSet = new HashSet();
        Set noSelectSheetIdSet = new HashSet();
        HashSet sheetIdSet = new HashSet();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            IRow addRow;
            int x;
            SelectorItemCollection sic;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("templateType")) {
                this.cmbTemplateType.setSelectedIndex(((Integer)filterItemInfo.getCompareValue()).intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("currency")) {
                String selectedCurrency = (String)filterItemInfo.getCompareValue();
                int itemCount = this.cmbCurrency.getItemCount();
                int index = 0;
                for (int x2 = 0; x2 < itemCount; ++x2) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.cmbCurrency.getItemAt(x2);
                    if (!currencyInfo.getId().toString().equals(selectedCurrency)) continue;
                    index = x2;
                    break;
                }
                this.cmbCurrency.setSelectedIndex(index);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataImportType")) {
                this.cmbDataImportType.setSelectedIndex(((Integer)filterItemInfo.getCompareValue()).intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataImportType")) {
                this.cmbDataImportType.setSelectedIndex(((Integer)filterItemInfo.getCompareValue()).intValue());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isWeaving")) {
                this.chkIsWeaving.setSelected(TypeConversionUtils.objToBoolean((Object)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isAudited")) {
                this.chkIsAudited.setSelected(TypeConversionUtils.objToBoolean((Object)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isCommited")) {
                this.chkIsCommited.setSelected(TypeConversionUtils.objToBoolean((Object)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("isReceived")) {
                this.chkIsReceived.setSelected(TypeConversionUtils.objToBoolean((Object)filterItemInfo.getCompareValue()));
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("companyIdSet")) {
                this.selectedCompanyIds.clear();
                Set companyIdSet = (Set)filterItemInfo.getCompareValue();
                EntityViewInfo view = new EntityViewInfo();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                view.setSelector(sic);
                FilterInfo filterInfo = new FilterInfo();
                view.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
                try {
                    CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                    if (companyOrgUnitCollection == null || companyOrgUnitCollection.isEmpty()) continue;
                    for (x = 0; x < companyOrgUnitCollection.size(); ++x) {
                        CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(x);
                        addRow = this.companyTable.addRow();
                        this.selectedCompanyIds.add(companyOrgUnitInfo.getId().toString());
                        addRow.getCell("id").setValue((Object)companyOrgUnitInfo.getId().toString());
                        addRow.getCell("companyName").setValue((Object)companyOrgUnitInfo.getName());
                        addRow.getCell("companyNumber").setValue((Object)companyOrgUnitInfo.getNumber());
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"loadData_getCompanyOrgUnitCollection_error", (Throwable)e);
                    continue;
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("templateIdSet")) {
                this.selectedTemplateIds.clear();
                Set templateIdSet = (Set)filterItemInfo.getCompareValue();
                EntityViewInfo view = new EntityViewInfo();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("templateType"));
                view.setSelector(sic);
                FilterInfo filterInfo = new FilterInfo();
                view.setFilter(filterInfo);
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)templateIdSet, CompareType.INCLUDE));
                try {
                    TemplateCollection templateCollection = TemplateFactory.getRemoteInstance().getTemplateCollection(view);
                    if (templateCollection == null || templateCollection.isEmpty()) continue;
                    for (x = 0; x < templateCollection.size(); ++x) {
                        TemplateInfo templateInfo = templateCollection.get(x);
                        addRow = this.templateTable.addRow();
                        addRow.getCell("templateNumber").setValue((Object)templateInfo.getNumber());
                        addRow.getCell("templateName").setValue((Object)templateInfo.getName());
                        addRow.getCell("templateType").setValue((Object)templateInfo.getTemplateType());
                        addRow.getCell("id").setValue((Object)templateInfo.getId().toString());
                        this.selectedTemplateIds.add(templateInfo.getId().toString());
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"loadData_getTemplateCollection_error", (Throwable)e);
                    continue;
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("selectSheetIdSet")) {
                selectSheetIdSet = (Set)filterItemInfo.getCompareValue();
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("noSelectSheetIdSet")) continue;
            noSelectSheetIdSet = (Set)filterItemInfo.getCompareValue();
        }
        if (selectSheetIdSet != null && selectSheetIdSet.size() > 0) {
            sheetIdSet.addAll(selectSheetIdSet);
        }
        if (noSelectSheetIdSet != null && noSelectSheetIdSet.size() > 0) {
            sheetIdSet.addAll(noSelectSheetIdSet);
        }
        if (sheetIdSet.size() > 0) {
            try {
                Map resultMap = AccountCheckFacadeFactory.getRemoteInstance().getImportForReportSheetInfo(sheetIdSet);
                List rowInfoList = (List)resultMap.get("result");
                if (rowInfoList != null && !rowInfoList.isEmpty()) {
                    for (int x = 0; x < rowInfoList.size(); ++x) {
                        Object[] obj = (Object[])rowInfoList.get(x);
                        IRow sheetAddRow = this.sheetTable.addRow();
                        sheetAddRow.getCell("select").setValue((Object)selectSheetIdSet.contains(obj[4]));
                        sheetAddRow.getCell("templateNumber").setValue(obj[0]);
                        sheetAddRow.getCell("templateName").setValue(obj[1]);
                        sheetAddRow.getCell("sheetName").setValue(obj[2]);
                        sheetAddRow.getCell("templateId").setValue(obj[3]);
                        sheetAddRow.getCell("id").setValue(obj[4]);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"loadData_getImportForReportSheetInfo_error", (Throwable)e);
            }
        }
    }

    public void clear() {
        this.cmbTemplateType.setSelectedIndex(0);
        Object object = this.getUIContext().get("currency");
        this.cmbCurrency.setSelectedItem(object);
        this.cmbDataImportType.setSelectedIndex(0);
        this.chkIsWeaving.setSelected(false);
        this.chkIsAudited.setSelected(true);
        this.chkIsCommited.setSelected(false);
        this.chkIsReceived.setSelected(false);
        this.companyTable.removeRows();
        this.selectedCompanyIds.clear();
        this.selectedTemplateIds.clear();
        this.templateTable.removeRows();
        this.sheetTable.removeRows();
    }

    public boolean verify() {
        if (!(this.chkIsWeaving.isSelected() || this.chkIsAudited.isSelected() || this.chkIsCommited.isSelected() || this.chkIsReceived.isSelected())) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_rptStNull", null));
            return false;
        }
        if (this.companyTable.getRowCount() < 1) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_companyNull", null));
            return false;
        }
        if (this.templateTable.getRowCount() < 1) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_tmpNull", null));
            return false;
        }
        if (this.sheetTable.getRowCount() < 1) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_sheetNull", null));
            return false;
        }
        boolean isSelect = false;
        for (int i = 0; i < this.sheetTable.getRowCount(); ++i) {
            IRow row = this.sheetTable.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            isSelect = true;
            break;
        }
        if (!isSelect) {
            MsgBox.showError((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "AccountCheckImportReport_sheetNull", null));
            return false;
        }
        return true;
    }
}

