/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.render.RenderObject;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.IExtBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountF7UI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class AccountF7UI
extends AbstractAccountF7UI
implements KDPromptSelector,
CommitListener {
    private static final Logger logger = CoreUIObject.getLogger(AccountF7UI.class);
    private boolean isCanceled = true;
    private String accountTableID = null;
    public AccountViewInfo accountViewInfo = null;
    private HashSet IDSet = new HashSet();
    private int selectRow = -1;
    private String strFocusNumber = "";
    AccountTreeRender treeRender;
    int space = 3;
    char collapseChar = (char)43;
    char expandChar = (char)45;
    char leafChar = (char)32;
    char spaceChar = (char)32;
    private boolean isWillCommit = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void willCommit(CommitEvent e) {
        this.isWillCommit = true;
        KDBizPromptBox pb = (KDBizPromptBox)e.getSource();
        pb.setDataBySelector();
        this.isWillCommit = false;
    }

    public boolean isCanceled() {
        return false;
    }

    public void onLoad() throws Exception {
        this.accountTableID = ((AccountTableInfo)this.getUIContext().get("accountTableInfo")).getId().toString();
        super.onLoad();
        this.kdAccountTable.addItem((Object)((AccountTableInfo)this.getUIContext().get("accountTableInfo")));
        FilterInfo filterInfo = this.mainQuery.getFilter();
        this.mainQuery.setFilter(this.getFilterInfo(filterInfo));
        KDBizPromptBox prmtAccount = (KDBizPromptBox)this.getUIContext().get("prmtAccount");
        prmtAccount.setEntityViewInfo(this.mainQuery);
        HashMap map = (HashMap)CheckageAccountFactory.getRemoteInstance().getHasCAAID(this.accountTableID);
        this.IDSet.addAll((HashSet)map.get("IDSet"));
        HashSet accountNumberSet = (HashSet)map.get("accountNumberSet");
        HashSet set = CheckageAccountFactory.getRemoteInstance().getNoHasCAAID(this.accountTableID, accountNumberSet);
        this.IDSet.addAll(set);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && AccountF7UI.this.tblMain.getSelectManager().get() != null) {
                    AccountF7UI.this.doSelected();
                }
            }
        });
        this.chkShowLongName.setSelected(false);
        this.outspread.setSelected(true);
        this.tblMain.getColumn("name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("longName").getStyleAttributes().setHided(false);
        this.treeRender = new AccountTreeRender();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.treeRender);
        this.tblMain.getColumn("number").getStyleAttributes().setNumberFormat("@");
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                AccountF7UI.this.setTreeDisplayStyle(start, end + 1);
            }
        });
    }

    private void setTreeDisplayStyle(int start, int end) {
        int count = end;
        for (int i = start; i < count; ++i) {
            IRow row2;
            String childLongNumber;
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell("id").getValue();
            int level = (Integer)row.getCell("level").getValue();
            Object numberValue = row.getCell("number").getValue();
            Object longNumberValue = row.getCell("longNumber").getValue();
            String acctLongNumber = (String)longNumberValue;
            if (!(numberValue instanceof String)) {
                return;
            }
            String acctNumber = (String)numberValue;
            boolean isLeaf = false;
            isLeaf = i + 1 < count ? (childLongNumber = (String)(row2 = this.tblMain.getRow(i + 1)).getCell("longNumber").getValue()) == null || !childLongNumber.startsWith(acctLongNumber + "!") : true;
            row.getCell("isLeaf").setValue((Object)isLeaf);
            NumberExpandInfo acctNumberExpandInfo = new NumberExpandInfo();
            acctNumberExpandInfo.setAcctId(id);
            acctNumberExpandInfo.setLevel(level);
            acctNumberExpandInfo.setLeaf(isLeaf);
            acctNumberExpandInfo.setNumber(acctNumber);
            acctNumberExpandInfo.setLongNumber(acctLongNumber);
            acctNumberExpandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)acctNumberExpandInfo);
        }
    }

    @Override
    protected void chkShowLongName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isShowLongName = this.chkShowLongName.isSelected();
        if (!isShowLongName) {
            this.tblMain.getColumn("name").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("longName").getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn("name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("longName").getStyleAttributes().setHided(false);
        }
    }

    public Object getData() {
        if (this.isCanceled) {
            if (this.accountViewInfo != null) {
                return this.accountViewInfo;
            }
            return null;
        }
        return this.accountViewInfo;
    }

    public void refreshList() throws Exception {
        FilterInfo filterInfo = this.mainQuery.getFilter();
        this.mainQuery.setFilter(this.getFilterInfo(filterInfo));
        super.refreshList();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    private FilterInfo getFilterInfo(FilterInfo filterInfo) {
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        FilterInfo filterInfoNew = new FilterInfo();
        filterInfoNew.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.accountTableID));
        if (this.IDSet.size() > 0) {
            filterInfoNew.getFilterItems().add(new FilterItemInfo("id", (Object)this.IDSet, CompareType.INCLUDE));
        }
        try {
            filterInfo.mergeFilter(filterInfoNew, "and");
        }
        catch (BOSException e) {
            logger.error((Object)"getFilterInfo()", (Throwable)e);
        }
        return filterInfo;
    }

    public void show() {
        this.isCanceled = true;
        this.mainQuery.setFilter(this.getFilterInfo(null));
        this.uiWindow.show();
    }

    @Override
    protected void outspread_itemStateChanged(ItemEvent e) throws Exception {
        boolean outspread = this.outspread.isSelected();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            acctNumberExpandInfo.setExpandStatus(outspread);
            boolean isAcctLeaf = (Boolean)row.getCell("isLeaf").getValue();
            int level = (Integer)row.getCell("level").getValue();
            if (isAcctLeaf && level > 1) {
                row.getStyleAttributes().setHided(!outspread);
                continue;
            }
            row.getStyleAttributes().setHided(false);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.doSelected();
    }

    private void doSelected() {
        int selectRow;
        logger.debug((Object)("select row is:" + this.selectRow));
        int blocks = this.tblMain.getSelectManager().size();
        int n = selectRow = this.tblMain.getSelectManager().get(0) == null ? -1 : this.tblMain.getSelectManager().get(0).getBeginRow();
        if (blocks == 0 || selectRow < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        IRow row = this.tblMain.getRow(selectRow);
        this.accountViewInfo = new AccountViewInfo();
        this.accountViewInfo.setNumber(row.getCell("number").getValue().toString());
        this.accountViewInfo.setName(row.getCell("name").getValue().toString());
        this.accountViewInfo.setDC(BalanceDirectionEnum.getEnum((int)((BizEnumValueDTO)row.getCell("DC").getValue()).getInt()));
        this.accountViewInfo.put("CAAName", row.getCell("CAA.name").getValue());
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int columnIndex;
        if (e.getClickCount() == 1 && (columnIndex = e.getColIndex()) == this.tblMain.getColumn("number").getColumnIndex()) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || row.getCell("number") == null || !(row.getCell("number").getValue() instanceof NumberExpandInfo)) {
                return;
            }
            this.strFocusNumber = row.getCell("number").getValue().toString();
            NumberExpandInfo numberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            if (this.treeRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row);
            }
            return;
        }
        super.tblMain_tableClicked(e);
    }

    private void setTreeDisplayStyle(IRow row) {
        boolean isAcctLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (isAcctLeaf) {
            return;
        }
        this.expandAcct(row);
    }

    private void expandAcct(IRow row) {
        IRow child;
        NumberExpandInfo childNumberExpandInfo;
        String childLongNumber;
        NumberExpandInfo acctNumberExpandInfo = (NumberExpandInfo)row.getCell("number").getValue();
        String acctNumber = acctNumberExpandInfo.getNumber();
        String acctLongNumber = acctNumberExpandInfo.getLongNumber() + "!";
        boolean isExpandStatus = acctNumberExpandInfo.isExpandStatus();
        String acctId = (String)row.getCell("id").getValue();
        acctNumberExpandInfo.setExpandStatus(!isExpandStatus);
        this.tblMain.setRefresh(false);
        int count = this.tblMain.getRowCount();
        for (int i = row.getRowIndex() + 1; i < count && (childLongNumber = (childNumberExpandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(i)).getCell("number").getValue()).getLongNumber()) != null && childLongNumber.startsWith(acctLongNumber); ++i) {
            child.getStyleAttributes().setHided(isExpandStatus);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    class NumberExpandInfo {
        private String acctId;
        private String number;
        private String longNumber;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public String getAcctId() {
            return this.acctId;
        }

        public void setAcctId(String acctId) {
            this.acctId = acctId;
        }
    }

    private class AccountTreeRender
    implements IExtBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        private AccountTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getAcctId();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getAcctId(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - ident - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle, Object extObject) {
            Object obj;
            RenderObject ro = (RenderObject)extObject;
            if (ro != null && ro.getCell() != null && (obj = ro.getCell().getValue()) != null) {
                this.draw(graphics, clip, obj, cellStyle);
            }
        }

        public boolean isClip() {
            return false;
        }

        public boolean isFillBackground() {
            return false;
        }

        public boolean isDrawBorder() {
            return false;
        }
    }
}

