/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountMappingDispenseUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountMappingListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.SelectCheckageCompanyUI;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountMappingDispenseUI
extends AbstractAccountMappingDispenseUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountMappingDispenseUI.class);
    private List accountMappingIds = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdCompanyTable.checkParsed();
        this.kdCompanyTable.setEditable(false);
        this.kdCompanyTable.getSelectManager().setSelectMode(10);
        this.accountMappingIds = (List)this.getUIContext().get("accountMappingIds");
    }

    @Override
    public void actionSelectOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        Map uiContext = this.getUIContext();
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(SelectCheckageCompanyUI.class.getName(), uiContext, null, OprtState.EDIT);
        ((UIModelDialog)window).setPreferredSize(new Dimension(1090, 800));
        ((UIModelDialog)window).setResizable(true);
        window.show();
        SelectCheckageCompanyUI ui = (SelectCheckageCompanyUI)window.getUIObject();
        if (!ui.isCancle()) {
            List<String[]> selectData = ui.getSelectData();
            this.kdCompanyTable.removeRows();
            for (int i = 0; i < selectData.size(); ++i) {
                IRow row = this.kdCompanyTable.setRow(i);
                row.getCell("checkageCompanyId").setValue((Object)selectData.get(i)[0]);
                row.getCell("orgUnitNumber").setValue((Object)selectData.get(i)[1]);
                row.getCell("orgUnitName").setValue((Object)selectData.get(i)[2]);
            }
            this.kdCompanyTable.setRefresh(true);
            this.kdCompanyTable.reLayoutAndPaint();
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.accountMappingIds != null && this.kdCompanyTable.getRowCount() > 0) {
            Map dispensedMap = this.getDispensedMap();
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < this.kdCompanyTable.getRowCount(); ++i) {
                Object checkageCompanyId = this.kdCompanyTable.getCell(i, "checkageCompanyId").getValue();
                if (checkageCompanyId == null) continue;
                for (Object accountMappingId : this.accountMappingIds) {
                    Set dispenseCompanyIds = (Set)dispensedMap.get(accountMappingId);
                    if (dispenseCompanyIds != null && dispenseCompanyIds.contains(checkageCompanyId)) continue;
                    AccountMapDispenseInfo info = new AccountMapDispenseInfo();
                    AccountMapInfo accountMapInfo = new AccountMapInfo();
                    accountMapInfo.setId(BOSUuid.read((String)accountMappingId.toString()));
                    info.setAccountMap(accountMapInfo);
                    CheckageCompanyInfo companyInfo = new CheckageCompanyInfo();
                    companyInfo.setId(BOSUuid.read((String)checkageCompanyId.toString()));
                    info.setCheckageCompany(companyInfo);
                    info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                    info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    coll.add((CoreBaseInfo)info);
                }
            }
            if (!coll.isEmpty()) {
                IObjectPK[] i = AccountMapDispenseFactory.getRemoteInstance().submitBatchData(coll);
            }
            AccountMappingListUI listUi = (AccountMappingListUI)((Object)this.getUIContext().get("Owner"));
            listUi.setMessageText(AccountCheckUtil.getResourceString(null, "545_dispenseSuccess", null));
            listUi.showMessage();
            this.disposeUIWindow();
        } else if (this.kdCompanyTable.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "554_selectCheckOrgUnit", null));
        }
    }

    @Override
    public void actionCancle_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public Map getDispensedMap() throws Exception {
        if (this.accountMappingIds != null) {
            AccountMapDispenseCollection coll = AccountMapDispenseFactory.getRemoteInstance().getAccountMapDispenseCollection("select accountMap.id,checkageCompany.id where accountMap.id in(" + CslRptUtil.list2String((List)this.accountMappingIds, (String)",", (boolean)true) + ")");
            OneToManyMap dispensedMap = new OneToManyMap(2);
            for (int i = 0; i < coll.size(); ++i) {
                dispensedMap.put(coll.get(i).getAccountMap().getId().toString(), coll.get(i).getCheckageCompany().getId().toString());
            }
            return dispensedMap;
        }
        return null;
    }
}

