/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AsstActTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.IAccountMap;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountMappingEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountSelectorUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class AccountMappingEditUI
extends AbstractAccountMappingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountMappingEditUI.class);
    private String uiTitle = null;
    private HashMap checkAgeAccountMap = new HashMap();
    ItemTypeEnum itemTypeEnum = null;

    public void onLoad() throws Exception {
        this.AccountEntriesTable.checkParsed();
        this.itemTypeEnum = (ItemTypeEnum)((Object)this.getUIContext().get("itemTypeEnum"));
        super.onLoad();
        this.uiTitle = this.getUITitle();
        this.comboElimType.removeAllItems();
        this.comboElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.comboElimType.addItem((Object)ElimTypeEnum.exchange);
        this.AccountEntriesTable.getStyleAttributes().setLocked(true);
        this.modifyTitle();
        if (this.editData != null) {
            if (this.editData.getElimType() != null) {
                this.comboElimType.setSelectedItem((Object)this.editData.getElimType());
            } else {
                this.comboElimType.setSelectedIndex(-1);
            }
        } else {
            this.comboElimType.setSelectedIndex(-1);
        }
        this.fillTableColor();
        AccountAndMapAccountCollection coll = this.editData.getAccount();
        for (int i = 0; i < coll.size(); ++i) {
            AccountAndMapAccountInfo info = coll.get(i);
            this.checkAgeAccountMap.put(info.getCheckAccount().getId().toString(), info.isIsMapAccount());
        }
        this.changeControByItemType();
        this.initDataSourceColumn();
    }

    private void initDataSourceColumn() {
        this.AccountEntriesTable.getColumn("dataSource").getStyleAttributes().setLocked(false);
        KDComboBox cmDataSrcType = new KDComboBox();
        cmDataSrcType.addItems(DataSrcTypeEnum.getEnumList().toArray());
        this.AccountEntriesTable.getColumn("dataSource").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmDataSrcType));
    }

    private void changeControByItemType() {
        if (this.itemTypeEnum != null) {
            this.comboItemType.addItem((Object)this.itemTypeEnum);
        }
    }

    private void changeTableColHide(boolean isHide) {
        this.AccountEntriesTable.getColumn("accountTable").getStyleAttributes().setHided(!isHide);
        this.AccountEntriesTable.getColumn("asstActTypes").getStyleAttributes().setHided(!isHide);
        this.AccountEntriesTable.getColumn("balType").getStyleAttributes().setHided(!isHide);
        this.AccountEntriesTable.getColumn("dataElementName").getStyleAttributes().setHided(isHide);
    }

    private void fillTableColor() {
        if (this.AccountEntriesTable.getRowCount() > 0) {
            IRow row = null;
            ICell isMapAccount = null;
            for (int i = 0; i < this.AccountEntriesTable.getRowCount(); ++i) {
                row = this.AccountEntriesTable.getRow(i);
                if (ItemTypeEnum.rptItem == this.itemTypeEnum) {
                    Integer interSeq = (Integer)row.getCell("dataElementInseq").getValue();
                    String dataElementName = DataElementProvider.getDataElementInfo((int)interSeq).getName();
                    row.getCell("dataElementName").setValue((Object)dataElementName);
                }
                if (((Boolean)(isMapAccount = row.getCell("isMapAccount")).getValue()).booleanValue()) continue;
                StyleAttributes sa = row.getStyleAttributes();
                sa.setBackground(new Color(240, 236, 250));
                row.setStyleAttributes(sa);
            }
        }
    }

    protected KDTable getDetailTable() {
        return this.AccountEntriesTable;
    }

    @Override
    public void actionSelectAccount_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        if (this.editData.getAccount() != null) {
            uiContext.put((Object)"Account", (Object)this.getNewAccountAndMapAccountCollection());
        }
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"itemTypeEnum", (Object)this.itemTypeEnum);
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AccountSelectorUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        AccountSelectorUI accountSelectorUI = (AccountSelectorUI)curUIWindow.getUIObject();
        ((KDFrame)curUIWindow).setBounds(10, 10, 1200, 600);
        curUIWindow.show();
    }

    private AccountAndMapAccountCollection getNewAccountAndMapAccountCollection() {
        AccountAndMapAccountCollection coll = this.editData.getAccount();
        int count = this.AccountEntriesTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.AccountEntriesTable.getRow(i);
            DataSrcTypeEnum dataSource = (DataSrcTypeEnum)row.getCell("dataSource").getValue();
            coll.get(i).setDataSource(dataSource);
        }
        return coll;
    }

    protected IObjectValue createNewData() {
        return new AccountMapInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountMapFactory.getRemoteInstance();
    }

    public void fillTable(AccountAndMapAccountCollection coll, boolean isUnilateralReconciliation, String ourAccountTableid, String oppositeAccountTableid) {
        String diffKey = this.getDiffRowKey();
        StringBuffer key = null;
        this.AccountEntriesTable.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            key = new StringBuffer();
            AccountAndMapAccountInfo info = coll.get(i);
            IRow row = this.AccountEntriesTable.addRow();
            String itemNumber = info.getCheckAccount().getItemNumber();
            row.getCell("itemNumber").setValue((Object)itemNumber);
            row.getCell("itemName").setValue((Object)info.getCheckAccount().getItemName());
            if (ItemTypeEnum.account == this.itemTypeEnum) {
                String accountTableid = info.getCheckAccount().getAccountTableid();
                String balType = info.getCheckAccount().getBalType().toString();
                String asstActTypes = info.getCheckAccount().getAsstActTypes().toString();
                row.getCell("accountTable").setValue((Object)info.getCheckAccount().getAccountTableName());
                row.getCell("balType").setValue((Object)balType);
                row.getCell("asstActTypes").setValue((Object)asstActTypes);
                row.getCell("accountTableID").setValue((Object)accountTableid);
                key.append(accountTableid).append(itemNumber).append(balType).append(asstActTypes);
            } else {
                int interSeq = info.getCheckAccount().getDataElement();
                row.getCell("dataElementName").setValue((Object)DataElementProvider.getDataElementInfo((int)info.getCheckAccount().getDataElement()).getName());
                row.getCell("dataElementInseq").setValue((Object)interSeq);
                key.append(itemNumber).append(interSeq);
            }
            row.getCell("itemDc").setValue((Object)info.getCheckAccount().getItemDC());
            boolean isMapAccount = info.isIsMapAccount();
            key.append(isMapAccount);
            row.getCell("isMapAccount").setValue((Object)isMapAccount);
            row.getCell("dataSource").setValue((Object)info.getDataSource());
            if (!info.isIsMapAccount()) {
                StyleAttributes sa = row.getStyleAttributes();
                sa.setBackground(new Color(240, 236, 250));
                row.setStyleAttributes(sa);
            }
            if (diffKey == null || !diffKey.equals(key.toString())) continue;
            row.getCell("dataSource").setValue((Object)DataSrcTypeEnum.DIFF);
            info.setDataSource(DataSrcTypeEnum.DIFF);
        }
        this.editData.put("account", (Object)coll);
        this.editData.setIsUnilateralReconciliation(isUnilateralReconciliation);
        this.editData.setOurAccountTableid(ourAccountTableid);
        this.editData.setOppositeAccountTableid(oppositeAccountTableid);
    }

    private String getDiffRowKey() {
        int count = this.AccountEntriesTable.getRowCount();
        StringBuffer key = null;
        for (int i = 0; i < count; ++i) {
            IRow row = this.AccountEntriesTable.getRow(i);
            DataSrcTypeEnum dataSource = (DataSrcTypeEnum)row.getCell("dataSource").getValue();
            if (dataSource.getValue() != 2) continue;
            key = new StringBuffer();
            String itemNumber = (String)row.getCell("itemNumber").getValue();
            boolean isMapAccount = (Boolean)row.getCell("isMapAccount").getValue();
            if (ItemTypeEnum.account == this.itemTypeEnum) {
                String accountTableID = (String)row.getCell("accountTableID").getValue();
                String balTypeString = null;
                if (row.getCell("balType").getValue() instanceof String) {
                    balTypeString = (String)row.getCell("balType").getValue();
                } else if (row.getCell("balType").getValue() instanceof BalTypeEnum) {
                    BalTypeEnum balType = (BalTypeEnum)((Object)row.getCell("balType").getValue());
                    balTypeString = balType.toString();
                }
                String asstActTypesString = null;
                if (row.getCell("asstActTypes").getValue() instanceof String) {
                    asstActTypesString = (String)row.getCell("asstActTypes").getValue();
                } else if (row.getCell("asstActTypes").getValue() instanceof AsstActTypeEnum) {
                    AsstActTypeEnum asstActTypes = (AsstActTypeEnum)((Object)row.getCell("asstActTypes").getValue());
                    asstActTypesString = asstActTypes.toString();
                }
                key.append(accountTableID).append(itemNumber).append(balTypeString).append(asstActTypesString).append(isMapAccount);
                continue;
            }
            String dataElement = null;
            if (row.getCell("dataElementInseq").getValue() instanceof String) {
                dataElement = (String)row.getCell("dataElementInseq").getValue();
            } else if (row.getCell("dataElementInseq").getValue() instanceof Integer) {
                int seq = (Integer)row.getCell("dataElementInseq").getValue();
                dataElement = String.valueOf(seq);
            }
            key.append(itemNumber).append(dataElement).append(isMapAccount);
        }
        return key == null ? null : key.toString();
    }

    private Map<String, DataSrcTypeEnum> getTableDataSrcMap() {
        HashMap<String, DataSrcTypeEnum> map = new HashMap<String, DataSrcTypeEnum>();
        int count = this.AccountEntriesTable.getRowCount();
        StringBuffer key = null;
        for (int i = 0; i < count; ++i) {
            IRow row = this.AccountEntriesTable.getRow(i);
            DataSrcTypeEnum dataSource = (DataSrcTypeEnum)row.getCell("dataSource").getValue();
            key = new StringBuffer();
            String itemNumber = (String)row.getCell("itemNumber").getValue();
            boolean isMapAccount = (Boolean)row.getCell("isMapAccount").getValue();
            if (ItemTypeEnum.account == this.itemTypeEnum) {
                String accountTableID = (String)row.getCell("accountTableID").getValue();
                String balTypeString = null;
                if (row.getCell("balType").getValue() instanceof String) {
                    balTypeString = (String)row.getCell("balType").getValue();
                } else if (row.getCell("balType").getValue() instanceof BalTypeEnum) {
                    BalTypeEnum balType = (BalTypeEnum)((Object)row.getCell("balType").getValue());
                    balTypeString = balType.toString();
                }
                String asstActTypesString = null;
                if (row.getCell("asstActTypes").getValue() instanceof String) {
                    asstActTypesString = (String)row.getCell("asstActTypes").getValue();
                } else if (row.getCell("asstActTypes").getValue() instanceof AsstActTypeEnum) {
                    AsstActTypeEnum asstActTypes = (AsstActTypeEnum)((Object)row.getCell("asstActTypes").getValue());
                    asstActTypesString = asstActTypes.toString();
                }
                key.append(accountTableID).append(itemNumber).append(balTypeString).append(asstActTypesString).append(isMapAccount);
            } else {
                String dataElement = null;
                if (row.getCell("dataElementInseq").getValue() instanceof String) {
                    dataElement = (String)row.getCell("dataElementInseq").getValue();
                } else if (row.getCell("dataElementInseq").getValue() instanceof Integer) {
                    int seq = (Integer)row.getCell("dataElementInseq").getValue();
                    dataElement = String.valueOf(seq);
                }
                key.append(itemNumber).append(dataElement).append(isMapAccount);
            }
            map.put(key.toString(), dataSource);
        }
        return map;
    }

    private void modifyTitle() {
        if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"View"));
            this.btnSelectAccount.setEnabled(false);
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"Update"));
            this.btnSelectAccount.setEnabled(true);
        } else {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AddNew"));
            this.btnSelectAccount.setEnabled(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.modifyTitle();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.modifyTitle();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NumberIsNull"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)this.itemTypeEnum.getValue()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtNumber.getText()));
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.getBizInterface().exists(filter)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NumberIsExist"));
            SysUtil.abort();
        }
        if (this.comboElimType.getSelectedIndex() < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ElimTypeIsNull"));
            SysUtil.abort();
        }
        if (this.editData.getAccount().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AccountMapisNull"));
            SysUtil.abort();
        }
        String accountMapNumber = null;
        accountMapNumber = this.editData.getId() != null ? ((IAccountMap)this.getBizInterface()).getExistNumber(this.editData.getAccount(), this.editData.getId().toString(), this.editData.isIsUnilateralReconciliation(), this.itemTypeEnum) : ((IAccountMap)this.getBizInterface()).getExistNumber(this.editData.getAccount(), null, this.editData.isIsUnilateralReconciliation(), this.itemTypeEnum);
        if (accountMapNumber != null) {
            MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ExistAccountMap"), accountMapNumber));
            SysUtil.abort();
        }
        if (this.editData.getId() != null) {
            Map resultMap;
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.editData.getId().toString());
            AccountAndMapAccountCollection accountColl = this.editData.getAccount();
            int count = 0;
            for (int i = 0; i < accountColl.size(); ++i) {
                AccountAndMapAccountInfo info = accountColl.get(i);
                if (this.checkAgeAccountMap.get(info.getCheckAccount().getId().toString()) == null || ((Boolean)this.checkAgeAccountMap.get(info.getCheckAccount().getId().toString())).booleanValue() != info.isIsMapAccount()) continue;
                ++count;
            }
            if (count < this.checkAgeAccountMap.size() && ((ArrayList)(resultMap = ((IAccountMap)this.getBizInterface()).removeOfNoQuote(list)).get("noRemoveIDList")).size() > 0) {
                String number = this.editData.getNumber();
                ArrayList numberList = (ArrayList)resultMap.get(number);
                StringBuffer result = new StringBuffer();
                result.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"OnlyCanAddCheckAccount")).append("\n");
                for (int i = 0; i < numberList.size(); ++i) {
                    result.append(numberList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"EditDefault"), (String)new String(result), (int)8188);
                SysUtil.abort();
            }
        }
        this.validateDiffData();
    }

    private void validateDiffData() {
        AccountAndMapAccountCollection accounts = this.editData.getAccount();
        if (accounts != null) {
            int index = this.countDiff();
            boolean isDouble = this.isDouble();
            if (accounts.size() == 1 && index == 1 || index >= 1 && !isDouble) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"552_noDiff"));
                SysUtil.abort();
            }
            if (index > 1 && isDouble) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"551_onlyOneDiff"));
                SysUtil.abort();
            }
            this.setAccountsDiffValue(accounts);
        }
    }

    private void setAccountsDiffValue(AccountAndMapAccountCollection accounts) {
        Map<String, DataSrcTypeEnum> map = this.getTableDataSrcMap();
        StringBuffer key = null;
        for (int i = 0; i < accounts.size(); ++i) {
            key = new StringBuffer();
            AccountAndMapAccountInfo info = accounts.get(i);
            String itemNumber = info.getCheckAccount().getItemNumber();
            if (ItemTypeEnum.account == this.itemTypeEnum) {
                String accountTableid = info.getCheckAccount().getAccountTableid();
                String balType = info.getCheckAccount().getBalType().toString();
                String asstActTypes = info.getCheckAccount().getAsstActTypes().toString();
                key.append(accountTableid).append(itemNumber).append(balType).append(asstActTypes);
            } else {
                int interSeq = info.getCheckAccount().getDataElement();
                key.append(itemNumber).append(interSeq);
            }
            boolean isMapAccount = info.isIsMapAccount();
            key.append(isMapAccount);
            if (map == null || map.isEmpty() || !map.containsKey(key.toString())) continue;
            DataSrcTypeEnum dste = map.get(key.toString());
            info.setDataSource(dste);
        }
    }

    private int countDiff() {
        int index = 0;
        int count = this.AccountEntriesTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.AccountEntriesTable.getRow(i);
            DataSrcTypeEnum dataSource = (DataSrcTypeEnum)row.getCell("dataSource").getValue();
            if (dataSource.getValue() != 2) continue;
            ++index;
        }
        return index;
    }

    private boolean isDouble() {
        int count = this.AccountEntriesTable.getRowCount();
        boolean isOwner = false;
        boolean isTar = false;
        for (int i = 0; i < count; ++i) {
            IRow row = this.AccountEntriesTable.getRow(i);
            boolean isMapAccount = (Boolean)row.getCell("isMapAccount").getValue();
            if (isMapAccount) {
                isTar = true;
                continue;
            }
            isOwner = true;
        }
        return isTar && isOwner;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.getOprtState() == OprtState.EDIT) {
            this.fillTableColor();
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.fillTableColor();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.fillTableColor();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.fillTableColor();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.fillTableColor();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.editData.getId().toString());
        try {
            Map resultMap = ((IAccountMap)this.getBizInterface()).removeOfNoQuote(list);
            ArrayList NoCanDeleteList = (ArrayList)resultMap.get("noRemoveIDList");
            if (NoCanDeleteList.size() > 0) {
                Iterator iter = resultMap.entrySet().iterator();
                StringBuffer result = new StringBuffer();
                boolean isFirst = true;
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = (String)entry.getKey();
                    if ("noRemoveIDList".equals(key)) continue;
                    String tempString = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"isDeleteDefaultNumber"), key);
                    result.append(tempString).append("\n");
                    ArrayList accountMapList = (ArrayList)resultMap.get(key);
                    for (int i = 0; i < accountMapList.size(); ++i) {
                        result.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CheckWorkTableNumber"), accountMapList.get(i))).append("\n");
                    }
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"isDeleteDefault"), (String)new String(result), (int)8188);
                SysUtil.abort();
            }
            super.actionRemove_actionPerformed(e);
        }
        catch (Exception e1) {
            logger.error((Object)"actionRemove_actionPerformed", (Throwable)e1);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isUnilateralReconciliation"));
        return sic;
    }

    public Object getTablePreferenceSchemaKey() {
        return ItemTypeEnum.account == this.itemTypeEnum ? null : this.itemTypeEnum;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (ItemTypeEnum.account == this.itemTypeEnum) {
            this.changeTableColHide(true);
        } else {
            this.changeTableColHide(false);
        }
    }
}

