/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountMappingF7UI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AccountMappingF7UI
extends AbstractAccountMappingF7UI
implements KDPromptSelector,
CommitListener {
    private static final long serialVersionUID = 1329487003317183111L;
    private static final Logger logger = CoreUIObject.getLogger(AccountMappingF7UI.class);
    private boolean isLoaded = false;
    private boolean isCancel = false;
    private boolean isInitMerge = false;
    private boolean isWillCommit = false;
    private AccountMapInfo accountMap = null;

    public void show() {
        this.uiWindow.show();
    }

    public void onLoad() throws Exception {
        String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        this.initCombItemType();
        this.initCombElimType(selectAll);
        this.initTable();
        super.onLoad();
        EntityViewInfo vInfo = this.getMainQuery();
        vInfo.setFilter(this.getFilter());
        this.refresh();
        this.isLoaded = true;
        this.initTxtLocation();
    }

    private EntityViewInfo getMainQuery() {
        if (this.accountMappingForF7Query == null) {
            this.accountMappingForF7Query = new EntityViewInfo();
        }
        return this.accountMappingForF7Query;
    }

    private FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        ItemTypeEnum itemType = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemType.getValue()));
        int selectedIndex = this.combElimType.getSelectedIndex();
        if (selectedIndex != 0) {
            if (selectedIndex == 1) {
                filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)1));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)3));
            }
        }
        return filter;
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"503_defaultNumber");
        this.txtFilter.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtFilter, defaultStr);
        this.txtFilter.addFocusListener((FocusListener)quickQueryHandler);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                AccountMappingF7UI.this.fillColorRows();
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && AccountMappingF7UI.this.tblMain.getSelectManager().get() != null) {
                    AccountMappingF7UI.this.doSelect();
                }
            }
        });
    }

    private void doSelect() {
        this.accountMap = this.getSelectedAccountMap();
        this.destroyWindow();
    }

    private void fillColorRows() {
        IRow row = null;
        ICell isMapAccount = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            isMapAccount = row.getCell("isMapAccount");
            if (((Boolean)isMapAccount.getValue()).booleanValue()) continue;
            row.getCell("itemNumber").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("itemName").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("dataElement").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("balType").getStyleAttributes().setBackground(new Color(240, 236, 250));
        }
    }

    private void refresh() {
        if (!this.isInitMerge) {
            this.initMerge();
        }
        this.itemTypeChange();
    }

    private void itemTypeChange() {
        ItemTypeEnum itemType = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
        if (0 == itemType.getValue()) {
            this.changeTableColHide(true);
        } else {
            this.changeTableColHide(false);
        }
    }

    private void changeTableColHide(boolean isHide) {
        this.tblMain.getColumn("dataElement").getStyleAttributes().setHided(isHide);
        this.tblMain.getColumn("balType").getStyleAttributes().setHided(!isHide);
    }

    public String[] getMergeColumnKeys() {
        ArrayList<String> mergeColumnKeys = new ArrayList<String>();
        mergeColumnKeys.add("number");
        mergeColumnKeys.add("elimType");
        mergeColumnKeys.add("remark");
        String[] columns = new String[mergeColumnKeys.size()];
        mergeColumnKeys.toArray(columns);
        return columns;
    }

    protected void initMerge() {
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setMergeable(false);
        }
        this.tblMain.getGroupManager().setGroup(true);
        String[] columns = this.getMergeColumnKeys();
        for (int i = 0; i < columns.length; ++i) {
            this.tblMain.getColumn(columns[i]).setGroup(true);
            this.tblMain.getColumn(columns[i]).setMergeable(true);
        }
        this.isInitMerge = true;
    }

    private void initCombItemType() {
        this.combItemType.addItems(ItemTypeEnum.getEnumList().toArray());
        AccountCheckUtil.initItemTypeDefaultValue(this.combItemType);
    }

    private void initCombElimType(String selectAll) {
        this.combElimType.addItem((Object)selectAll);
        this.combElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.combElimType.addItem((Object)ElimTypeEnum.exchange);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnFilter_actionPerformed(ActionEvent e) throws Exception {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"503_defaultNumber");
        String search = this.txtFilter.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblMain.getColumnIndex("number");
            CslRptUIUtil.tableMainLocate((KDTable)this.tblMain, (String)search, (int[])new int[]{colIndex1});
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.destroyWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.checkSelected(this.tblMain);
        this.accountMap = this.getSelectedAccountMap();
        this.destroyWindow();
    }

    private AccountMapInfo getSelectedAccountMap() {
        AccountMapInfo accountMap = new AccountMapInfo();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            String number = (String)this.tblMain.getRow(rowIndex).getCell("number").getValue();
            String id = (String)this.tblMain.getRow(rowIndex).getCell("id").getValue();
            BizEnumValueDTO elimType = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("elimType").getValue();
            int elimTypeValue = elimType.getInt();
            BizEnumValueDTO itemType = (BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("itemType").getValue();
            int itemTypeValue = itemType.getInt();
            accountMap.setId(BOSUuid.read((String)id));
            accountMap.setNumber(number);
            accountMap.setItemType(ItemTypeEnum.getEnum(itemTypeValue));
            accountMap.setElimType(ElimTypeEnum.getEnum((int)elimTypeValue));
        }
        return accountMap;
    }

    public void checkSelected(KDTable tbl) {
        if (tbl.getRowCount() == 0 || tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void combItemType_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        EntityViewInfo vInfo = this.getMainQuery();
        vInfo.setFilter(this.getFilter());
        this.tblMain.removeRows();
        this.itemTypeChange();
    }

    @Override
    protected void combElimType_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        EntityViewInfo vInfo = this.getMainQuery();
        vInfo.setFilter(this.getFilter());
        this.tblMain.removeRows();
    }

    public void willCommit(CommitEvent e) {
        this.isWillCommit = true;
        KDBizPromptBox pb = (KDBizPromptBox)e.getSource();
        pb.setDataBySelector();
        this.isWillCommit = false;
    }

    public boolean isCanceled() {
        return false;
    }

    public Object getData() {
        return this.accountMap;
    }
}

