/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.IAccountMap;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAccountMappingListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountMapUnDispenseUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountMappingDispenseUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountMappingEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountMappingFilterUI;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountMappingListUI
extends AbstractAccountMappingListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountMappingListUI.class);
    private boolean isConfirm = false;
    private ArrayList<String> NoCanDeleteList = null;
    private int index = 0;
    public CommonQueryDialog conditionDialog = null;
    public CustomerQueryPanel conditionPanel = null;
    ItemTypeEnum itemTypeEnum = ItemTypeEnum.account;
    protected boolean isInitMerge = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"itemTypeEnum", (Object)this.itemTypeEnum);
    }

    protected String getEditUIName() {
        return AccountMappingEditUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountMapFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                AccountMappingListUI.this.fillColorRows();
            }
        });
        super.onLoad();
        KDTMenuManager tm = this.getMenuManager(this.tblMain);
        if (tm != null) {
            KDPopupMenu pop = tm.getMenu();
            pop.getComponent(3).setVisible(false);
            pop.getComponent(4).setVisible(false);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (ItemTypeEnum.account == this.itemTypeEnum) {
            this.changeTableColHide(true);
        } else {
            this.changeTableColHide(false);
        }
    }

    private void fillColorRows() {
        IRow row = null;
        ICell isMapAccount = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            isMapAccount = row.getCell("isMapAccount");
            if (((Boolean)isMapAccount.getValue()).booleanValue()) continue;
            row.getCell("accountTableID.name").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("itemNumber").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("itemName").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("asstActTypes").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("dataElement").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("dataElementName").getStyleAttributes().setBackground(new Color(240, 236, 250));
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(false);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(true);
    }

    private void enableOrDisEnable(boolean isEnable) throws BOSException, Exception {
        this.checkSelected();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getSelectedKeyValue());
        if (!isEnable) {
            ArrayList billNumberList = ((IAccountMap)this.getBizInterface()).getBillNumber(this.getSelectedKeyValue());
            if (billNumberList.size() > 0) {
                int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
                int selectIndex = selectRows[0];
                String accountMapNumber = this.tblMain.getRow(selectIndex).getCell("number").getValue().toString();
                StringBuffer result = new StringBuffer();
                result.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"Cause")).append("\n");
                for (int i = 0; i < billNumberList.size(); ++i) {
                    result.append((String)billNumberList.get(i));
                }
                int state = MsgBox.showConfirm3a((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ExistWorkTable"), accountMapNumber), (String)result.toString());
                if (state == 2) {
                    SysUtil.abort();
                }
            }
        } else {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("number"));
            sc.add(new SelectorItemInfo("account.*"));
            sc.add(new SelectorItemInfo("isUnilateralReconciliation"));
            sc.add(new SelectorItemInfo("account.checkAccount.*"));
            BOSUuid uuid = BOSUuid.read((String)this.getSelectedKeyValue());
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            AccountMapInfo info = ((IAccountMap)this.getBizInterface()).getAccountMapInfo((IObjectPK)pk, sc);
            String existNumber = ((IAccountMap)this.getBizInterface()).getExistNumber(info.getAccount(), this.getSelectedKeyValue(), info.isIsUnilateralReconciliation(), this.itemTypeEnum);
            if (existNumber != null) {
                MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ExistNumber"), info.getNumber(), existNumber));
                SysUtil.abort();
            }
        }
        ((IAccountMap)this.getBizInterface()).enableOrDisEnable(list, isEnable);
        this.refreshList();
    }

    @Override
    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.selectItemIsFrz();
    }

    private void selectItemIsFrz() {
        boolean isFreezed = false;
        boolean isUnFreezed = false;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex;
            this.index = rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row != null) {
                Boolean bFreezed = (Boolean)row.getCell("isFree").getValue();
                if (bFreezed.booleanValue()) {
                    isUnFreezed = true;
                } else {
                    isFreezed = true;
                }
            }
        }
        this.btnCancelCancel.setEnabled(isUnFreezed);
        this.btnCancel.setEnabled(isFreezed);
        this.menuItemCancel.setEnabled(isFreezed);
        this.menuItemCancelCancel.setEnabled(isUnFreezed);
    }

    public String[] getMergeColumnKeys() {
        ArrayList<String> mergeColumnKeys = new ArrayList<String>();
        mergeColumnKeys.add("number");
        mergeColumnKeys.add("elimType");
        mergeColumnKeys.add("remark");
        mergeColumnKeys.add("isFree");
        mergeColumnKeys.add("creator.number");
        mergeColumnKeys.add("createTime");
        mergeColumnKeys.add("lastUpdateUser.number");
        mergeColumnKeys.add("lastUpdateTime");
        String[] columns = new String[mergeColumnKeys.size()];
        mergeColumnKeys.toArray(columns);
        return columns;
    }

    protected void initMerge() {
        this.tblMain.checkParsed();
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setMergeable(false);
        }
        this.tblMain.getGroupManager().setGroup(true);
        String[] columns = this.getMergeColumnKeys();
        for (int i = 0; i < columns.length; ++i) {
            this.tblMain.getColumn(columns[i]).setGroup(true);
            this.tblMain.getColumn(columns[i]).setMergeable(true);
        }
        this.isInitMerge = true;
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "accountTableID.name", "itemNumber", "itemName"};
        return locateNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            SysUtil.abort();
        }
        this.isConfirm = true;
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        try {
            Map resultMap = ((IAccountMap)this.getBizInterface()).removeOfNoQuote(list);
            this.NoCanDeleteList = (ArrayList)resultMap.get("noRemoveIDList");
            HashSet<String> norRevIds = new HashSet<String>();
            Map<String, StringBuffer> toleranceRela = this.getRelaToleranceData(list, norRevIds);
            StringBuffer result = new StringBuffer();
            if (this.NoCanDeleteList.size() > 0) {
                Iterator iter = resultMap.entrySet().iterator();
                boolean isFirst = true;
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = (String)entry.getKey();
                    if (!isFirst) {
                        result.append("\n");
                    }
                    if ("noRemoveIDList".equals(key)) continue;
                    String tempString = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"isDeleteDefaultNumber"), key);
                    result.append(tempString).append("\n");
                    ArrayList accountMapList = (ArrayList)resultMap.get(key);
                    for (int i = 0; i < accountMapList.size(); ++i) {
                        result.append(accountMapList.get(i)).append("\n");
                    }
                    isFirst = false;
                }
                if (!norRevIds.isEmpty()) {
                    this.getCheckToleranceMsg(toleranceRela, result);
                }
            } else if (this.NoCanDeleteList.isEmpty() && !norRevIds.isEmpty()) {
                this.getCheckToleranceMsg(toleranceRela, result);
            }
            Set dispenseRelIds = this.checkAccountMapDispensed(list, result);
            if (count > 1) {
                HashSet<String> cannotDelSet = new HashSet<String>();
                cannotDelSet.addAll(this.NoCanDeleteList);
                cannotDelSet.addAll(norRevIds);
                cannotDelSet.addAll(dispenseRelIds);
                if (!cannotDelSet.isEmpty()) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)(count == cannotDelSet.size() ? "AllIsDeleteDefault" : "PartIsDeleteDefault")), (String)new String(result), (int)8188);
                    if (count == cannotDelSet.size()) {
                        SysUtil.abort();
                    }
                }
            } else if (!(this.NoCanDeleteList.isEmpty() && norRevIds.isEmpty() && dispenseRelIds.isEmpty())) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"isDeleteDefault"), (String)new String(result), (int)8188);
                SysUtil.abort();
            }
            super.actionRemove_actionPerformed(e);
        }
        catch (Exception e1) {
            logger.error((Object)"actionRemove_actionPerformed", (Throwable)e1);
        }
        finally {
            this.isConfirm = false;
        }
    }

    private void getCheckToleranceMsg(Map<String, StringBuffer> toleranceRela, StringBuffer result) {
        Iterator<String> it = toleranceRela.keySet().iterator();
        String title = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"536_errTitle");
        while (it.hasNext()) {
            String key = it.next();
            String tempString = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"isDeleteDefaultNumber"), key);
            StringBuffer msg = toleranceRela.get(key);
            result.append(tempString).append(" \n").append(title).append(" \n").append(msg.toString()).append(" \n");
        }
    }

    private Map<String, StringBuffer> getRelaToleranceData(ArrayList list, Set<String> norRevIds) throws BOSException {
        HashSet mapIds = new HashSet(list);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountMap", mapIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("toleranceType", (Object)0));
        view.getSelector().add(new SelectorItemInfo("accountMap.number"));
        view.getSelector().add(new SelectorItemInfo("accountMap.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.name"));
        view.getSorter().add(new SorterItemInfo("accountMap.number"));
        view.getSorter().add(new SorterItemInfo("orgUnit.name"));
        ToleranceCollection tolerances = ToleranceFactory.getRemoteInstance().getToleranceCollection(view);
        HashMap<String, StringBuffer> result = new HashMap<String, StringBuffer>();
        StringBuffer orgNames = null;
        if (tolerances != null && !tolerances.isEmpty()) {
            Iterator it = tolerances.iterator();
            while (it.hasNext()) {
                ToleranceInfo tolerance = (ToleranceInfo)it.next();
                String mappingNumber = tolerance.getAccountMap().getNumber();
                String mapId = tolerance.getAccountMap().getId().toString();
                String orgName = tolerance.getOrgUnit().getName();
                if (result.containsKey(mappingNumber)) {
                    ((StringBuffer)result.get(mappingNumber)).append(orgName).append(" \n");
                } else {
                    orgNames = new StringBuffer();
                    orgNames.append(orgName).append(" \n");
                    result.put(mappingNumber, orgNames);
                }
                norRevIds.add(mapId);
            }
        }
        return result;
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList list = super.getSelectedIdValues();
        if (this.NoCanDeleteList != null && this.NoCanDeleteList.size() > 0) {
            for (String NoCanDeleteNumber : this.NoCanDeleteList) {
                if (!list.contains(NoCanDeleteNumber)) continue;
                list.remove(NoCanDeleteNumber);
            }
        }
        return list;
    }

    protected Set checkAccountMapDispensed(ArrayList list, StringBuffer detailMsg) throws Exception {
        HashSet<String> cantRemoveIds = new HashSet<String>();
        if (list != null && !list.isEmpty()) {
            HashSet idSet = new HashSet(list);
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add("accountMap.id");
            view.getSelector().add("accountMap.number");
            view.getSelector().add("checkageCompany.company.name");
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("accountMap.id", idSet, CompareType.INCLUDE));
            view.getSorter().add(new SorterItemInfo("accountMap.number"));
            view.getSorter().add(new SorterItemInfo("checkageCompany.company.name"));
            AccountMapDispenseCollection coll = AccountMapDispenseFactory.getRemoteInstance().getAccountMapDispenseCollection(view);
            if (coll != null && !coll.isEmpty()) {
                StringBuffer detail = null;
                HashMap<String, StringBuffer> dMap = new HashMap<String, StringBuffer>();
                for (int i = 0; i < coll.size(); ++i) {
                    AccountMapDispenseInfo info = coll.get(i);
                    String accountMapNumber = info.getAccountMap().getNumber();
                    String companyName = info.getCheckageCompany().getCompany().getName();
                    cantRemoveIds.add(info.getAccountMap().getId().toString());
                    if (dMap.containsKey(accountMapNumber)) {
                        ((StringBuffer)dMap.get(accountMapNumber)).append(companyName).append("\n");
                        continue;
                    }
                    detail = new StringBuffer();
                    detail.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"545_accountMapRelaDispense", (Object[])new Object[]{accountMapNumber})).append(" \n");
                    detail.append(companyName).append("\n");
                    dMap.put(accountMapNumber, detail);
                }
                if (!dMap.isEmpty()) {
                    for (StringBuffer msg : dMap.values()) {
                        detailMsg.append(msg).append("\n");
                    }
                }
            }
        }
        return cantRemoveIds;
    }

    protected boolean confirmRemove() {
        if (this.isConfirm) {
            return true;
        }
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected void setPreSelecteRow() {
        this.tblMain.getSelectManager().select(this.index, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(this.index);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery;
        if (!this.isInitMerge) {
            this.initMerge();
        }
        if (!this.isPerformDefaultQuery(iQuery = QuerySolutionFacadeFactory.getRemoteInstance(), queryName = AccountMappingListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            this.setDialogMainQueryCondition();
        } else {
            this.changeTable();
        }
    }

    protected void setDialogMainQueryCondition() throws Exception {
        if (this.getConditionDialog().show()) {
            this.doQuery(this.getConditionDialog());
            this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
            this.tblMain.removeRows();
            this.changeTable();
        } else {
            SysUtil.abort();
        }
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        int defaultValue = CSLParamUtil.getAccountCheckItemTypeDefaultValue(null);
        if (defaultValue != 0 && defaultValue != 1) {
            defaultValue = 1;
        }
        filter.getFilterItems().add(new FilterItemInfo("checkAccount.itemType", (Object)defaultValue));
        filter.getFilterItems().add(new FilterItemInfo("isFree", (Object)0));
        return viewInfo;
    }

    private void changeTable() {
        if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterItemCollection currentFilterItemCollection = this.mainQuery.getFilter().getFilterItems();
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                ItemTypeEnum itemTypeEnum;
                FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
                Object compareValue = filterItemInfo.getCompareValue();
                if (!"checkAccount.itemType".equals(filterItemInfo.getPropertyName())) continue;
                this.itemTypeEnum = itemTypeEnum = ItemTypeEnum.getEnum((Integer)compareValue);
                if (ItemTypeEnum.account == itemTypeEnum) {
                    this.changeTableColHide(true);
                    continue;
                }
                this.changeTableColHide(false);
            }
        }
    }

    private void changeTableColHide(boolean isHide) {
        this.tblMain.getColumn("dataElementName").getStyleAttributes().setHided(isHide);
        this.tblMain.getColumn("accountTableID.name").getStyleAttributes().setHided(!isHide);
        this.tblMain.getColumn("asstActTypes").getStyleAttributes().setHided(!isHide);
        this.tblMain.getColumn("dataElement").getStyleAttributes().setHided(!isHide);
    }

    private CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPK1 = MetaDataPK.create((String)"com.kingdee.eas.fi.newrpt.accountcheck", (String)"AccountMappingQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK1);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(280);
            this.conditionDialog.setHeight(240);
            this.conditionDialog.setTitle(AccountCheckUtil.getResourceString(null, "accountMapFilterTitle", null));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.newrpt.accountcheck.client.AccountMappingListUI");
        }
        return this.conditionDialog;
    }

    private CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new AccountMappingFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    protected void doDefaultSolution(IQuerySolutionFacade iQuery, String queryName) throws Exception {
        super.doDefaultSolution(iQuery, queryName);
        String queryString = this.getCurrentSolutionInfo().getEntityViewInfo();
        if (queryString != null) {
            EntityViewInfo newView = new EntityViewInfo();
            FilterInfo newFilter = new FilterInfo();
            newView.setFilter(newFilter);
            EntityViewInfo defaultView = new EntityViewInfo(queryString);
            FilterInfo filter = defaultView.getFilter();
            FilterItemCollection filterItems = filter.getFilterItems();
            if (filterItems != null && !filterItems.isEmpty()) {
                int size = filterItems.size();
                for (int i = 0; i < size; ++i) {
                    FilterItemInfo filterItemInfo = filterItems.get(i);
                    String propertyName = filterItemInfo.getPropertyName();
                    if ("checkAccount.accountDC".equals(propertyName)) {
                        newFilter.getFilterItems().add(new FilterItemInfo("checkAccount.itemDC", filterItemInfo.getCompareValue()));
                        continue;
                    }
                    if ("checkAccount.accountName".equals(propertyName)) {
                        newFilter.getFilterItems().add(new FilterItemInfo("checkAccount.itemName", filterItemInfo.getCompareValue()));
                        continue;
                    }
                    if ("checkAccount.accountNumber".equals(propertyName)) {
                        newFilter.getFilterItems().add(new FilterItemInfo("checkAccount.itemNumber", filterItemInfo.getCompareValue()));
                        continue;
                    }
                    newFilter.getFilterItems().add(filterItemInfo);
                }
            }
            this.getCurrentSolutionInfo().setEntityViewInfo(newView.toString());
        }
    }

    public Object getTablePreferenceSchemaKey() {
        return ItemTypeEnum.account == this.itemTypeEnum ? null : this.itemTypeEnum;
    }

    protected ArrayList getExportParam() {
        String solutionName = "eas.fi.gr.ppAccountMap";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = AccountCheckUtil.getResourceString(null, "accountMap_import_title", null);
        param.datataskMode = 1;
        EntityViewInfo mainQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)(ItemTypeEnum.account == this.itemTypeEnum ? ItemTypeEnum.account.getValue() : ItemTypeEnum.rptItem.getValue())));
        mainQuery.setFilter(filter);
        param.putContextParam((Object)"mainQuery", (Object)mainQuery);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountMapForExportQuery"));
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.importData();
    }

    @Override
    public void actionDispense_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = super.getSelectedIdValues();
        if (list != null && !list.isEmpty()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"accountMappingIds", (Object)list);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountMappingDispenseUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            window.show();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
        }
    }

    @Override
    public void actionUnDispense_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = super.getSelectedIdValues();
        if (list != null && !list.isEmpty()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"accountMappingIds", (Object)list);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountMapUnDispenseUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            ((UIModelDialog)window).setPreferredSize(new Dimension(1090, 800));
            window.show();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
        }
    }

    private void importData() throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        ArrayList importParam = this.getImportParam();
        if (importParam != null) {
            task.invoke(importParam, 0);
        }
    }

    protected ArrayList getImportParam() {
        String solutionName = "eas.fi.gr.pp.ppAccountMap";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = AccountCheckUtil.getResourceString(null, "accountMap_import_title", null);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

