/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.KDTableUtilForRpt;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.ShowUIMessageAction;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAutoCheckSchmListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AutoCheckSchmEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AutoCheckSchmLogUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AutoCheckSchmSetTimeDispatchUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ImmediateExecutionUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class AutoCheckSchmListUI
extends AbstractAutoCheckSchmListUI {
    private static final long serialVersionUID = 1560856348092348635L;
    private static final Logger logger = CoreUIObject.getLogger(AutoCheckSchmListUI.class);
    protected transient ShowUIMessageAction showMessageHandler = new ShowUIMessageAction((CoreUI)this);
    private static final String ACTION_TRANSATIONSTATUSREPAIR_WINDOW = "transactionStatusRepair_window";
    private int index = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.addDataRepairWindowKeyListener();
    }

    protected String getEditUIName() {
        return AutoCheckSchmEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoCheckSchmFactory.getRemoteInstance();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name"};
        return locateNames;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
    }

    @Override
    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        block6: {
            boolean isFreezed = false;
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (selectRows != null && selectRows.length > 0) {
                IRow row = this.tblMain.getRow(selectRows[0]);
                this.index = selectRows[0];
                String id = null;
                if (row != null) {
                    isFreezed = (Boolean)row.getCell("isFreezed").getValue();
                    id = (String)row.getCell("id").getValue();
                }
                this.actionEdit.setEnabled(isFreezed);
                this.actionCancelCancel.setEnabled(isFreezed);
                this.actionCancel.setEnabled(!isFreezed);
                this.actionRemove.setEnabled(isFreezed);
                this.actionStartExecute.setEnabled(!isFreezed);
                this.actionStopExecute.setEnabled(!isFreezed);
                try {
                    if (AutoCheckSchmFactory.getRemoteInstance().isRunningAutoCheckSchm(id)) {
                        this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.SHOW_MSG_EXECUTING"), false, true);
                        break block6;
                    }
                    this.showMessageHandler.showMessage("", false, false);
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            } else {
                this.actionCancelCancel.setEnabled(false);
                this.actionCancel.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionStartExecute.setEnabled(false);
                this.actionStopExecute.setEnabled(!isFreezed);
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(false);
        this.refresh(e);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(true);
        this.refresh(e);
    }

    private void enableOrDisEnable(boolean isEnable) throws BOSException, Exception {
        int result;
        this.checkSelected();
        if (!isEnable && (result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"IsConfirmEnable"))) != 0) {
            SysUtil.abort();
        }
        AutoCheckSchmFactory.getRemoteInstance().enable(this.getSelectedKeyValue(), isEnable);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(selectRows[0]);
        if (row != null) {
            row.getCell("isFreezed").setValue((Object)(!isEnable ? 1 : 0));
        }
        this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)(isEnable ? "WARN_ENABLE_SUCCESS" : "WARN_CANCEL_SUCCESS")), true, true);
    }

    private void initMainQuery() {
        FilterInfo filterInfo = this.getMainQuery().getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        } else {
            filterInfo.getFilterItems().clear();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("creatOrgUnit.id", (Object)SysContext.getSysContext().getCurrentOrgUnit().getId().toString(), CompareType.EQUALS));
        this.getMainQuery().setFilter(filterInfo);
        this.mainQuery = this.getMainQuery();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.initMainQuery();
        super.actionQuery_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    @Override
    public void actionDispatchSetting_actionPerformed(ActionEvent e) throws Exception {
        super.actionDispatchSetting_actionPerformed(e);
        this.checkSelected();
        String schmId = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)schmId);
        uiContext.put((Object)"schmId", (Object)schmId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AutoCheckSchmSetTimeDispatchUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionRemoveSchedule_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveSchedule_actionPerformed(e);
        this.checkSelected();
        String schmId = this.getSelectedKeyValue();
        AutoCheckSchmInfo schmInfo = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmInfo("select id,jobProcessDef where id = '" + schmId + "'");
        String jobProcessDefid = schmInfo.getJobProcessDef();
        if (!StringUtils.isEmpty((String)jobProcessDefid)) {
            EnactmentServiceFactory.createRemoteEnactService().removeJobProcessDef(jobProcessDefid);
            schmInfo.setJobProcessDef(null);
            schmInfo.setIsAutoDispatch(false);
            SelectorItemCollection itemColl = new SelectorItemCollection();
            itemColl.add(new SelectorItemInfo("jobProcessDef"));
            itemColl.add(new SelectorItemInfo("isAutoDispatch"));
            AutoCheckSchmFactory.getRemoteInstance().updatePartial(schmInfo, itemColl);
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"removeScheduleSuccess"), true, true);
        } else {
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"noSchedule"), true, true);
        }
        this.refresh(e);
    }

    private void addDataRepairWindowKeyListener() {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(84, 11);
            inputMap.put(keyStroke, ACTION_TRANSATIONSTATUSREPAIR_WINDOW);
            actionMap.remove(ACTION_TRANSATIONSTATUSREPAIR_WINDOW);
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoCheckSchmListUI.this.transationStatusRepair();
                }
            };
            actionMap.put(ACTION_TRANSATIONSTATUSREPAIR_WINDOW, action);
        }
    }

    private void transationStatusRepair() {
        this.checkSelected();
        String schmId = this.getSelectedKeyValue();
        try {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.confirmRepairTransationStatus"));
            if (result == 0) {
                boolean isSuccess = AutoCheckSchmFactory.getRemoteInstance().repairTransationStatus(schmId);
                if (isSuccess) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.repairSuccess"));
                    return;
                }
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.repairFail"));
                return;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"transationStatusRepair---------", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"transationStatusRepair---------", (Throwable)e);
        }
    }

    @Override
    public void actionStartExecute_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartExecute_actionPerformed(e);
        this.checkSelected();
        String schmId = this.getSelectedKeyValue();
        BOSUuid bosUuid = BOSUuid.read((String)schmId);
        try {
            MutexUtil.checkMutex((String)"SchmEdit", (BOSUuid)bosUuid, (String)"ActionEdit");
        }
        catch (MutexException ex) {
            logger.warn((Object)"", (Throwable)ex);
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"NET_MUTEX_CANNOT_EXE_WHEN_EDIT"), true, true);
            return;
        }
        UIContext uiContext = new UIContext();
        AutoCheckSchmInfo schmInfo = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmInfo("select * where id = '" + schmId + "'");
        uiContext.put((Object)"schm", (Object)schmInfo);
        uiContext.put((Object)"showMessageHandler", (Object)this.showMessageHandler);
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ImmediateExecutionUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        curUIWindow.show();
    }

    @Override
    public void actionStopExecute_actionPerformed(ActionEvent e) throws Exception {
        super.actionStopExecute_actionPerformed(e);
        this.checkSelected();
        String isFreezed = KDTableUtilForRpt.getSelectedFieldValueBy((KDTable)this.tblMain, (String)"isFreezed");
        if (Boolean.TRUE.toString().equals(isFreezed)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.WARN_CANNOT_STOP_FOR_CANCEL"));
            return;
        }
        String schmId = this.getSelectedKeyValue();
        Map resutlMap = AutoCheckSchmFactory.getRemoteInstance().abortAutoCheckSchmTask(schmId);
        if ("IsNoExceute".equals(resutlMap.get("IsSuccess"))) {
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Rpt_Weave_Scheme_NoRun"), true, true);
        } else if ("true".equals(resutlMap.get("IsSuccess"))) {
            this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Abort_Task_IsSuccess"), true, true);
        } else {
            List cannotAbortJobList = (List)resutlMap.get("cannotAbortJobList");
            List canAbortJobList = (List)resutlMap.get("canAbortJobList");
            int cannotAbortSize = 0;
            int canAbortSize = 0;
            if (cannotAbortJobList != null && cannotAbortJobList.size() > 0) {
                cannotAbortSize = cannotAbortJobList.size();
            }
            if (canAbortJobList != null && canAbortJobList.size() > 0) {
                canAbortSize = canAbortJobList.size();
            }
            int totle = cannotAbortSize + canAbortSize;
            if (canAbortSize > 0) {
                this.showMessageHandler.showMessage(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Abort_Task_Msg"), new Integer(totle), new Integer(canAbortSize)), true, true);
            } else {
                this.showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Abort_Task_IsError"), true, true);
            }
        }
    }

    @Override
    public void actionExecuteReport_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String schmId = KDTableUtilForRpt.getSelectedFieldValueBy((KDTable)this.tblMain, (String)"id");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"schmId", (Object)schmId);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(AutoCheckSchmLogUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (Exception ee) {
            this.actionRefresh_actionPerformed(null);
            throw ee;
        }
    }

    protected void setMessageBarText(String msg) {
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected void setPreSelecteRow() {
        this.tblMain.getSelectManager().select(this.index, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(this.index);
    }

    protected void Remove() throws Exception {
        String id = this.getSelectedKeyValue();
        BOSUuid uuid = BOSUuid.read((String)id);
        ObjectUuidPK pk = new ObjectUuidPK(uuid);
        if (!AutoCheckSchmFactory.getRemoteInstance().exists((IObjectPK)pk)) {
            this.refresh(new ActionEvent((Object)this, 1, "Remove"));
            SysUtil.abort();
        }
        super.Remove();
    }
}

