/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CompareCharEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAutoCheckSchmLogFilterUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.CheckageCompanyF7UI;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ComboBoxModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class AutoCheckSchmLogFilterUI
extends AbstractAutoCheckSchmLogFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoCheckSchmLogFilterUI.class);
    TreeMap<Integer, List<Integer>> yearMap = new TreeMap();
    Map<String, AutoCheckSchmLogInfo> cacheSchmLogMap = new HashMap<String, AutoCheckSchmLogInfo>();
    Map<String, AutoCheckSchmInfo> cacheSchmMap = new HashMap<String, AutoCheckSchmInfo>();
    private Set selectedCompanyIds = new HashSet();
    private Set selectedOrgUnitIds = new HashSet();
    protected OrgTreeCollection orgTreeColl = null;
    protected UnionF7Helper.UnionF7 unitF7;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblCompany.checkParsed();
        this.tblOrgUnit.checkParsed();
        this.tblCompany.getStyleAttributes().setLocked(true);
        this.tblOrgUnit.getStyleAttributes().setLocked(true);
        this.tblCompany.getSelectManager().setSelectMode(10);
        this.tblOrgUnit.getSelectManager().setSelectMode(10);
        this.initComp();
        this.initMyListener();
    }

    protected void initMyListener() {
        this.schm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    AutoCheckSchmLogFilterUI.this.changeSchm((AutoCheckSchmInfo)AutoCheckSchmLogFilterUI.this.schm.getSelectedItem());
                }
                catch (Exception e1) {
                    logger.error((Object)"schm_change_error", (Throwable)e1);
                }
            }
        });
        this.diffType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem = AutoCheckSchmLogFilterUI.this.diffType.getSelectedItem();
                if ("".equals(selectedItem)) {
                    AutoCheckSchmLogFilterUI.this.diffAmount.setEnabled(false);
                    AutoCheckSchmLogFilterUI.this.diffAmount.setValue(null);
                } else {
                    AutoCheckSchmLogFilterUI.this.diffAmount.setEnabled(true);
                }
            }
        });
        this.periodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AutoCheckSchmLogFilterUI.this.updateYearAndPeriod();
                }
            }
        });
    }

    private void updateYearAndPeriod() {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.periodType.getSelectedItem();
        if (periodTypeEnum == null) {
            return;
        }
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 13, 1));
        } else if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 4, 1));
        } else if (RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 2, 1));
        } else if (RptPeriodTypeEnum.YEARLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 1, 1));
        }
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    private void initComp() throws EASBizException, BOSException {
        String schmId = (String)this.getUIContext().get("schmId");
        AutoCheckSchmInfo selectSchmInfo = null;
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        String creatOrgUnitIDStr = "";
        creatOrgUnitIDStr = currentFIUnit != null ? currentFIUnit.getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
        AutoCheckSchmCollection autoCheckSchmCollection = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmCollection("select id,name where creatOrgUnit='" + creatOrgUnitIDStr + "'");
        if (autoCheckSchmCollection != null && !autoCheckSchmCollection.isEmpty()) {
            for (int i = 0; i < autoCheckSchmCollection.size(); ++i) {
                AutoCheckSchmInfo autoCheckSchmInfo = autoCheckSchmCollection.get(i);
                this.schm.addItem((Object)autoCheckSchmInfo);
                if (selectSchmInfo != null || !autoCheckSchmInfo.getId().toString().equals(schmId)) continue;
                selectSchmInfo = autoCheckSchmInfo;
            }
        }
        if (selectSchmInfo != null) {
            this.schm.setSelectedItem(selectSchmInfo, false);
        }
        this.periodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.SEMIYEARLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.YEARLY);
        CurrencyInfo currCurrency = RptNewUIUtil.getCompanyBasicCurrency(OrgType.Company, currentFIUnit.getId().toString());
        this.currency.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC()));
        this.currency.setSelectedItem((Object)currCurrency, false);
        PeriodCollection currentNodePeriodCollection = InitDataFacadaFactory.getRemoteInstance().getFiscal((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)currentFIUnit.getId().toString())));
        if (currentNodePeriodCollection != null && currentNodePeriodCollection.size() > 0) {
            for (int i = 0; i < currentNodePeriodCollection.size(); ++i) {
                Integer year = currentNodePeriodCollection.get(i).getPeriodYear();
                Integer period = currentNodePeriodCollection.get(i).getPeriodNumber();
                List<Integer> periodVec = this.yearMap.get(year);
                if (periodVec == null) {
                    periodVec = new ArrayList<Integer>(12);
                    this.yearMap.put(year, periodVec);
                }
                periodVec.add(period);
            }
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"FiscalPeriodIsNotExist"));
            SysUtil.abort();
        }
        int[] yearPeriod = this.reviseYearPeriod(currentFIUnit);
        CslRptUIUtil.setSpineRange((KDSpinner)this.year, (int)0, (int)9999, (boolean)true, (boolean)true);
        this.year.setValue((Object)yearPeriod[0], false);
        CslRptUIUtil.setSpineRange((KDSpinner)this.period, (int)1, (int)13, (boolean)true, (boolean)true);
        this.period.setValue((Object)yearPeriod[1], false);
        List CompareCharList = CompareCharEnum.getEnumList();
        this.diffType.addItem((Object)"");
        for (int i = 0; i < CompareCharList.size(); ++i) {
            this.diffType.addItem(CompareCharList.get(i));
        }
        this.diffAmount.setPrecision(6);
        this.diffAmount.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        this.diffAmount.setMinimumValue((Comparable)new BigDecimal("-999999999999999.999999"));
        this.diffAmount.setEnabled(false);
    }

    private int[] reviseYearPeriod(CompanyOrgUnitInfo currentFIUnit) {
        Integer[] years;
        int[] yearPeriod = RptNewUIUtil.getFICurrPeriod(currentFIUnit);
        int n = yearPeriod[0] > (years = this.getYearScope())[1] ? years[1] : (yearPeriod[0] < years[0] ? years[0] : yearPeriod[0]);
        yearPeriod[0] = n;
        return yearPeriod;
    }

    private void changeSchm(AutoCheckSchmInfo selectSchmInfo) throws EASBizException, BOSException {
        AutoCheckSchmInfo schmInfo;
        AutoCheckSchmLogInfo autoCheckSchmLogInfo;
        String selectSchmId = selectSchmInfo.getId().toString();
        if (!this.cacheSchmLogMap.containsKey(selectSchmId)) {
            autoCheckSchmLogInfo = AutoCheckSchmLogFactory.getRemoteInstance().getLastValue(selectSchmId);
            this.cacheSchmLogMap.put(selectSchmId, autoCheckSchmLogInfo);
        } else {
            autoCheckSchmLogInfo = this.cacheSchmLogMap.get(selectSchmId);
        }
        if (autoCheckSchmLogInfo != null) {
            this.currency.setSelectedItem((Object)autoCheckSchmLogInfo.getCurrency());
            this.periodType.setSelectedItem((Object)autoCheckSchmLogInfo.getPeriodType());
            this.year.setValue((Object)autoCheckSchmLogInfo.getYear());
            this.period.setValue((Object)autoCheckSchmLogInfo.getPeriod());
        }
        if (!this.cacheSchmMap.containsKey(selectSchmId)) {
            schmInfo = new AutoCheckSchmInfo();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scheme", (Object)selectSchmId));
            view.setFilter(filter);
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("seq"));
            view.setSorter(sort);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("seq"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.code"));
            view.setSelector(sic);
            AutoCheckSchmCompEntryCollection autoCheckSchmCompEntryCollection = AutoCheckSchmCompEntryFactory.getRemoteInstance().getAutoCheckSchmCompEntryCollection(view);
            if (autoCheckSchmCompEntryCollection != null && !autoCheckSchmCompEntryCollection.isEmpty()) {
                AutoCheckSchmCompEntryCollection companyEntries = schmInfo.getCompanyEntries();
                for (int i = 0; i < autoCheckSchmCompEntryCollection.size(); ++i) {
                    companyEntries.add(autoCheckSchmCompEntryCollection.get(i));
                }
            }
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("seq"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.code"));
            view.setSelector(sic);
            AutoCheckSchmUnitEntryCollection autoCheckSchmUnitEntryCollection = AutoCheckSchmUnitEntryFactory.getRemoteInstance().getAutoCheckSchmUnitEntryCollection(view);
            if (autoCheckSchmUnitEntryCollection != null && !autoCheckSchmUnitEntryCollection.isEmpty()) {
                AutoCheckSchmUnitEntryCollection orgUnitEntries = schmInfo.getOrgUnitEntries();
                for (int i = 0; i < autoCheckSchmUnitEntryCollection.size(); ++i) {
                    orgUnitEntries.add(autoCheckSchmUnitEntryCollection.get(i));
                }
            }
            this.cacheSchmMap.put(selectSchmId, schmInfo);
        } else {
            schmInfo = this.cacheSchmMap.get(selectSchmId);
        }
        if (schmInfo != null) {
            this.tblCompany.removeRows();
            this.selectedCompanyIds.clear();
            AutoCheckSchmCompEntryCollection companyEntries = schmInfo.getCompanyEntries();
            if (companyEntries != null && !companyEntries.isEmpty()) {
                for (int i = 0; i < companyEntries.size(); ++i) {
                    AutoCheckSchmCompEntryInfo autoCheckSchmCompEntryInfo = companyEntries.get(i);
                    String companyId = autoCheckSchmCompEntryInfo.getCompany().getId().toString();
                    IRow addRow = this.tblCompany.addRow();
                    addRow.getCell("id").setValue((Object)companyId);
                    addRow.getCell("companyName").setValue((Object)autoCheckSchmCompEntryInfo.getCompany().getName());
                    addRow.getCell("companyNumber").setValue((Object)autoCheckSchmCompEntryInfo.getCompany().getNumber());
                    addRow.getCell("code").setValue((Object)autoCheckSchmCompEntryInfo.getCompany().getCode());
                    this.selectedCompanyIds.add(companyId);
                }
            }
            AutoCheckSchmUnitEntryCollection orgUnitEntries = schmInfo.getOrgUnitEntries();
            this.tblOrgUnit.removeRows();
            this.tblOrgUnit.setUserObject(null);
            this.selectedOrgUnitIds.clear();
            if (orgUnitEntries != null && !orgUnitEntries.isEmpty()) {
                AutoCheckSchmInfo autoCheckSchmInfo = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmInfo("select id,orgTree where id='" + selectSchmId + "'");
                this.tblOrgUnit.setUserObject((Object)autoCheckSchmInfo.getOrgTree());
                for (int i = 0; i < orgUnitEntries.size(); ++i) {
                    AutoCheckSchmUnitEntryInfo autoCheckSchmUnitEntryInfo = orgUnitEntries.get(i);
                    String orgUnitId = autoCheckSchmUnitEntryInfo.getOrgUnit().getId().toString();
                    IRow addRow = this.tblOrgUnit.addRow();
                    addRow.getCell("id").setValue((Object)orgUnitId);
                    addRow.getCell("orgUnitName").setValue((Object)autoCheckSchmUnitEntryInfo.getOrgUnit().getName());
                    addRow.getCell("orgUnitNumber").setValue((Object)autoCheckSchmUnitEntryInfo.getOrgUnit().getNumber());
                    this.selectedOrgUnitIds.add(orgUnitId);
                }
            }
        }
    }

    private Integer[] getYearScope() {
        Object[] array = this.yearMap.keySet().toArray();
        if (array == null || array.length == 0) {
            return new Integer[]{0, 0};
        }
        Arrays.sort(array);
        return new Integer[]{(Integer)array[0], (Integer)array[array.length - 1]};
    }

    public boolean verify() {
        if (this.schm.getItemCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"88_AutoCheckSchmLogFilterUI"));
            return false;
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        int i;
        CurrencyInfo currCurrency;
        RptPeriodTypeEnum typeEnum;
        int autoCheckStatusIndex;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuilder sbFormula = new StringBuilder();
        AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)this.schm.getSelectedItem();
        if (autoCheckSchmInfo != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("schm", (Object)autoCheckSchmInfo.getId().toString()));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if ((autoCheckStatusIndex = this.autoCheckStatus.getSelectedIndex()) != -1) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("autoCheckStatus", (Object)autoCheckStatusIndex));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if ((typeEnum = (RptPeriodTypeEnum)this.periodType.getSelectedItem()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)typeEnum.getValue()));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if ((currCurrency = (CurrencyInfo)this.currency.getSelectedItem()) != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)currCurrency.getId().toString()));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        this.filterInfo.getFilterItems().add(new FilterItemInfo("year", (Object)this.year.getIntegerVlaue()));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        this.filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)this.period.getIntegerVlaue()));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        Object diffTypeItem = this.diffType.getSelectedItem();
        if (diffTypeItem != null && !"".equals(diffTypeItem)) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("diffType", (Object)((CompareCharEnum)((Object)diffTypeItem)).getValue()));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
            if (this.diffAmount.getBigDecimalValue() != null) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("diffAmount", (Object)this.diffAmount.getBigDecimalValue()));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
            }
        }
        if (this.tblCompany.getRowCount() > 0) {
            HashSet<Object> companySet = new HashSet<Object>();
            for (i = 0; i < this.tblCompany.getRowCount(); ++i) {
                companySet.add(this.tblCompany.getRow(i).getCell("id").getValue());
            }
            this.filterInfo.getFilterItems().add(new FilterItemInfo("tblCompany", companySet, CompareType.INCLUDE));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if (this.tblOrgUnit.getRowCount() > 0) {
            HashSet<Object> orgUnitSet = new HashSet<Object>();
            for (i = 0; i < this.tblOrgUnit.getRowCount(); ++i) {
                orgUnitSet.add(this.tblOrgUnit.getRow(i).getCell("id").getValue());
            }
            this.filterInfo.getFilterItems().add(new FilterItemInfo("tblOrgUnit", orgUnitSet, CompareType.INCLUDE));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
        }
        if (sbFormula.length() > 0) {
            int index = sbFormula.lastIndexOf(" and ");
            this.filterInfo.setMaskString(sbFormula.substring(0, index).toString());
        } else if (this.filterInfo.containsKey("maskString")) {
            this.filterInfo.remove("maskString");
        }
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            int x;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            Object compareValue = filterItemInfo.getCompareValue();
            if ("schm".equals(propertyName)) {
                try {
                    AutoCheckSchmCollection autoCheckSchmCollection = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmCollection("select id,name,orgTree where id='" + compareValue + "'");
                    if (autoCheckSchmCollection == null || autoCheckSchmCollection.isEmpty()) continue;
                    this.schm.setSelectedItem((Object)autoCheckSchmCollection.get(0));
                    this.tblOrgUnit.setUserObject((Object)autoCheckSchmCollection.get(0).getOrgTree());
                }
                catch (Exception e) {
                    logger.error((Object)"loadData_autoCheckSchmCollection_error", (Throwable)e);
                }
                continue;
            }
            if ("autoCheckStatus".equals(propertyName)) {
                this.autoCheckStatus.setSelectedIndex(((Integer)compareValue).intValue());
                continue;
            }
            if ("periodType".equals(propertyName)) {
                this.periodType.setSelectedItem((Object)RptPeriodTypeEnum.getEnum((int)((Integer)compareValue)));
                continue;
            }
            if ("currency".equals(propertyName)) {
                try {
                    CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select id,number,name,precision where id='" + compareValue + "'");
                    if (currencyCollection == null || currencyCollection.isEmpty()) continue;
                    this.currency.setSelectedItem((Object)currencyCollection.get(0));
                }
                catch (Exception e) {
                    logger.error((Object)"loadData_getCurrencyCollection_error", (Throwable)e);
                }
                continue;
            }
            if ("year".equals(propertyName)) {
                this.year.setValue(compareValue);
                continue;
            }
            if ("period".equals(propertyName)) {
                this.period.setValue(compareValue);
                continue;
            }
            if ("diffType".equals(propertyName)) {
                this.diffType.setSelectedItem((Object)CompareCharEnum.getEnum((String)compareValue));
                continue;
            }
            if ("diffAmount".equals(propertyName)) {
                this.diffAmount.setValue(compareValue);
                continue;
            }
            if ("tblCompany".equals(propertyName)) {
                this.tblCompany.removeRows();
                this.selectedCompanyIds.clear();
                Set tblCompanySet = (Set)compareValue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                view.setFilter(filterInfo);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("code"));
                view.setSelector(sic);
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)tblCompanySet, CompareType.INCLUDE));
                try {
                    CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                    if (companyOrgUnitCollection == null || companyOrgUnitCollection.isEmpty()) continue;
                    for (x = 0; x < companyOrgUnitCollection.size(); ++x) {
                        CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(x);
                        this.selectedCompanyIds.add(companyOrgUnitInfo.getId().toString());
                        IRow addRow = this.tblCompany.addRow();
                        addRow.getCell("id").setValue((Object)companyOrgUnitInfo.getId().toString());
                        addRow.getCell("companyName").setValue((Object)companyOrgUnitInfo.getName());
                        addRow.getCell("companyNumber").setValue((Object)companyOrgUnitInfo.getNumber());
                        addRow.getCell("code").setValue((Object)companyOrgUnitInfo.getCode());
                    }
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)"loadData_getCompanyOrgUnitCollection_error", (Throwable)e);
                    continue;
                }
            }
            if (!"tblOrgUnit".equals(propertyName)) continue;
            this.tblOrgUnit.removeRows();
            this.selectedOrgUnitIds.clear();
            Set tblOrgUnitSet = (Set)compareValue;
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo filterInfo2 = new FilterInfo();
            view2.setFilter(filterInfo2);
            SelectorItemCollection sic2 = new SelectorItemCollection();
            sic2.add(new SelectorItemInfo("id"));
            sic2.add(new SelectorItemInfo("name"));
            sic2.add(new SelectorItemInfo("number"));
            view2.setSelector(sic2);
            filterInfo2.getFilterItems().add(new FilterItemInfo("id", (Object)tblOrgUnitSet, CompareType.INCLUDE));
            try {
                FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view2);
                if (fullOrgUnitCollection == null || fullOrgUnitCollection.isEmpty()) continue;
                for (x = 0; x < fullOrgUnitCollection.size(); ++x) {
                    FullOrgUnitInfo orgUnitInfo = fullOrgUnitCollection.get(x);
                    this.selectedOrgUnitIds.add(orgUnitInfo.getId().toString());
                    IRow addRow2 = this.tblOrgUnit.addRow();
                    addRow2.getCell("id").setValue((Object)orgUnitInfo.getId().toString());
                    addRow2.getCell("orgUnitName").setValue((Object)orgUnitInfo.getName());
                    addRow2.getCell("orgUnitNumber").setValue((Object)orgUnitInfo.getNumber());
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"loadData_getFullOrgUnitCollection_error", (Throwable)e);
            }
        }
    }

    public void clear() {
        this.schm.setSelectedIndex(0);
        this.autoCheckStatus.setSelectedIndex(0);
        this.periodType.setSelectedIndex(0);
        this.currency.setSelectedIndex(0);
        this.diffType.setSelectedIndex(0);
        this.diffAmount.setValue(null);
        this.diffAmount.setEnabled(false);
        try {
            this.changeSchm((AutoCheckSchmInfo)this.schm.getSelectedItem());
        }
        catch (Exception e) {
            logger.error((Object)"clear_error", (Throwable)e);
        }
    }

    @Override
    protected void addCompany_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.selectedCompanyIds != null && !this.selectedCompanyIds.isEmpty()) {
            HashSet selectCompanySet = new HashSet();
            selectCompanySet.addAll(this.selectedCompanyIds);
            uiContext.put((Object)"selectedOrgIds", selectCompanySet);
        }
        uiContext.put((Object)"UITitle", (Object)AccountCheckUtil.getResourceString(null, "AccountCheckImportReportCompanyF7", null));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CheckageCompanyF7UI.class.getName(), (Map)uiContext);
        CheckageCompanyF7UI f7ui = (CheckageCompanyF7UI)uiWindow.getUIObject();
        f7ui.getUIWindow().show();
        if (!f7ui.isCancel()) {
            this.tblCompany.removeRows();
            this.selectedCompanyIds.clear();
            Collection returnValue = f7ui.getReturnValue();
            if (returnValue != null && !returnValue.isEmpty()) {
                for (CompanyOrgUnitInfo companyInfo : returnValue) {
                    this.selectedCompanyIds.add(companyInfo.getId().toString());
                    IRow addRow = this.tblCompany.addRow();
                    addRow.getCell("id").setValue((Object)companyInfo.getId().toString());
                    addRow.getCell("companyName").setValue((Object)companyInfo.getName());
                    addRow.getCell("companyNumber").setValue((Object)companyInfo.getNumber());
                    addRow.getCell("code").setValue((Object)companyInfo.getCode());
                }
            }
        }
    }

    @Override
    protected void removeCompany_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblCompany);
        Arrays.sort(selectRows);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.selectedCompanyIds.remove(this.tblCompany.getRow(selectRows[i]).getCell("id").getValue());
            this.tblCompany.removeRow(selectRows[i]);
        }
    }

    @Override
    protected void addOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        OrgTreeInfo selectedtree = (OrgTreeInfo)this.tblOrgUnit.getUserObject();
        HashSet selectOrgUnitSet = new HashSet();
        if (this.selectedOrgUnitIds != null && !this.selectedOrgUnitIds.isEmpty()) {
            selectOrgUnitSet.addAll(this.selectedOrgUnitIds);
        }
        if (this.orgTreeColl == null) {
            this.orgTreeColl = CslRptUIUtil.getOrgTreeCollection();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.orgTreeColl.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(this.orgTreeColl.get(i).getId().toString()).append("'");
            }
            sb.insert(0, "select id,startDate,endDate,name,number,type,status,isVersioned where id in(").append(") and startDate is not null and isForBudget<>1 ");
            sb.append(" and (isHide<>1 or isHide is null ) and layerType=").append(1).append("  order by number asc,startDate desc ");
            this.orgTreeColl = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(sb.toString());
        }
        if (this.unitF7 == null) {
            this.unitF7 = new UnionF7Helper.UnionF7((IUIObject)this, 2);
            this.unitF7.setOrgTrees(this.orgTreeColl);
            this.unitF7.setMultiSelect(true);
            this.unitF7.setTreeChangeRemoveSeletedOrgs(true);
            this.unitF7.setSupportShowArchiveOrgTree(true);
        }
        if (selectedtree != null && this.unitF7.getPreOrgTreeInfo() == null) {
            String seletedTreeId = selectedtree.getId().toString();
            if (this.orgTreeColl != null && this.orgTreeColl.size() > 0) {
                OrgTreeInfo selectOrgTreeInfo = null;
                for (int i = 0; i < this.orgTreeColl.size(); ++i) {
                    OrgTreeInfo orgTreeInfo = this.orgTreeColl.get(i);
                    if (!seletedTreeId.equals(orgTreeInfo.getId().toString())) continue;
                    selectOrgTreeInfo = orgTreeInfo;
                    break;
                }
                if (selectOrgTreeInfo != null) {
                    this.unitF7.setPreOrgTreeInfo(selectOrgTreeInfo);
                }
            }
        }
        if (selectOrgUnitSet.size() > 0) {
            this.unitF7.setSelectedOrgIds(selectOrgUnitSet);
        }
        this.unitF7.show();
        if (!this.unitF7.isCanceled()) {
            OrgUnitInfo[] orgArray = (OrgUnitInfo[])this.unitF7.getData();
            OrgTreeInfo orgTree = this.unitF7.getSelectedOrgTree();
            this.unitF7.setPreOrgTreeInfo(orgTree);
            this.tblOrgUnit.removeRows();
            this.tblOrgUnit.setUserObject(null);
            this.selectedOrgUnitIds.clear();
            if (orgTree != null) {
                this.tblOrgUnit.setUserObject((Object)orgTree);
            }
            for (OrgUnitInfo orgUnit : orgArray) {
                this.selectedOrgUnitIds.add(orgUnit.getId().toString());
                IRow row = this.tblOrgUnit.addRow();
                row.getCell("id").setValue((Object)orgUnit.getId().toString());
                row.getCell("orgUnitName").setValue((Object)orgUnit.getName());
                row.getCell("orgUnitNumber").setValue((Object)orgUnit.getNumber());
            }
        }
    }

    @Override
    protected void removeOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblOrgUnit);
        Arrays.sort(selectRows);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.selectedOrgUnitIds.remove(this.tblOrgUnit.getRow(selectRows[i]).getCell("id").getValue());
            this.tblOrgUnit.removeRow(selectRows[i]);
        }
    }
}

