/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationListUI;
import com.kingdee.eas.fi.gr.cslrpt.util.CslOrgTreeUtil;
import com.kingdee.eas.fi.gr.fast.MergeReportCenterFacadeFactory;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogCondition;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogUIInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.IAutoCheckSchmLog;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractAutoCheckSchmLogUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountCheckWorktableUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AutoCheckSchmDetailLogUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AutoCheckSchmLogFilterUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.GroupCheckageListUI;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JPopupMenu;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class AutoCheckSchmLogUI
extends AbstractAutoCheckSchmLogUI
implements KDTDataRequestListener {
    private static final Logger logger = CoreUIObject.getLogger(AutoCheckSchmLogUI.class);
    private Map treeModelMap = null;
    String schmId;
    DefaultKingdeeTreeNode rootNode = null;
    public CommonQueryDialog conditionDialog = null;
    public CustomerQueryPanel conditionPanel = null;
    private boolean isLoaded = false;
    AutoCheckSchmLogCondition filterCondition;
    int preDisplayTypeGroupValue = -1;
    protected int maxRow = -1;
    protected AbstractAction linkToGroupAction = null;
    protected AbstractAction linkToElimAction = null;
    Map<String, AutoCheckSchmLogInfo> cacheSchmLogMap = new HashMap<String, AutoCheckSchmLogInfo>();
    Map<String, AutoCheckSchmInfo> cacheSchmMap = new HashMap<String, AutoCheckSchmInfo>();

    public AutoCheckSchmLogUI() throws Exception {
        this.tblMain.addKDTDataRequestListener((KDTDataRequestListener)this);
    }

    public void onLoad() throws Exception {
        this.schmId = (String)this.getUIContext().get("schmId");
        this.initComp();
        this.initTreePopMenu();
        super.onLoad();
        this.changeCompByCondition(this.filterCondition);
        this.initMyListener();
        this.isLoaded = true;
        this.treeMain.setSelectionNode(null);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("selected").getStyleAttributes().setLocked(false);
    }

    private void initTreePopMenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        menu.removeAll();
        menu.add(new AbstractAction(AccountCheckUtil.getResourceString(null, "linkToAccountCheckWorktableUI", null)){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoCheckSchmLogUI.this.linkToAccountCheckWorktableUI(null, null, false);
            }
        });
        this.linkToGroupAction = new AbstractAction(AccountCheckUtil.getResourceString(null, "linkToGroupCheckageListUI", null)){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoCheckSchmLogUI.this.linkToGroupCheckageListUI(null, null);
            }
        };
        menu.add(this.linkToGroupAction);
        this.linkToElimAction = new AbstractAction(AccountCheckUtil.getResourceString(null, "linkToEliminationListUI", null)){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoCheckSchmLogUI.this.linkToEliminationListUI();
            }
        };
        menu.add(this.linkToElimAction);
        this.treeMain.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                return true;
            }
        });
    }

    private void initMyListener() {
        this.periodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AutoCheckSchmLogUI.this.updateYearAndPeriod();
                }
            }
        });
        this.year.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AutoCheckSchmLogUI.this.updateOrgTree(e);
            }
        });
        this.period.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AutoCheckSchmLogUI.this.updateOrgTree(e);
            }
        });
    }

    private void updateOrgTree(ChangeEvent e) {
        if (!this.radioOrgUnit.isSelected()) {
            return;
        }
        try {
            this.initOrgUnitTree(false);
        }
        catch (Exception e1) {
            logger.error((Object)"updateOrgTree error.", (Throwable)e1);
        }
    }

    private void updateYearAndPeriod() {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.periodType.getSelectedItem();
        if (periodTypeEnum == null) {
            return;
        }
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 13, 1));
        } else if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 4, 1));
        } else if (RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 2, 1));
        } else if (RptPeriodTypeEnum.YEARLY.equals((Object)periodTypeEnum)) {
            this.period.setModel((SpinnerModel)this.getSpinnerNumberModel(1, 1, 1, 1));
        }
    }

    private SpinnerNumberModel getSpinnerNumberModel(int initValue, int minimum, int maximum, int stepSize) {
        return new SpinnerNumberModel(initValue, minimum, maximum, stepSize);
    }

    private void initComp() throws BOSException, EASBizException {
        this.displayTypeGroup.setValue(0);
        this.chkIncludeChild.setVisible(false);
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        String creatOrgUnitIDStr = "";
        creatOrgUnitIDStr = currentFIUnit != null ? currentFIUnit.getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
        AutoCheckSchmCollection autoCheckSchmCollection = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmCollection("select id,name where creatOrgUnit='" + creatOrgUnitIDStr + "'");
        if (autoCheckSchmCollection != null && !autoCheckSchmCollection.isEmpty()) {
            int i;
            ItemListener[] itemListeners = this.cbxMain.getItemListeners();
            for (i = 0; i < itemListeners.length; ++i) {
                this.cbxMain.removeItemListener(itemListeners[i]);
            }
            for (i = 0; i < autoCheckSchmCollection.size(); ++i) {
                this.cbxMain.addItem((Object)autoCheckSchmCollection.get(i));
            }
            for (i = 0; i < itemListeners.length; ++i) {
                this.cbxMain.addItemListener(itemListeners[i]);
            }
        }
        this.orgTree.setEnabled(false);
        this.periodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.SEMIYEARLY);
        this.periodType.addItem((Object)RptPeriodTypeEnum.YEARLY);
        CslRptUIUtil.setSpineRange((KDSpinner)this.period, (int)1, (int)13, (boolean)true, (boolean)true);
        CurrencyInfo currCurrency = RptNewUIUtil.getCompanyBasicCurrency(OrgType.Company, currentFIUnit.getId().toString());
        this.currency.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC()));
        this.unExecCount.setEnabled(false);
        this.execCount.setEnabled(false);
        this.successCount.setEnabled(false);
        this.failCount.setEnabled(false);
        this.unExecCount.setCustomBackgroundColor(new Color(153, 204, 255));
        this.execCount.setCustomBackgroundColor(new Color(255, 255, 133));
        this.successCount.setCustomBackgroundColor(new Color(249, 249, 212));
        this.failCount.setCustomBackgroundColor(new Color(255, 204, 153));
    }

    private void changeCompByCondition(AutoCheckSchmLogCondition condition) throws EASBizException, BOSException {
        CurrencyCollection currencyCollection;
        AutoCheckSchmInfo selectSchmInfo = null;
        for (int i = 0; i < this.cbxMain.getItemCount(); ++i) {
            AutoCheckSchmInfo schmInfo = (AutoCheckSchmInfo)this.cbxMain.getItemAt(i);
            if (selectSchmInfo != null || !schmInfo.getId().toString().equals(condition.getSchmId())) continue;
            selectSchmInfo = schmInfo;
            break;
        }
        if (selectSchmInfo != null) {
            this.cbxMain.setSelectedItem(selectSchmInfo, false);
        }
        if (!StringUtils.isEmpty((String)condition.getOrgTreeId())) {
            OrgTreeInfo orgTreeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("select id,name,number where id='" + condition.getOrgTreeId() + "'");
            this.orgTree.setText(orgTreeInfo.getName());
            this.orgTree.setUserObject((Object)orgTreeInfo);
        } else {
            this.orgTree.setText(null);
            this.orgTree.setUserObject(null);
        }
        this.periodType.setSelectedItem((Object)condition.getPeriodType());
        if (!StringUtils.isEmpty((String)condition.getCurrencyId()) && (currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select id,number,name,precision where id='" + condition.getCurrencyId() + "'")) != null && !currencyCollection.isEmpty()) {
            this.currency.setSelectedItem((Object)currencyCollection.get(0));
        }
        this.year.setValue((Object)condition.getYear());
        this.period.setValue((Object)condition.getPeriod());
    }

    public void initTree() throws Exception {
        if (this.displayTypeGroup.getValue() == 0) {
            this.initCompanyTree();
            this.changeComp(true);
            this.changeTreePopMenu(true);
        } else if (this.displayTypeGroup.getValue() == 1) {
            this.initOrgUnitTree(true);
            this.changeComp(false);
            this.changeTreePopMenu(false);
        }
    }

    private void changeTreePopMenu(boolean isCompany) {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        menu.getComponent(0).setVisible(isCompany);
        menu.getComponent(1).setVisible(!isCompany);
        menu.getComponent(2).setVisible(!isCompany);
    }

    private void changeComp(boolean isCompany) {
        this.kDRemoveData.setEnabled(isCompany);
        this.kDUnConfirm.setEnabled(isCompany);
        this.btnUnAudit.setEnabled(!isCompany);
        this.btnDeleteElim.setEnabled(!isCompany);
        this.tblMain.getColumn("orgUnitName").getStyleAttributes().setHided(isCompany);
        this.tblMain.getColumn("getDataExecStatus").getStyleAttributes().setHided(!isCompany);
        this.tblMain.getColumn("confirmExecStatus").getStyleAttributes().setHided(!isCompany);
        this.tblMain.getColumn("diffHdExecStatus").getStyleAttributes().setHided(isCompany);
        this.tblMain.getColumn("auditExecStatus").getStyleAttributes().setHided(isCompany);
        this.tblMain.getColumn("createElimExecStatus").getStyleAttributes().setHided(isCompany);
        this.tblMain.getColumn("diffMode").getStyleAttributes().setHided(isCompany);
    }

    private void initOrgUnitTree(boolean isDisplayTypeGroupChange) throws Exception {
        RptPeriodTypeEnum periodTypeEnum;
        int periodValue;
        int yearValue;
        Date rptDate;
        String orgTreeNumber;
        OrgTreeInfo newOrgTreeInfo;
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTree.getUserObject();
        if (orgTreeInfo == null) {
            this.treeMain.setModel(null);
            return;
        }
        String orgTreeId = orgTreeInfo.getId().toString();
        if (orgTreeId.equals((newOrgTreeInfo = CslRptUtil.getOrgTreeInfo(null, (String)(orgTreeNumber = orgTreeInfo.getNumber()), (String)orgTreeId, (Date)(rptDate = RPTDateUtil.getPeriodLastDate((int)(yearValue = this.year.getIntegerVlaue().intValue()), (int)(periodValue = this.period.getIntegerVlaue().intValue()), (RptPeriodTypeEnum)(periodTypeEnum = (RptPeriodTypeEnum)this.periodType.getSelectedItem()))))).getId().toString()) && !isDisplayTypeGroupChange) {
            return;
        }
        this.orgTree.setUserObject((Object)newOrgTreeInfo);
        TreeModel model = this.buildTreeModel(newOrgTreeInfo.getId().toString());
        this.rootNode = (DefaultKingdeeTreeNode)model.getRoot();
        DefaultTreeModel model2 = new DefaultTreeModel((TreeNode)this.rootNode);
        this.treeMain.setModel((TreeModel)model2);
        this.treeMain.expandAllNodes(true, (TreeNode)this.rootNode);
    }

    private TreeModel buildTreeModel(String treeId) throws EASBizException, BOSException {
        if (this.treeModelMap == null) {
            this.treeModelMap = new HashMap();
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String CUId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String key = new StringBuffer(treeId).append(userId).append(CUId).toString();
        Map treeModelInfoMap = null;
        if (this.treeModelMap.containsKey(key)) {
            treeModelInfoMap = (Map)this.treeModelMap.get(key);
        } else {
            ObjectUuidPK userPk = new ObjectUuidPK(userId);
            treeModelInfoMap = MergeReportCenterFacadeFactory.getRemoteInstance().buildTreeModelInfo((IObjectPK)userPk, treeId, CUId);
            this.treeModelMap.put(key, treeModelInfoMap);
        }
        Map displayOrgIDs = (Map)treeModelInfoMap.get("permOrgs");
        OrgStructureCollection collection = (OrgStructureCollection)treeModelInfoMap.get("orgStructureCollection");
        HashMap<String, String> numberIdMap = new HashMap<String, String>();
        for (int i = 0; i < collection.size(); ++i) {
            FullOrgUnitInfo unit = collection.get(i).getUnit();
            unit.put("ENABLE_FLAG", null);
            if (!unit.isIsUnion()) continue;
            numberIdMap.put(unit.getNumber(), unit.getId().toString());
        }
        Set<String> hasPermissionOrgUnitSet = this.filterCondition.getOrgUnitSet();
        FullOrgUnitCollection orgUnitColl = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select number where id in(" + CslRptUtil.collection2String(hasPermissionOrgUnitSet, (String)",", (boolean)true) + ")");
        HashMap hasPermissionOrgUnits = new HashMap();
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            String number = orgUnitColl.get(i).getNumber();
            String id = (String)numberIdMap.get(number);
            if (id == null || !displayOrgIDs.containsKey(id)) continue;
            hasPermissionOrgUnits.put(id, displayOrgIDs.get(id));
        }
        numberIdMap.clear();
        DefaultTreeModel treeModel = CslOrgTreeUtil.buildTreeByOrgStructCollection((OrgStructureCollection)collection);
        CslOrgTreeUtil.treatTreeModel((DefaultTreeModel)treeModel, (int)0, hasPermissionOrgUnits, (boolean)true, (boolean)false);
        return treeModel;
    }

    private IAutoCheckSchmLog getAutoCheckSchmLogFactory() throws BOSException {
        return AutoCheckSchmLogFactory.getRemoteInstance();
    }

    private void initCompanyTree() throws BOSException {
        if (this.filterCondition == null) {
            return;
        }
        Set<String> companySet = this.filterCondition.getCompanySet();
        if (companySet == null) {
            this.treeMain.setModel(null);
            return;
        }
        this.rootNode = new DefaultKingdeeTreeNode((Object)AccountCheckUtil.getResourceString(null, "schmLogUITreeNodeTitle", null));
        this.rootNode.setUserObject(null);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)this.rootNode);
        this.treeMain.setModel((TreeModel)model);
        this.treeMain.getSelectionModel().setSelectionMode(1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        if (fullOrgUnitCollection != null && !fullOrgUnitCollection.isEmpty()) {
            DefaultKingdeeTreeNode node = null;
            for (int i = 0; i < fullOrgUnitCollection.size(); ++i) {
                FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitCollection.get(i);
                node = new DefaultKingdeeTreeNode();
                this.insertNode(node, fullOrgUnitInfo);
            }
        }
        this.treeMain.expandAllNodes(true, (TreeNode)this.rootNode);
    }

    private void insertNode(DefaultKingdeeTreeNode node, FullOrgUnitInfo fullOrgUnitInfo) {
        node.setText(fullOrgUnitInfo.getName());
        node.setUserObject((Object)fullOrgUnitInfo);
        node.setAllowsChildren(false);
        this.treeMain.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)this.rootNode, this.rootNode.getChildCount());
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if ((e.getColIndex() == 9 || e.getColIndex() == 10 || e.getColIndex() == 13) && this.radioOrgUnit.isSelected() && e.getClickCount() == 2) {
            ICell cell = this.tblMain.getCell(e.getRowIndex(), e.getColIndex());
            if (e.getColIndex() == 13) {
                Object diffAmount = cell.getValue();
                if (diffAmount != null && diffAmount instanceof BigDecimal) {
                    boolean isDiffZero = ((BigDecimal)diffAmount).compareTo(BigDecimal.ZERO) == 0;
                    this.linkToGroupCheckageListUI(this.tblMain.getRow(e.getRowIndex()).getCell("ownCompanyId").getValue().toString(), isDiffZero);
                }
            } else if (cell != null && cell.getValue() != null && cell.getValue() instanceof AutoCheckStatusEnum && cell.getValue().equals((Object)AutoCheckStatusEnum.execSuccess)) {
                this.linkToGroupCheckageListUI(this.tblMain.getRow(e.getRowIndex()).getCell("ownCompanyId").getValue().toString(), null);
            }
        } else if (this.radioCompany.isSelected() && e.getClickCount() == 2) {
            ICell cell;
            if (e.getColIndex() == 7 || e.getColIndex() == 8) {
                IRow row;
                ICell cell2 = this.tblMain.getCell(e.getRowIndex(), e.getColIndex());
                if (cell2 != null && cell2.getValue() != null && cell2.getValue() instanceof AutoCheckStatusEnum && cell2.getValue().equals((Object)AutoCheckStatusEnum.execSuccess) && (row = this.tblMain.getRow(e.getRowIndex())).getCell("ownCompanyId").getValue() != null && row.getCell("targetCompanyId").getValue() != null) {
                    this.linkToAccountCheckWorktableUI(row.getCell("ownCompanyId").getValue().toString(), row.getCell("targetCompanyId").getValue().toString(), false);
                }
            } else if (e.getColIndex() == 13 && (cell = this.tblMain.getCell(e.getRowIndex(), e.getColIndex())) != null && cell.getValue() != null && cell.getValue() instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)cell.getValue()) != 0) {
                IRow row = this.tblMain.getRow(e.getRowIndex());
                this.linkToAccountCheckWorktableUI(row.getCell("ownCompanyId").getValue().toString(), row.getCell("targetCompanyId").getValue().toString(), true);
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode selectNode = this.getSelectNode();
        if (selectNode != null) {
            boolean isDisable = OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)selectNode);
            this.linkToElimAction.setEnabled(!isDisable);
            this.linkToGroupAction.setEnabled(!isDisable);
        }
        this.actionRefresh_actionPerformed(null);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
    }

    protected void cbxMain_itemStateChanged(ItemEvent e) throws Exception {
        AutoCheckSchmInfo schmInfo;
        AutoCheckSchmLogInfo autoCheckSchmLogInfo;
        AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)this.cbxMain.getSelectedItem();
        String selectSchmId = autoCheckSchmInfo.getId().toString();
        if (!this.cacheSchmLogMap.containsKey(selectSchmId)) {
            autoCheckSchmLogInfo = AutoCheckSchmLogFactory.getRemoteInstance().getLastValue(selectSchmId);
            this.cacheSchmLogMap.put(selectSchmId, autoCheckSchmLogInfo);
        } else {
            autoCheckSchmLogInfo = this.cacheSchmLogMap.get(selectSchmId);
        }
        if (autoCheckSchmLogInfo != null) {
            String currencyId2 = autoCheckSchmLogInfo.getCurrency().getId().toString();
            RptPeriodTypeEnum periodType2 = autoCheckSchmLogInfo.getPeriodType();
            int year2 = autoCheckSchmLogInfo.getYear();
            int period2 = autoCheckSchmLogInfo.getPeriod();
            this.currency.setSelectedItem((Object)autoCheckSchmLogInfo.getCurrency());
            this.periodType.setSelectedItem((Object)periodType2);
            this.year.setValue((Object)year2);
            this.period.setValue((Object)period2);
            this.filterCondition.setCurrencyId(currencyId2);
            this.filterCondition.setPeriodType(periodType2);
            this.filterCondition.setYear(year2);
            this.filterCondition.setPeriod(period2);
        }
        if (!this.cacheSchmMap.containsKey(selectSchmId)) {
            schmInfo = new AutoCheckSchmInfo();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scheme", (Object)selectSchmId));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.code"));
            view.setSelector(sic);
            AutoCheckSchmCompEntryCollection autoCheckSchmCompEntryCollection = AutoCheckSchmCompEntryFactory.getRemoteInstance().getAutoCheckSchmCompEntryCollection(view);
            if (autoCheckSchmCompEntryCollection != null && !autoCheckSchmCompEntryCollection.isEmpty()) {
                AutoCheckSchmCompEntryCollection companyEntries = schmInfo.getCompanyEntries();
                for (int i = 0; i < autoCheckSchmCompEntryCollection.size(); ++i) {
                    companyEntries.add(autoCheckSchmCompEntryCollection.get(i));
                }
            }
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.code"));
            view.setSelector(sic);
            AutoCheckSchmUnitEntryCollection autoCheckSchmUnitEntryCollection = AutoCheckSchmUnitEntryFactory.getRemoteInstance().getAutoCheckSchmUnitEntryCollection(view);
            if (autoCheckSchmUnitEntryCollection != null && !autoCheckSchmUnitEntryCollection.isEmpty()) {
                AutoCheckSchmUnitEntryCollection orgUnitEntries = schmInfo.getOrgUnitEntries();
                for (int i = 0; i < autoCheckSchmUnitEntryCollection.size(); ++i) {
                    orgUnitEntries.add(autoCheckSchmUnitEntryCollection.get(i));
                }
            }
            this.cacheSchmMap.put(selectSchmId, schmInfo);
        } else {
            schmInfo = this.cacheSchmMap.get(selectSchmId);
        }
        if (autoCheckSchmInfo.getOrgTree() == null) {
            this.orgTree.setText(null);
            this.orgTree.setUserObject(null);
        }
        this.filterCondition.setSchmId(selectSchmId);
        this.filterCondition.setOrgTreeId(autoCheckSchmInfo.getOrgTree() != null ? autoCheckSchmInfo.getOrgTree().getId().toString() : null);
        this.filterCondition.setIncludAdjustPeriod(autoCheckSchmInfo.isIsIncludAdjustPeriod());
        AutoCheckSchmCompEntryCollection companyEntries = schmInfo.getCompanyEntries();
        if (companyEntries != null && !companyEntries.isEmpty()) {
            HashSet<String> companySet = new HashSet<String>();
            for (int i = 0; i < companyEntries.size(); ++i) {
                companySet.add(companyEntries.get(i).getCompany().getId().toString());
            }
            this.filterCondition.setCompanySet(companySet);
        } else {
            this.filterCondition.setCompanySet(null);
        }
        AutoCheckSchmUnitEntryCollection orgUnitEntries = schmInfo.getOrgUnitEntries();
        if (orgUnitEntries != null && !orgUnitEntries.isEmpty()) {
            HashSet<String> orgUnitSet = new HashSet<String>();
            for (int i = 0; i < orgUnitEntries.size(); ++i) {
                orgUnitSet.add(orgUnitEntries.get(i).getOrgUnit().getId().toString());
            }
            this.filterCondition.setOrgUnitSet(orgUnitSet);
        } else {
            this.filterCondition.setOrgUnitSet(null);
        }
        this.initTree();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"selected", (Boolean)Boolean.TRUE);
    }

    @Override
    protected void btnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"selected", (Boolean)Boolean.FALSE);
    }

    @Override
    protected void kDRemoveData_actionPerformed(ActionEvent e) throws Exception {
        List<String> selectIds = this.getSelectIds();
        if (!selectIds.isEmpty()) {
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "removeBySchm", null)))) {
                return;
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)this.cbxMain.getSelectedItem();
        this.removeData(autoCheckSchmInfo.getId().toString(), selectIds);
    }

    private StringBuilder checkAllOrgPermission(Map selectMap, IObjectPK userPK, String userName, String permissionNum) throws EASBizException, BOSException {
        StringBuilder sbInfo = new StringBuilder();
        Set ownCompanyIdSet = selectMap.keySet();
        IObjectPK[] pkArray = new IObjectPK[ownCompanyIdSet.size()];
        int i = 0;
        for (String ownCompanyId : ownCompanyIdSet) {
            pkArray[i++] = new ObjectUuidPK(ownCompanyId);
        }
        Set permissIdSet = PermissionFactory.getRemoteInstance().checkBatchPermission(userPK, pkArray, permissionNum);
        PermItemInfo permItemInfo = PermItemFactory.getRemoteInstance().getPermItemInfo("select alias where number ='" + permissionNum + "'");
        HashSet oldCompanyIdSet = new HashSet();
        oldCompanyIdSet.addAll(ownCompanyIdSet);
        oldCompanyIdSet.removeAll(permissIdSet);
        if (!oldCompanyIdSet.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", oldCompanyIdSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            view.setSelector(sic);
            HashMap<String, String> companyInfoMap = new HashMap<String, String>();
            CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            for (int x = 0; x < companyOrgUnitCollection.size(); ++x) {
                CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(x);
                companyInfoMap.put(companyOrgUnitInfo.getId().toString(), companyOrgUnitInfo.getName());
            }
            for (String companyId : oldCompanyIdSet) {
                Object[] object = new Object[]{userName, companyInfoMap.get(companyId), permItemInfo.getAlias()};
                sbInfo.append(AccountCheckUtil.getResourceString(null, "haveNoOrgFunctionPermission", object));
                sbInfo.append("\n");
                selectMap.remove(companyId);
            }
        }
        return sbInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeData(String schmId, List<String> schmUnitLogIds) throws Exception {
        Map resultMap = AutoCheckSchmLogFactory.getRemoteInstance().batchRemoveData(schmId, schmUnitLogIds);
        if (resultMap != null) {
            Object isAllSuccess = resultMap.get("allSuccess");
            if (!Boolean.TRUE.equals(isAllSuccess)) {
                Object someSuccess = resultMap.get("someSuccess");
                String resultInfo = (String)resultMap.get("resultInfo");
                if (!Boolean.TRUE.equals(someSuccess)) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"removeBill_detailInfo"), (String)resultInfo, (int)1);
                    return;
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"removeBillFailInfo_title"), (String)resultInfo, (int)1);
            } else {
                MsgBox.showInfo((String)AccountCheckUtil.getResourceString(null, "removeDataSuccess", null));
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "noSchmRemoveData", null));
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    protected void kDUnConfirm_actionPerformed(ActionEvent e) throws Exception {
        List<String> selectIds = this.getSelectIds();
        if (!selectIds.isEmpty()) {
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "unConfirmBySchm", null)))) {
                return;
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)this.cbxMain.getSelectedItem();
        this.unConfirmData(autoCheckSchmInfo.getId().toString(), selectIds);
    }

    private void unConfirmData(String schmId, List<String> schmUnitLogIds) throws Exception {
        Map resultMap = AutoCheckSchmLogFactory.getRemoteInstance().batchUnConfirm(schmId, schmUnitLogIds);
        String info = (String)resultMap.get("info");
        boolean noData = "true".equals(resultMap.get("noData"));
        boolean hasUnConfrimData = "true".equals(resultMap.get("hasUnConfrimData"));
        if (!StringUtils.isEmpty((String)info)) {
            String title = hasUnConfrimData ? AccountCheckUtil.getResourceString(null, "confirm_some", null) : "";
            MsgBox.showDetailAndOK((Component)((Object)this), (String)(title + AccountCheckUtil.getResourceString(null, "unConfirmFailInfo", null)), (String)info, (int)1);
        } else if (noData) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "noSchmUnConfirmData", null));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "unConfirmSuccess", null));
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    protected void btnUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.btnUnAudit_actionPerformed(e);
    }

    @Override
    protected void btnDeleteElim_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteElim_actionPerformed(e);
    }

    @Override
    protected void btnDetailLog_actionPerformed(ActionEvent e) throws Exception {
        ICell iCell;
        int rowIndex;
        String orgUnitId = null;
        if (this.radioOrgUnit.isSelected() && this.chkIncludeChild.isSelected() && (rowIndex = this.tblMain.getSelectManager().getActiveRowIndex()) >= 0 && (iCell = this.tblMain.getCell(rowIndex, "orgUnitId")) != null && iCell.getValue() != null) {
            orgUnitId = iCell.getValue().toString();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            DefaultKingdeeTreeNode selectNode = this.getSelectNode();
            if (selectNode == null) {
                return;
            }
            Object selectNodeObj = selectNode.getUserObject();
            if (selectNodeObj != null) {
                if (selectNodeObj instanceof OrgStructureInfo) {
                    OrgStructureInfo unitInfo = (OrgStructureInfo)selectNodeObj;
                    orgUnitId = unitInfo.getUnit().getId().toString();
                } else if (selectNodeObj instanceof FullOrgUnitInfo) {
                    FullOrgUnitInfo fullOrgInfo = (FullOrgUnitInfo)selectNodeObj;
                    orgUnitId = fullOrgInfo.getId().toString();
                }
            }
        }
        AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)this.cbxMain.getSelectedItem();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)((CurrencyInfo)this.currency.getSelectedItem()).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)((RptPeriodTypeEnum)this.periodType.getSelectedItem()).getValue()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)this.year.getIntegerVlaue()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.period.getIntegerVlaue()));
        filter.getFilterItems().add(new FilterItemInfo("schmId", (Object)autoCheckSchmInfo.getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        AutoCheckSchmLogCollection autoCheckSchmLogCollection = AutoCheckSchmLogFactory.getRemoteInstance().getAutoCheckSchmLogCollection(view);
        String schmLogId = null;
        if (autoCheckSchmLogCollection == null || autoCheckSchmLogCollection.isEmpty()) {
            return;
        }
        schmLogId = autoCheckSchmLogCollection.get(0).getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"schmLogId", (Object)schmLogId);
        uiContext.put((Object)"orgUnitId", (Object)orgUnitId);
        uiContext.put((Object)"isSelectCompany", (Object)this.radioCompany.isSelected());
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AutoCheckSchmDetailLogUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, 2);
        }
        catch (UIException ee) {
            logger.error((Object)"", (Throwable)ee);
        }
        uiWindow.show();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        try {
            int formulaIndex = 0;
            StringBuilder sbFormula = new StringBuilder();
            AutoCheckSchmCollection autoCheckSchmCollection = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmCollection("where id='" + this.schmId + "'");
            AutoCheckSchmInfo autoCheckSchmInfo = null;
            if (autoCheckSchmCollection != null && !autoCheckSchmCollection.isEmpty()) {
                autoCheckSchmInfo = autoCheckSchmCollection.get(0);
            }
            if (autoCheckSchmInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("schm", (Object)autoCheckSchmInfo.getId().toString()));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
            }
            filter.getFilterItems().add(new FilterItemInfo("autoCheckStatus", (Object)0));
            sbFormula.append("#" + formulaIndex++);
            sbFormula.append(" and ");
            AutoCheckSchmLogInfo autoCheckSchmLogInfo = AutoCheckSchmLogFactory.getRemoteInstance().getLastValue(this.schmId);
            if (autoCheckSchmLogInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("currency", (Object)autoCheckSchmLogInfo.getCurrency().getId().toString()));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)autoCheckSchmLogInfo.getPeriodType().getValue()));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
                filter.getFilterItems().add(new FilterItemInfo("year", (Object)autoCheckSchmLogInfo.getYear()));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)autoCheckSchmLogInfo.getPeriod()));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
            } else {
                PeriodCollection currentNodePeriodCollection;
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)3));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
                CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
                CurrencyInfo currCurrency = RptNewUIUtil.getCompanyBasicCurrency(OrgType.Company, currentFIUnit.getId().toString());
                if (currCurrency != null) {
                    filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currCurrency.getId().toString()));
                    sbFormula.append("#" + formulaIndex++);
                    sbFormula.append(" and ");
                }
                if ((currentNodePeriodCollection = InitDataFacadaFactory.getRemoteInstance().getFiscal((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)currentFIUnit.getId().toString())))) != null && currentNodePeriodCollection.size() > 0) {
                    TreeMap<Integer, List<Integer>> yearMap = new TreeMap<Integer, List<Integer>>();
                    for (int i = 0; i < currentNodePeriodCollection.size(); ++i) {
                        Integer year = currentNodePeriodCollection.get(i).getPeriodYear();
                        Integer period = currentNodePeriodCollection.get(i).getPeriodNumber();
                        List<Integer> periodVec = yearMap.get(year);
                        if (periodVec == null) {
                            periodVec = new ArrayList<Integer>(12);
                            yearMap.put(year, periodVec);
                        }
                        periodVec.add(period);
                    }
                    int[] yearPeriod = this.reviseYearPeriod(currentFIUnit, yearMap);
                    filter.getFilterItems().add(new FilterItemInfo("year", (Object)yearPeriod[0]));
                    sbFormula.append("#" + formulaIndex++);
                    sbFormula.append(" and ");
                    filter.getFilterItems().add(new FilterItemInfo("period", (Object)yearPeriod[1]));
                    sbFormula.append("#" + formulaIndex++);
                    sbFormula.append(" and ");
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("scheme", (Object)this.schmId));
            view.setFilter(filterInfo);
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("seq"));
            view.setSorter(sort);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("seq"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.code"));
            view.setSelector(sic);
            HashSet<String> companySet = new HashSet<String>();
            AutoCheckSchmCompEntryCollection autoCheckSchmCompEntryCollection = AutoCheckSchmCompEntryFactory.getRemoteInstance().getAutoCheckSchmCompEntryCollection(view);
            if (autoCheckSchmCompEntryCollection != null && !autoCheckSchmCompEntryCollection.isEmpty()) {
                for (int i = 0; i < autoCheckSchmCompEntryCollection.size(); ++i) {
                    companySet.add(autoCheckSchmCompEntryCollection.get(i).getCompany().getId().toString());
                }
            }
            if (companySet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("tblCompany", companySet, CompareType.INCLUDE));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
            }
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("seq"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.code"));
            view.setSelector(sic);
            HashSet<String> orgUnitSet = new HashSet<String>();
            AutoCheckSchmUnitEntryCollection autoCheckSchmUnitEntryCollection = AutoCheckSchmUnitEntryFactory.getRemoteInstance().getAutoCheckSchmUnitEntryCollection(view);
            if (autoCheckSchmUnitEntryCollection != null && !autoCheckSchmUnitEntryCollection.isEmpty()) {
                for (int i = 0; i < autoCheckSchmUnitEntryCollection.size(); ++i) {
                    orgUnitSet.add(autoCheckSchmUnitEntryCollection.get(i).getOrgUnit().getId().toString());
                }
            }
            if (orgUnitSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("tblOrgUnit", orgUnitSet, CompareType.INCLUDE));
                sbFormula.append("#" + formulaIndex++);
                sbFormula.append(" and ");
            }
            if (sbFormula.length() > 0) {
                int index = sbFormula.lastIndexOf(" and ");
                filter.setMaskString(sbFormula.substring(0, index).toString());
            } else if (filter.containsKey("maskString")) {
                filter.remove("maskString");
            }
        }
        catch (Exception e) {
            logger.error((Object)"getInitDefaultSolution error.", (Throwable)e);
        }
        return viewInfo;
    }

    private int[] reviseYearPeriod(CompanyOrgUnitInfo currentFIUnit, TreeMap<Integer, List<Integer>> yearMap) {
        Integer[] years;
        int[] yearPeriod = RptNewUIUtil.getFICurrPeriod(currentFIUnit);
        int n = yearPeriod[0] > (years = this.getYearScope(yearMap))[1] ? years[1] : (yearPeriod[0] < years[0] ? years[0] : yearPeriod[0]);
        yearPeriod[0] = n;
        return yearPeriod;
    }

    private Integer[] getYearScope(TreeMap<Integer, List<Integer>> yearMap) {
        Object[] array = yearMap.keySet().toArray();
        if (array == null || array.length == 0) {
            return new Integer[]{0, 0};
        }
        Arrays.sort(array);
        return new Integer[]{(Integer)array[0], (Integer)array[array.length - 1]};
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = AutoCheckSchmLogUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            this.setDialogMainQueryCondition();
        } else {
            this.filterCondition = this.getCondition();
        }
    }

    protected void setDialogMainQueryCondition() throws Exception {
        if (this.getConditionDialog().show()) {
            this.doQuery(this.conditionDialog);
            this.mainQuery = this.conditionDialog.getEntityViewInfoResult();
            this.filterCondition = this.getCondition();
            this.changeCompByCondition(this.filterCondition);
            if (this.isLoaded) {
                this.initTree();
            }
            this.actionRefresh_actionPerformed(null);
        } else {
            SysUtil.abort();
        }
    }

    private CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPK1 = MetaDataPK.create((String)"com.kingdee.eas.base.message", (String)"MsgQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK1);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(450);
            this.conditionDialog.setHeight(430);
            this.conditionDialog.setTitle(AccountCheckUtil.getResourceString(null, "autoCheckSchmLogFilterTitle", null));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.newrpt.accountcheck.client.AutoCheckSchmLogUI");
        } else {
            this.loadFilterUIParam();
        }
        return this.conditionDialog;
    }

    private void loadFilterUIParam() {
        KDPanel userPanel = this.conditionDialog.getUserPanel("com.kingdee.eas.fi.newrpt.accountcheck.client.AutoCheckSchmLogFilterUI");
        if (userPanel != null) {
            AutoCheckSchmLogFilterUI filterUi = (AutoCheckSchmLogFilterUI)userPanel;
            filterUi.schm.setSelectedItem(this.cbxMain.getSelectedItem(), false);
            filterUi.periodType.setSelectedItem(this.periodType.getSelectedItem());
            filterUi.currency.setSelectedItem(this.currency.getSelectedItem());
            filterUi.year.setValue((Object)this.year.getIntegerVlaue());
            filterUi.period.setValue((Object)this.period.getIntegerVlaue());
        }
    }

    private CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new AutoCheckSchmLogFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            this.conditionPanel.getUIContext().put("schmId", this.schmId);
        }
        return this.conditionPanel;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        if (!this.isLoaded) {
            return;
        }
        if (this.radioCompany.isSelected()) {
            this.queryCompanyData(e);
        } else if (this.radioOrgUnit.isSelected()) {
            this.queryOrgUnitData(e);
        }
    }

    private void queryCompanyData(KDTDataRequestEvent e) {
        try {
            if (this.getSelectNode() == null) {
                this.changeCount(null);
                return;
            }
            AutoCheckSchmLogCondition condition = this.getQueryCondition();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            if (from == 0) {
                this.filterCondition.setUnExecCount(0);
                this.filterCondition.setExecCount(0);
                this.filterCondition.setSuccessCount(0);
                this.filterCondition.setFailCount(0);
                this.changeCount(null);
                this.filterCondition = AutoCheckSchmLogFactory.getRemoteInstance().fetchCompanyData(condition);
                this.maxRow = this.filterCondition.getMaxRow();
            }
            int tableRowCount = this.tblMain.getRowCount3();
            if (this.maxRow <= 0 || this.maxRow <= tableRowCount) {
                return;
            }
            if (tableRowCount < this.maxRow && tableRowCount + length > this.maxRow) {
                length = this.maxRow - tableRowCount;
            }
            this.filterCondition.setFrom(from);
            this.filterCondition.setLength(length);
            ArrayList companyData = AutoCheckSchmLogFactory.getRemoteInstance().getCompanyData(this.filterCondition);
            if (companyData != null && companyData.size() > 0) {
                int rowFrom = this.tblMain.getRowCount3();
                this.insertRows(true, companyData, rowFrom, this.tblMain);
            }
            this.setBigDecimalFormat();
            this.changeCount(this.filterCondition);
        }
        catch (Exception ex) {
            logger.error((Object)"queryCompanyData error.", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private void changeCount(AutoCheckSchmLogCondition condition) {
        if (condition != null) {
            this.unExecCount.setText(condition.getUnExecCount() + "");
            this.execCount.setText(condition.getExecCount() + "");
            this.successCount.setText(condition.getSuccessCount() + "");
            this.failCount.setText(condition.getFailCount() + "");
        } else {
            this.unExecCount.setText("0");
            this.execCount.setText("0");
            this.successCount.setText("0");
            this.failCount.setText("0");
        }
    }

    private DefaultKingdeeTreeNode getSelectNode() {
        return this.treeMain.getSelectionPath() != null ? (DefaultKingdeeTreeNode)this.treeMain.getSelectionPath().getLastPathComponent() : null;
    }

    private void insertRows(boolean isCompany, ArrayList rows, int insertRowIndex, KDTable table) throws Exception {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        table.setRefresh(false);
        IRow row = null;
        for (int i = 0; i < rows.size(); ++i) {
            AutoCheckSchmLogUIInfo logUIInfo = (AutoCheckSchmLogUIInfo)rows.get(i);
            row = table.setRow(insertRowIndex++);
            this.setRowValue(row, logUIInfo, isCompany);
        }
        table.setRefresh(true);
    }

    private void setRowValue(IRow row, AutoCheckSchmLogUIInfo rowData, boolean isCompany) throws Exception {
        row.getCell("id").setValue((Object)rowData.id);
        row.getCell("selected").setValue((Object)rowData.selected);
        row.getCell("checkCompany").setValue((Object)rowData.checkCompany);
        row.getCell("ownCompanyId").setValue((Object)rowData.ownCompanyId);
        row.getCell("targetCompanyId").setValue((Object)rowData.targetCompanyId);
        row.getCell("diffAmount").setValue((Object)rowData.diffAmount);
        row.getCell("createtime").setValue((Object)rowData.createtime);
        if (isCompany) {
            row.getCell("getDataExecStatus").setValue((Object)AutoCheckStatusEnum.getEnum(rowData.getDataExecStatus));
            row.getCell("confirmExecStatus").setValue((Object)AutoCheckStatusEnum.getEnum(rowData.confirmExecStatus));
            this.changeColorBySt(row.getCell("getDataExecStatus"), rowData.getDataExecStatus);
            this.changeColorBySt(row.getCell("confirmExecStatus"), rowData.confirmExecStatus);
        } else {
            row.getCell("orgUnitId").setValue((Object)rowData.orgUnitId);
            row.getCell("orgUnitName").setValue((Object)rowData.orgUnitName);
            row.getCell("diffHdExecStatus").setValue((Object)AutoCheckStatusEnum.getEnum(rowData.diffHdExecStatus));
            row.getCell("auditExecStatus").setValue((Object)AutoCheckStatusEnum.getEnum(rowData.auditExecStatus));
            row.getCell("createElimExecStatus").setValue((Object)AutoCheckStatusEnum.getEnum(rowData.createElimExecStatus));
            row.getCell("diffMode").setValue((Object)DiffModeEnum.getEnum((int)rowData.diffMode));
            this.changeColorBySt(row.getCell("diffHdExecStatus"), rowData.diffHdExecStatus);
            this.changeColorBySt(row.getCell("auditExecStatus"), rowData.auditExecStatus);
            this.changeColorBySt(row.getCell("createElimExecStatus"), rowData.createElimExecStatus);
        }
    }

    private void changeColorBySt(ICell cell, int getDataExecStatus) {
        switch (getDataExecStatus) {
            case 1: {
                cell.getStyleAttributes().setBackground(new Color(153, 204, 255));
                break;
            }
            case 2: {
                cell.getStyleAttributes().setBackground(new Color(255, 255, 133));
                break;
            }
            case 3: {
                cell.getStyleAttributes().setBackground(new Color(249, 249, 212));
                break;
            }
            case 4: {
                cell.getStyleAttributes().setBackground(new Color(255, 204, 153));
                break;
            }
        }
    }

    private void setBigDecimalFormat() {
        this.tblMain.getColumn("diffAmount").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("diffAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void queryOrgUnitData(KDTDataRequestEvent e) {
        DefaultKingdeeTreeNode selectNode = this.getSelectNode();
        if (selectNode == null || selectNode.getUserObject() == null || !selectNode.isCheckBoxEnabled()) {
            this.changeCount(null);
            return;
        }
        try {
            AutoCheckSchmLogCondition condition = this.getQueryCondition();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            if (from == 0) {
                this.filterCondition.setUnExecCount(0);
                this.filterCondition.setExecCount(0);
                this.filterCondition.setSuccessCount(0);
                this.filterCondition.setFailCount(0);
                this.changeCount(null);
                this.filterCondition = AutoCheckSchmLogFactory.getRemoteInstance().fetchOrgUnitData(condition);
                this.maxRow = this.filterCondition.getMaxRow();
            }
            int tableRowCount = this.tblMain.getRowCount3();
            if (this.maxRow <= 0 || this.maxRow <= tableRowCount) {
                return;
            }
            if (tableRowCount < this.maxRow && tableRowCount + length > this.maxRow) {
                length = this.maxRow - tableRowCount;
            }
            this.filterCondition.setFrom(from);
            this.filterCondition.setLength(length);
            ArrayList companyData = AutoCheckSchmLogFactory.getRemoteInstance().getOrgUnitData(this.filterCondition);
            if (companyData != null && companyData.size() > 0) {
                int rowFrom = this.tblMain.getRowCount3();
                this.insertRows(false, companyData, rowFrom, this.tblMain);
            }
            this.setBigDecimalFormat();
            this.changeCount(this.filterCondition);
        }
        catch (Exception ex) {
            logger.error((Object)"queryCompanyData error.", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private AutoCheckSchmLogCondition getQueryCondition() {
        AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)this.cbxMain.getSelectedItem();
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.periodType.getSelectedItem();
        CurrencyInfo currencyInfo = (CurrencyInfo)this.currency.getSelectedItem();
        DefaultKingdeeTreeNode selectNode = this.getSelectNode();
        if (this.displayTypeGroup.getValue() == 0) {
            if (!selectNode.isRoot()) {
                this.filterCondition.setSelectCompanyId(((FullOrgUnitInfo)selectNode.getUserObject()).getId().toString());
            } else {
                this.filterCondition.setSelectCompanyId(null);
            }
        } else if (this.displayTypeGroup.getValue() == 1) {
            boolean isIncludeChild = this.isIsIncludeChild();
            if (isIncludeChild) {
                this.filterCondition.setSelectOrgUnitId(null);
                HashSet<String> orgUnitSet = new HashSet<String>();
                this.getAllChildId(orgUnitSet, selectNode);
                this.filterCondition.setOrgUnitSet(orgUnitSet);
            } else {
                this.filterCondition.setSelectOrgUnitId(((OrgStructureInfo)selectNode.getUserObject()).getUnit().getId().toString());
            }
        }
        this.filterCondition.setSchmId(autoCheckSchmInfo.getId().toString());
        this.filterCondition.setPeriodType(periodTypeEnum);
        this.filterCondition.setCurrencyId(currencyInfo.getId().toString());
        this.filterCondition.setYear(this.year.getIntegerVlaue());
        this.filterCondition.setPeriod(this.period.getIntegerVlaue());
        this.filterCondition.setItemType(((ItemTypeEnum)((Object)this.itemType.getSelectedItem())).getValue());
        return this.filterCondition;
    }

    private void getAllChildId(Set<String> orgUnitSet, DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = null;
        if (root != null) {
            if (root.getChildCount() > 0) {
                for (int i = root.getChildCount() - 1; i >= 0; --i) {
                    node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    this.getAllChildId(orgUnitSet, node);
                }
            }
            if (root.isCheckBoxEnabled()) {
                orgUnitSet.add(((OrgStructureInfo)root.getUserObject()).getUnit().getId().toString());
            }
        }
    }

    private AutoCheckSchmLogCondition getCondition() throws EASBizException, BOSException {
        this.filterCondition = new AutoCheckSchmLogCondition();
        FilterInfo filter = this.mainQuery.getFilter();
        FilterItemCollection filterItems = filter.getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            FilterItemInfo filterItemInfo = filterItems.get(i);
            String propertyName = filterItemInfo.getPropertyName();
            Object compareValue = filterItemInfo.getCompareValue();
            if ("schm".equals(propertyName)) {
                String selectSchmId = (String)compareValue;
                this.filterCondition.setSchmId(selectSchmId);
                AutoCheckSchmInfo autoCheckSchmInfo = AutoCheckSchmFactory.getRemoteInstance().getAutoCheckSchmInfo("select orgTree,isIncludAdjustPeriod where id='" + selectSchmId + "'");
                this.filterCondition.setOrgTreeId(autoCheckSchmInfo.getOrgTree() != null ? autoCheckSchmInfo.getOrgTree().getId().toString() : null);
                this.filterCondition.setIncludAdjustPeriod(autoCheckSchmInfo.isIsIncludAdjustPeriod());
                continue;
            }
            if ("autoCheckStatus".equals(propertyName)) {
                switch ((Integer)compareValue) {
                    case 1: {
                        this.filterCondition.setAutoCheckStatus(AutoCheckStatusEnum.unExecute);
                        break;
                    }
                    case 2: {
                        this.filterCondition.setAutoCheckStatus(AutoCheckStatusEnum.executing);
                        break;
                    }
                    case 3: {
                        this.filterCondition.setAutoCheckStatus(AutoCheckStatusEnum.execSuccess);
                        break;
                    }
                    case 4: {
                        this.filterCondition.setAutoCheckStatus(AutoCheckStatusEnum.execFail);
                        break;
                    }
                }
                continue;
            }
            if ("periodType".equals(propertyName)) {
                this.filterCondition.setPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)compareValue)));
                continue;
            }
            if ("currency".equals(propertyName)) {
                this.filterCondition.setCurrencyId((String)compareValue);
                continue;
            }
            if ("year".equals(propertyName)) {
                this.filterCondition.setYear((Integer)compareValue);
                continue;
            }
            if ("period".equals(propertyName)) {
                this.filterCondition.setPeriod((Integer)compareValue);
                continue;
            }
            if ("diffType".equals(propertyName)) {
                this.filterCondition.setDiffType((String)compareValue);
                continue;
            }
            if ("diffAmount".equals(propertyName)) {
                if (compareValue == null) continue;
                this.filterCondition.setDiffAmount((BigDecimal)compareValue);
                continue;
            }
            if ("tblCompany".equals(propertyName)) {
                this.filterCondition.setCompanySet((Set)compareValue);
                continue;
            }
            if (!"tblOrgUnit".equals(propertyName)) continue;
            this.filterCondition.setOrgUnitSet((Set)compareValue);
        }
        return this.filterCondition;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "id";
    }

    @Override
    protected void radioCompany_actionPerformed(ActionEvent e) throws Exception {
        int value = this.displayTypeGroup.getValue();
        if (this.preDisplayTypeGroupValue == value) {
            return;
        }
        this.chkIncludeChild.setVisible(false);
        this.chkIncludeChild.setSelected(false, false);
        this.initTree();
        this.preDisplayTypeGroupValue = value;
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    protected void radioOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        int value = this.displayTypeGroup.getValue();
        if (this.preDisplayTypeGroupValue == value) {
            return;
        }
        this.chkIncludeChild.setVisible(true);
        this.initTree();
        this.preDisplayTypeGroupValue = value;
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        List<String> ids = this.getSelectIds();
        if (!ids.isEmpty()) {
            FullOrgUnitInfo unitInfo;
            if (MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "199isUnAudited", null)) == 0 && (unitInfo = this.getLastSelectNode()) != null && unitInfo.getId() != null) {
                this.unAudited(this.schmId, ids);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    @Override
    public void actionDeleteElim_actionPerformed(ActionEvent e) throws Exception {
        List<String> ids = this.getSelectIds();
        if (!ids.isEmpty()) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "200isDeleteElim", null)) == 0) {
                Map result = AutoCheckSchmLogFactory.getRemoteInstance().batchDeleteElim(this.schmId, ids);
                if (result != null) {
                    int isDel;
                    Set auditedNums = (Set)result.get("auditedNums");
                    Set existNums = (Set)result.get("existNums");
                    Map existConvtIds = (Map)result.get("existConvtIds");
                    int deleteCount = 0;
                    if (result.containsKey("successCount")) {
                        deleteCount = (Integer)result.get("successCount");
                    }
                    if (existNums != null && !existNums.isEmpty() && (isDel = MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"292_AdjustEditUI"), (String)(existNums.toString() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"433_EliminationAutoListUI")))) == 0) {
                        ArrayList<Object> removeIds = new ArrayList<Object>();
                        removeIds.addAll(existConvtIds.keySet());
                        removeIds.addAll(existConvtIds.values());
                        EliminationFactory.getRemoteInstance().removeBatch(removeIds);
                        deleteCount += removeIds.size();
                    }
                    if (auditedNums != null && !auditedNums.isEmpty()) {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"150_error"), (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"91Can_Not_Delete") + " \n " + auditedNums.toString()), (int)8188);
                    } else if (deleteCount <= 0) {
                        MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "202noElimDelete", null));
                    } else {
                        MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "198_deleteElimSuccess", new Object[]{deleteCount}));
                    }
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "202noElimDelete", null));
                }
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    protected List<String> getSelectIds() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            ids.add((String)row.getCell("id").getValue());
        }
        return ids;
    }

    protected Set<String> getSelectCompanyIds() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            ids.add((String)row.getCell("orgUnitId").getValue());
        }
        return ids;
    }

    protected Map getSelectMap() throws Exception {
        HashMap<String, ArrayList<String>> selectMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            String ownCompanyId = (String)row.getCell("ownCompanyId").getValue();
            ArrayList<String> ids = (ArrayList<String>)selectMap.get(ownCompanyId);
            if (ids == null) {
                ids = new ArrayList<String>();
                selectMap.put(ownCompanyId, ids);
            }
            ids.add((String)row.getCell("id").getValue());
        }
        return selectMap;
    }

    public void unAudited(String schmId, List<String> schmUnitLogIds) throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        Set<String> companyIds = this.getSelectCompanyIds();
        for (String companyId : companyIds) {
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(companyId), (String)"csl_groupCheckage_unaudit");
        }
        Map result = AutoCheckSchmLogFactory.getRemoteInstance().batchUnAudit(schmId, schmUnitLogIds);
        int updateCount = 0;
        if (result != null) {
            Object msg = result.get("msg");
            if (result.containsKey("updateCount")) {
                updateCount = (Integer)result.get("updateCount");
            }
            if (msg == null || StringUtils.isEmpty((String)((String)msg)) && updateCount > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "203unAuditSuccessCount", new Object[]{updateCount}));
            } else if (msg != null && !StringUtils.isEmpty((String)((String)msg))) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)(AccountCheckUtil.getResourceString(null, "203unAuditSuccessCount", new Object[]{updateCount}) + "\n" + AccountCheckUtil.getResourceString(null, "110partUnAuditFail", null)), (String)msg.toString(), (int)8188);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "203unAuditSuccessCount", new Object[]{updateCount}));
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "203unAuditSuccessCount", new Object[]{updateCount}));
        }
    }

    private void linkToAccountCheckWorktableUI(String selectCompanyId, String targetCompanyId, boolean isOnlyDiffShow) {
        try {
            if (!StringUtils.isEmpty((String)selectCompanyId) && !StringUtils.isEmpty((String)targetCompanyId)) {
                HashSet<String> companyIdSet = new HashSet<String>();
                companyIdSet.add(selectCompanyId);
                companyIdSet.add(targetCompanyId);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
                view.setFilter(filter);
                FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
                if (fullOrgUnitCollection == null || fullOrgUnitCollection.isEmpty()) {
                    return;
                }
                FullOrgUnitInfo ownOrgUnitInfo = null;
                FullOrgUnitInfo tarOrgUnitInfo = null;
                for (int i = 0; i < fullOrgUnitCollection.size(); ++i) {
                    FullOrgUnitInfo fullOrgUnitInfo = fullOrgUnitCollection.get(i);
                    if (selectCompanyId.equals(fullOrgUnitInfo.getId().toString())) {
                        ownOrgUnitInfo = fullOrgUnitInfo;
                    }
                    if (!targetCompanyId.equals(fullOrgUnitInfo.getId().toString())) continue;
                    tarOrgUnitInfo = fullOrgUnitInfo;
                }
                if (ownOrgUnitInfo != null && tarOrgUnitInfo != null) {
                    this.openAccountCheckWorktableUI(ownOrgUnitInfo, tarOrgUnitInfo, isOnlyDiffShow);
                }
            } else {
                DefaultKingdeeTreeNode selectNode = this.getSelectNode();
                if (selectNode == null) {
                    return;
                }
                FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)selectNode.getUserObject();
                this.openAccountCheckWorktableUI(unitInfo, null, isOnlyDiffShow);
            }
        }
        catch (Exception e) {
            logger.error((Object)"linkToAccountCheckWorktableUI error.", (Throwable)e);
            this.handUIException(e);
        }
    }

    private void openAccountCheckWorktableUI(FullOrgUnitInfo unitInfo, FullOrgUnitInfo tarOrgUnitInfo, boolean isOnlyDiffShow) throws EASBizException, BOSException {
        ObjectUuidPK orgPK = null;
        CompanyOrgUnitCollection schmCompanyCol = null;
        boolean isSelectRoot = false;
        FullOrgUnitInfo ownCompany = null;
        if (unitInfo == null || unitInfo.getId() == null) {
            orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
            Set<String> companySet = this.filterCondition.getCompanySet();
            if (companySet != null && !companySet.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
                view.setFilter(filterInfo);
                schmCompanyCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            }
            isSelectRoot = true;
        } else {
            ownCompany = unitInfo;
            orgPK = new ObjectUuidPK(unitInfo.getId());
        }
        PermissionHelper.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)orgPK, (String)"csl_checkwork_view");
        AutoCheckSchmInfo autoCheckSchmInfo = (AutoCheckSchmInfo)this.cbxMain.getSelectedItem();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isLinkQuery", (Object)"true");
        uiContext.put((Object)"schmInfo", (Object)autoCheckSchmInfo);
        uiContext.put((Object)"periodType", (Object)((RptPeriodTypeEnum)this.periodType.getSelectedItem()));
        uiContext.put((Object)"currency", (Object)((CurrencyInfo)this.currency.getSelectedItem()));
        uiContext.put((Object)"year", (Object)this.year.getIntegerVlaue());
        uiContext.put((Object)"period", (Object)this.period.getIntegerVlaue());
        uiContext.put((Object)"diffType", (Object)this.filterCondition.getDiffType());
        uiContext.put((Object)"diffAmount", (Object)this.filterCondition.getDiffAmount());
        uiContext.put((Object)"isOnlyDiffShow", (Object)isOnlyDiffShow);
        if (ownCompany != null) {
            uiContext.put((Object)"company", (Object)ownCompany);
        }
        if (tarOrgUnitInfo != null) {
            uiContext.put((Object)"tarCompany", (Object)tarOrgUnitInfo);
        }
        if (isSelectRoot) {
            uiContext.put((Object)"isSelectRoot", (Object)"true");
            if (schmCompanyCol != null && !schmCompanyCol.isEmpty()) {
                uiContext.put((Object)"schmCompanyCol", (Object)schmCompanyCol);
            }
        }
        uiContext.put((Object)"itemType", (Object)((ItemTypeEnum)((Object)this.itemType.getSelectedItem())));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
        IUIWindow window = uiFactory.create(AccountCheckWorktableUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
    }

    private void linkToGroupCheckageListUI(String companyId, Boolean isDiffZero) {
        try {
            CheckageFilterInfo filterInfo = this.getCommonFilter();
            if (filterInfo != null) {
                PermissionHelper.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(filterInfo.orgUnitId), (String)"csl_groupCheckage_view");
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"filterInfo", (Object)filterInfo);
                uiContext.put((Object)"orgTreeInfo", (Object)((OrgTreeInfo)this.orgTree.getUserObject()));
                FullOrgUnitInfo unitInfo = this.getLastSelectNode();
                uiContext.put((Object)"orgUnitInfo", (Object)unitInfo);
                if (companyId != null) {
                    uiContext.put((Object)"ownCompany", (Object)FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select id,number,name where id='" + companyId + "'"));
                }
                if (isDiffZero != null) {
                    uiContext.put((Object)"isDiffZero", (Object)isDiffZero);
                }
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                IUIWindow window = uiFactory.create(GroupCheckageListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                window.show();
            }
        }
        catch (Exception e) {
            logger.error((Object)"linkToGroupCheckageListUI error.", (Throwable)e);
            this.handUIException(e);
        }
    }

    private void linkToEliminationListUI() {
        this.toCheckageListUI(null, null, null);
    }

    private void toCheckageListUI(String ownCompanyId, String targetCompanyId, Boolean isDiffZero) {
        try {
            UIContext uiContext = new UIContext((Object)this);
            FullOrgUnitInfo unitInfo = this.getLastSelectNode();
            if (unitInfo != null) {
                uiContext.put((Object)"orgBound", (Object)((OrgTreeInfo)this.orgTree.getUserObject()));
                uiContext.put((Object)"year", (Object)this.year.getIntegerVlaue());
                uiContext.put((Object)"period", (Object)this.period.getIntegerVlaue());
                uiContext.put((Object)"date", (Object)RPTDateUtil.getPeriodLastDate((int)this.year.getIntegerVlaue(), (int)this.period.getIntegerVlaue(), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.periodType.getSelectedItem())));
                uiContext.put((Object)"periodType", (Object)((RptPeriodTypeEnum)this.periodType.getSelectedItem()));
                uiContext.put((Object)"orgUnit", (Object)unitInfo);
                uiContext.put((Object)"currency", (Object)((CurrencyInfo)this.currency.getSelectedItem()));
                if (isDiffZero != null) {
                    uiContext.put((Object)"isDiffZero", (Object)isDiffZero);
                }
                if (ownCompanyId != null) {
                    uiContext.put((Object)"ownCompany", (Object)FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select id,name,number where id='" + ownCompanyId + "'"));
                }
                IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(EliminationListUI.class.getName(), (Map)uiContext, null);
                iUIWindow.show();
            }
        }
        catch (Exception e) {
            logger.error((Object)"linkToEliminationListUI error.", (Throwable)e);
            this.handUIException(e);
        }
    }

    private CheckageFilterInfo getCommonFilter() {
        FullOrgUnitInfo unitInfo = this.getLastSelectNode();
        if (unitInfo != null && unitInfo.getId() != null) {
            CheckageFilterInfo filterInfo = new CheckageFilterInfo();
            filterInfo.autoCheckSchmId = this.schmId;
            filterInfo.periodType = ((RptPeriodTypeEnum)this.periodType.getSelectedItem()).getValue();
            filterInfo.year = this.year.getIntegerVlaue();
            filterInfo.period = this.period.getIntegerVlaue();
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTree.getUserObject();
            if (orgTreeInfo != null) {
                filterInfo.treeId = orgTreeInfo.getId().toString();
            }
            filterInfo.orgUnitId = unitInfo.getId().toString();
            filterInfo.currencyId = ((CurrencyInfo)this.currency.getSelectedItem()).getId().toString();
            return filterInfo;
        }
        return null;
    }

    private FullOrgUnitInfo getLastSelectNode() {
        DefaultKingdeeTreeNode currt_node;
        if (this.treeMain.getSelectionPath() != null && (currt_node = (DefaultKingdeeTreeNode)this.treeMain.getSelectionPath().getLastPathComponent()) != null) {
            return ((OrgStructureInfo)currt_node.getUserObject()).getUnit();
        }
        return null;
    }

    protected void chkIncludeChild_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIncludeChild_itemStateChanged(e);
    }
}

