/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractBatchReconciliationToleranceSettingEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ChooseAccountMappingUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ChooseRecociliationOrgUI;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BatchReconciliationToleranceSettingEditUI
extends AbstractBatchReconciliationToleranceSettingEditUI {
    private static final long serialVersionUID = 5990704635489504059L;
    private static final Logger logger = CoreUIObject.getLogger(BatchReconciliationToleranceSettingEditUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    boolean isCanClose = false;

    public void onLoad() throws Exception {
        this.getUIMenuBar().setVisible(false);
        super.onLoad();
        this.initToleranceValue();
        this.initTable();
    }

    private void initToleranceValue() {
        this.txtValue.setMinimumValue((Comparable)new BigDecimal("000000000000000.000000"));
        this.txtValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
    }

    private void initTable() {
        this.tblOrg.checkParsed();
        this.tblOrg.getStyleAttributes().setLocked(true);
        this.tblOrg.getSelectManager().setSelectMode(10);
        this.tblMapping.checkParsed();
        this.tblMapping.getStyleAttributes().setLocked(true);
        this.tblMapping.getSelectManager().setSelectMode(10);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnDelOrg_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblOrg);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblOrg);
        int size = selectRows.length;
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                int index = selectRows[i];
                this.tblOrg.removeRow(index);
            }
        }
    }

    private void checkSelected(KDTable tbl) {
        if (tbl.getRowCount() == 0 || tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnAddOrg_actionPerformed(ActionEvent e) throws Exception {
        List<FullOrgUnitInfo> datas;
        UIContext uiCtx = new UIContext((Object)this);
        List<FullOrgUnitInfo> orgs = this.getOrgs();
        uiCtx.put((Object)"orgs", orgs);
        uiCtx.put((Object)"isOrg", (Object)true);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChooseRecociliationOrgUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        uiWindow.show();
        boolean isCancel = ((ChooseRecociliationOrgUI)uiWindow.getUIObject()).isCancel();
        if (!isCancel && (datas = ((ChooseRecociliationOrgUI)uiWindow.getUIObject()).getData()) != null && !datas.isEmpty()) {
            for (FullOrgUnitInfo org : datas) {
                if (orgs == null || orgs.contains(org)) continue;
                this.initOrgTable(org);
            }
        }
    }

    @Override
    protected void btnAddTarOrg_actionPerformed(ActionEvent e) throws Exception {
        List<FullOrgUnitInfo> datas;
        UIContext uiCtx = new UIContext((Object)this);
        List<FullOrgUnitInfo> orgs = this.getTarOrgs();
        uiCtx.put((Object)"orgs", orgs);
        uiCtx.put((Object)"isOrg", (Object)false);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChooseRecociliationOrgUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        uiWindow.show();
        boolean isCancel = ((ChooseRecociliationOrgUI)uiWindow.getUIObject()).isCancel();
        if (!isCancel && (datas = ((ChooseRecociliationOrgUI)uiWindow.getUIObject()).getData()) != null && !datas.isEmpty()) {
            for (FullOrgUnitInfo org : datas) {
                if (orgs == null || orgs.contains(org)) continue;
                this.initTarOrgTable(org);
            }
        }
    }

    @Override
    protected void btnDelTarOrg_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblTarOrg);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblTarOrg);
        int size = selectRows.length;
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                int index = selectRows[i];
                this.tblTarOrg.removeRow(index);
            }
        }
    }

    private List<FullOrgUnitInfo> getOrgs() {
        ArrayList<FullOrgUnitInfo> orgs = new ArrayList<FullOrgUnitInfo>();
        int size = this.tblOrg.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblOrg.getRow(i);
            FullOrgUnitInfo org = (FullOrgUnitInfo)row.getUserObject();
            orgs.add(org);
        }
        return orgs;
    }

    private List<FullOrgUnitInfo> getTarOrgs() {
        ArrayList<FullOrgUnitInfo> orgs = new ArrayList<FullOrgUnitInfo>();
        int size = this.tblTarOrg.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblTarOrg.getRow(i);
            FullOrgUnitInfo org = (FullOrgUnitInfo)row.getUserObject();
            orgs.add(org);
        }
        return orgs;
    }

    private void initOrgTable(FullOrgUnitInfo org) {
        String orgId = org.getId().toString();
        String number = org.getNumber();
        String name = org.getName();
        IRow row = this.tblOrg.addRow();
        row.setUserObject((Object)org);
        row.getCell("orgId").setValue((Object)orgId);
        row.getCell("orgNumber").setValue((Object)number);
        row.getCell("orgName").setValue((Object)name);
    }

    private void initTarOrgTable(FullOrgUnitInfo tarOrg) {
        String orgId = tarOrg.getId().toString();
        String number = tarOrg.getNumber();
        String name = tarOrg.getName();
        IRow row = this.tblTarOrg.addRow();
        row.setUserObject((Object)tarOrg);
        row.getCell("tarOrgID").setValue((Object)orgId);
        row.getCell("tarOrgNum").setValue((Object)number);
        row.getCell("tarOrgName").setValue((Object)name);
    }

    @Override
    protected void btnAddMapping_actionPerformed(ActionEvent e) throws Exception {
        List<AccountMapInfo> datas;
        UIContext uiCtx = new UIContext((Object)this);
        HashSet<String> mappingIds = new HashSet<String>();
        ArrayList<AccountMapInfo> mappings = new ArrayList<AccountMapInfo>();
        this.getMappingDatas(mappingIds, mappings);
        uiCtx.put((Object)"mappingIds", mappingIds);
        uiCtx.put((Object)"mappings", mappings);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChooseAccountMappingUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        uiWindow.show();
        boolean isCancel = ((ChooseAccountMappingUI)uiWindow.getUIObject()).isCancel();
        if (!isCancel && (datas = ((ChooseAccountMappingUI)uiWindow.getUIObject()).getData()) != null && !datas.isEmpty()) {
            for (AccountMapInfo accountMap : datas) {
                if (mappings == null || mappings.contains(accountMap)) continue;
                this.initMappingTable(accountMap);
            }
        }
    }

    private void getMappingDatas(Set<String> mappingIds, List<AccountMapInfo> mappings) {
        int size = this.tblMapping.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMapping.getRow(i);
            String id = (String)row.getCell("mappingId").getValue();
            AccountMapInfo accountMap = (AccountMapInfo)row.getUserObject();
            if (mappingIds != null) {
                mappingIds.add(id);
            }
            mappings.add(accountMap);
        }
    }

    private void initMappingTable(AccountMapInfo accountMap) {
        String id = accountMap.getId().toString();
        String number = accountMap.getNumber();
        ItemTypeEnum itemType = accountMap.getItemType();
        ElimTypeEnum elimType = accountMap.getElimType();
        IRow row = this.tblMapping.addRow();
        row.setUserObject((Object)accountMap);
        row.getCell("mappingId").setValue((Object)id);
        row.getCell("mappingNumber").setValue((Object)number);
        row.getCell("mappingItemType").setValue((Object)itemType);
        row.getCell("mappingElimType").setValue((Object)elimType);
    }

    @Override
    protected void btnDelMapping_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblMapping);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMapping);
        int size = selectRows.length;
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                int index = selectRows[i];
                this.tblMapping.removeRow(index);
            }
        }
    }

    private void verify() {
        ToleranceTypeEnum toleranceTypeEnum;
        int size;
        if (StringUtils.isEmpty((String)this.txtValue.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"506_toleranceNull"));
            SysUtil.abort();
        }
        if ((size = this.tblOrg.getRowCount()) == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"504_orgNull"));
            SysUtil.abort();
        }
        if (0 == (toleranceTypeEnum = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem())).getValue() && (size = this.tblMapping.getRowCount()) == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"505_mappingNull"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        List<FullOrgUnitInfo> orgs = this.getOrgs();
        List<FullOrgUnitInfo> tarOrgs = this.getTarOrgs();
        ArrayList<AccountMapInfo> mappings = new ArrayList<AccountMapInfo>();
        ToleranceTypeEnum toleranceType = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem());
        if (toleranceType.getValue() == 0) {
            this.getMappingDatas(null, mappings);
        }
        if (toleranceType.getValue() == 0 && orgs != null && !orgs.isEmpty() && mappings != null && !mappings.isEmpty() || toleranceType.getValue() == 1 && orgs != null && !orgs.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            ToleranceInfo tolerance = null;
            String value = this.txtValue.getStringValue();
            BigDecimal toleranceValue = new BigDecimal(value);
            String remark = this.txtRemark.getText();
            Set<String> keys = null;
            HashSet<String> tarKeys = null;
            if (toleranceType.getValue() == 0) {
                keys = new HashSet<String>();
                tarKeys = new HashSet<String>();
                this.getOneKeys(keys, tarKeys);
            } else {
                keys = this.getAllKeys();
            }
            StringBuffer detail = new StringBuffer();
            String key = null;
            HashSet<String> msgSet = null;
            StringBuffer sDetail = null;
            for (FullOrgUnitInfo org : orgs) {
                String orgId;
                if (toleranceType.getValue() == 0) {
                    orgId = org.getId().toString();
                    if (tarOrgs != null && !tarOrgs.isEmpty()) {
                        msgSet = new HashSet<String>();
                        for (FullOrgUnitInfo tarOrg : tarOrgs) {
                            String tarOrgId = tarOrg.getId().toString();
                            for (AccountMapInfo accountMap : mappings) {
                                String accountMapId = accountMap.getId().toString();
                                key = orgId + tarOrgId + accountMapId;
                                if (tarKeys != null && tarKeys.contains(key)) {
                                    sDetail = new StringBuffer();
                                    String orgName = org.getName();
                                    String tarOrgName = tarOrg.getName();
                                    String mappingNumber = accountMap.getNumber();
                                    String itemType = accountMap.getItemType().getAlias();
                                    sDetail.append(orgName).append("-").append(tarOrgName).append("-").append(itemType).append("-").append(mappingNumber).append(" \n");
                                    if (msgSet.contains(sDetail.toString())) continue;
                                    detail.append(orgName).append("-").append(tarOrgName).append("-").append(itemType).append("-").append(mappingNumber).append(" \n");
                                    msgSet.add(sDetail.toString());
                                    continue;
                                }
                                if (!this.isCanAdd(orgId, tarOrgId, accountMapId, colls)) continue;
                                tolerance = new ToleranceInfo();
                                tolerance.setOrgUnit(org);
                                tolerance.setTarOrgUnit(tarOrg);
                                tolerance.setAccountMap(accountMap);
                                tolerance.setValue(toleranceValue);
                                tolerance.setToleranceType(toleranceType);
                                tolerance.setRemark(remark);
                                colls.add((CoreBaseInfo)tolerance);
                            }
                        }
                        continue;
                    }
                    for (AccountMapInfo accountMap : mappings) {
                        String accountMapId = accountMap.getId().toString();
                        key = orgId + accountMapId;
                        if (keys.contains(key)) {
                            String orgName = org.getName();
                            String mappingNumber = accountMap.getNumber();
                            String itemType = accountMap.getItemType().getAlias();
                            detail.append(orgName).append("-").append(itemType).append("-").append(mappingNumber).append("\n");
                            continue;
                        }
                        tolerance = new ToleranceInfo();
                        tolerance.setOrgUnit(org);
                        tolerance.setAccountMap(accountMap);
                        tolerance.setValue(toleranceValue);
                        tolerance.setToleranceType(toleranceType);
                        tolerance.setRemark(remark);
                        colls.add((CoreBaseInfo)tolerance);
                    }
                    continue;
                }
                orgId = org.getId().toString();
                if (keys.contains(orgId)) {
                    String orgName = org.getName();
                    detail.append(orgName).append("\n");
                    continue;
                }
                tolerance = new ToleranceInfo();
                tolerance.setOrgUnit(org);
                tolerance.setValue(toleranceValue);
                tolerance.setToleranceType(toleranceType);
                tolerance.setRemark(remark);
                colls.add((CoreBaseInfo)tolerance);
            }
            ToleranceFactory.getRemoteInstance().submit(colls);
            if (detail.length() > 0) {
                String title = EASResource.getString((String)RES, (String)"538_partAdd");
                String subTitle = null;
                subTitle = toleranceType.getValue() == 0 ? (tarOrgs != null && !tarOrgs.isEmpty() ? EASResource.getString((String)RES, (String)"547_subOne") : EASResource.getString((String)RES, (String)"539_subOne")) : EASResource.getString((String)RES, (String)"540_subAllTitle");
                StringBuffer msg = new StringBuffer();
                msg.append(subTitle).append("\n").append(detail);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)msg.toString(), (int)8188);
            } else {
                String success = EASResource.getString((String)RES, (String)"537_allAdd");
                MsgBox.showInfo((Component)((Object)this), (String)success);
            }
            this.actionAddNew_actionPerformed(e);
            this.isCanClose = true;
        }
    }

    private boolean isCanAdd(String orgId, String tarOrgId, String mappingId, CoreBaseCollection colls) {
        if (colls != null && !colls.isEmpty()) {
            for (ToleranceInfo tolerance : colls) {
                String orgUnitId = tolerance.getOrgUnit().getId().toString();
                String tarOrgUnitId = tolerance.getTarOrgUnit().getId().toString();
                String mId = tolerance.getAccountMap().getId().toString();
                if (!orgUnitId.equals(tarOrgId) || !tarOrgUnitId.equals(orgId) || !mId.equals(mappingId)) continue;
                return false;
            }
        }
        return true;
    }

    private Set<String> getAllKeys() throws BOSException {
        HashSet<String> keys = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("toleranceType", (Object)1));
        ToleranceCollection tolerances = ToleranceFactory.getRemoteInstance().getToleranceCollection(view);
        Iterator it = tolerances.iterator();
        while (it.hasNext()) {
            ToleranceInfo tolerance = (ToleranceInfo)it.next();
            String orgId = tolerance.getOrgUnit().getId().toString();
            keys.add(orgId);
        }
        return keys;
    }

    private void getOneKeys(Set<String> keys, Set<String> tarKeys) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("toleranceType", (Object)0));
        ToleranceCollection tolerances = ToleranceFactory.getRemoteInstance().getToleranceCollection(view);
        Iterator it = tolerances.iterator();
        StringBuffer key = null;
        while (it.hasNext()) {
            key = new StringBuffer();
            ToleranceInfo tolerance = (ToleranceInfo)it.next();
            String orgId = tolerance.getOrgUnit().getId().toString();
            String mappingId = tolerance.getAccountMap().getId().toString();
            if (tolerance.getTarOrgUnit() != null) {
                String tarOrgId = tolerance.getTarOrgUnit().getId().toString();
                key.append(orgId).append(tarOrgId).append(mappingId);
                tarKeys.add(key.toString());
                key = new StringBuffer();
                key.append(tarOrgId).append(orgId).append(mappingId);
                tarKeys.add(key.toString());
                continue;
            }
            key.append(orgId);
            key.append(mappingId);
            keys.add(key.toString());
        }
    }

    @Override
    protected void combDefine_itemStateChanged(ItemEvent e) throws Exception {
        ToleranceTypeEnum toleranceType = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem());
        if (toleranceType.getValue() == 1) {
            this.btnAddMapping.setEnabled(false);
            this.btnDelMapping.setEnabled(false);
            this.tblMapping.removeRows();
            this.btnAddTarOrg.setEnabled(false);
            this.btnDelTarOrg.setEnabled(false);
            this.tblTarOrg.removeRows();
        } else {
            this.btnAddMapping.setEnabled(true);
            this.btnDelMapping.setEnabled(true);
            this.btnAddTarOrg.setEnabled(true);
            this.btnDelTarOrg.setEnabled(true);
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.txtValue.setText(null);
        this.txtValue.setValue(null);
        this.combDefine.setSelectedIndex(0);
        this.txtRemark.setText(null);
        this.btnAddMapping.setEnabled(true);
        this.btnDelMapping.setEnabled(true);
        this.tblOrg.removeRows();
        this.tblMapping.removeRows();
        this.tblTarOrg.removeRows();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    public boolean destroyWindow() {
        Object owner;
        boolean b = super.destroyWindow();
        if (b && (owner = this.getUIContext().get("Owner")) instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return b;
    }

    protected boolean checkBeforeWindowClosing() {
        block11: {
            ToleranceTypeEnum toleranceType = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem());
            int orgSize = this.tblOrg.getRowCount();
            int mappingSize = this.tblMapping.getRowCount();
            boolean isClose = true;
            if (!StringUtils.isEmpty((String)this.txtValue.getText()) || !StringUtils.isEmpty((String)this.txtRemark.getText())) {
                isClose = false;
            } else if (toleranceType.getValue() != 0) {
                isClose = false;
            } else if (orgSize > 0 || mappingSize > 0) {
                isClose = false;
            }
            if (!isClose) {
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"542_closeConfirm"));
                if (result == 0) {
                    try {
                        this.actionSubmit_actionPerformed(null);
                        if (this.isCanClose) {
                            return super.checkBeforeWindowClosing();
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (result == 1) {
                    return super.checkBeforeWindowClosing();
                }
            }
        }
        return super.checkBeforeWindowClosing();
    }
}

