/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CompanyStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.SubmitFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractCheckageBillDataSubmitUI;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class CheckageBillDataSubmitUI
extends AbstractCheckageBillDataSubmitUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckageBillDataSubmitUI.class);
    private boolean isSubmit = true;
    private SubmitFilterInfo filterInfo = new SubmitFilterInfo();
    private String initSearchStr = null;
    private String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    private int tempCriticalNum = 50;

    public CheckageBillDataSubmitUI() throws Exception {
        try {
            this.tempCriticalNum = Integer.parseInt(CSLParamUtil.getStringCslParamValue(null, (String)"CHECKAGEBILLTEMPCRITICALNUM"));
        }
        catch (Exception ee) {
            logger.error((Object)"CHECKAGEBILLTEMPCRITICALNUM error.", (Throwable)ee);
        }
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public void onLoad() throws Exception {
        this.isSubmit = "true".equals(this.getUIContext().get("isSubmit"));
        this.initFilter();
        this.initControls();
        this.initOrgUnitField();
        this.initTblMain();
        super.onLoad();
    }

    private void initTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
    }

    private void initControls() throws Exception {
        this.menuBar.setVisible(false);
        if (this.isSubmit) {
            this.btnSubmit.setVisible(true);
            this.btnUnSubmit.setVisible(false);
            this.kDLabelContainer4.setVisible(false);
            this.remove((Component)this.kdOrgUnitField);
            this.kdOrgUnitField.setBounds(new Rectangle(550, 10, 377, 19));
            this.add((Component)this.kdOrgUnitField, new KDLayout.Constraints(550, 10, 377, 19, 385));
        } else {
            this.setUITitle(AccountCheckUtil.getResourceString(null, "checkDataUnSubmit", null));
            this.btnSubmit.setVisible(false);
            this.btnUnSubmit.setVisible(true);
        }
        CslRptUIUtil.setSpineRange((KDSpinner)this.kdYear, (int)1900, (int)2999, (boolean)true, (boolean)true);
        this.kdYear.setValue((Object)this.filterInfo.getYear(), false);
        CslRptUIUtil.setSpineRange((KDSpinner)this.kdPeriod, (int)1, (int)366, (boolean)true, (boolean)true);
        this.kdPeriod.setValue((Object)this.filterInfo.getPeriod(), false);
        CurrencyCollection currencyCol = InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC();
        this.kdCurrency.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)currencyCol));
        CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select id,number,name,precision where id='" + this.filterInfo.getCurrencyId() + "'");
        if (currencyCollection != null && !currencyCollection.isEmpty()) {
            this.kdCurrency.setSelectedItem((Object)currencyCollection.get(0));
        }
        this.kdCompanyStatus.addItem((Object)this.selectAll);
        this.kdCompanyStatus.addItem((Object)CompanyStatusEnum.commited);
        this.kdCompanyStatus.addItem((Object)CompanyStatusEnum.locked);
        this.kdCompanyStatus.setSelectedIndex(0);
        this.kdCompanyStatus.setSelectedIndex(0);
    }

    private void initOrgUnitField() {
        if (this.initSearchStr == null) {
            this.initSearchStr = this.kdOrgUnitField.getText();
        }
        this.kdOrgUnitField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CheckageBillDataSubmitUI.this.initSearchStr != null && CheckageBillDataSubmitUI.this.initSearchStr.equals(CheckageBillDataSubmitUI.this.kdOrgUnitField.getText())) {
                    CheckageBillDataSubmitUI.this.kdOrgUnitField.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (StringUtils.isEmpty((String)CheckageBillDataSubmitUI.this.kdOrgUnitField.getText())) {
                    CheckageBillDataSubmitUI.this.kdOrgUnitField.setText(CheckageBillDataSubmitUI.this.initSearchStr);
                }
            }
        });
    }

    private void initFilter() {
        this.filterInfo.clear();
        this.filterInfo.setYear((Integer)this.getUIContext().get("year"));
        this.filterInfo.setPeriod((Integer)this.getUIContext().get("period"));
        this.filterInfo.setCurrencyId((String)this.getUIContext().get("currencyId"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void kDQuery_actionPerformed(ActionEvent e) throws Exception {
        this.queryData(e);
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    protected void btnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.FALSE);
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        Map mapInfo = this.getSelectedMap();
        Set companyIDSet = (Set)mapInfo.get("companyIdSet");
        if (companyIDSet == null || companyIDSet.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "isSubmitCheckData", null)))) {
            return;
        }
        StringBuilder infoSb = new StringBuilder();
        this.checkPermission(companyIDSet, null, "csl_checkwork_sumbit", infoSb);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (!companyIDSet.isEmpty()) {
            paramMap.put("companyIDSet", companyIDSet);
            paramMap.put("filterInfo", this.filterInfo);
            paramMap.put("tempCriticalNum", this.tempCriticalNum);
            Map resultMap = AccountCheckFacadeFactory.getRemoteInstance().submitCheckageBillData(paramMap, true);
            if (resultMap.containsKey("isEmpty")) {
                return;
            }
            if (resultMap.containsKey("infoSb")) {
                infoSb.append(resultMap.get("infoSb"));
            }
        }
        if (infoSb.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "submitCheckDataFailSome", null), (String)infoSb.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)AccountCheckUtil.getResourceString(null, "submitCheckDataSuccess", null));
        }
        this.queryData(null);
    }

    @Override
    protected void btnUnSubmit_actionPerformed(ActionEvent e) throws Exception {
        Map mapInfo = this.getSelectedMap();
        Set companyIDSet = (Set)mapInfo.get("companyIdSet");
        if (companyIDSet == null || companyIDSet.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "isUnSubmitCheckData", null)))) {
            return;
        }
        Map companyAndIdMap = (Map)mapInfo.get("companyAndIdMap");
        StringBuilder infoSb = new StringBuilder();
        this.checkPermission(companyIDSet, companyAndIdMap, "csl_checkwork_unSumbit", infoSb);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (!companyAndIdMap.isEmpty()) {
            paramMap.put("companyAndIdMap", companyAndIdMap);
            paramMap.put("tempCriticalNum", this.tempCriticalNum);
            Map resultMap = AccountCheckFacadeFactory.getRemoteInstance().submitCheckageBillData(paramMap, false);
            if (resultMap.containsKey("infoSb")) {
                infoSb.append(resultMap.get("infoSb"));
            }
        }
        if (infoSb.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "unSubmitCheckDataFailSome", null), (String)infoSb.toString(), (int)1);
        }
        this.queryData(null);
    }

    private Map getSelectedMap() {
        HashMap<String, Cloneable> mapInfo = new HashMap<String, Cloneable>();
        HashSet<String> companyIdSet = new HashSet<String>();
        HashMap<String, String> companyAndIdMap = new HashMap<String, String>();
        for (int i = 0; i < this.tblMain.getExpandedRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell("select").getValue())) continue;
            companyIdSet.add((String)row.getCell("companyID").getValue());
            companyAndIdMap.put((String)row.getCell("companyID").getValue(), (String)row.getCell("id").getValue());
        }
        if (!companyIdSet.isEmpty()) {
            mapInfo.put("companyIdSet", companyIdSet);
        }
        if (!companyAndIdMap.isEmpty()) {
            mapInfo.put("companyAndIdMap", companyAndIdMap);
        }
        return mapInfo;
    }

    private void checkPermission(Set<String> companyOrgIdSet, Map<String, String> companyAndIdMap, String permission, StringBuilder noPermissionSbInfo) {
        if (!StringUtils.isEmpty((String)permission) && !companyOrgIdSet.isEmpty()) {
            IObjectPK[] pkArray = new IObjectPK[companyOrgIdSet.size()];
            int i = 0;
            for (String companyId : companyOrgIdSet) {
                pkArray[i++] = new ObjectUuidPK(companyId);
            }
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            CompanyOrgUnitCollection noPermissionCompanyOrgUnitCollection = null;
            try {
                Set havePermissionOrgSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, pkArray, permission);
                HashSet<String> noPermissionOrgSet = new HashSet<String>(companyOrgIdSet);
                noPermissionOrgSet.removeAll(havePermissionOrgSet);
                if (!noPermissionOrgSet.isEmpty()) {
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    view.setSelector(sic);
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", noPermissionOrgSet, CompareType.INCLUDE));
                    view.setFilter(filterInfo);
                    noPermissionCompanyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                    companyOrgIdSet.removeAll(noPermissionOrgSet);
                    if (companyAndIdMap != null && !companyAndIdMap.isEmpty()) {
                        for (String company : noPermissionOrgSet) {
                            companyAndIdMap.remove(company);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"checkPermission error.", (Throwable)e);
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            if (noPermissionCompanyOrgUnitCollection != null && !noPermissionCompanyOrgUnitCollection.isEmpty()) {
                this.packInfo(noPermissionCompanyOrgUnitCollection, noPermissionSbInfo, permission);
            }
        }
    }

    private void packInfo(CompanyOrgUnitCollection noPermissionCompanyOrgUnitCollection, StringBuilder noPermissionSbInfo, String permission) {
        String permissionTitle = null;
        if ("csl_checkwork_sumbit".equals(permission)) {
            permissionTitle = AccountCheckUtil.getResourceString(null, "haveNoSubmitPermission", null);
        } else if ("csl_checkwork_unSumbit".equals(permission)) {
            permissionTitle = AccountCheckUtil.getResourceString(null, "haveNoUnSubmitPermission", null);
        }
        noPermissionSbInfo.append(permissionTitle).append("\n");
        for (int i = 0; i < noPermissionCompanyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = noPermissionCompanyOrgUnitCollection.get(i);
            noPermissionSbInfo.append(companyOrgUnitInfo.getNumber()).append("-").append(companyOrgUnitInfo.getName());
            noPermissionSbInfo.append("\n");
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.queryData(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.queryData(e);
    }

    private void queryData(ActionEvent e) throws EASBizException, BOSException {
        this.tblMain.removeRows();
        this.initQueryFilter();
        List rowDatas = AccountCheckFacadeFactory.getRemoteInstance().getCheckageCompanyList(this.filterInfo);
        if (rowDatas != null && !rowDatas.isEmpty()) {
            this.insertRows(rowDatas, this.tblMain);
        }
    }

    private void insertRows(List rowDatas, KDTable table) {
        table.setRefresh(false);
        int z = rowDatas.size();
        for (int i = 0; i < z; ++i) {
            Map infoMap = (Map)rowDatas.get(i);
            IRow addRow = this.tblMain.addRow(0);
            addRow.getCell("select").setValue((Object)false);
            addRow.getCell("companyNumber").setValue(infoMap.get("companyNumber"));
            addRow.getCell("companyName").setValue(infoMap.get("companyName"));
            addRow.getCell("submitor").setValue(infoMap.get("submitor"));
            addRow.getCell("submitTime").setValue(infoMap.get("submitTime"));
            addRow.getCell("status").setValue(infoMap.get("status"));
            addRow.getCell("id").setValue(infoMap.get("id"));
            addRow.getCell("companyID").setValue(infoMap.get("companyID"));
        }
        table.setRowCount(rowDatas.size());
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    private void initQueryFilter() {
        Object status;
        this.filterInfo.clear();
        this.filterInfo.setYear(this.kdYear.getIntegerVlaue());
        this.filterInfo.setPeriod(this.kdPeriod.getIntegerVlaue());
        this.filterInfo.setCurrencyId(((CurrencyInfo)this.kdCurrency.getSelectedItem()).getId().toString());
        this.filterInfo.setSubmit(this.isSubmit);
        if (!StringUtils.isEmpty((String)this.kdOrgUnitField.getText()) && !this.kdOrgUnitField.getText().equals(this.initSearchStr)) {
            this.filterInfo.setSearchStr(this.kdOrgUnitField.getText());
        }
        if (!this.selectAll.equals(status = this.kdCompanyStatus.getSelectedItem())) {
            this.filterInfo.setStatus((CompanyStatusEnum)((Object)this.kdCompanyStatus.getSelectedItem()));
        }
        this.filterInfo.setTempCriticalNum(this.tempCriticalNum);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("submitor").getStyleAttributes().setHided(this.isSubmit);
        this.tblMain.getColumn("submitTime").getStyleAttributes().setHided(this.isSubmit);
        this.tblMain.getColumn("status").getStyleAttributes().setHided(this.isSubmit);
    }
}

