/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractCheckageOrgUnitF7UI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CheckageOrgUnitF7UI
extends AbstractCheckageOrgUnitF7UI {
    private static final Logger logger = CoreUIObject.getLogger(CheckageOrgUnitF7UI.class);
    private static final String ORG_F7_RESOURCE_PATH = "com.kingdee.eas.basedata.org.client.OrgF7Resource";
    private boolean isCancel = true;
    private final int criticalNum = 10000;
    private Set selectedOrgIDs = new HashSet();
    private Collection selectedOrgs = new ArrayList();
    private FilterInfo searchFilter = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblSelected.checkParsed();
        this.initComponent();
        this.getParamFromUIContext();
    }

    private void getParamFromUIContext() throws Exception {
        if (this.getUIContext().get("selectedOrgIds") != null) {
            this.selectedOrgIDs = (Set)this.getUIContext().get("selectedOrgIds");
            if (this.selectedOrgIDs.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.selectedOrgIDs, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                IQueryExecutor iexec = this.getQueryExecutor(this.checkageOrgUnitF7QueryPK, viewInfo);
                IRowSet rs = iexec.executeQuery();
                while (rs.next()) {
                    FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)rs.getString("id")));
                    orgUnitInfo.setName(rs.getString("unit.name"));
                    orgUnitInfo.setNumber(rs.getString("unit.number"));
                    this.selectedOrgs.add(orgUnitInfo);
                }
                this.fillDataToSelectTable();
            }
        } else {
            this.selectedOrgs.clear();
        }
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            long t2 = System.currentTimeMillis();
            this.checkageOrgUnitF7Query = this.getEntityViewInfo();
            logger.error((Object)("getEntityView cost: " + (System.currentTimeMillis() - t2)));
            logger.error((Object)("querySQL is: " + this.checkageOrgUnitF7Query.toString()));
            if (this.checkageOrgUnitF7Query != null) {
                FilterInfo filter = this.checkageOrgUnitF7Query.getFilter();
                if (filter != null && this.searchFilter != null && !this.searchFilter.getFilterItems().isEmpty()) {
                    filter.mergeFilter(this.searchFilter, "and");
                }
                long t1 = System.currentTimeMillis();
                int start = (Integer)e.getParam1();
                int length = (Integer)e.getParam2() - start + 1;
                try {
                    IQueryExecutor exec = this.getQueryExecutor(this.checkageOrgUnitF7QueryPK, this.checkageOrgUnitF7Query);
                    IRowSet rowSet = exec.executeQuery(start, length);
                    e.setRowSet(rowSet);
                    this.onGetRowSet(rowSet);
                }
                catch (Exception ee) {
                    this.handUIException(ee);
                }
                logger.info((Object)("tblMain_doRequestRowSet cost: " + (System.currentTimeMillis() - t1)));
            }
            this.tblMain.getSelectManager().setSelectMode(10);
            this.tblSelected.getSelectManager().setSelectMode(10);
            KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)0);
            this.tblMain.getStyleAttributes().setLocked(true);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    private void initComponent() {
        this.kDContainer1.addButton((JButton)this.btnDownSelect);
        this.kDContainer1.addButton((JButton)this.btnUpSelect);
        this.kDContainer1.addButton((JButton)this.btnDownAll);
        this.kDContainer1.addButton((JButton)this.btnUpAll);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public Set getSelectedOrgIDs() {
        return this.selectedOrgIDs;
    }

    public Collection getReturnValue() {
        if (!this.isCancel) {
            return this.selectedOrgs;
        }
        return new HashSet();
    }

    protected String getName(String value) {
        return EASResource.getString((String)ORG_F7_RESOURCE_PATH, (String)value);
    }

    private CoreBaseCollection getCollBySelectedOrgIds(FilterInfo filterInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = this.getSelectorCollection();
        if (sic != null && sic.size() > 0) {
            viewInfo.setSelector(sic);
        }
        return FullOrgUnitFactory.getRemoteInstance().getCollection(viewInfo);
    }

    protected SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private CoreBaseCollection handleOneRow() throws BOSException {
        HashSet<String> tmp = new HashSet<String>();
        int rowNum = this.tblMain.getSelectManager().get().getTop();
        ICell cell = this.tblMain.getRow(rowNum).getCell("id");
        if (cell == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        tmp.add(cell.getValue().toString());
        return this.getCollBySelectedOrgIds(this.buildFilterInfo(tmp));
    }

    private FilterInfo buildFilterInfo(Set selectedKeyValues) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)selectedKeyValues, CompareType.INCLUDE));
        return filter;
    }

    private CoreBaseCollection getSelectedKeyValues() throws BOSException {
        CoreBaseCollection coll = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return coll;
        }
        if (size == 1 && selectRows.length == 1) {
            coll = this.handleOneRow();
        } else {
            ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
            int mode = 0;
            if (blockList != null && blockList.size() == 1) {
                mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
            }
            coll = mode == 8 ? this.handleKeyFieldBySelectedIds() : this.handleMutiRows(selectRows);
        }
        return coll;
    }

    private CoreBaseCollection handleMutiRows(int[] selectRows) throws BOSException {
        CoreBaseCollection result = new CoreBaseCollection();
        if (selectRows != null) {
            int allIdSize = selectRows.length;
            HashSet<String> tmp = new HashSet<String>();
            for (int m = 0; m < allIdSize / 10000 + 1; ++m) {
                int j = (m + 1) * 10000 > allIdSize ? allIdSize : (m + 1) * 10000;
                for (int i = m * 10000; i < j; ++i) {
                    ICell cell = this.tblMain.getRow(selectRows[i]).getCell("id");
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if (cell.getValue() == null) continue;
                    tmp.add(cell.getValue().toString());
                }
                result.addCollection(this.getCollBySelectedOrgIds(this.buildFilterInfo(tmp)));
                tmp.clear();
            }
        }
        return result;
    }

    private CoreBaseCollection handleKeyFieldBySelectedIds() throws BOSException {
        List selectKeyIdFields = this.getQueryPkList();
        CoreBaseCollection result = new CoreBaseCollection();
        if (selectKeyIdFields != null) {
            int allIdSize = selectKeyIdFields.size();
            HashSet<String> tmp = new HashSet<String>();
            for (int m = 0; m < allIdSize / 10000 + 1; ++m) {
                int j = (m + 1) * 10000 > allIdSize ? allIdSize : (m + 1) * 10000;
                for (int i = m * 10000; i < j; ++i) {
                    Object idObj = selectKeyIdFields.get(i);
                    if (idObj == null) continue;
                    tmp.add(idObj.toString());
                }
                result.addCollection(this.getCollBySelectedOrgIds(this.buildFilterInfo(tmp)));
                tmp.clear();
            }
        }
        return result;
    }

    private EntityViewInfo getEntityViewInfo() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        if (this.selectedOrgIDs != null && this.selectedOrgIDs.size() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.selectedOrgIDs, CompareType.NOTINCLUDE));
            viewInfo.getFilter().mergeFilter(filter, "and");
        }
        return viewInfo;
    }

    private List getQueryPkList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            EntityViewInfo entityViewInfo = this.getEntityViewInfo();
            FilterInfo filter = entityViewInfo.getFilter();
            if (this.searchFilter != null && !this.searchFilter.getFilterItems().isEmpty()) {
                filter.mergeFilter(this.searchFilter, "and");
            }
            IQueryExecutor iexec = this.getQueryExecutor(this.checkageOrgUnitF7QueryPK, entityViewInfo);
            IRowSet rs = iexec.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("id"));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return list;
    }

    protected void addDataToSelected() throws BOSException {
        CoreBaseCollection coll = this.getSelectedKeyValues();
        this.fillDataToSelectTable(coll);
    }

    private void fillDataToSelectTable(CoreBaseCollection coll) {
        if (coll != null) {
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                CoreBaseInfo info = coll.get(i);
                if (this.selectedOrgIDs.contains(info.getId().toString())) continue;
                this.selectedOrgIDs.add(info.getId().toString());
                this.selectedOrgs.add(info);
                String[] cellValues = this.getTableCellValues(info);
                this.fullfillRowValue(-1, cellValues);
            }
        }
    }

    protected void fullfillRowValue(int insertPosition, String[] cellValues) {
        if (cellValues != null && cellValues.length == 3) {
            IRow row = null;
            row = -1 == insertPosition ? this.tblSelected.addRow() : this.tblSelected.addRow(insertPosition);
            row.getCell("id").setValue((Object)cellValues[0]);
            row.getCell("orgUnitName").setValue((Object)cellValues[1]);
            row.getCell("orgUnitNumber").setValue((Object)cellValues[2]);
        }
    }

    protected String[] getTableCellValues(CoreBaseInfo info) {
        String[] cellValues = new String[3];
        if (info != null && info.getId() != null) {
            cellValues[0] = info.getId().toString();
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)info;
            cellValues[1] = orgUnit.getNumber();
            cellValues[2] = orgUnit.getName();
        }
        return cellValues;
    }

    @Override
    protected void btnDownSelect_actionPerformed(ActionEvent e) throws Exception {
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i < 0) {
            MsgBox.showInfo((String)this.getName("MutiModeTips"));
            return;
        }
        this.addDataToSelected();
        this.tblMain.refresh();
    }

    @Override
    protected void btnDownAll_actionPerformed(ActionEvent e) throws Exception {
        LongTimeDialog ltd = null;
        Window o = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (o instanceof Dialog) {
            ltd = new LongTimeDialog((Dialog)o);
        } else if (o instanceof Frame) {
            ltd = new LongTimeDialog((Frame)o);
        }
        if (ltd != null) {
            ltd.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    CoreBaseCollection coll = CheckageOrgUnitF7UI.this.handleKeyFieldBySelectedIds();
                    CheckageOrgUnitF7UI.this.fillDataToSelectTable(coll);
                    CheckageOrgUnitF7UI.this.tblMain.refresh();
                    return null;
                }

                public void afterExec(Object arg0) throws Exception {
                }
            });
            ltd.show();
        }
    }

    @Override
    protected void btnUpSelect_actionPerformed(ActionEvent e) throws Exception {
        int i = this.tblSelected.getSelectManager().getActiveRowIndex();
        if (i < 0) {
            MsgBox.showInfo((String)this.getName("MutiModeTips"));
        }
        this.removeDataFromSelected();
        this.afterRemoveDataFromSelected();
        this.tblMain.refresh();
    }

    private void afterRemoveDataFromSelected() throws BOSException {
        this.fillDataToSelectTable();
    }

    private void fillDataToSelectTable() throws BOSException {
        if (this.selectedOrgs != null) {
            this.tblSelected.removeRows();
            for (CoreBaseInfo info : this.selectedOrgs) {
                String[] cellValues = this.getTableCellValues(info);
                this.fullfillRowValue(-1, cellValues);
            }
        }
    }

    private void removeDataFromSelected() {
        HashSet<String> delOrgIdlist = new HashSet<String>();
        int size = this.tblSelected.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblSelected, (IBlock)this.tblSelected.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object obj = this.tblSelected.getRow(j).getCell("id").getValue();
                delOrgIdlist.add(obj.toString());
            }
        }
        this.selectedOrgIDs.removeAll(delOrgIdlist);
        ArrayList<CoreBaseInfo> list = new ArrayList<CoreBaseInfo>();
        for (CoreBaseInfo info : this.selectedOrgs) {
            if (!delOrgIdlist.contains(info.getId().toString())) continue;
            list.add(info);
        }
        this.selectedOrgs.removeAll(list);
    }

    @Override
    protected void btnUpAll_actionPerformed(ActionEvent e) throws Exception {
        HashSet<Object> delOrgIdlist = new HashSet<Object>();
        int j = this.tblSelected.getRowCount();
        for (int i = 0; i < j; ++i) {
            delOrgIdlist.add(this.tblSelected.getRow(i).getCell("id").getValue());
        }
        this.selectedOrgIDs.removeAll(delOrgIdlist);
        ArrayList list = new ArrayList();
        Iterator it = this.selectedOrgs.iterator();
        while (it.hasNext()) {
            CoreBaseInfo info = (CoreBaseInfo)it.next();
            if (!delOrgIdlist.contains(info.getId().toString())) continue;
            it.remove();
        }
        this.tblSelected.removeRows();
        this.tblMain.refresh();
    }

    @Override
    public void kDsearch_actionPerformed(ActionEvent e) throws Exception {
        if (!StringUtils.isEmpty((String)this.searchTxt.getText())) {
            this.searchFilter = new FilterInfo();
            int selectedIndex = this.cmbSearchItem.getSelectedIndex();
            if (selectedIndex == 0) {
                this.searchFilter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)("%" + this.searchTxt.getText().trim() + "%"), CompareType.LIKE));
                this.searchFilter.getFilterItems().add(new FilterItemInfo("unit.name", (Object)("%" + this.searchTxt.getText().trim() + "%"), CompareType.LIKE));
                this.searchFilter.setMaskString("(#0 or #1)");
            } else if (selectedIndex == 1) {
                this.searchFilter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)("%" + this.searchTxt.getText().trim() + "%"), CompareType.LIKE));
            } else if (selectedIndex == 2) {
                this.searchFilter.getFilterItems().add(new FilterItemInfo("unit.name", (Object)("%" + this.searchTxt.getText().trim() + "%"), CompareType.LIKE));
            }
        } else {
            this.searchFilter = null;
        }
        this.tblMain.refresh();
    }

    @Override
    protected void kdConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void kdClose_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }
}

