/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CompanyStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractCheckageStatusListUI;
import com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableFacadeFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CheckageStatusListUI
extends AbstractCheckageStatusListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CheckageStatusListUI.class);
    protected String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    protected OrgTreeCollection orgTreeColl = null;
    protected Date[] curDate = null;
    private boolean isFireOrgTreeChange = true;
    protected CheckageFilterInfo filterInfo = null;
    protected String initSearchStr = null;
    protected Map<String, String> key_sortType = new HashMap<String, String>();
    protected KDTSortManager sm = null;
    protected Map<String, String> colKey_sortKey = new HashMap<String, String>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() throws Exception {
        this.initTblMain();
        this.ckIncludeChild.setSelected(false, false);
        this.curDate = new Date[]{CslRptUIUtil.getLastPeriodDate(null)};
        this.orgTreeColl = CslWorkTableUIUtil.getAllOrgTreeColl();
        AccountCheckUtil.initYearPeriodAndPeriodType(this.kdYear, this.kdPeriod, null, null, this.curDate, null, this.orgTreeColl, this.kdOrgTree, null, null, (ListUI)this);
        AccountCheckUtil.initCurrency(this.kdCurrency);
        this.kdCompanyStatus.insertItemAt((Object)this.selectAll, 0);
        this.kdCompanyStatus.setSelectedIndex(0);
        this.initOrgTree();
        this.initGroupButton();
        this.pnlMain.setOneTouchExpandable(true);
        this.pnlMain.setArrowType(1);
        this.initOrgUnitField();
        this.initSortKeyMap();
    }

    protected void initSortKeyMap() throws Exception {
        String name = "fname_" + SysContext.getSysContext().getLocale();
        this.colKey_sortKey.put("orgUnitName", "pUnit." + name);
        this.colKey_sortKey.put("companyNumber", "unit.fnumber");
        this.colKey_sortKey.put("companyName", "unit." + name);
        this.colKey_sortKey.put("status", "status.fstatus");
        this.colKey_sortKey.put("lastUpdateUser", "pmuser.fnumber");
        this.colKey_sortKey.put("lastUpdateTime", "status.flastupdatetime");
    }

    protected void initOrgUnitField() throws Exception {
        if (this.initSearchStr == null) {
            this.initSearchStr = this.kdOrgUnitField.getText();
        }
        this.kdOrgUnitField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CheckageStatusListUI.this.initSearchStr != null && CheckageStatusListUI.this.initSearchStr.equals(CheckageStatusListUI.this.kdOrgUnitField.getText())) {
                    CheckageStatusListUI.this.kdOrgUnitField.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (StringUtils.isEmpty((String)CheckageStatusListUI.this.kdOrgUnitField.getText())) {
                    CheckageStatusListUI.this.kdOrgUnitField.setText(CheckageStatusListUI.this.initSearchStr);
                }
            }
        });
    }

    protected void initTblMain() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getColumn("orgUnitName").getStyleAttributes().setHided(true);
        this.sm = new KDTSortManager(this.tblMain);
    }

    protected void initOrgTree() throws Exception {
        AccountCheckUtil.refreshOrgTree(this.curDate[0], this.kdOrgTree, this.orgTreeColl, (ListUI)this);
        this.kdOrgTree.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && CheckageStatusListUI.this.isFireOrgTreeChange) {
                    CheckageStatusListUI.this.builderTree(((OrgTreeInfo)CheckageStatusListUI.this.kdOrgTree.getSelectedItem()).getId().toString());
                }
            }
        });
        if (this.kdOrgTree.getItemCount() > 0) {
            AccountCheckUtil.setSelectedFireChanged(this.kdOrgTree, 0);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.refreshCheckageStatusDatas(null);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshCheckageStatusDatas(null);
    }

    protected void initGroupButton() {
        this.treeView.getControlPane().show();
        int count = this.treeView.getControlPane().getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (i <= 0 || i == count - 1 || i == count - 5 || i == count - 6) continue;
            this.treeView.getControlPane().getComponent(i).setVisible(false);
        }
    }

    public void builderTree(String orgTreeId) {
        try {
            OrgStructureCollection orgStructure = null;
            OrgStructureInfo selectUserObj = null;
            if (!StringUtils.isEmpty((String)orgTreeId)) {
                KDTreeNode selectNode = this.getSelectedTreeNode();
                if (selectNode != null) {
                    selectUserObj = (OrgStructureInfo)selectNode.getUserObject();
                }
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("orgTreeId", orgTreeId);
                condition.put("isForOrgTreeF7", "true");
                condition.put("isUnion", "true");
                orgStructure = CslWorkTableFacadeFactory.getRemoteInstance().getOrgUnitTree(condition);
            }
            if (orgStructure != null) {
                CslWorkTableUIUtil.buildTree(this.treeMain, orgStructure, null, false);
                boolean isSelected = false;
                if (selectUserObj != null && orgStructure.get(0).getTree().getNumber().equals(selectUserObj.getTree().getNumber())) {
                    isSelected = this.setSelectTreeNode((KDTreeNode)this.treeMain.getModel().getRoot(), selectUserObj);
                }
                if (!isSelected) {
                    this.treeMain.setSelectionRow(0);
                }
            } else {
                ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
                if (this.tblMain != null) {
                    this.tblMain.removeRows();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"buildTree error.", (Throwable)ex);
            super.handleException(ex);
        }
    }

    protected void initTree() throws Exception {
        this.treeMain.setShowsRootHandles(true);
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.refreshCheckageStatusDatas(null);
    }

    protected void refreshCheckageStatusDatas(String sortStr) throws Exception {
        this.tblMain.removeRows();
        if (this.kdOrgTree.getSelectedItem() == null || this.getSelectOrgUnitId(false) == null) {
            return;
        }
        CheckageFilterInfo filter = this.initFilter(sortStr);
        if (this.filterInfo.isIncludeChild && this.filterInfo.hasPermOrgIds.isEmpty() || !this.filterInfo.isIncludeChild && StringUtils.isEmpty((String)this.filterInfo.orgUnitId)) {
            return;
        }
        List rowDatas = CheckageCompanyStatusFactory.getRemoteInstance().getCheckageStatusList(filter);
        if (rowDatas != null && !rowDatas.isEmpty()) {
            this.insertRows(rowDatas, 0, this.tblMain);
        }
    }

    protected void refreshCheckageStatusByCompany(Map result, boolean isLock) throws Exception {
        Collection handleIds;
        if (result != null && (handleIds = (Collection)result.get("handleIds")) != null && !handleIds.isEmpty()) {
            HashSet ids = new HashSet(handleIds);
            Timestamp timeStamp = (Timestamp)result.get("timeStamp");
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                Object statusId = row.getCell("statusId").getValue();
                if (statusId == null || !ids.contains(statusId)) continue;
                row.getCell("lastUpdateUser").setValue((Object)userInfo.getName());
                row.getCell("lastUpdateTime").setValue((Object)timeStamp);
                row.getCell("status").setValue((Object)(isLock ? CompanyStatusEnum.locked : CompanyStatusEnum.commited));
            }
        }
    }

    private void insertRows(List rows, int insertRowIndex, KDTable table) throws Exception {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        table.setRefresh(false);
        KDTColumns columns = table.getColumns();
        IRow row = null;
        ICell cell = null;
        Object value = null;
        for (int i = 0; i < rows.size(); ++i) {
            Map rowData = (Map)rows.get(i);
            row = table.setRow(insertRowIndex++);
            for (int c = 0; c < columns.size(); ++c) {
                String columnKey = columns.getColumnKey(c);
                cell = row.getCell(columnKey);
                value = rowData.get(columnKey.toUpperCase(Locale.ENGLISH));
                if (columnKey.equalsIgnoreCase("status")) {
                    cell.setValue((Object)CompanyStatusEnum.getEnum(Integer.valueOf(value.toString())));
                    continue;
                }
                cell.setValue(value);
            }
        }
        table.setRowCount(rows.size());
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    protected CheckageFilterInfo initFilter(String sortStr) {
        if (this.filterInfo == null) {
            this.filterInfo = new CheckageFilterInfo();
        }
        this.filterInfo.clear();
        this.filterInfo.year = this.kdYear.getIntegerVlaue();
        this.filterInfo.period = this.kdPeriod.getIntegerVlaue();
        this.filterInfo.currencyId = ((CurrencyInfo)this.kdCurrency.getSelectedItem()).getId().toString();
        this.filterInfo.treeId = ((OrgTreeInfo)this.kdOrgTree.getSelectedItem()).getId().toString();
        this.filterInfo.orgUnitId = this.getSelectOrgUnitId(true);
        this.filterInfo.isIncludeChild = this.ckIncludeChild.isSelected();
        if (this.kdCompanyStatus.getSelectedIndex() > 0) {
            this.filterInfo.status = ((CompanyStatusEnum)((Object)this.kdCompanyStatus.getSelectedItem())).getValue();
        }
        if (!StringUtils.isEmpty((String)this.kdOrgUnitField.getText()) && !this.kdOrgUnitField.getText().equals(this.initSearchStr)) {
            this.filterInfo.orgNumberOrNameFilter = this.kdOrgUnitField.getText();
        }
        this.getIncludeChildOrgUnits(this.filterInfo.hasPermOrgIds);
        this.filterInfo.sortStr = sortStr;
        return this.filterInfo;
    }

    @Override
    public void actionIncludeChildChanged_actionPerformed(ActionEvent e) throws Exception {
        this.refreshCheckageStatusDatas(null);
    }

    @Override
    public void actionCheckageDataLock_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer msg = new StringBuffer();
        List ids = this.checkSelectDatas(msg, true);
        if (ids != null && !ids.isEmpty()) {
            String curMsg;
            Map result = CheckageCompanyStatusFactory.getRemoteInstance().lockCheckageData(ids, 0);
            if (result != null && (curMsg = (String)result.get("error")) != null) {
                msg.append(curMsg);
            }
            this.refreshCheckageStatusByCompany(result, true);
        } else if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "500_allLockFail", null), (String)msg.toString(), (int)8188);
            return;
        }
        if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "501_partLockFail", null), (String)msg.toString(), (int)8188);
        }
    }

    @Override
    public void actionCheckageDataUnLock_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer msg = new StringBuffer();
        List ids = this.checkSelectDatas(msg, false);
        if (ids != null && !ids.isEmpty()) {
            Map result = CheckageCompanyStatusFactory.getRemoteInstance().lockCheckageData(ids, 1);
            this.refreshCheckageStatusByCompany(result, false);
        } else if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "498_allUnlockFail", null), (String)msg.toString(), (int)8188);
            return;
        }
        if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "499_partUnlockFail", null), (String)msg.toString(), (int)8188);
        }
    }

    protected List checkSelectDatas(StringBuffer msg, boolean isLock) throws Exception {
        Map selectedDatas = this.getSelectedDatas(isLock);
        this.checkPermission(selectedDatas, msg, isLock);
        return this.checkStatus(selectedDatas, msg, isLock);
    }

    protected List checkStatus(Map selectedDatas, StringBuffer msg, boolean isLock) throws Exception {
        if (selectedDatas != null && !selectedDatas.isEmpty()) {
            TreeSet tmpRowIndexs = new TreeSet();
            for (Object values : selectedDatas.values()) {
                tmpRowIndexs.addAll((List)values);
            }
            StringBuffer detailMsg = new StringBuffer();
            ArrayList<String> ids = new ArrayList<String>();
            for (Object rowIndex : tmpRowIndexs) {
                IRow row = this.tblMain.getRow(((Integer)rowIndex).intValue());
                if (row == null) continue;
                CompanyStatusEnum status = (CompanyStatusEnum)((Object)row.getCell("status").getValue());
                if (isLock && !CompanyStatusEnum.commited.equals((Object)status)) {
                    detailMsg.append(row.getCell("companyNumber").getValue()).append("-").append(row.getCell("companyName").getValue()).append(" \n");
                    continue;
                }
                if (!isLock && !CompanyStatusEnum.locked.equals((Object)status)) {
                    detailMsg.append(row.getCell("companyNumber").getValue()).append("-").append(row.getCell("companyName").getValue()).append(" \n");
                    continue;
                }
                ids.add(row.getCell("statusId").getValue().toString());
            }
            if (detailMsg.length() > 0) {
                msg.append(AccountCheckUtil.getResourceString(null, isLock ? "496_unCommitCantLock" : "497_unLockCantUnlock", null)).append(" \n");
                msg.append(detailMsg);
            }
            return ids;
        }
        return null;
    }

    protected void checkPermission(Map selectedDatas, StringBuffer msg, boolean isLock) throws Exception {
        if (selectedDatas != null && !selectedDatas.isEmpty()) {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            String permission = isLock ? "csl_checkageStatus_lock" : "csl_checkageStatus_unlock";
            IObjectPK[] orgPKs = new IObjectPK[selectedDatas.size()];
            int i = 0;
            for (Object orgId : selectedDatas.keySet()) {
                orgPKs[i++] = new ObjectStringPK((String)orgId);
            }
            Set hasPermOrgs = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, orgPKs, permission);
            if (hasPermOrgs.size() < selectedDatas.size()) {
                HashSet noHasPermOrgs = new HashSet();
                for (Object orgId : selectedDatas.keySet()) {
                    if (hasPermOrgs.contains(orgId)) continue;
                    noHasPermOrgs.add(orgId);
                    List rowIndexs = (List)selectedDatas.get(orgId);
                    String orgUnitName = (String)this.tblMain.getRow(((Integer)rowIndexs.get(0)).intValue()).getCell("orgUnitName").getValue();
                    msg.append(AccountCheckUtil.getResourceString(null, isLock ? "494_noPermCantLock" : "495_noPermCantUnlock", new Object[]{orgUnitName})).append("\n");
                    for (Object rowIndex : rowIndexs) {
                        IRow row = this.tblMain.getRow(((Integer)rowIndex).intValue());
                        msg.append(row.getCell("companyNumber").getValue()).append("-").append(row.getCell("companyName").getValue()).append(" \n");
                    }
                }
                for (Object orgId : noHasPermOrgs) {
                    selectedDatas.remove(orgId);
                }
                noHasPermOrgs.clear();
                hasPermOrgs.clear();
            }
        }
    }

    protected Map getSelectedDatas(boolean isLock) throws Exception {
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
            this.abort();
            return null;
        }
        int[] selectRows = this.getSelectedRowIndex();
        OneToManyMap selectedDatas = new OneToManyMap();
        for (int rowIndex : selectRows) {
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) continue;
            selectedDatas.put(row.getCell("orgUnitId").getValue().toString(), rowIndex);
        }
        return selectedDatas;
    }

    protected int[] getSelectedRowIndex() throws Exception {
        int[] selectRows = null;
        if (this.tblMain.getSelectManager().get().getMode() == 8) {
            selectRows = new int[this.tblMain.getRowCount()];
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                selectRows[i] = i;
            }
        } else {
            selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        }
        return selectRows;
    }

    protected void getIncludeChildOrgUnits(Set<String> orgUnits) {
        if (orgUnits != null && this.ckIncludeChild.isSelected()) {
            KDTreeNode curNode = this.getSelectedTreeNode();
            this.getIncludeChildOrgUnits(curNode, orgUnits);
        }
    }

    protected void getIncludeChildOrgUnits(KDTreeNode node, Set<String> orgUnits) {
        String unitId;
        if (this.isNodeEnable(node) && !StringUtils.isEmpty((String)(unitId = this.getNodeUnitId(node)))) {
            orgUnits.add(unitId);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode curNode = node.getChildAt(i);
            if (!(curNode instanceof KDTreeNode)) continue;
            this.getIncludeChildOrgUnits((KDTreeNode)curNode, orgUnits);
        }
    }

    protected boolean isNodeEnable(KDTreeNode curNode) {
        if (curNode != null && curNode.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo info = (OrgStructureInfo)curNode.getUserObject();
            return info != null && (info.get("isEnable") == null || (Boolean)info.get("isEnable") != false);
        }
        return false;
    }

    protected String getSelectOrgUnitId(boolean isEnableNode) {
        KDTreeNode node = this.getSelectedTreeNode();
        if (isEnableNode && this.isNodeEnable(node) || !isEnableNode) {
            return this.getNodeUnitId(node);
        }
        return null;
    }

    public KDTreeNode getSelectedTreeNode() {
        Object node;
        if (this.treeMain.getSelectionPath() != null && (node = this.treeMain.getSelectionPath().getLastPathComponent()) instanceof KDTreeNode) {
            return (KDTreeNode)node;
        }
        return null;
    }

    protected String getNodeUnitId(KDTreeNode node) {
        OrgStructureInfo info;
        if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null && info.getUnit().getId() != null) {
            return info.getUnit().getId().toString();
        }
        return null;
    }

    protected boolean setSelectTreeNode(KDTreeNode node, OrgStructureInfo selectUserObj) throws Exception {
        if (node != null) {
            OrgStructureInfo curUserObj = (OrgStructureInfo)node.getUserObject();
            if (curUserObj != null && curUserObj.getUnit().getNumber().equals(selectUserObj.getUnit().getNumber())) {
                if (this.isNodeEnable(node)) {
                    this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)node);
                    return true;
                }
                return false;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode curNode = node.getChildAt(i);
                if (!(curNode instanceof KDTreeNode)) continue;
                return this.setSelectTreeNode((KDTreeNode)curNode, selectUserObj);
            }
        }
        return false;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            String sortKey = this.tblMain.getColumnKey(e.getColIndex());
            if (sortKey != null && sortKey.equals("select")) {
                return;
            }
            String sortType = this.key_sortType.get(sortKey);
            sortType = StringUtils.isEmpty((String)sortType) ? "asc" : (this.key_sortType.get(sortKey).equals("asc") ? "desc" : "asc");
            this.sm.sort(e.getColIndex(), sortType.equals("asc") ? 0 : 1);
            this.key_sortType.put(sortKey, sortType);
            if (!StringUtils.isEmpty((String)sortKey)) {
                this.refreshCheckageStatusDatas(this.colKey_sortKey.get(sortKey) + " " + sortType);
            }
            return;
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected String getKeyFieldName() {
        return "statusId";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    public boolean isFireOrgTreeChange() {
        return this.isFireOrgTreeChange;
    }

    public void setFireOrgTreeChange(boolean isFireOrgTreeChange) {
        this.isFireOrgTreeChange = isFireOrgTreeChange;
    }
}

