/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractChooseAccountMappingUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class ChooseAccountMappingUI
extends AbstractChooseAccountMappingUI {
    private static final long serialVersionUID = -7942210212526568919L;
    private static final Logger logger = CoreUIObject.getLogger(ChooseAccountMappingUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    private boolean isLoaded = false;
    private boolean isCancel = false;
    private List<AccountMapInfo> initDatas = null;
    private List<AccountMapInfo> selectedDatas = null;
    private Map<String, List<Map<String, String>>> initAccounts = null;
    private boolean isInitMerge = false;

    public void onLoad() throws Exception {
        String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        this.initCombItemType();
        this.initCombElimType(selectAll);
        this.initComponent();
        this.initTable();
        this.initTxtLocation();
        this.setFilter();
        super.onLoad();
        this.refresh();
        this.initSelectedData();
        this.isLoaded = true;
    }

    private void setFilter() {
        Set mappingIds;
        EntityViewInfo vInfo = this.getMainQuery();
        FilterInfo filter = this.getFilter();
        if (this.getUIContext().containsKey("mappingIds") && this.getUIContext().get("mappingIds") != null && !(mappingIds = (Set)this.getUIContext().get("mappingIds")).isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)mappingIds, CompareType.NOTINCLUDE));
        }
        vInfo.setFilter(filter);
    }

    private void initSelectedData() {
        if (this.getUIContext().containsKey("mappings") && this.getUIContext().get("mappings") != null) {
            List accountMaps = (List)this.getUIContext().get("mappings");
            for (AccountMapInfo accountMap : accountMaps) {
                String id = accountMap.getId().toString();
                String number = accountMap.getNumber();
                ItemTypeEnum itemType = accountMap.getItemType();
                ElimTypeEnum elimType = accountMap.getElimType();
                IRow row = this.tblSelected.addRow();
                row.getCell("id").setValue((Object)id);
                row.getCell("number").setValue((Object)number);
                row.getCell("itemType").setValue((Object)itemType);
                row.getCell("elimType").setValue((Object)elimType);
            }
        }
    }

    private void initData() {
        this.initDatas = new ArrayList<AccountMapInfo>();
        int size = this.tblSelect.getRowCount();
        ItemTypeEnum itemTypeEnum = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
        this.initAccounts = new HashMap<String, List<Map<String, String>>>();
        AccountMapInfo accountMap = null;
        ArrayList<HashMap<String, String>> accountList = null;
        HashMap<String, String> account = null;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblSelect.getRow(i);
            String id = (String)row.getCell("id").getValue();
            boolean isMapAccount = (Boolean)row.getCell("isMapAccount").getValue();
            String number = (String)row.getCell("number").getValue();
            BizEnumValueDTO elimTypeDto = (BizEnumValueDTO)row.getCell("elimType").getValue();
            int elimTypeValue = elimTypeDto.getInt();
            ElimTypeEnum elimType = ElimTypeEnum.getEnum((int)elimTypeValue);
            BizEnumValueDTO itemTypeDto = (BizEnumValueDTO)row.getCell("itemType").getValue();
            int itemTypeValue = itemTypeDto.getInt();
            ItemTypeEnum itemType = ItemTypeEnum.getEnum(itemTypeValue);
            String itemNumber = (String)row.getCell("itemNumber").getValue();
            String itemName = (String)row.getCell("itemName").getValue();
            String dataElementName = null;
            if (itemTypeEnum.getValue() == 0) {
                BizEnumValueDTO balTypeDto = (BizEnumValueDTO)row.getCell("balType").getValue();
                int balTypeValue = balTypeDto.getInt();
                dataElementName = BalTypeEnum.getEnum(balTypeValue).getAlias();
            } else {
                dataElementName = (String)row.getCell("dataElement").getValue();
            }
            String remark = (String)row.getCell("remark").getValue();
            accountMap = new AccountMapInfo();
            account = new HashMap<String, String>();
            accountMap.setId(BOSUuid.read((String)id));
            accountMap.setNumber(number);
            accountMap.setItemType(itemType);
            accountMap.setElimType(elimType);
            accountMap.setRemark(remark);
            if (!this.initDatas.contains(accountMap)) {
                this.initDatas.add(accountMap);
            }
            if (this.initAccounts.containsKey(id)) {
                account = new HashMap();
                account.put("isMapAccount", String.valueOf(isMapAccount));
                account.put("itemNumber", itemNumber);
                account.put("itemName", itemName);
                account.put("dataElementName", dataElementName);
                this.initAccounts.get(id).add(account);
                continue;
            }
            accountList = new ArrayList<HashMap<String, String>>();
            account = new HashMap();
            account.put("isMapAccount", String.valueOf(isMapAccount));
            account.put("itemNumber", itemNumber);
            account.put("itemName", itemName);
            account.put("dataElementName", dataElementName);
            accountList.add(account);
            this.initAccounts.put("id", accountList);
        }
    }

    private EntityViewInfo getMainQuery() {
        if (this.accountMappingForF7Query == null) {
            this.accountMappingForF7Query = new EntityViewInfo();
        }
        return this.accountMappingForF7Query;
    }

    private void refresh() {
        if (!this.isInitMerge) {
            this.initMerge();
        }
        this.itemTypeChange();
    }

    public String[] getMergeColumnKeys() {
        ArrayList<String> mergeColumnKeys = new ArrayList<String>();
        mergeColumnKeys.add("number");
        mergeColumnKeys.add("elimType");
        mergeColumnKeys.add("remark");
        String[] columns = new String[mergeColumnKeys.size()];
        mergeColumnKeys.toArray(columns);
        return columns;
    }

    protected void initMerge() {
        for (int i = 0; i < this.tblSelect.getColumnCount(); ++i) {
            this.tblSelect.getColumn(i).setMergeable(false);
        }
        this.tblSelect.getGroupManager().setGroup(true);
        String[] columns = this.getMergeColumnKeys();
        for (int i = 0; i < columns.length; ++i) {
            this.tblSelect.getColumn(columns[i]).setGroup(true);
            this.tblSelect.getColumn(columns[i]).setMergeable(true);
        }
        this.isInitMerge = true;
    }

    private FilterInfo getFilter() {
        Set<String> mappingIds;
        FilterInfo filter = new FilterInfo();
        ItemTypeEnum itemType = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemType.getValue()));
        int selectedIndex = this.combElimType.getSelectedIndex();
        if (selectedIndex != 0) {
            if (selectedIndex == 1) {
                filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)1));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("elimType", (Object)3));
            }
        }
        if ((mappingIds = this.getSelectedMappingIds()) != null && !mappingIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", mappingIds, CompareType.NOTINCLUDE));
        }
        return filter;
    }

    private Set<String> getSelectedMappingIds() {
        HashSet<String> mappingIds = new HashSet<String>();
        int size = this.tblSelected.getRowCount();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblSelected.getRow(i);
                String id = (String)row.getCell("id").getValue();
                mappingIds.add(id);
            }
        }
        return mappingIds;
    }

    private void initCombItemType() {
        this.combItemType.addItems(ItemTypeEnum.getEnumList().toArray());
        AccountCheckUtil.initItemTypeDefaultValue(this.combItemType);
    }

    private void initCombElimType(String selectAll) {
        this.combElimType.addItem((Object)selectAll);
        this.combElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.combElimType.addItem((Object)ElimTypeEnum.exchange);
    }

    private void initComponent() {
        this.kDContainer1.addButton((JButton)this.btnAdd);
        this.kDContainer1.addButton((JButton)this.btnDelete);
        this.kDContainer1.addButton((JButton)this.btnAddAll);
        this.kDContainer1.addButton((JButton)this.btnDeleteAll);
    }

    private void initTable() {
        this.tblSelect.checkParsed();
        this.tblSelect.getStyleAttributes().setLocked(true);
        this.tblSelect.getSelectManager().setSelectMode(10);
        this.tblSelect.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ChooseAccountMappingUI.this.fillColorRows();
            }
        });
        this.tblSelected.checkParsed();
        this.tblSelected.getStyleAttributes().setLocked(true);
        this.tblSelected.getSelectManager().setSelectMode(10);
    }

    private void fillColorRows() {
        IRow row = null;
        ICell isMapAccount = null;
        for (int i = 0; i < this.tblSelect.getRowCount(); ++i) {
            row = this.tblSelect.getRow(i);
            isMapAccount = row.getCell("isMapAccount");
            if (((Boolean)isMapAccount.getValue()).booleanValue()) continue;
            row.getCell("itemNumber").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("itemName").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("dataElement").getStyleAttributes().setBackground(new Color(240, 236, 250));
            row.getCell("balType").getStyleAttributes().setBackground(new Color(240, 236, 250));
        }
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)RES, (String)"503_defaultNumber");
        this.txtFilter.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtFilter, defaultStr);
        this.txtFilter.addFocusListener((FocusListener)quickQueryHandler);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnFilter_actionPerformed(ActionEvent e) throws Exception {
        String defaultStr = EASResource.getString((String)RES, (String)"503_defaultNumber");
        String search = this.txtFilter.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblSelect.getColumnIndex("number");
            CslRptUIUtil.tableMainLocate((KDTable)this.tblSelect, (String)search, (int[])new int[]{colIndex1});
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.destroyWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelected.getRowCount();
        this.selectedDatas = new ArrayList<AccountMapInfo>();
        AccountMapInfo accountMap = null;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblSelected.getRow(i);
            String id = (String)row.getCell("id").getValue();
            String number = (String)row.getCell("number").getValue();
            ItemTypeEnum itemType = (ItemTypeEnum)((Object)row.getCell("itemType").getValue());
            ElimTypeEnum elimType = (ElimTypeEnum)row.getCell("elimType").getValue();
            accountMap = new AccountMapInfo();
            accountMap.setId(BOSUuid.read((String)id));
            accountMap.setNumber(number);
            accountMap.setItemType(itemType);
            accountMap.setElimType(elimType);
            this.selectedDatas.add(accountMap);
        }
        this.destroyWindow();
    }

    @Override
    protected void combItemType_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        EntityViewInfo vInfo = this.getMainQuery();
        vInfo.setFilter(this.getFilter());
        this.tblSelect.removeRows();
        if (this.tblSelect.getRowCount() > 0) {
            this.tblSelect.getSelectManager().select(0, 0);
        }
        this.itemTypeChange();
    }

    private void itemTypeChange() {
        ItemTypeEnum itemType = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
        if (0 == itemType.getValue()) {
            this.changeTableColHide(true);
        } else {
            this.changeTableColHide(false);
        }
    }

    private void changeTableColHide(boolean isHide) {
        this.tblSelect.getColumn("dataElement").getStyleAttributes().setHided(isHide);
        this.tblSelect.getColumn("balType").getStyleAttributes().setHided(!isHide);
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    @Override
    protected void combElimType_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        EntityViewInfo vInfo = this.getMainQuery();
        vInfo.setFilter(this.getFilter());
        this.tblSelect.removeRows();
        if (this.tblSelect.getRowCount() > 0) {
            this.tblSelect.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        Set<String> selectedId;
        this.checkSelected(this.tblSelect);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblSelect);
        int size = selectRows.length;
        if (size > 0 && (selectedId = this.addDataToSelectedTable(selectRows, size)) != null && !selectedId.isEmpty()) {
            this.initSelectTable(selectedId);
        }
    }

    private Set<String> addDataToSelectedTable(int[] selectRows, int size) {
        String preRowId = null;
        HashSet<String> selectedId = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            int index = selectRows[i];
            IRow row = this.tblSelect.getRow(index);
            String id = (String)row.getCell("id").getValue();
            if (preRowId != null && preRowId.equals(id)) continue;
            this.addNewRow(row, id);
            selectedId.add(id);
            preRowId = id;
        }
        return selectedId;
    }

    private void addNewRow(IRow row, String id) {
        String number = (String)row.getCell("number").getValue();
        BizEnumValueDTO elimTypeDto = (BizEnumValueDTO)row.getCell("elimType").getValue();
        int elimTypeValue = elimTypeDto.getInt();
        ElimTypeEnum elimType = ElimTypeEnum.getEnum((int)elimTypeValue);
        BizEnumValueDTO itemTypeDto = (BizEnumValueDTO)row.getCell("itemType").getValue();
        int itemTypeValue = itemTypeDto.getInt();
        ItemTypeEnum itemType = ItemTypeEnum.getEnum(itemTypeValue);
        IRow newRow = this.tblSelected.addRow();
        newRow.getCell("id").setValue((Object)id);
        newRow.getCell("number").setValue((Object)number);
        newRow.getCell("elimType").setValue((Object)elimType);
        newRow.getCell("itemType").setValue((Object)itemType);
    }

    private void initSelectTable(Set<String> selectedId) {
        EntityViewInfo vInfo = this.getMainQuery();
        FilterInfo filter = this.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("id", selectedId, CompareType.NOTINCLUDE));
        vInfo.setFilter(filter);
        this.tblSelect.removeRows();
        if (this.tblSelect.getRowCount() > 0) {
            this.tblSelect.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblSelected);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblSelected);
        int size = selectRows.length;
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                int index = selectRows[i];
                this.tblSelected.removeRow(index);
            }
            size = selectRows.length;
            if (size > 0) {
                HashSet<String> selectedId = new HashSet<String>();
                for (int i = 0; i < size; ++i) {
                    IRow row = this.tblSelect.getRow(i);
                    String id = (String)row.getCell("id").getValue();
                    selectedId.add(id);
                }
                this.initSelectTable(selectedId);
            } else {
                this.refreshTable();
            }
        }
    }

    private void refreshTable() {
        EntityViewInfo vInfo = this.getMainQuery();
        FilterInfo filter = this.getFilter();
        vInfo.setFilter(filter);
        this.tblSelect.removeRows();
        if (this.tblSelect.getRowCount() > 0) {
            this.tblSelect.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelect.getRowCount();
        String preRowId = null;
        for (int i = size - 1; i >= 0; --i) {
            IRow row = this.tblSelect.getRow(i);
            String id = (String)row.getCell("id").getValue();
            if (preRowId == null || !preRowId.equals(id)) {
                this.addNewRow(row, id);
                preRowId = id;
            }
            this.tblSelect.removeRow(i);
        }
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelected.getRowCount();
        for (int i = size - 1; i >= 0; --i) {
            this.tblSelected.removeRow(i);
        }
        this.refreshTable();
    }

    public void checkSelected(KDTable tbl) {
        if (tbl.getRowCount() == 0 || tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public List<AccountMapInfo> getData() {
        return this.selectedDatas;
    }
}

