/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgRelTemplateFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractChooseAssociateTemplateUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class ChooseAssociateTemplateUI
extends AbstractChooseAssociateTemplateUI {
    private static final long serialVersionUID = 2642617097666716872L;
    private static final Logger logger = CoreUIObject.getLogger(ChooseAssociateTemplateUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    private boolean isCancel = false;
    private List<TemplateInfo> selectedTmpls = null;
    private List<TemplateInfo> tmpls = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblSelect.checkParsed();
        this.tblSelect.getStyleAttributes().setLocked(true);
        this.tblSelect.getSelectManager().setSelectMode(10);
        this.tblSelected.checkParsed();
        this.tblSelected.getStyleAttributes().setLocked(true);
        this.tblSelected.getSelectManager().setSelectMode(10);
        this.initComponent();
        this.initTxtLocation();
        this.initTemplateByOrgIds();
        this.initSelectedTbl();
    }

    private void initTemplateByOrgIds() throws EASBizException, BOSException {
        if (this.getUIContext().containsKey("orgIds") && this.getUIContext().get("orgIds") != null) {
            Set orgIds = (Set)this.getUIContext().get("orgIds");
            HashMap<String, Set> params = new HashMap<String, Set>();
            params.put("orgIds", orgIds);
            this.tmpls = CheckageOrgRelTemplateFactory.getRemoteInstance().getRptTemplateList(params);
            if (this.tmpls != null && !this.tmpls.isEmpty()) {
                for (TemplateInfo tmpl : this.tmpls) {
                    this.initSelectTable(tmpl, this.tblSelect);
                }
            }
        }
    }

    private void initSelectedTbl() {
        if (this.getUIContext().containsKey("tmpls") && this.getUIContext().get("tmpls") != null) {
            List tmpllist = (List)this.getUIContext().get("tmpls");
            for (TemplateInfo tmpl : tmpllist) {
                this.initSelectTable(tmpl, this.tblSelected);
            }
            ArrayList<TemplateInfo> newTmpls = new ArrayList<TemplateInfo>();
            newTmpls.addAll(this.tmpls);
            newTmpls.removeAll(tmpllist);
            this.tblSelect.removeRows();
            for (TemplateInfo tmpl : newTmpls) {
                this.initSelectTable(tmpl, this.tblSelect);
            }
        }
    }

    private void initSelectTable(TemplateInfo tmpl, KDTable table) {
        String id = tmpl.getId().toString();
        String group = tmpl.getGroup();
        String number = tmpl.getNumber();
        String name = tmpl.getName();
        RptTmpTypeEnum tmplType = tmpl.getTemplateType();
        RptPeriodTypeEnum periodType = tmpl.getPeriodType();
        String org = tmpl.getMaintainCU().getName();
        IRow row = table.addRow();
        row.getCell("id").setValue((Object)id);
        row.getCell("group").setValue((Object)group);
        row.getCell("number").setValue((Object)number);
        row.getCell("name").setValue((Object)name);
        row.getCell("type").setValue((Object)tmplType);
        row.getCell("periodType").setValue((Object)periodType);
        row.getCell("org").setValue((Object)org);
        row.setUserObject((Object)tmpl);
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    private void initComponent() {
        this.kDContainer1.addButton((JButton)this.btnAdd);
        this.kDContainer1.addButton((JButton)this.btnDelete);
        this.kDContainer1.addButton((JButton)this.btnAddAll);
        this.kDContainer1.addButton((JButton)this.btnDeleteAll);
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)RES, (String)"486_tmplQuickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation, defaultStr);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    @Override
    protected void btnLocation_actionPerformed(ActionEvent e) throws Exception {
        String defaultStr = EASResource.getString((String)RES, (String)"486_tmplQuickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblSelect.getColumnIndex("number");
            int colIndex2 = this.tblSelect.getColumnIndex("name");
            CslRptUIUtil.tableMainLocate((KDTable)this.tblSelect, (String)search, (int[])new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.destroyWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelected.getRowCount();
        this.selectedTmpls = new ArrayList<TemplateInfo>();
        for (int i = 0; i < size; ++i) {
            TemplateInfo tmpl = (TemplateInfo)this.tblSelected.getRow(i).getUserObject();
            this.selectedTmpls.add(tmpl);
        }
        this.isCancel = false;
        this.destroyWindow();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblSelect);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblSelect);
        int size = selectRows.length;
        if (size > 0) {
            int index;
            int i;
            for (i = 0; i < size; ++i) {
                index = selectRows[i];
                TemplateInfo tmpl = (TemplateInfo)this.tblSelect.getRow(index).getUserObject();
                this.initSelectTable(tmpl, this.tblSelected);
            }
            for (i = size - 1; i >= 0; --i) {
                index = selectRows[i];
                this.tblSelect.removeRow(index);
            }
            if (this.tblSelect.getRowCount() > 0) {
                this.tblSelect.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblSelected);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblSelected);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                int index = selectRows[i];
                this.tblSelected.removeRow(index);
            }
            ArrayList<TemplateInfo> selTableTmpls = new ArrayList<TemplateInfo>();
            int size = this.tblSelected.getRowCount();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    TemplateInfo tmpl = (TemplateInfo)this.tblSelected.getRow(i).getUserObject();
                    selTableTmpls.add(tmpl);
                }
                if (!selTableTmpls.isEmpty()) {
                    ArrayList<TemplateInfo> newTmpls = new ArrayList<TemplateInfo>();
                    newTmpls.addAll(this.tmpls);
                    newTmpls.removeAll(selTableTmpls);
                    this.tblSelect.removeRows();
                    for (TemplateInfo tmpl : newTmpls) {
                        this.initSelectTable(tmpl, this.tblSelect);
                    }
                }
                if (this.tblSelected.getRowCount() > 0) {
                    this.tblSelected.getSelectManager().select(0, 0);
                }
            } else {
                this.tblSelect.removeRows();
                for (TemplateInfo tmpl : this.tmpls) {
                    this.initSelectTable(tmpl, this.tblSelect);
                }
            }
        }
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelect.getRowCount();
        if (size > 0) {
            this.tblSelected.removeRows();
            for (int i = 0; i < size; ++i) {
                TemplateInfo tmpl = (TemplateInfo)this.tblSelect.getRow(i).getUserObject();
                this.initSelectTable(tmpl, this.tblSelected);
            }
            this.tblSelect.removeRows();
        }
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        if (!this.tmpls.isEmpty()) {
            this.tblSelected.removeRows();
            this.tblSelect.removeRows();
            for (TemplateInfo tmpl : this.tmpls) {
                this.initSelectTable(tmpl, this.tblSelect);
            }
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public List<TemplateInfo> getResult() {
        return this.selectedTmpls;
    }

    public void checkSelected(KDTable tbl) {
        if (tbl.getRowCount() == 0 || tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

