/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractChooseRecociliationOrgUI;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class ChooseRecociliationOrgUI
extends AbstractChooseRecociliationOrgUI {
    private static final long serialVersionUID = 712005507977633248L;
    private static final Logger logger = CoreUIObject.getLogger(ChooseRecociliationOrgUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    private boolean isCancel = false;
    private List<FullOrgUnitInfo> selectedOrgs = null;
    private List<FullOrgUnitInfo> initOrgs = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponent();
        this.initTable();
        this.initTxtLocation();
        this.initSelectTableData();
        this.initSelectedTbl();
    }

    private void initSelectedTbl() {
        if (this.getUIContext().containsKey("orgs") && this.getUIContext().get("orgs") != null) {
            List orgList = (List)this.getUIContext().get("orgs");
            for (FullOrgUnitInfo orgUnit : orgList) {
                this.initTableData(this.tblSelected, orgUnit);
            }
            ArrayList<FullOrgUnitInfo> newOrgs = new ArrayList<FullOrgUnitInfo>();
            newOrgs.addAll(this.initOrgs);
            newOrgs.removeAll(orgList);
            this.tblSelect.removeRows();
            for (FullOrgUnitInfo orgUnit : newOrgs) {
                this.initTableData(this.tblSelect, orgUnit);
            }
        }
    }

    private void initComponent() {
        this.kDContainer1.addButton((JButton)this.btnAdd);
        this.kDContainer1.addButton((JButton)this.btnDelete);
        this.kDContainer1.addButton((JButton)this.btnAddAll);
        this.kDContainer1.addButton((JButton)this.btnDeleteAll);
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    private void initSelectTableData() throws BOSException {
        Set<String> orgIDSet;
        EntityViewInfo view = new EntityViewInfo();
        boolean isOrg = (Boolean)this.getUIContext().get("isOrg");
        if (isOrg && (orgIDSet = this.getAuthorizedOrg()) != null && !orgIDSet.isEmpty()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", orgIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
        }
        view.getSelector().add(new SelectorItemInfo("company.id"));
        view.getSelector().add(new SelectorItemInfo("company.number"));
        view.getSelector().add(new SelectorItemInfo("company.name"));
        view.getSelector().add(new SelectorItemInfo("company.code"));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSorter().add(new SorterItemInfo("company.number"));
        CheckageCompanyCollection chkComs = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyCollection(view);
        if (chkComs != null && !chkComs.isEmpty()) {
            Iterator it = chkComs.iterator();
            FullOrgUnitInfo orgUnit = null;
            this.initOrgs = new ArrayList<FullOrgUnitInfo>();
            while (it.hasNext()) {
                CheckageCompanyInfo chkCom = (CheckageCompanyInfo)it.next();
                BOSUuid orgId = chkCom.getCompany().getId();
                String number = chkCom.getCompany().getNumber();
                String name = chkCom.getCompany().getName();
                String code = chkCom.getCompany().getCode();
                orgUnit = new FullOrgUnitInfo();
                orgUnit.setId(orgId);
                orgUnit.setNumber(number);
                orgUnit.setName(name);
                orgUnit.setCode(code);
                this.initTableData(this.tblSelect, orgUnit);
                this.initOrgs.add(orgUnit);
            }
        }
    }

    private void initTableData(KDTable table, FullOrgUnitInfo orgUnit) {
        IRow row = table.addRow();
        row.setUserObject((Object)orgUnit);
        row.getCell("id").setValue((Object)orgUnit.getId().toString());
        row.getCell("number").setValue((Object)orgUnit.getNumber());
        row.getCell("name").setValue((Object)orgUnit.getName());
        row.getCell("code").setValue((Object)orgUnit.getCode());
    }

    private Set<String> getAuthorizedOrg() {
        HashSet<String> orgIDSet = new HashSet<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("org"));
        view.setSelector(seletor);
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)userID));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        view.setFilter(filter);
        OrgRangeCollection orgRangeCollection = null;
        try {
            orgRangeCollection = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"initMainQuery", (Throwable)e);
        }
        if (orgRangeCollection != null && orgRangeCollection.size() > 0) {
            for (int i = 0; i < orgRangeCollection.size(); ++i) {
                orgIDSet.add(orgRangeCollection.get(i).getOrg().getId().toString());
            }
        }
        return orgIDSet;
    }

    private void initTable() {
        this.tblSelect.checkParsed();
        this.tblSelect.getStyleAttributes().setLocked(true);
        this.tblSelect.getSelectManager().setSelectMode(10);
        this.tblSelected.checkParsed();
        this.tblSelected.getStyleAttributes().setLocked(true);
        this.tblSelected.getSelectManager().setSelectMode(10);
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)RES, (String)"485_orgQuickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation, defaultStr);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnLocation_actionPerformed(ActionEvent e) throws Exception {
        String defaultStr = EASResource.getString((String)RES, (String)"485_orgQuickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblSelect.getColumnIndex("number");
            int colIndex2 = this.tblSelect.getColumnIndex("name");
            CslRptUIUtil.tableMainLocate((KDTable)this.tblSelect, (String)search, (int[])new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.destroyWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelected.getRowCount();
        this.selectedOrgs = new ArrayList<FullOrgUnitInfo>();
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo org = (FullOrgUnitInfo)this.tblSelected.getRow(i).getUserObject();
            this.selectedOrgs.add(org);
        }
        this.isCancel = false;
        this.destroyWindow();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblSelect);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblSelect);
        int size = selectRows.length;
        if (size > 0) {
            int index;
            int i;
            for (i = 0; i < size; ++i) {
                index = selectRows[i];
                FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.tblSelect.getRow(index).getUserObject();
                this.initTableData(this.tblSelected, orgUnit);
            }
            for (i = size - 1; i >= 0; --i) {
                index = selectRows[i];
                this.tblSelect.removeRow(index);
            }
            if (this.tblSelect.getRowCount() > 0) {
                this.tblSelect.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(this.tblSelected);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblSelected);
        int size = selectRows.length;
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                int index = selectRows[i];
                this.tblSelected.removeRow(index);
            }
            ArrayList<FullOrgUnitInfo> selOrgList = new ArrayList<FullOrgUnitInfo>();
            size = this.tblSelected.getRowCount();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.tblSelected.getRow(i).getUserObject();
                    selOrgList.add(orgUnit);
                }
                if (!selOrgList.isEmpty()) {
                    ArrayList<FullOrgUnitInfo> newOrgList = new ArrayList<FullOrgUnitInfo>();
                    newOrgList.addAll(this.initOrgs);
                    newOrgList.removeAll(selOrgList);
                    this.tblSelect.removeRows();
                    for (FullOrgUnitInfo orgUnit : newOrgList) {
                        this.initTableData(this.tblSelect, orgUnit);
                    }
                }
                if (this.tblSelected.getRowCount() > 0) {
                    this.tblSelected.getSelectManager().select(0, 0);
                }
            } else {
                this.tblSelect.removeRows();
                for (FullOrgUnitInfo orgUnit : this.initOrgs) {
                    this.initTableData(this.tblSelect, orgUnit);
                }
            }
        }
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelect.getRowCount();
        if (size > 0) {
            this.tblSelected.removeRows();
            for (int i = 0; i < size; ++i) {
                FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.tblSelect.getRow(i).getUserObject();
                this.initTableData(this.tblSelected, orgUnit);
            }
            this.tblSelect.removeRows();
        }
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        if (!this.initOrgs.isEmpty()) {
            this.tblSelected.removeRows();
            this.tblSelect.removeRows();
            for (FullOrgUnitInfo orgUnit : this.initOrgs) {
                this.initTableData(this.tblSelect, orgUnit);
            }
        }
    }

    private void checkSelected(KDTable tbl) {
        if (tbl.getRowCount() == 0 || tbl.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public List<FullOrgUnitInfo> getData() {
        return this.selectedOrgs;
    }
}

