/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.RptBaseFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillHeadFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillRelatElimCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillRelatElimFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ConfirmStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractGroupCheckageListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.GroupCheckageDiffHandleUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.GroupCreateElimListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ReconciliationOrgSettingsViewUI;
import com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableFacadeFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.newrpt.cslworktable.util.CslWorkTableUtil;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class GroupCheckageListUI
extends AbstractGroupCheckageListUI
implements KDTDataRequestListener {
    private static final Logger logger = CoreUIObject.getLogger(GroupCheckageListUI.class);
    protected CurrencyCollection currencyCol = null;
    protected UnionF7Helper.UnionF7 orgUnionf7 = null;
    protected UnionF7Helper.UnionF7 companyf7 = null;
    protected String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    protected CheckageFilterInfo filterInfo = null;
    protected int maxRow = -1;
    protected boolean isShowMsg = false;
    protected boolean isError = false;
    protected String minTotal = null;
    protected String total = null;
    protected Map<String, Class> key_Enum = new HashMap<String, Class>();
    String totleNumber = "z999999999";
    String minTotleNumber = "zzzzzzzzzzzz";
    protected MnsUnionF7 orgTreef7 = null;
    protected OrgTreeCollection orgTreeColl = null;
    protected Date[] curDate = null;
    protected boolean isIncludeChild = true;
    protected boolean isInitWorkButton = false;
    protected BigDecimal diffMimTotle = BigDecimal.ZERO;
    protected BigDecimal diffTotle = BigDecimal.ZERO;

    public GroupCheckageListUI() throws Exception {
        this.tblMain.addKDTDataRequestListener((KDTDataRequestListener)this);
        int pageCount = 1500;
        this.tblMain.getDataRequestManager().setPageRowCount(pageCount);
        Field pageCountField = this.tblMain.getDataRequestManager().getClass().getDeclaredField("pageRowCount");
        NewRptUtil.makeAccessible(pageCountField);
        pageCountField.set(this.tblMain.getDataRequestManager(), pageCount);
        pageCountField = this.tblMain.getDataRequestManager().getClass().getDeclaredField("queryPageRowCount");
        NewRptUtil.makeAccessible(pageCountField);
        pageCountField.set(this.tblMain.getDataRequestManager(), pageCount);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initFromAutoCheckSchmLog();
        CslRptUIUtil.setActionVisible((CoreUI)this, (String)"actionMoveTree");
    }

    protected void init() throws Exception {
        AccountCheckUtil.initItemTypeDefaultValue(this.kdItemType);
        this.chkIncludeChild.setSelected(false, false);
        this.kDMenu1.setIcon(EASResource.getIcon((String)"imgTbtn_differencedispose"));
        this.curDate = new Date[]{CslRptUIUtil.getLastPeriodDate(null)};
        this.orgTreeColl = CslWorkTableUIUtil.getAllOrgTreeColl();
        AccountCheckUtil.initYearPeriodAndPeriodType(this.kdYear, this.kdPeriod, this.kdPeriodType, this.kdCheckPeriod, this.curDate, this.selectAll, this.orgTreeColl, this.kdOrgTree, null, this.kdCompany, (ListUI)this);
        AccountCheckUtil.initCurrency(this.kdCurrency);
        this.initStatus();
        this.initOrgTree();
        this.initOrgUnit();
        this.initCompany();
        this.initPopupMenu();
        this.addTableSelectionEvent();
        this.minTotal = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"labMinTotal").toString();
        this.total = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"labTotal").toString();
        this.key_Enum.put("balTypeName", BalTypeEnum.class);
        this.key_Enum.put("diffMode", DiffModeEnum.class);
        this.key_Enum.put("confirmstatus", ConfirmStatusEnum.class);
        this.key_Enum.put("auditStatus", AuditedStatusEnum.class);
        this.key_Enum.put("checkType", ElimTypeEnum.class);
        this.key_Enum.put("dataSource", DataSourceEnum.class);
        this.kDDataSource.insertItemAt((Object)this.selectAll, 0);
        this.kDDataSource.setSelectedIndex(0);
        this.pnlMain.setOneTouchExpandable(true);
        this.pnlMain.setArrowType(1);
        this.pnlTable.setLayout((LayoutManager)new KDLayout(){

            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                GroupCheckageListUI.this.layoutDiff();
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.checkParsed();
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("targetCompanyName") + 1);
    }

    protected void initFromAutoCheckSchmLog() throws Exception {
        Map uiContext = this.getUIContext();
        CheckageFilterInfo filterInfo = (CheckageFilterInfo)uiContext.get("filterInfo");
        if (filterInfo != null) {
            FullOrgUnitInfo orgUnitInfo;
            Object ownCompany;
            int i;
            this.kdItemType.setSelectedIndex(0);
            for (i = 0; i < this.kdPeriodType.getItemCount(); ++i) {
                if (((RptPeriodTypeEnum)this.kdPeriodType.getItemAt(i)).getValue() != filterInfo.periodType) continue;
                this.kdPeriodType.setSelectedIndex(i);
                break;
            }
            this.kdYear.setValue((Object)filterInfo.year, false);
            this.kdPeriod.setValue((Object)filterInfo.period, true);
            for (i = 0; i < this.kdCurrency.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.kdCurrency.getItemAt(i)).getId().toString().equals(filterInfo.currencyId)) continue;
                this.kdCurrency.setSelectedIndex(i);
                break;
            }
            OrgTreeInfo orgTree = (OrgTreeInfo)uiContext.get("orgTreeInfo");
            this.orgTreef7.setCurrOrgTree(orgTree);
            this.kdOrgTree.setData((Object)orgTree);
            if (this.orgUnionf7 != null) {
                this.orgUnionf7.setTreeID(orgTree.getId().toString());
            }
            if (this.companyf7 != null) {
                this.companyf7.setTreeID(orgTree.getId().toString());
            }
            if ((ownCompany = uiContext.get("ownCompany")) != null) {
                this.kdCompany.setValue(ownCompany);
            }
            this.kdConfirmStatus.setSelectedItem((Object)ConfirmStatusEnum.confirm);
            Object isDiffZero = uiContext.get("isDiffZero");
            if (isDiffZero != null) {
                if (((Boolean)isDiffZero).booleanValue()) {
                    this.kdDiffCompare.setSelectedItem((Object)"=");
                    this.kdDiffValue.setText("0");
                } else {
                    this.kdDiffCompare.setSelectedItem((Object)"<>");
                    this.kdDiffValue.setText("0");
                }
            }
            if ((orgUnitInfo = (FullOrgUnitInfo)uiContext.get("orgUnitInfo")) != null && orgUnitInfo.getId() != null) {
                this.builderTree(((OrgTreeInfo)this.kdOrgTree.getValue()).getId().toString(), orgUnitInfo.getId().toString(), null);
            }
        }
    }

    protected void initPopupMenu() throws Exception {
        KDTMenuManager tm = this.getMenuManager(this.tblMain);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        Component copy = null;
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if ("menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuItemCopy".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            copy = pop.getComponent(i);
        }
        JMenuItem menuItem = new JMenuItem();
        menuItem.setName("menuShowContactor");
        menuItem.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"9_actionName"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = GroupCheckageListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                    if (index == -1) {
                        return;
                    }
                    IRow row = GroupCheckageListUI.this.tblMain.getRow(index);
                    String ownCompanyId = row.getCell("ownCompanyId").getValue().toString();
                    UIContext uiContext = new UIContext((Object)this);
                    String id = GroupCheckageListUI.this.getCheckageCompanyRecordIdByCompanyId(ownCompanyId);
                    uiContext.put((Object)"ID", (Object)id);
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReconciliationOrgSettingsViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.getUIObject().getUIToolBar().setVisible(false);
                    uiWindow.getUIObject().setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"8_title"));
                    uiWindow.show();
                }
                catch (EASBizException e1) {
                    GroupCheckageListUI.this.handUIException(e1);
                }
                catch (BOSException e1) {
                    GroupCheckageListUI.this.handUIException(e1);
                }
            }
        });
        pop.addMenuItemAfterComponent(menuItem, copy);
    }

    private void addTableSelectionEvent() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int selectRow = GroupCheckageListUI.this.tblMain.getSelectManager().getActiveRowIndex();
                if (selectRow == -1) {
                    return;
                }
                if (GroupCheckageListUI.this.isSubTotal()) {
                    GroupCheckageListUI.this.setPopUpMenuVisible(false);
                } else {
                    GroupCheckageListUI.this.setPopUpMenuVisible(true);
                }
            }
        });
    }

    private boolean isSubTotal() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return false;
        }
        IRow row = this.tblMain.getRow(selectRow);
        Object companyId = row.getCell("ownCompanyId").getValue();
        return companyId == null;
    }

    private void setPopUpMenuVisible(boolean isVisible) {
        KDTMenuManager tm = this.getMenuManager(this.tblMain);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if (!"menuShowContactor".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(isVisible);
        }
    }

    private String getCheckageCompanyRecordIdByCompanyId(String billCompanyId) throws EASBizException, BOSException {
        CheckageCompanyInfo info = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyInfo("Select id where company = '" + billCompanyId + "'");
        return info.getId().toString();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFetchAverage.setVisible(false);
        this.btnFetchBig.setVisible(false);
        this.btnFetchCredit.setVisible(false);
        this.btnFetchDebit.setVisible(false);
        this.btnFetchSmall.setVisible(false);
        this.btnFetchZero.setVisible(false);
        if (!this.isInitWorkButton) {
            ItemAction[] itemActions = new ItemAction[]{this.actionFetchBig, this.actionFetchSmall, this.actionFetchDebit, this.actionFetchCredit, this.actionFetchAverage, this.actionFetchZero};
            CslRptUIUtil.addAssistMenuItem2btn((ItemAction[])itemActions, (KDWorkButton)this.btnBatchHandle, (Map)this.getServiceContext());
            this.isInitWorkButton = true;
        }
    }

    protected void initOrgTree() throws Exception {
        if (this.orgTreef7 == null) {
            this.orgTreef7 = new MnsUnionF7((IUIObject)this);
            this.orgTreef7.setF7uiTiTle(AccountCheckUtil.getResourceString(null, "460selectOrgTree", null));
            this.orgTreef7.setShowAssistantOrg(true);
            this.orgTreef7.setCheckedAssistantOrgChkBox(true);
            this.orgTreef7.setEnableCurOrgTreeRootNode(true);
            this.orgTreef7.setMultiSelect(false);
            this.orgTreef7.setSelectMode(2);
            this.orgTreef7.setCascadingSelection(false);
            HashSet selectOrgIdSet = new HashSet();
            this.orgTreef7.setCheckedOrgIDs(selectOrgIdSet);
            this.orgTreef7.setUnChangeableOrgIDs(selectOrgIdSet);
            this.orgTreef7.setPermissionItem("csl_groupCheckage_view");
            this.orgTreef7.setOrgTreeColl(CslWorkTableUIUtil.getOrgTreeColl(this.orgTreeColl, AccountCheckUtil.getDate(this.kdYear, this.kdPeriod, this.kdPeriodType)));
            this.orgTreef7.initUI();
            this.orgTreef7.reRoadOrgTree();
        }
        this.kdOrgTree.setSelector((KDPromptSelector)this.orgTreef7);
        this.kdOrgTree.setEditable(false);
        this.kdOrgTree.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (GroupCheckageListUI.this.kdOrgTree.getValue() != null) {
                    if (GroupCheckageListUI.this.kdOrgTree.getData() instanceof FullOrgUnitInfo) {
                        FullOrgUnitInfo curOrgUnitInfo = (FullOrgUnitInfo)GroupCheckageListUI.this.kdOrgTree.getData();
                        GroupCheckageListUI.this.kdOrgTree.setData((Object)GroupCheckageListUI.this.orgTreef7.getSelectedTree());
                        String treeId = ((OrgTreeInfo)GroupCheckageListUI.this.kdOrgTree.getValue()).getId().toString();
                        if (GroupCheckageListUI.this.orgUnionf7 != null) {
                            GroupCheckageListUI.this.orgUnionf7.setTreeID(treeId);
                        }
                        if (GroupCheckageListUI.this.companyf7 != null) {
                            GroupCheckageListUI.this.companyf7.setTreeID(treeId);
                        }
                        GroupCheckageListUI.this.builderTree(treeId, curOrgUnitInfo.getId().toString(), null);
                        return;
                    }
                    if (GroupCheckageListUI.this.kdOrgTree.getValue() instanceof OrgTreeInfo) {
                        GroupCheckageListUI.this.builderTree(((OrgTreeInfo)GroupCheckageListUI.this.kdOrgTree.getValue()).getId().toString(), null, null);
                    }
                } else {
                    GroupCheckageListUI.this.kdCompany.setValue(null);
                    GroupCheckageListUI.this.builderTree(null, null, null);
                }
            }
        });
    }

    protected void initOrgUnit() throws Exception {
        if (this.orgUnionf7 == null) {
            this.orgUnionf7 = new UnionF7Helper.UnionF7((IUIObject)this, 2){

                public void show() {
                    if (GroupCheckageListUI.this.kdOrgTree.getValue() == null) {
                        MsgBox.showWarning((String)AccountCheckUtil.getResourceString(null, "98selectOrgTree", null));
                        return;
                    }
                    super.show();
                }

                public Object getData() {
                    if (GroupCheckageListUI.this.kdOrgTree.getValue() == null) {
                        return null;
                    }
                    return super.getData();
                }
            };
            if (this.kdOrgTree.getValue() != null) {
                this.orgUnionf7.setTreeID(((OrgTreeInfo)this.kdOrgTree.getValue()).getId().toString());
            }
            this.orgUnionf7.setDataPermission("csl_groupCheckage_view");
            this.orgUnionf7.setRptAnalysis(true);
            this.orgUnionf7.setMultiSelect(false);
            this.orgUnionf7.setShowAssistantOrg(true);
            this.orgUnionf7.setCheckedAssistantOrgChkBox(true);
        }
    }

    protected void initCompany() throws Exception {
        if (this.companyf7 == null) {
            this.companyf7 = new UnionF7Helper.UnionF7((IUIObject)this, 1){

                public void show() {
                    if (GroupCheckageListUI.this.kdOrgTree.getValue() == null) {
                        MsgBox.showWarning((String)AccountCheckUtil.getResourceString(null, "98selectOrgTree", null));
                        return;
                    }
                    super.show();
                }

                public Object getData() {
                    if (GroupCheckageListUI.this.kdOrgTree.getValue() == null) {
                        return null;
                    }
                    return super.getData();
                }
            };
            if (this.kdOrgTree.getValue() != null) {
                this.companyf7.setTreeID(((OrgTreeInfo)this.kdOrgTree.getValue()).getId().toString());
            }
            this.companyf7.setRptAnalysis(true);
            this.companyf7.setMultiSelect(false);
            this.companyf7.setShowAssistantOrg(true);
            this.companyf7.setCheckedAssistantOrgChkBox(true);
        }
        this.kdCompany.setSelector((KDPromptSelector)this.companyf7);
        this.kdCompany.setEditable(false);
    }

    protected void initStatus() throws Exception {
        this.kdCheckType.addItem((Object)this.selectAll);
        this.kdCheckType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.kdCheckType.addItem((Object)ElimTypeEnum.exchange);
        this.kdConfirmStatus.insertItemAt((Object)this.selectAll, 0);
        this.kdAuditStatus.insertItemAt((Object)this.selectAll, 0);
        this.kdDiffCompare.insertItemAt((Object)"", 0);
        this.kdCheckType.setSelectedIndex(0);
        this.kdConfirmStatus.setSelectedIndex(0);
        this.kdAuditStatus.setSelectedIndex(0);
        this.kdDiffCompare.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (GroupCheckageListUI.this.kdDiffCompare.getSelectedItem() != null && !StringUtils.isEmpty((String)GroupCheckageListUI.this.kdDiffCompare.getSelectedItem().toString())) {
                        GroupCheckageListUI.this.kdDiffValue.setEnabled(true);
                    } else {
                        GroupCheckageListUI.this.kdDiffValue.setEnabled(false);
                        GroupCheckageListUI.this.kdDiffValue.setText(null);
                        if (GroupCheckageListUI.this.filterInfo != null) {
                            GroupCheckageListUI.this.filterInfo.diffChar = null;
                            GroupCheckageListUI.this.filterInfo.diffValue = null;
                        }
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)"periodType.addItemListener", (Throwable)e1);
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdDiffCompare.setSelectedIndex(0);
        this.kdDiffValue.setMinimumValue((Comparable)new BigDecimal("0"));
        this.kdDiffValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        this.kdDiffValue.setSupportedEmpty(true);
    }

    protected void initYearPeriodAndPeriodType() throws Exception {
        CslRptUIUtil.setSpineRange((KDSpinner)this.kdYear, (int)1900, (int)2999, (boolean)true, (boolean)true);
        CslWorkTableUIUtil.setSpineRangeByPeriodType(this.kdPeriod, (RptPeriodTypeEnum)this.kdPeriodType.getSelectedItem(), this.kdYear.getIntegerVlaue(), true, true);
        this.kdPeriodType.removeItem((Object)RptPeriodTypeEnum.DAILY);
        this.kdPeriodType.removeItem((Object)RptPeriodTypeEnum.WEEKLY);
        this.kdPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    CslWorkTableUIUtil.setSpineRangeByPeriodType(GroupCheckageListUI.this.kdPeriod, (RptPeriodTypeEnum)GroupCheckageListUI.this.kdPeriodType.getSelectedItem(), GroupCheckageListUI.this.kdYear.getIntegerVlaue(), true, true);
                    AccountCheckUtil.changeCheckPeriod((RptPeriodTypeEnum)GroupCheckageListUI.this.kdPeriodType.getSelectedItem(), GroupCheckageListUI.this.kdCheckPeriod, GroupCheckageListUI.this.kdPeriod.getIntegerVlaue(), GroupCheckageListUI.this.selectAll);
                }
                catch (Exception e1) {
                    logger.error((Object)"periodType.addItemListener", (Throwable)e1);
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    CslWorkTableUIUtil.setSpineRangeByPeriodType(GroupCheckageListUI.this.kdPeriod, (RptPeriodTypeEnum)GroupCheckageListUI.this.kdPeriodType.getSelectedItem(), GroupCheckageListUI.this.kdYear.getIntegerVlaue(), true, true);
                }
                catch (Exception e1) {
                    logger.error((Object)"year.addChangeListener", (Throwable)e1);
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    AccountCheckUtil.changeCheckPeriod((RptPeriodTypeEnum)GroupCheckageListUI.this.kdPeriodType.getSelectedItem(), GroupCheckageListUI.this.kdCheckPeriod, GroupCheckageListUI.this.kdPeriod.getIntegerVlaue(), GroupCheckageListUI.this.selectAll);
                }
                catch (Exception e1) {
                    logger.error((Object)"period.addChangeListener", (Throwable)e1);
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdPeriodType.setSelectedIndex(0);
        Date date = CslRptUIUtil.getLastPeriodDate(null);
        int[] yearPeriod = RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.kdPeriodType.getSelectedItem()));
        this.kdYear.setValue((Object)yearPeriod[0], false);
        this.kdPeriod.setValue((Object)yearPeriod[1], false);
        AccountCheckUtil.changeCheckPeriod((RptPeriodTypeEnum)this.kdPeriodType.getSelectedItem(), this.kdCheckPeriod, this.kdPeriod.getIntegerVlaue(), this.selectAll);
    }

    @Override
    public void actionQueryCheckages_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isShowMsg = true;
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            this.isShowMsg = false;
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        Set<String> selectKeys = AccountCheckUtil.getSelectBlocks(this.tblMain, "id");
        if (this.checkInput()) {
            this.isError = false;
            this.tblMain.removeRows();
        }
        AccountCheckUtil.setSelectBlocks(this.tblMain, selectKeys, null, "id");
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        if (!this.isError) {
            try {
                if (!this.checkInput()) {
                    return;
                }
                int from = e.getFirstRow();
                int length = e.getLastRow() - e.getFirstRow() + 1;
                if (from == 0) {
                    this.diffMimTotle = BigDecimal.ZERO;
                    this.diffTotle = BigDecimal.ZERO;
                    this.filterInfo = CheckageBillFactory.getRemoteInstance().prepareFetchGroupCheckageBill(this.initFilter());
                    this.maxRow = this.filterInfo.maxRow;
                }
                int tableRowCount = this.tblMain.getRowCount3();
                if (this.maxRow <= 0 || this.maxRow <= tableRowCount) {
                    return;
                }
                if (tableRowCount < this.maxRow && tableRowCount + length > this.maxRow) {
                    length = this.maxRow - tableRowCount;
                }
                this.filterInfo.from = from;
                this.filterInfo.lenth = length;
                ArrayList bills = CheckageBillFactory.getRemoteInstance().getGroupCheckageBill(this.filterInfo);
                if (bills != null) {
                    int rowFrom = this.tblMain.getRowCount3();
                    this.insertRows(bills, rowFrom, this.tblMain);
                }
                this.groupTableRow();
                this.setBigDecimalFormat();
            }
            catch (Exception ex) {
                this.isError = true;
                logger.error((Object)"tableDataRequest error.", (Throwable)ex);
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }

    public void refreshByBillHeadIds(List billHeadIds) throws Exception {
        if (billHeadIds != null && !billHeadIds.isEmpty()) {
            CheckageFilterInfo filters = new CheckageFilterInfo();
            filters.billHeadIds = billHeadIds;
            filters.itemType = ((ItemTypeEnum)((Object)this.kdItemType.getSelectedItem())).getValue();
            ArrayList bills = CheckageBillFactory.getRemoteInstance().getGroupCheckageBill(filters);
            if (bills != null) {
                int i;
                this.tblMain.setRefresh(false);
                IRow row = null;
                ICell cell = null;
                int rowCount = this.tblMain.getRowCount3();
                KDTColumns columns = this.tblMain.getColumns();
                HashMap<String, Integer> id_rowIndexs = new HashMap<String, Integer>();
                int totalIndex = -1;
                int rowIndex = -1;
                for (i = 0; i < rowCount; ++i) {
                    cell = this.tblMain.getRow(i).getCell("id");
                    if (cell == null || cell.getValue() == null) continue;
                    String rowId = cell.getValue().toString();
                    if (rowId.equals(this.minTotleNumber)) {
                        id_rowIndexs.put(this.tblMain.getRow(i - 1).getCell("billHeadId").getValue().toString() + this.minTotleNumber, i);
                        continue;
                    }
                    if (rowId.equals(this.totleNumber)) {
                        totalIndex = i;
                        continue;
                    }
                    id_rowIndexs.put(rowId, i);
                }
                for (i = 0; i < bills.size(); ++i) {
                    String id;
                    Map rowData = (Map)bills.get(i);
                    if (this.totleNumber.equals(rowData.get("number".toUpperCase(Locale.ENGLISH)))) continue;
                    if (this.minTotleNumber.equals(rowData.get("companyNumber".toUpperCase(Locale.ENGLISH)))) {
                        id = ((Map)bills.get(i - 1)).get("billHeadId".toUpperCase(Locale.ENGLISH)) + this.minTotleNumber;
                        rowIndex = (Integer)id_rowIndexs.get(id);
                        if (rowIndex < 0) continue;
                        row = this.tblMain.getRow(rowIndex);
                        if (totalIndex >= 0) {
                            this.setTotleValue(row, this.tblMain.getRow(totalIndex), rowData);
                        }
                        this.setRowValue(row, rowData, columns, true);
                        continue;
                    }
                    id = (String)rowData.get("id".toUpperCase(Locale.ENGLISH));
                    rowIndex = (Integer)id_rowIndexs.get(id);
                    if (rowIndex < 0) continue;
                    row = this.tblMain.getRow(rowIndex);
                    this.setRowValue(row, rowData, columns, true);
                }
                this.tblMain.setRefresh(true);
                this.tblMain.reLayoutAndPaint();
            }
        }
    }

    protected void setTotleValue(IRow minRow, IRow totelRow, Map<String, Object> minRowData) {
        BigDecimal[] values;
        BigDecimal totalConfirmDebit = (BigDecimal)totelRow.getCell("confirmDebit").getValue();
        BigDecimal totalConfirmCredit = (BigDecimal)totelRow.getCell("confirmCredit").getValue();
        BigDecimal minConfirmDebit = (BigDecimal)minRow.getCell("confirmDebit").getValue();
        BigDecimal minConfirmCredit = (BigDecimal)minRow.getCell("confirmCredit").getValue();
        BigDecimal minConfirmDebitData = (BigDecimal)minRowData.get("confirmDebit".toUpperCase(Locale.ENGLISH));
        BigDecimal minConfirmCreditData = (BigDecimal)minRowData.get("confirmCredit".toUpperCase(Locale.ENGLISH));
        for (BigDecimal value : values = new BigDecimal[]{totalConfirmDebit, totalConfirmCredit, minConfirmDebit, minConfirmCredit, minConfirmDebitData, minConfirmCreditData}) {
            if (value != null) continue;
            value = BigDecimal.ZERO;
        }
        totalConfirmDebit = totalConfirmDebit.subtract(minConfirmDebit).add(minConfirmDebitData);
        totalConfirmCredit = totalConfirmCredit.subtract(minConfirmCredit).add(minConfirmCreditData);
        totelRow.getCell("confirmDebit").setValue((Object)totalConfirmDebit);
        totelRow.getCell("confirmCredit").setValue((Object)totalConfirmCredit);
    }

    private void insertRows(ArrayList rows, int insertRowIndex, KDTable table) throws Exception {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        table.setRefresh(false);
        KDTColumns columns = table.getColumns();
        IRow row = null;
        HashMap<String, Integer[]> Merges = new HashMap<String, Integer[]>();
        for (int i = 0; i < rows.size(); ++i) {
            Map rowData = (Map)rows.get(i);
            row = table.setRow(insertRowIndex++);
            this.setRowValue(row, rowData, columns, false);
            String number = (String)row.getCell("number").getValue();
            if (StringUtils.isEmpty((String)number)) continue;
            Integer[] rowIndexs = (Integer[])Merges.get(number);
            if (rowIndexs == null) {
                rowIndexs = new Integer[]{row.getRowIndex(), rowIndexs[0]};
                Merges.put(number, rowIndexs);
                continue;
            }
            rowIndexs[1] = row.getRowIndex();
        }
        if (!Merges.isEmpty()) {
            KDTMergeManager mm = table.getMergeManager();
            int index = table.getColumn("diff").getColumnIndex();
            for (Integer[] rowIndex : Merges.values()) {
                mm.mergeBlock(rowIndex[0].intValue(), index, rowIndex[1].intValue(), index, 4);
            }
        }
        Merges.clear();
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    private void setRowValue(IRow row, Map<String, Object> rowData, KDTColumns columns, boolean isRefresh) throws Exception {
        ICell cell = null;
        Object value = null;
        for (int c = 0; c < columns.size(); ++c) {
            String columnKey = columns.getColumnKey(c);
            if (isRefresh && ("orgUnitName".equalsIgnoreCase(columnKey) || "orgUnitId".equalsIgnoreCase(columnKey))) continue;
            cell = row.getCell(columnKey);
            if (columnKey.equals("itemType")) {
                cell.setValue((Object)((ItemTypeEnum)((Object)this.kdItemType.getSelectedItem())));
                continue;
            }
            value = rowData.get(columnKey.toUpperCase(Locale.ENGLISH));
            if (this.key_Enum.containsKey(columnKey) && value != null) {
                if (((ItemTypeEnum)((Object)this.kdItemType.getSelectedItem())).equals((Object)ItemTypeEnum.rptItem) && columnKey.equals("balTypeName")) {
                    cell.setValue(value);
                    continue;
                }
                cell.setValue((Object)CslWorkTableUIUtil.getEnum(this.key_Enum.get(columnKey), Integer.valueOf(value.toString())));
                continue;
            }
            cell.setValue(value);
            if (!columnKey.equalsIgnoreCase("diff") || this.totleNumber.equals(rowData.get("number".toUpperCase())) || this.minTotleNumber.equals(rowData.get("companyNumber".toUpperCase()))) continue;
            this.diffMimTotle = value == null ? BigDecimal.ZERO : (BigDecimal)value;
        }
        if (this.totleNumber.equals(rowData.get("number".toUpperCase()))) {
            row.setUserObject((Object)"isTotleRow");
            row.getCell("number").setValue(null);
            row.getCell("itemType").setValue(null);
            row.getCell("ownCompantName").setValue(null);
            row.getCell("targetCompanyName").setValue((Object)this.total);
            row.getCell("id").setValue((Object)this.totleNumber);
            row.getCell("diff").setValue((Object)this.diffTotle);
            row.getStyleAttributes().setBackground(Color.decode("#FFFF9C"));
        } else if (this.minTotleNumber.equals(rowData.get("companyNumber".toUpperCase()))) {
            row.setUserObject((Object)"isMinRow");
            row.getCell("number").setValue(null);
            row.getCell("itemType").setValue(null);
            row.getCell("ownCompantName").setValue(null);
            row.getCell("targetCompanyName").setValue((Object)this.minTotal);
            row.getCell("id").setValue((Object)this.minTotleNumber);
            row.getCell("diff").setValue((Object)this.diffMimTotle);
            this.diffTotle = this.diffTotle.add(this.diffMimTotle.abs());
            row.getStyleAttributes().setBackground(Color.decode("#FFFF9C"));
        }
    }

    protected boolean checkInput() throws Exception {
        if (this.kdOrgTree.getValue() == null) {
            if (this.isShowMsg) {
                MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "98selectOrgTree", null));
            }
            return false;
        }
        if (this.getSelectOrgUnitId() == null) {
            if (this.isShowMsg) {
                MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "99selectOrgUnit", null));
            }
            return false;
        }
        return true;
    }

    protected CheckageFilterInfo initFilter() {
        if (this.filterInfo == null) {
            this.filterInfo = new CheckageFilterInfo();
        }
        this.filterInfo.clear();
        this.filterInfo.itemType = ((ItemTypeEnum)((Object)this.kdItemType.getSelectedItem())).getValue();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.kdPeriodType.getSelectedItem();
        this.filterInfo.periodType = periodType.getValue();
        this.filterInfo.year = this.kdYear.getIntegerVlaue();
        this.filterInfo.period = this.kdPeriod.getIntegerVlaue();
        this.filterInfo.currencyId = ((CurrencyInfo)this.kdCurrency.getSelectedItem()).getId().toString();
        this.filterInfo.treeId = ((OrgTreeInfo)this.kdOrgTree.getValue()).getId().toString();
        this.filterInfo.orgUnitId = this.getSelectOrgUnitId();
        this.filterInfo.isIncludeChild = this.chkIncludeChild.isSelected();
        this.getIncludeChildOrgUnits(this.filterInfo.hasPermOrgIds);
        if (this.kdCheckPeriod.getSelectedIndex() != 0) {
            this.filterInfo.checkPeriod = (Integer)this.kdCheckPeriod.getSelectedItem();
        }
        if (this.kdCheckType.getSelectedIndex() != 0) {
            this.filterInfo.checkType = ((ElimTypeEnum)this.kdCheckType.getSelectedItem()).getValue();
        }
        if (!StringUtils.isEmpty((String)this.kdDiffValue.getText()) && this.kdDiffCompare.getSelectedItem() != null) {
            this.filterInfo.diffChar = this.kdDiffCompare.getSelectedItem().toString();
            try {
                this.filterInfo.diffValue = this.kdDiffValue.getBigDecimalValue();
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "100isNotDigit", new Object[]{this.kdDiffValue.getText()}));
            }
        }
        if (this.kdCompany.getValue() != null) {
            this.filterInfo.companyId = ((OrgUnitInfo)this.kdCompany.getValue()).getId().toString();
        }
        if (this.kdConfirmStatus.getSelectedIndex() != 0) {
            this.filterInfo.confirmStatus = ((ConfirmStatusEnum)((Object)this.kdConfirmStatus.getSelectedItem())).getValue();
        }
        if (this.kdAuditStatus.getSelectedIndex() != 0) {
            this.filterInfo.auditStatus = ((AuditedStatusEnum)this.kdAuditStatus.getSelectedItem()).getValue();
        }
        if (!this.selectAll.equals(this.kDDataSource.getSelectedItem())) {
            this.filterInfo.dataSource = ((DataSourceEnum)((Object)this.kDDataSource.getSelectedItem())).getValue();
        }
        return this.filterInfo;
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("orgUnitName").setGroup(true);
        this.tblMain.getColumn("targetCompanyName").setGroup(true);
        this.tblMain.getColumn("currencyName").setGroup(true);
        this.tblMain.getColumn("diff").setGroup(true);
        this.tblMain.getColumn("diffMode").setGroup(true);
        this.tblMain.getColumn("confirmstatus").setGroup(true);
        this.tblMain.getColumn("confirmor").setGroup(true);
        this.tblMain.getColumn("confirmTime").setGroup(true);
        this.tblMain.getColumn("auditStatus").setGroup(true);
        this.tblMain.getColumn("auditor").setGroup(true);
        this.tblMain.getColumn("auditTime").setGroup(true);
        this.tblMain.getColumn("checkType").setGroup(true);
        this.tblMain.getColumn("ownCompantName").setGroup(true);
        this.tblMain.getColumn("diffRemark").setGroup(true);
        this.tblMain.getColumn("checkPeriod").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("orgUnitName").setMergeable(true);
        this.tblMain.getColumn("targetCompanyName").setMergeable(true);
        this.tblMain.getColumn("currencyName").setMergeable(true);
        this.tblMain.getColumn("diff").setMergeable(true);
        this.tblMain.getColumn("diffMode").setMergeable(true);
        this.tblMain.getColumn("confirmstatus").setMergeable(true);
        this.tblMain.getColumn("confirmor").setMergeable(true);
        this.tblMain.getColumn("confirmTime").setMergeable(true);
        this.tblMain.getColumn("auditStatus").setMergeable(true);
        this.tblMain.getColumn("auditor").setMergeable(true);
        this.tblMain.getColumn("auditTime").setMergeable(true);
        this.tblMain.getColumn("checkType").setMergeable(true);
        this.tblMain.getColumn("ownCompantName").setMergeable(true);
        this.tblMain.getColumn("diffRemark").setMergeable(true);
        this.tblMain.getColumn("checkPeriod").setMergeable(true);
    }

    private void setBigDecimalFormat() {
        this.tblMain.getColumn("debit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("credit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("confirmDebit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("confirmCredit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("diff").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("confirmDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("confirmCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("diff").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public boolean checkPermission(String permission, String orgUnitId) throws Exception {
        if (this.checkInput()) {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            if (!StringUtils.isEmpty((String)orgUnitId)) {
                PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(orgUnitId), (String)permission);
            } else if (this.chkIncludeChild.isSelected()) {
                Map orgUnitIds = this.getSelectValues(new String[]{"orgUnitId"});
                for (Object curOrgUnitId : orgUnitIds.keySet()) {
                    PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(curOrgUnitId.toString()), (String)permission);
                }
            } else {
                PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(this.getSelectOrgUnitId()), (String)permission);
            }
            return true;
        }
        this.abort();
        return false;
    }

    public Map<String, Object> checkPermission(String permission) throws Exception {
        if (this.checkInput()) {
            HashMap<String, Object> orgUnitPerms = new HashMap<String, Object>();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            if (this.chkIncludeChild.isSelected()) {
                Map orgUnits = this.getSelectValues(new String[]{"orgUnitId", "orgUnitName"});
                if (orgUnits != null) {
                    for (Object curOrgUnitId : orgUnits.keySet()) {
                        try {
                            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK((String)curOrgUnitId), (String)permission);
                            orgUnitPerms.put((String)curOrgUnitId, true);
                        }
                        catch (Exception e) {
                            orgUnitPerms.put((String)curOrgUnitId, orgUnits.get(curOrgUnitId));
                            logger.error((Object)"checkPermission", (Throwable)e);
                        }
                    }
                }
            } else {
                String curOrgUnitId = this.getSelectOrgUnitId();
                try {
                    PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(curOrgUnitId), (String)permission);
                    orgUnitPerms.put(curOrgUnitId, true);
                }
                catch (Exception e) {
                    orgUnitPerms.put(curOrgUnitId, this.getSelectOrgUnitName());
                    logger.error((Object)"checkPermission", (Throwable)e);
                }
            }
            return orgUnitPerms;
        }
        this.abort();
        return null;
    }

    protected Set<String> getSelectBillHeadIds() throws Exception {
        Map selectValues = this.getSelectValues(new String[]{"billHeadId"});
        if (selectValues != null) {
            HashSet<String> selects = new HashSet<String>();
            selects.addAll(selectValues.keySet());
            return selects;
        }
        return null;
    }

    protected Map<String, FullOrgUnitInfo> getSelectBills() throws Exception {
        int[] selectRows = this.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            HashMap<String, FullOrgUnitInfo> bills = new HashMap<String, FullOrgUnitInfo>();
            HashMap<String, FullOrgUnitInfo> orgUnits = new HashMap<String, FullOrgUnitInfo>();
            String billHeadId = null;
            String orgUnitId = null;
            String orgUnitName = null;
            IRow row = null;
            for (int index : selectRows) {
                billHeadId = null;
                orgUnitId = null;
                orgUnitName = null;
                row = this.tblMain.getRow(index);
                if (row.getCell("billHeadId").getValue() == null) {
                    if (this.minTotleNumber.equals(row.getCell("id").getValue())) {
                        billHeadId = this.tblMain.getRow(index - 1).getCell("billHeadId").getValue().toString();
                        orgUnitId = this.tblMain.getRow(index - 1).getCell("orgUnitId").getValue().toString();
                        orgUnitName = this.tblMain.getRow(index - 1).getCell("orgUnitName").getValue().toString();
                    }
                } else {
                    billHeadId = row.getCell("billHeadId").getValue().toString();
                    orgUnitId = row.getCell("orgUnitId").getValue().toString();
                    orgUnitName = row.getCell("orgUnitName").getValue().toString();
                }
                if (billHeadId == null) continue;
                FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)orgUnits.get(orgUnitId);
                if (orgUnit == null) {
                    orgUnit = new FullOrgUnitInfo();
                    orgUnit.setName(orgUnitName);
                    orgUnit.setId(BOSUuid.read((String)orgUnitId));
                    orgUnits.put(orgUnitId, orgUnit);
                }
                bills.put(billHeadId, orgUnit);
            }
            orgUnits.clear();
            return bills;
        }
        return null;
    }

    protected int[] getSelectRows() throws Exception {
        int[] selectRows;
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
            this.abort();
            return null;
        }
        int rowCount = this.tblMain.getRowCount3();
        if (this.tblMain.getSelectManager().get().getMode() == 8 && rowCount < this.maxRow) {
            while (rowCount < this.maxRow) {
                this.tblMain.getRow(rowCount);
                rowCount = this.tblMain.getRowCount3();
            }
            this.tblMain.getSelectManager().select(0, 0, rowCount, this.tblMain.getColumnCount());
        }
        if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
            this.abort();
            return null;
        }
        return selectRows;
    }

    protected Map getSelectValues(String[] columnKeys) throws Exception {
        int[] selectRows = this.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            Object billHeadIds = null;
            billHeadIds = columnKeys.length > 2 ? new OneToManyMap() : new HashMap();
            String billHeadId = null;
            IRow row = null;
            String id = null;
            block0: for (int index : selectRows) {
                id = null;
                billHeadId = null;
                row = this.tblMain.getRow(index);
                for (String columnKey : columnKeys) {
                    if (row.getCell(columnKey).getValue() == null) {
                        if (this.minTotleNumber.equals(row.getCell("id").getValue())) {
                            billHeadId = this.tblMain.getRow(index - 1).getCell(columnKey).getValue().toString();
                        }
                    } else {
                        billHeadId = row.getCell(columnKey).getValue().toString();
                    }
                    if (columnKeys.length == 1) {
                        if (billHeadId == null) continue;
                        billHeadIds.put(billHeadId, null);
                        continue;
                    }
                    if (id == null) {
                        if (billHeadId == null) continue block0;
                        id = billHeadId;
                        continue;
                    }
                    billHeadIds.put(id, billHeadId);
                }
            }
            return billHeadIds;
        }
        return null;
    }

    protected List<String> getSelectBillHeadIds(StringBuffer msg, Map<String, Object> orgUnitPerms, HandleType handleType2) throws Exception {
        Set<String> billHeadIds = this.getSelectBillHeadIds();
        if (billHeadIds == null || billHeadIds.isEmpty()) {
            return null;
        }
        HashMap<String, Object> elimRelaMap = new HashMap<String, Object>();
        if (HandleType.unAudit.equals((Object)handleType2) && !billHeadIds.isEmpty()) {
            CheckageBillRelatElimCollection coll = CheckageBillRelatElimFactory.getRemoteInstance().getCheckageBillRelatElimCollection("select checkageBill.billHead.id,elimEntry.elimination.periodType,elimEntry.elimination.orgBound.name where checkageBill.billHead.id in(" + CslRptUtil.collection2String(billHeadIds, (String)",", (boolean)true) + ") and elimEntry.elimination!=null ");
            for (int i = 0; i < coll.size(); ++i) {
                elimRelaMap.put(coll.get(i).getCheckageBill().getBillHead().getId().toString(), new Object[]{coll.get(i).getElimEntry().getElimination().getOrgBound().getName(), coll.get(i).getElimEntry().getElimination().getPeriodType().getAlias()});
            }
        }
        billHeadIds.clear();
        HashSet<String> handledBillHeadIds = new HashSet<String>();
        HashMap<String, String> diffBillMap = new HashMap<String, String>();
        HashSet<String> singleDataHeadIds = new HashSet<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<String> noPermissions = new HashSet<String>();
        for (int index : selectRows) {
            this.handleSingleBill(msg, index, handleType2, handledBillHeadIds, billHeadIds, diffBillMap, elimRelaMap, singleDataHeadIds, orgUnitPerms, noPermissions);
        }
        noPermissions.clear();
        if ((HandleType.diffHandle.equals((Object)handleType2) || HandleType.audit.equals((Object)handleType2)) && !singleDataHeadIds.isEmpty()) {
            Map reslut = CheckageBillHeadFactory.getRemoteInstance().checkSingleAccountMap(singleDataHeadIds);
            if (reslut != null && !reslut.isEmpty()) {
                for (Object number : reslut.values()) {
                    if (HandleType.diffHandle.equals((Object)handleType2)) {
                        msg.append(AccountCheckUtil.getResourceString(null, "115cantDiffHandle", new Object[]{number}));
                        continue;
                    }
                    msg.append(AccountCheckUtil.getResourceString(null, "116cantAudit", new Object[]{number}));
                }
                singleDataHeadIds.removeAll(reslut.keySet());
                for (Object id : reslut.keySet()) {
                    diffBillMap.remove(id);
                }
            }
            billHeadIds.addAll(singleDataHeadIds);
        }
        if (HandleType.audit.equals((Object)handleType2) && !diffBillMap.isEmpty()) {
            StringBuffer detail = new StringBuffer();
            for (String curNumber : diffBillMap.values()) {
                detail.append(AccountCheckUtil.getResourceString(null, "103existDiff", new Object[]{curNumber}));
            }
            if (MsgBox.isOk((int)MsgBox.showConfirm3((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "102auditForExistDiff", null), (String)detail.toString()))) {
                billHeadIds.addAll(diffBillMap.keySet());
            } else {
                return null;
            }
        }
        if (billHeadIds.isEmpty()) {
            String error = null;
            if (HandleType.audit.equals((Object)handleType2)) {
                error = AccountCheckUtil.getResourceString(null, "104auditFail", null);
            } else if (HandleType.unAudit.equals((Object)handleType2)) {
                error = AccountCheckUtil.getResourceString(null, "105unAuditFail", null);
            } else if (HandleType.diffHandle.equals((Object)handleType2)) {
                error = AccountCheckUtil.getResourceString(null, "106diffHandleFail", null);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)msg.toString(), (int)8188);
            return null;
        }
        return new ArrayList<String>(billHeadIds);
    }

    protected void handleSingleBill(StringBuffer msg, int rowIndex, HandleType handleType2, Set<String> handledBillHeadIds, Set<String> billHeadIds, Map<String, String> diffBillMap, Map<String, Object> elimRelaMap, Set<String> singleDataHeadIds, Map<String, Object> orgUnitPerms, Set<String> noPermissions) throws Exception {
        String billHeadId = (String)this.tblMain.getRow(rowIndex).getCell("billHeadId").getValue();
        if (billHeadId != null && handledBillHeadIds.contains(billHeadId)) {
            return;
        }
        int startIndex = this.findStartIndex(rowIndex);
        int endIndex = this.findEndIndex(rowIndex);
        if (startIndex >= 0 && endIndex >= 0) {
            if (StringUtils.isEmpty((String)billHeadId)) {
                billHeadId = this.tblMain.getRow(startIndex).getCell("billHeadId").getValue().toString();
            }
            if (billHeadId != null && handledBillHeadIds.contains(billHeadId)) {
                return;
            }
            String number = (String)this.tblMain.getRow(startIndex).getCell("number").getValue();
            if (HandleType.unAudit.equals((Object)handleType2) && elimRelaMap.containsKey(billHeadId)) {
                Object[] params = (Object[])elimRelaMap.get(billHeadId);
                msg.append(AccountCheckUtil.getResourceString(null, "117linkElimCantUnAudit", new Object[]{number, params[0], params[1]}));
                handledBillHeadIds.add(billHeadId);
                return;
            }
            AuditedStatusEnum auditStatus = (AuditedStatusEnum)this.tblMain.getRow(startIndex).getCell("auditStatus").getValue();
            if (HandleType.audit.equals((Object)handleType2) && auditStatus != null && AuditedStatusEnum.AUDITED.equals((Object)auditStatus)) {
                msg.append(AccountCheckUtil.getResourceString(null, "118auditNoneedAudit", new Object[]{number}));
                handledBillHeadIds.add(billHeadId);
                return;
            }
            if (HandleType.diffHandle.equals((Object)handleType2) && auditStatus != null && AuditedStatusEnum.AUDITED.equals((Object)auditStatus)) {
                msg.append(AccountCheckUtil.getResourceString(null, "119auditedCantDiff", new Object[]{number}));
                handledBillHeadIds.add(billHeadId);
                return;
            }
            if (HandleType.unAudit.equals((Object)handleType2) && auditStatus != null && AuditedStatusEnum.UNAUDITED.equals((Object)auditStatus)) {
                msg.append(AccountCheckUtil.getResourceString(null, "120unAuditNoNeedUnAudit", new Object[]{number}));
                handledBillHeadIds.add(billHeadId);
                return;
            }
            if (orgUnitPerms != null) {
                String orgUnitId = this.tblMain.getRow(startIndex).getCell("orgUnitId").getValue().toString();
                if (noPermissions.contains(orgUnitId)) {
                    return;
                }
                if (orgUnitPerms.get(orgUnitId) instanceof String) {
                    String msgResource = null;
                    if (HandleType.diffHandle.equals((Object)handleType2)) {
                        msgResource = "449noDiffPermission";
                    } else if (HandleType.audit.equals((Object)handleType2)) {
                        msgResource = "450noAuditPermission";
                    } else if (HandleType.unAudit.equals((Object)handleType2)) {
                        msgResource = "451noUnAuditPermission";
                    }
                    if (msgResource != null) {
                        msg.append(AccountCheckUtil.getResourceString(null, msgResource, new Object[]{orgUnitPerms.get(orgUnitId)})).append("\r\n");
                        noPermissions.add(orgUnitId);
                        handledBillHeadIds.add(billHeadId);
                        return;
                    }
                }
            }
            String ownCompanyId = null;
            String targetCompanyId = null;
            boolean isSameCompany = false;
            for (int i = startIndex; i <= endIndex; ++i) {
                String curTargetCompanyId;
                ConfirmStatusEnum confirmStatus;
                if (HandleType.audit.equals((Object)handleType2)) {
                    confirmStatus = (ConfirmStatusEnum)((Object)this.tblMain.getRow(i).getCell("confirmstatus").getValue());
                    BigDecimal diff = (BigDecimal)this.tblMain.getRow(i).getCell("diff").getValue();
                    if (confirmStatus != null && ConfirmStatusEnum.unconfirm.equals((Object)confirmStatus)) {
                        msg.append(AccountCheckUtil.getResourceString(null, "116cantAudit", new Object[]{number}));
                        handledBillHeadIds.add(billHeadId);
                        diffBillMap.remove(billHeadId);
                        return;
                    }
                    if (BigDecimal.ZERO.compareTo(diff) != 0) {
                        diffBillMap.put(billHeadId, number);
                    }
                } else if (HandleType.diffHandle.equals((Object)handleType2) && ((confirmStatus = (ConfirmStatusEnum)((Object)this.tblMain.getRow(i).getCell("confirmstatus").getValue())) == null || !ConfirmStatusEnum.confirm.equals((Object)confirmStatus))) {
                    msg.append(AccountCheckUtil.getResourceString(null, "115cantDiffHandle", new Object[]{number}));
                    handledBillHeadIds.add(billHeadId);
                    return;
                }
                if (!HandleType.audit.equals((Object)handleType2) && !HandleType.diffHandle.equals((Object)handleType2)) continue;
                String companyId = this.tblMain.getRow(i).getCell("ownCompanyId").getValue().toString();
                if (companyId.equals(curTargetCompanyId = this.tblMain.getRow(i).getCell("targetCompanyId").getValue().toString())) {
                    isSameCompany = true;
                }
                if (ownCompanyId == null) {
                    ownCompanyId = companyId;
                    continue;
                }
                if (ownCompanyId.equals(companyId)) continue;
                targetCompanyId = companyId;
            }
            if (!(!HandleType.audit.equals((Object)handleType2) && !HandleType.diffHandle.equals((Object)handleType2) || isSameCompany || ownCompanyId != null && targetCompanyId != null)) {
                singleDataHeadIds.add(billHeadId);
                return;
            }
            billHeadIds.add(billHeadId);
        }
    }

    protected boolean isSingleData() {
        return true;
    }

    protected int findEndIndex(int rowIndex) {
        int rowCount = this.tblMain.getRowCount3();
        for (int i = rowIndex; i < rowCount; ++i) {
            String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            if (!id.equals(this.minTotleNumber)) continue;
            return i - 1;
        }
        return -1;
    }

    protected int findStartIndex(int rowIndex) {
        for (int i = rowIndex; i >= 0; --i) {
            String id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            if (!id.equals(this.minTotleNumber) || i == rowIndex) continue;
            return i + 1;
        }
        return 0;
    }

    protected void diffHandle(DiffModeEnum diffMode) throws Exception {
        Object orgUnitPerm;
        Map<String, Object> orgUnitPerms = this.checkPermission("csl_groupCheckage_diffHandle");
        if (orgUnitPerms != null && orgUnitPerms.size() == 1 && (orgUnitPerm = orgUnitPerms.values().iterator().next()) instanceof String) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "106diffHandleFail", null), (String)AccountCheckUtil.getResourceString(null, "449noDiffPermission", new Object[]{orgUnitPerm}), (int)8188);
            return;
        }
        StringBuffer msg = new StringBuffer();
        List<String> billHeadIds = this.getSelectBillHeadIds(msg, orgUnitPerms, HandleType.diffHandle);
        if (billHeadIds != null && !billHeadIds.isEmpty()) {
            CheckageBillFactory.getRemoteInstance().diffHandle(billHeadIds, diffMode);
            this.actionRefresh_actionPerformed(null);
            if (msg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "107partDataFail", null), (String)msg.toString(), (int)8188);
            } else {
                this.showSuccessMsg(CslWorkTableUtil.getResourceString("9_Success", null));
            }
        }
    }

    protected void auditAndUnAuditHandle(AuditedStatusEnum auditedStatus) throws Exception {
        Object orgUnitPerm;
        boolean isAudit = AuditedStatusEnum.AUDITED.equals((Object)auditedStatus);
        String permItem = isAudit ? "csl_groupCheckage_audit" : "csl_groupCheckage_unaudit";
        Map<String, Object> orgUnitPerms = this.checkPermission(permItem);
        if (orgUnitPerms != null && orgUnitPerms.size() == 1 && (orgUnitPerm = orgUnitPerms.values().iterator().next()) instanceof String) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, isAudit ? "109partAuditFail" : "110partUnAuditFail", null), (String)AccountCheckUtil.getResourceString(null, isAudit ? "450noAuditPermission" : "451noUnAuditPermission", new Object[]{orgUnitPerm}), (int)8188);
            return;
        }
        StringBuffer msg = new StringBuffer();
        List<String> billHeadIds = this.getSelectBillHeadIds(msg, orgUnitPerms, isAudit ? HandleType.audit : HandleType.unAudit);
        if (billHeadIds != null && !billHeadIds.isEmpty()) {
            Map result = CheckageBillFactory.getRemoteInstance().auditAndUnAudit(billHeadIds, auditedStatus, this.filterInfo);
            this.refreshByBillHeadIds(billHeadIds);
            if (result != null && result.containsKey("msg")) {
                msg.append(result.get("msg"));
            }
            if (msg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, isAudit ? "109partAuditFail" : "110partUnAuditFail", null), (String)msg.toString(), (int)8188);
            } else {
                this.showSuccessMsg(AccountCheckUtil.getResourceString(null, isAudit ? "111auditSuccess" : "112unAuditSuccess", null));
            }
        }
    }

    protected void setBillHeadAuditStatus(IRow row, DiffModeEnum diffMode, boolean isAudit) throws Exception {
        row.getCell("confirmstatus").setValue((Object)(isAudit ? AuditedStatusEnum.AUDITED : AuditedStatusEnum.UNAUDITED).getAlias());
        row.getCell("confirmor").setValue(isAudit ? SysContext.getSysContext().getCurrentUserInfo().getName() : null);
        row.getCell("auditTime").setValue((Object)(isAudit ? new Timestamp(new Date().getTime()) : null));
        row.getCell("diffMode").setValue((Object)(isAudit ? diffMode.getAlias() : null));
    }

    protected void setRowAuditValue(CheckageBillInfo billInfo, IRow row) throws Exception {
        row.getCell("confirmDebit").setValue((Object)billInfo.getAuditDebit());
        row.getCell("confirmCredit").setValue((Object)billInfo.getAuditCredit());
    }

    @Override
    public void actionFetchBig_actionPerformed(ActionEvent e) throws Exception {
        this.diffHandle(DiffModeEnum.FetchBig);
    }

    @Override
    public void actionFetchSmall_actionPerformed(ActionEvent e) throws Exception {
        this.diffHandle(DiffModeEnum.FetchSmall);
    }

    @Override
    public void actionFetchDebit_actionPerformed(ActionEvent e) throws Exception {
        this.diffHandle(DiffModeEnum.FetchDebit);
    }

    @Override
    public void actionFetchCredit_actionPerformed(ActionEvent e) throws Exception {
        this.diffHandle(DiffModeEnum.FetchCredit);
    }

    @Override
    public void actionFetchAverage_actionPerformed(ActionEvent e) throws Exception {
        this.diffHandle(DiffModeEnum.FetchAverage);
    }

    @Override
    public void actionFetchZero_actionPerformed(ActionEvent e) throws Exception {
        this.diffHandle(DiffModeEnum.FetchZero);
    }

    @Override
    public void actionAuditData_actionPerformed(ActionEvent e) throws Exception {
        this.auditAndUnAuditHandle(AuditedStatusEnum.AUDITED);
    }

    @Override
    public void actionUnAuditData_actionPerformed(ActionEvent e) throws Exception {
        this.auditAndUnAuditHandle(AuditedStatusEnum.UNAUDITED);
    }

    @Override
    public void actionDiffHandle_actionPerformed(ActionEvent e) throws Exception {
        Map<String, FullOrgUnitInfo> billHeadIds = this.getSelectBills();
        if (billHeadIds != null && !billHeadIds.isEmpty()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"billHeadIds", billHeadIds);
            uiContext.put((Object)"currencyPrecision", (Object)((CurrencyInfo)this.kdCurrency.getSelectedItem()).getPrecision());
            uiContext.put((Object)"itemType", (Object)((ItemTypeEnum)((Object)this.kdItemType.getSelectedItem())).getValue());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(GroupCheckageDiffHandleUI.class.getName(), (Map)uiContext, null);
            uiWindow.show();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void disposeUIWindow() {
        if (this.filterInfo != null && this.filterInfo.tmpTable != null) {
            try {
                RptBaseFactory.getRemoteInstance().dropTable(this.filterInfo.tmpTable);
            }
            catch (BOSException e) {
                logger.error((Object)"disposeUIWindow_BOSException", (Throwable)e);
            }
        }
        super.disposeUIWindow();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void showSuccessMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public void actionCreateElimination_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkInput() && this.checkPermission("csl_checkageCreateElim_view", this.getSelectOrgUnitId())) {
            OrgStructureInfo info;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"filterInfo", (Object)this.initFilter());
            uiContext.put((Object)"orgTreeInfo", (Object)((OrgTreeInfo)this.kdOrgTree.getValue()));
            KDTreeNode node = this.getSelectedTreeNode();
            if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null) {
                uiContext.put((Object)"orgUnitInfo", (Object)info.getUnit());
            }
            uiContext.put((Object)"isIncludeChild", (Object)this.chkIncludeChild.isSelected());
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            IUIWindow window = uiFactory.create(GroupCreateElimListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    protected void initUserConfig() {
        Map uiContext = this.getUIContext();
        if (uiContext.get("filterInfo") != null) {
            this.tblMain.getGroupManager().setGroup(false);
        }
        super.initUserConfig();
    }

    public void doLayout() {
        super.doLayout();
        this.layoutDiff();
    }

    public void layout() {
        super.layout();
        this.layoutDiff();
    }

    protected void validateTree() {
        super.validateTree();
        this.layoutDiff();
    }

    public void layoutDiff() {
        Rectangle rec = this.kdQuery.getBounds();
        Rectangle kdDiff = this.kDLabelContainer7.getBounds();
        if (kdDiff.getWidth() > 70.0) {
            this.kDLabelContainer7.setBoundLabelLength(30);
            kdDiff.width = 70;
            this.kDLabelContainer7.setBounds(kdDiff);
            Rectangle diffCom = this.kdDiffCompare.getBounds();
            diffCom.width = 40;
            this.kdDiffCompare.setBounds(diffCom);
            this.kdDiffCompare.doLayout();
            this.kDLabelContainer7.doLayout();
            Rectangle kdDiffText = this.kdDiffValue.getBounds();
            kdDiffText.x = kdDiff.x + (int)kdDiff.getWidth() + 1;
            kdDiffText.width = 70;
            this.kdDiffValue.setBounds(kdDiffText);
            rec.width = this.kDLabelContainer7.getWidth() + this.kdDiffValue.getWidth() + 2;
            this.kdQuery.setBounds(rec);
            this.kdQuery.doLayout();
        }
    }

    public Object getTablePreferenceSchemaKey() {
        return this.kdItemType.getSelectedItem();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        OrgStructureInfo info;
        KDTreeNode curNode = this.getSelectedTreeNode();
        if (curNode != null && curNode.getUserObject() instanceof OrgStructureInfo && (info = (OrgStructureInfo)curNode.getUserObject()) != null && info.get("isEnable") != null && !((Boolean)info.get("isEnable")).booleanValue()) {
            this.isError = true;
            this.tblMain.removeRows();
            return;
        }
        this.actionRefresh_actionPerformed(null);
    }

    protected void getIncludeChildOrgUnits(Set<String> orgUnits) {
        if (orgUnits != null && this.chkIncludeChild.isSelected()) {
            KDTreeNode curNode = this.getSelectedTreeNode();
            this.getIncludeChildOrgUnits(curNode, orgUnits);
        }
    }

    protected void getIncludeChildOrgUnits(KDTreeNode node, Set<String> orgUnits) {
        if (this.isNodeEnable(node)) {
            String unitId = this.getNodeUnitId(node);
            if (!StringUtils.isEmpty((String)unitId)) {
                orgUnits.add(unitId);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode curNode = node.getChildAt(i);
                if (!(curNode instanceof KDTreeNode)) continue;
                this.getIncludeChildOrgUnits((KDTreeNode)curNode, orgUnits);
            }
        }
    }

    protected boolean isNodeEnable(KDTreeNode curNode) {
        if (curNode != null && curNode.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo info = (OrgStructureInfo)curNode.getUserObject();
            return info != null && (info.get("isEnable") == null || (Boolean)info.get("isEnable") != false);
        }
        return false;
    }

    public void builderTree(String orgTreeId, String orgUnitId, String orgUnitNumber) {
        try {
            OrgStructureCollection orgStructure = null;
            if (!StringUtils.isEmpty((String)orgTreeId) && StringUtils.isEmpty((String)orgUnitId) && StringUtils.isEmpty((String)orgUnitNumber)) {
                orgUnitNumber = this.getSelectOrgUnitNumber();
            }
            if (!(StringUtils.isEmpty((String)orgTreeId) || StringUtils.isEmpty((String)orgUnitId) && StringUtils.isEmpty((String)orgUnitNumber))) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("orgTreeId", orgTreeId);
                if (!StringUtils.isEmpty((String)orgUnitId)) {
                    condition.put("orgUnitId", orgUnitId);
                }
                if (!StringUtils.isEmpty((String)orgUnitNumber)) {
                    condition.put("orgUnitNumber", orgUnitNumber);
                }
                condition.put("isForOrgTreeF7", "true");
                condition.put("isUnion", "true");
                condition.put("permissionItem", "csl_groupCheckage_view");
                orgStructure = CslWorkTableFacadeFactory.getRemoteInstance().getOrgUnitTree(condition);
            }
            if (orgStructure != null) {
                CslWorkTableUIUtil.buildTree(this.treeMain, orgStructure, null);
            } else {
                ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
                if (this.tblMain != null) {
                    this.tblMain.removeRows();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"buildTree error.", (Throwable)ex);
            super.handleException(ex);
        }
    }

    protected String getSelectOrgUnitId() {
        KDTreeNode node = this.getSelectedTreeNode();
        return this.getNodeUnitId(node);
    }

    protected String getNodeUnitId(KDTreeNode node) {
        OrgStructureInfo info;
        if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null && info.getUnit().getId() != null) {
            return info.getUnit().getId().toString();
        }
        return null;
    }

    public String getSelectOrgUnitName() {
        OrgStructureInfo info;
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null && info.getUnit().getName() != null) {
            return info.getUnit().getName();
        }
        return null;
    }

    public String getSelectOrgUnitNumber() {
        OrgStructureInfo info;
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null && info.getUnit().getNumber() != null) {
            return info.getUnit().getNumber();
        }
        return null;
    }

    public String getRootUnitNumber() {
        OrgStructureInfo info;
        Object root;
        if (this.treeMain.getModel() != null && (root = this.treeMain.getModel().getRoot()) != null && root instanceof KDTreeNode && (info = (OrgStructureInfo)((KDTreeNode)root).getUserObject()) != null && info.getUnit() != null && info.getUnit().getNumber() != null) {
            return info.getUnit().getNumber();
        }
        return null;
    }

    public KDTreeNode getSelectedTreeNode() {
        Object node;
        if (this.treeMain.getSelectionPath() != null && (node = this.treeMain.getSelectionPath().getLastPathComponent()) instanceof KDTreeNode) {
            return (KDTreeNode)node;
        }
        return null;
    }

    protected void initTree() throws Exception {
        this.actionGroupAddNew.setVisible(false);
        this.actionGroupView.setVisible(false);
        this.actionGroupEdit.setVisible(false);
        this.actionGroupRemove.setVisible(false);
        this.actionGroupMoveTree.setVisible(false);
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        int count = this.treeView.getControlPane().getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (i != 3 && i != 2) continue;
            this.treeView.getControlPane().getComponent(i).setVisible(true);
        }
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    public static enum HandleType {
        audit,
        unAudit,
        diffHandle;

    }
}

