/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.BindInfo;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gl.RptBaseFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.EliminationListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractGroupCreateElimListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.LinkQueryCheckageDataListUI;
import com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableFacadeFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.BooleanAllEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GroupCreateElimListUI
extends AbstractGroupCreateElimListUI
implements KDTDataRequestListener {
    private static final Logger logger = CoreUIObject.getLogger(GroupCreateElimListUI.class);
    protected String selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
    protected UnionF7Helper.UnionF7 orgUnionf7 = null;
    protected Map<String, Class> key_Enum = new HashMap<String, Class>();
    protected CheckageFilterInfo filterInfo = null;
    protected int maxRow = -1;
    protected boolean isError = false;
    protected List<Uuid> requestIds = new ArrayList<Uuid>();
    protected boolean isShowMsg = false;
    protected MnsUnionF7 orgTreef7 = null;
    protected OrgTreeCollection orgTreeColl = null;
    protected Date[] curDate = null;
    protected Color color = new Color(0xF6F6BF);

    public GroupCreateElimListUI() throws Exception {
        this.tblMain.addKDTDataRequestListener((KDTDataRequestListener)this);
        int pageCount = 1500;
        this.tblMain.getDataRequestManager().setPageRowCount(pageCount);
        Field pageCountField = this.tblMain.getDataRequestManager().getClass().getDeclaredField("pageRowCount");
        NewRptUtil.makeAccessible(pageCountField);
        pageCountField.set(this.tblMain.getDataRequestManager(), pageCount);
        pageCountField = this.tblMain.getDataRequestManager().getClass().getDeclaredField("queryPageRowCount");
        NewRptUtil.makeAccessible(pageCountField);
        pageCountField.set(this.tblMain.getDataRequestManager(), pageCount);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initFromGroupCheckageList();
        this.initSelectRowSumField();
        CslRptUIUtil.setActionVisible((CoreUI)this, (String)"actionMoveTree");
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.checkParsed();
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("companyName") + 1);
    }

    protected void initSelectRowSumField() throws Exception {
        ArrayList<String> fieldSumList = new ArrayList<String>();
        fieldSumList.add("debit");
        fieldSumList.add("credit");
        HashMap<String, String> fieldKeyMap = new HashMap<String, String>();
        fieldKeyMap.put("debit", "debit");
        fieldKeyMap.put("credit", "credit");
        this.getUIContext().put("innerFieldKeyMap", fieldKeyMap);
        this.getUIContext().put("innerMergeColumnKeyList", new ArrayList());
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        fieldNameMap.put("debit", ((ColumnItemData)this.tblMain.getColumn("debit").getUserObject()).getTitle());
        fieldNameMap.put("credit", ((ColumnItemData)this.tblMain.getColumn("credit").getUserObject()).getTitle());
        this.getUIContext().put("innerFieldNameMap", fieldNameMap);
        this.setCurrentListUISumList(fieldSumList);
        this.setField(this.tblMain.getColumnIndex("debit"), "debit");
        this.setField(this.tblMain.getColumnIndex("credit"), "credit");
    }

    protected void initFromGroupCheckageList() throws Exception {
        Map uiContext = this.getUIContext();
        CheckageFilterInfo filterInfo = (CheckageFilterInfo)uiContext.get("filterInfo");
        if (filterInfo != null) {
            Object orgUnitInfo;
            int i;
            for (i = 0; i < this.kdPeriodType.getItemCount(); ++i) {
                if (((RptPeriodTypeEnum)this.kdPeriodType.getItemAt(i)).getValue() != filterInfo.periodType) continue;
                this.kdPeriodType.setSelectedIndex(i);
                break;
            }
            this.kdYear.setValue((Object)filterInfo.year, false);
            this.kdPeriod.setValue((Object)filterInfo.period, true);
            for (i = 0; i < this.kdCurrency.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.kdCurrency.getItemAt(i)).getId().toString().equals(filterInfo.currencyId)) continue;
                this.kdCurrency.setSelectedIndex(i);
                break;
            }
            if (filterInfo.checkType >= 0) {
                this.kdCheckType.setSelectedItem((Object)ElimTypeEnum.getEnum((int)filterInfo.checkType));
            }
            this.kdOrgTree.setValue(uiContext.get("orgTreeInfo"));
            Object isIncludeChild = uiContext.get("isIncludeChild");
            if (isIncludeChild != null && isIncludeChild instanceof Boolean) {
                this.chkIncludeChild.setSelected(((Boolean)isIncludeChild).booleanValue());
            }
            if ((orgUnitInfo = uiContext.get("orgUnitInfo")) != null && orgUnitInfo instanceof FullOrgUnitInfo) {
                this.builderTree(((OrgTreeInfo)uiContext.get("orgTreeInfo")).getId().toString(), ((FullOrgUnitInfo)orgUnitInfo).getId().toString(), null);
            } else {
                this.actionRefresh_actionPerformed(null);
            }
        }
    }

    protected void init() throws Exception {
        this.tblMain.getColumn("isSelect").getStyleAttributes().setLocked(false);
        this.curDate = new Date[]{CslRptUIUtil.getLastPeriodDate(null)};
        this.orgTreeColl = CslWorkTableUIUtil.getAllOrgTreeColl();
        AccountCheckUtil.initCurrency(this.kdCurrency);
        AccountCheckUtil.initYearPeriodAndPeriodType(this.kdYear, this.kdPeriod, this.kdPeriodType, null, this.curDate, this.selectAll, this.orgTreeColl, this.kdOrgTree, null, null, (ListUI)this);
        this.initOrgTree();
        this.initCheckType();
        this.initDebitEqualCredit();
        this.initElimType();
        this.key_Enum.put("checkType", ElimTypeEnum.class);
        this.key_Enum.put("isEqual", BooleanAllEnum.class);
        this.key_Enum.put("isSupportImport", BooleanAllEnum.class);
        this.btnSelectAll.setVisible(false);
        this.btnClearAll.setVisible(false);
        this.kDMenuItem1.setVisible(false);
        this.kDMenuItem2.setVisible(false);
    }

    protected void initDebitEqualCredit() {
        this.kdDebitEqCredit.addItem((Object)BooleanAllEnum.All);
        this.kdDebitEqCredit.addItem((Object)BooleanAllEnum.Yes);
        this.kdDebitEqCredit.addItem((Object)BooleanAllEnum.No);
        this.kdDebitEqCredit.setSelectedIndex(0);
    }

    protected void initElimType() throws Exception {
        this.kdElimType.addItem((Object)this.selectAll);
        EliminationModeCollection coll = EliminationModeFactory.getRemoteInstance().getEliminationModeCollection("select id,name,number order by number ");
        for (int i = 0; i < coll.size(); ++i) {
            this.kdElimType.addItem((Object)coll.get(i));
        }
        this.kdElimType.setSelectedIndex(0);
    }

    protected void initCheckType() {
        this.kdCheckType.addItem((Object)this.selectAll);
        this.kdCheckType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.kdCheckType.addItem((Object)ElimTypeEnum.exchange);
        this.kdCheckType.setSelectedIndex(0);
    }

    protected void initOrgTree() throws Exception {
        if (this.orgTreef7 == null) {
            this.orgTreef7 = new MnsUnionF7((IUIObject)this);
            this.orgTreef7.setF7uiTiTle(AccountCheckUtil.getResourceString(null, "460selectOrgTree", null));
            this.orgTreef7.setShowAssistantOrg(true);
            this.orgTreef7.setCheckedAssistantOrgChkBox(true);
            this.orgTreef7.setEnableCurOrgTreeRootNode(true);
            this.orgTreef7.setMultiSelect(false);
            this.orgTreef7.setSelectMode(2);
            this.orgTreef7.setCascadingSelection(false);
            HashSet selectOrgIdSet = new HashSet();
            this.orgTreef7.setCheckedOrgIDs(selectOrgIdSet);
            this.orgTreef7.setUnChangeableOrgIDs(selectOrgIdSet);
            this.orgTreef7.setPermissionItem("csl_checkageCreateElim_view");
            this.orgTreef7.setOrgTreeColl(CslWorkTableUIUtil.getOrgTreeColl(this.orgTreeColl, AccountCheckUtil.getDate(this.kdYear, this.kdPeriod, this.kdPeriodType)));
            this.orgTreef7.initUI();
            this.orgTreef7.reRoadOrgTree();
        }
        this.kdOrgTree.setSelector((KDPromptSelector)this.orgTreef7);
        this.kdOrgTree.setEditable(false);
        this.kdOrgTree.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (GroupCreateElimListUI.this.kdOrgTree.getValue() != null) {
                    if (GroupCreateElimListUI.this.kdOrgTree.getData() instanceof FullOrgUnitInfo) {
                        FullOrgUnitInfo curOrgUnitInfo = (FullOrgUnitInfo)GroupCreateElimListUI.this.kdOrgTree.getData();
                        GroupCreateElimListUI.this.kdOrgTree.setData((Object)GroupCreateElimListUI.this.orgTreef7.getSelectedTree());
                        String treeId = GroupCreateElimListUI.this.orgTreef7.getSelectedTree().getId().toString();
                        GroupCreateElimListUI.this.builderTree(treeId, curOrgUnitInfo.getId().toString(), null);
                        return;
                    }
                    GroupCreateElimListUI.this.builderTree(((OrgTreeInfo)GroupCreateElimListUI.this.kdOrgTree.getValue()).getId().toString(), null, null);
                } else {
                    GroupCreateElimListUI.this.builderTree(null, null, null);
                }
            }
        });
    }

    protected boolean checkInput() throws Exception {
        if (this.kdOrgTree.getValue() == null) {
            if (this.isShowMsg) {
                MsgBox.showWarning((String)AccountCheckUtil.getResourceString(null, "98selectOrgTree", null));
            }
            return false;
        }
        if (this.getSelectOrgUnitId() == null) {
            if (this.isShowMsg) {
                MsgBox.showWarning((String)AccountCheckUtil.getResourceString(null, "99selectOrgUnit", null));
            }
            return false;
        }
        return true;
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        if (!this.isError) {
            try {
                if (!this.checkInput()) {
                    return;
                }
                int from = e.getFirstRow();
                int length = e.getLastRow() - e.getFirstRow() + 1;
                if (from == 0) {
                    CheckageFilterInfo curFilterInfo = this.initFilter();
                    this.filterInfo = CheckageBillFactory.getRemoteInstance().preCreateElim(curFilterInfo);
                    this.maxRow = this.filterInfo.maxRow;
                    KDTFootManager footRowManager = this.tblMain.getFootManager();
                    IRow footRow = null;
                    if (footRowManager == null) {
                        footRowManager = new KDTFootManager(this.tblMain);
                        footRowManager.addFootView();
                        this.tblMain.setFootManager(footRowManager);
                        footRow = footRowManager.addFootRow(0);
                        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
                        footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                        this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
                        this.tblMain.getIndexColumn().setWidth(30);
                        footRowManager.addIndexText(0, EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total"));
                        this.setRowNumberFormat(footRow);
                    } else {
                        footRow = footRowManager.getFootRow(0);
                    }
                    footRow.getCell("debit").setValue((Object)this.filterInfo.debitTotal);
                    footRow.getCell("credit").setValue((Object)this.filterInfo.creditTotal);
                    if (!StringUtils.isEmpty((CharSequence)this.filterInfo.msg)) {
                        MsgBox.showInfo((Component)((Object)this), (String)this.filterInfo.msg.toString());
                    }
                }
                int tableRowCount = this.tblMain.getRowCount3();
                if (this.maxRow <= 0 || this.maxRow <= tableRowCount) {
                    return;
                }
                if (tableRowCount < this.maxRow && tableRowCount + length > this.maxRow) {
                    length = this.maxRow - tableRowCount;
                }
                this.filterInfo.from = from;
                this.filterInfo.lenth = length;
                List elims = CheckageBillFactory.getRemoteInstance().getPreElimDatas(this.filterInfo);
                if (elims != null) {
                    int rowFrom = this.tblMain.getRowCount3();
                    this.insertRows(elims, rowFrom, this.tblMain);
                }
                this.groupTableRow();
                this.setBigDecimalFormat();
            }
            catch (Throwable ex) {
                this.isError = true;
                logger.error((Object)"tableDataRequest error.", ex);
                if (this.requestIds != null && !this.requestIds.isEmpty()) {
                    try {
                        this.releaseCheckControllock();
                    }
                    catch (Throwable et) {
                        logger.error((Object)"releaseCheckControlLock error.", ex);
                        ExceptionHandler.handle((Throwable)ex);
                    }
                }
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }

    private void setBigDecimalFormat() {
        this.tblMain.getColumn("debit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("credit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("sorNumber").setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("summary").setGroup(true);
        this.tblMain.getColumn("orgUnitName").setGroup(true);
        this.tblMain.getColumn("companyName").setGroup(true);
        this.tblMain.getColumn("sorNumber").setMergeable(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("summary").setMergeable(true);
        this.tblMain.getColumn("companyName").setMergeable(true);
    }

    private void insertRows(List rows, int insertRowIndex, KDTable table) throws Exception {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        table.setRefresh(false);
        KDTColumns columns = table.getColumns();
        IRow row = null;
        for (int i = 0; i < rows.size(); ++i) {
            Map rowData = (Map)rows.get(i);
            row = table.setRow(insertRowIndex++);
            this.setRowValue(row, rowData, columns);
            row.getCell("isSelect").setValue((Object)false);
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    private void setRowValue(IRow row, Map<String, Object> rowData, KDTColumns columns) throws Exception {
        ICell cell = null;
        Object value = null;
        String currencyName = ((CurrencyInfo)this.kdCurrency.getSelectedItem()).getName();
        for (int c = 0; c < columns.size(); ++c) {
            String columnKey = columns.getColumnKey(c);
            cell = row.getCell(columnKey);
            if (columnKey.equals("currency")) {
                cell.setValue((Object)currencyName);
                continue;
            }
            if (columnKey.equals("isFixElim")) {
                cell.setValue((Object)BooleanAllEnum.No.getAlias());
                continue;
            }
            if (columnKey.equals("dataType")) {
                cell.setValue((Object)ValueTypeEnum.MONEY);
                continue;
            }
            value = rowData.get(columnKey.toUpperCase(Locale.ENGLISH));
            if (this.key_Enum.containsKey(columnKey) && value != null) {
                cell.setValue((Object)CslWorkTableUIUtil.getEnum(this.key_Enum.get(columnKey), Integer.valueOf(value.toString())));
                continue;
            }
            cell.setValue(value);
        }
        row.getCell("sorNumber").setValue(row.getCell("number").getValue());
        if (row.getCell("isDiff").getValue() != null && Integer.valueOf(row.getCell("isDiff").getValue().toString()) == 1) {
            if (row.getCell("debit").getValue() != null) {
                row.getCell("debit").getStyleAttributes().setBackground(this.color);
            } else if (row.getCell("credit").getValue() != null) {
                row.getCell("credit").getStyleAttributes().setBackground(this.color);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getKeyFieldName() {
        return "number";
    }

    protected CheckageFilterInfo initFilter() {
        if (this.filterInfo == null) {
            this.filterInfo = new CheckageFilterInfo();
        }
        this.filterInfo.clear();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.kdPeriodType.getSelectedItem();
        this.filterInfo.itemType = -1;
        this.filterInfo.periodType = periodType.getValue();
        this.filterInfo.year = this.kdYear.getIntegerVlaue();
        this.filterInfo.period = this.kdPeriod.getIntegerVlaue();
        CurrencyInfo currency = (CurrencyInfo)this.kdCurrency.getSelectedItem();
        this.filterInfo.currencyId = currency.getId().toString();
        this.filterInfo.currencyNumber = currency.getNumber();
        this.filterInfo.precision = currency.getPrecision();
        this.filterInfo.treeId = ((OrgTreeInfo)this.kdOrgTree.getValue()).getId().toString();
        this.filterInfo.orgUnitId = this.getSelectOrgUnitId();
        this.filterInfo.isIncludeChild = this.chkIncludeChild.isSelected();
        this.getIncludeChildOrgUnits(this.filterInfo.hasPermOrgIds);
        if (this.kdCheckType.getSelectedIndex() != 0) {
            this.filterInfo.checkType = ((ElimTypeEnum)this.kdCheckType.getSelectedItem()).getValue();
        }
        this.filterInfo.isDCEquals = ((BooleanAllEnum)this.kdDebitEqCredit.getSelectedItem()).getValue();
        if (this.kdElimType.getSelectedIndex() != 0) {
            this.filterInfo.elimModeId = ((EliminationModeInfo)this.kdElimType.getSelectedItem()).getId().toString();
        }
        this.filterInfo.isLastPeriod12 = this.kdIsLastPeriod12.isSelected();
        return this.filterInfo;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        ICell cell = null;
        for (int i = 0; i < rowCount; ++i) {
            cell = this.tblMain.getCell(i, "isSelect");
            if (cell == null || cell.getStyleAttributes().isLocked()) continue;
            cell.setValue((Object)true);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        ICell cell = null;
        for (int i = 0; i < rowCount; ++i) {
            cell = this.tblMain.getCell(i, "isSelect");
            if (cell == null || cell.getStyleAttributes().isLocked()) continue;
            cell.setValue((Object)false);
        }
    }

    @Override
    public void actionLinkQueryCheckBill_actionPerformed(ActionEvent e) throws Exception {
        String companyId;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
            return;
        }
        IRow row = this.tblMain.getRow(selectRows[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String string = companyId = row.getCell("companyId").getValue() == null ? null : row.getCell("companyId").getValue().toString();
        if (row.getCell("isDiff").getValue() != null && Integer.valueOf(row.getCell("isDiff").getValue().toString()) == 1) {
            companyId = null;
        }
        params.put("companyId", companyId);
        params.put("itemNumber", row.getCell("itemNumber").getValue().toString());
        params.put("dataElement", row.getCell("dataElement").getValue());
        params.put("number", row.getCell("number").getValue().toString());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"params", params);
        uiContext.put((Object)"filterInfo", (Object)this.filterInfo);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(LinkQueryCheckageDataListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        ((UINewFrame)window).setPreferredSize(new Dimension(1450, 600));
        window.show();
        ((UINewFrame)window).setExtendedState(0);
    }

    @Override
    public void actionCreateElim_actionPerformed(ActionEvent e) throws Exception {
        Object orgName;
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
            return;
        }
        int rowCount3 = this.tblMain.getRowCount3();
        if (this.tblMain.getSelectManager().get().getMode() == 8 && rowCount3 < this.maxRow) {
            while (rowCount3 < this.maxRow) {
                this.tblMain.getRow(rowCount3);
                rowCount3 = this.tblMain.getRowCount3();
            }
            this.tblMain.getSelectManager().select(0, 0, rowCount3, this.tblMain.getColumnCount());
        }
        HashMap<String, String> elimNumber_orgIdMap = new HashMap<String, String>();
        HashMap<String, String> orgUnitId_NameMap = new HashMap<String, String>();
        IRow row = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StringBuffer msg = new StringBuffer();
        for (int i : selectRows) {
            row = this.tblMain.getRow(i);
            orgUnitId_NameMap.put((String)row.getCell("orgUnitId").getValue(), (String)row.getCell("orgUnitName").getValue());
            String number = (String)row.getCell("number").getValue();
            if (elimNumber_orgIdMap.containsKey(number)) continue;
            elimNumber_orgIdMap.put(number, (String)row.getCell("orgUnitId").getValue());
            BooleanAllEnum isEqual = (BooleanAllEnum)row.getCell("isEqual").getValue();
            if (!BooleanAllEnum.No.equals((Object)isEqual)) continue;
            if (msg.length() > 0) {
                msg.append(",");
            }
            msg.append(number);
        }
        if (elimNumber_orgIdMap.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "101selectRow", null));
            return;
        }
        boolean isCreate = true;
        if (msg.length() > 0) {
            isCreate = elimNumber_orgIdMap.size() == 1 ? MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "123dcNotEqual", null))) : MsgBox.isOk((int)MsgBox.showConfirm3((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "124partDcNotEqual", null), (String)msg.toString()));
        }
        if (!isCreate) {
            return;
        }
        Map<String, Object> orgUnitPerms = this.checkPermission("csl_checkageCreateElim_create", orgUnitId_NameMap);
        if (orgUnitPerms != null && orgUnitPerms.size() == 1 && (orgName = orgUnitPerms.values().iterator().next()) instanceof String) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "452createElimFail", null), (String)AccountCheckUtil.getResourceString(null, "453noCreateElimPerm", new Object[]{orgName}), (int)8188);
            return;
        }
        if (isCreate) {
            msg.setLength(0);
            Set<String> elimNumbers = this.getHavePermissionNumbers(orgUnitId_NameMap, elimNumber_orgIdMap, msg);
            if (elimNumbers == null || elimNumbers.isEmpty()) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "452createElimFail", null), (String)msg.toString(), (int)8188);
                return;
            }
            this.filterInfo.isGenerateDynaElim = this.kdAutoCreateDyElim.isSelected();
            Map reslut = CheckageBillFactory.getRemoteInstance().createElim(elimNumbers, this.filterInfo);
            if (reslut != null) {
                Object object = reslut.get("successNumbers");
                if (reslut.get("detailMsg") != null) {
                    msg.append(reslut.get("detailMsg").toString());
                }
                if (msg.length() > 0) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "125partCreateFail", null), (String)msg.toString(), (int)8188);
                }
                if (object != null) {
                    Set successNumbers = (Set)object;
                    if (successNumbers.size() == elimNumber_orgIdMap.size()) {
                        MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "126elimCreateSuccess", null));
                    }
                    this.actionRefresh_actionPerformed(e);
                }
            } else if (msg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "125partCreateFail", null), (String)msg.toString(), (int)8188);
            }
        }
    }

    @Override
    public void actionOpenElim_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkInput()) {
            OrgStructureInfo info;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"orgBound", (Object)((OrgTreeInfo)this.kdOrgTree.getValue()));
            uiContext.put((Object)"year", (Object)this.kdYear.getIntegerVlaue());
            uiContext.put((Object)"period", (Object)this.kdPeriod.getIntegerVlaue());
            uiContext.put((Object)"date", (Object)RPTDateUtil.getPeriodLastDate((int)this.kdYear.getIntegerVlaue(), (int)this.kdPeriod.getIntegerVlaue(), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.kdPeriodType.getSelectedItem())));
            uiContext.put((Object)"periodType", (Object)((RptPeriodTypeEnum)this.kdPeriodType.getSelectedItem()));
            KDTreeNode node = this.getSelectedTreeNode();
            FullOrgUnitInfo unit = null;
            if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null) {
                unit = info.getUnit();
            }
            if (unit == null) {
                return;
            }
            uiContext.put((Object)"orgUnit", unit);
            uiContext.put((Object)"currency", (Object)((CurrencyInfo)this.kdCurrency.getSelectedItem()));
            IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(EliminationListUI.class.getName(), (Map)uiContext, null);
            iUIWindow.show();
        }
    }

    @Override
    public void actionQueryElim_actionPerformed(ActionEvent e) throws Exception {
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkInput()) {
            if (this.requestMutex()) {
                this.isError = false;
                this.tblMain.removeRows();
            } else {
                this.isError = true;
                this.tblMain.removeRows();
            }
        }
    }

    public boolean requestMutex() throws Exception {
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        KDTreeNode curNode = this.getSelectedTreeNode();
        if (this.chkIncludeChild.isSelected()) {
            this.getIncludeChildOrgUnits(curNode, orgUnitMap);
        } else {
            String[] unitId = this.getNodeUnitId(curNode);
            orgUnitMap.put(unitId[0], unitId[1]);
        }
        if (!this.requestIds.isEmpty()) {
            this.releaseCheckControllock();
        }
        MessageFormat descriptionFormat = new MessageFormat(AccountCheckUtil.getResourceString(null, "127cantParallelCreateElim", null));
        String actionNameHead = AccountCheckUtil.getResourceString(null, "128checkPreCreateElim", null);
        StringBuffer mutexName = new StringBuffer();
        ArrayList<String[]> MutexParameters = new ArrayList<String[]>();
        for (String orgUntid : orgUnitMap.keySet()) {
            String description = descriptionFormat.format(new Object[]{SysContext.getSysContext().getUserName(), orgUnitMap.get(orgUntid)});
            mutexName.setLength(0);
            mutexName.append(((CurrencyInfo)this.kdCurrency.getSelectedItem()).getId().toString());
            mutexName.append(((OrgTreeInfo)this.kdOrgTree.getValue()).getId().toString());
            mutexName.append(orgUntid);
            String actionName = actionNameHead + "[" + (String)orgUnitMap.get(orgUntid) + "]";
            String[] param = new String[]{actionName, mutexName.toString(), description};
            MutexParameters.add(param);
        }
        if (!MutexParameters.isEmpty()) {
            Map reqMutexRes = AccountCheckFacadeFactory.getRemoteInstance().batchRequestMutex(MutexParameters);
            Object msg = reqMutexRes.get("failMsg");
            if (msg != null && !StringUtils.isEmpty((CharSequence)msg.toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
                return false;
            }
            List succRequestIds = (List)reqMutexRes.get("requestIds");
            if (succRequestIds != null && !succRequestIds.isEmpty()) {
                this.requestIds.addAll(succRequestIds);
            }
        }
        return true;
    }

    protected void releaseCheckControllock() throws Exception {
        AccountCheckFacadeFactory.getRemoteInstance().batchReleaseMutex(this.requestIds);
        this.requestIds.clear();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void disposeUIWindow() {
        if (this.filterInfo != null) {
            try {
                IRptBase iRptBase = RptBaseFactory.getRemoteInstance();
                if (this.filterInfo.tmpTable != null) {
                    iRptBase.dropTable(this.filterInfo.tmpTable);
                }
                if (this.filterInfo.billLinkElimTable != null) {
                    iRptBase.dropTable(this.filterInfo.billLinkElimTable);
                }
                this.releaseCheckControllock();
            }
            catch (Exception e) {
                logger.error((Object)"disposeUIWindow_BOSException", (Throwable)e);
            }
        }
        super.disposeUIWindow();
    }

    private void setRowNumberFormat(IRow row) {
        if (row != null) {
            String nuberFormat = "%R-{#,##0.00}f";
            Object currency = this.kdCurrency.getSelectedItem();
            if (currency != null) {
                int currencyPrecision = ((CurrencyInfo)currency).getPrecision();
                StringBuffer sb = new StringBuffer();
                if (currencyPrecision == 0) {
                    sb.append("#");
                } else {
                    sb.append("0.");
                    for (int j = 0; j < currencyPrecision; ++j) {
                        sb.append("0");
                    }
                }
                nuberFormat = nuberFormat.replaceAll("0.00", sb.toString());
            }
            row.getCell("debit").getStyleAttributes().setNumberFormat(nuberFormat);
            row.getCell("credit").getStyleAttributes().setNumberFormat(nuberFormat);
        }
    }

    public Set<String> getHavePermissionNumbers(Map<String, String> orgUnitId_nameMap, Map<String, String> elimNumber_orgIdMap, StringBuffer msg) throws Exception {
        Map<String, Object> orgUnitPerms = this.checkPermission("csl_checkageCreateElim_create", orgUnitId_nameMap);
        HashSet<String> elimNumbers = new HashSet<String>();
        if (orgUnitPerms != null && !this.handlePermission(orgUnitPerms, orgUnitId_nameMap, elimNumber_orgIdMap, msg, elimNumbers, AccountCheckUtil.getResourceString(null, "453noCreateElimPerm", null))) {
            return null;
        }
        boolean isGenerElimAudited = CSLParamUtil.getParamBooleanValue(null, (String)"GR_CSL_DZPT_GenerateEliminationAudited");
        if (isGenerElimAudited) {
            orgUnitPerms = this.checkPermission("csl_elivoucher_approve", orgUnitId_nameMap);
            if (!this.handlePermission(orgUnitPerms, orgUnitId_nameMap, elimNumber_orgIdMap, msg, elimNumbers, AccountCheckUtil.getResourceString(null, "454noAuditPerm", null))) {
                return null;
            }
            if (!elimNumbers.isEmpty() && !MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "481createAuditElim", null)))) {
                this.abort();
            }
        }
        return elimNumbers;
    }

    protected boolean handlePermission(Map<String, Object> orgUnitPerms, Map<String, String> orgUnitId_nameMap, Map<String, String> elimNumber_orgIdMap, StringBuffer msg, Set<String> elimNumbers, String errorMsg) throws Exception {
        if (orgUnitPerms != null) {
            Object orgName;
            MessageFormat format = null;
            if (orgUnitPerms.size() == 1 && (orgName = orgUnitPerms.values().iterator().next()) instanceof String) {
                if (format == null) {
                    format = new MessageFormat(errorMsg);
                }
                msg.append(format.format(new Object[]{orgName})).append("\r\n");
                elimNumbers.clear();
                return false;
            }
            HashSet<String> handleOrgUnitIds = new HashSet<String>();
            for (String number : elimNumber_orgIdMap.keySet()) {
                Object orgName2;
                String orgUnitId = elimNumber_orgIdMap.get(number);
                if (handleOrgUnitIds.contains(orgUnitId) || (orgName2 = orgUnitPerms.get(orgUnitId)) == null) continue;
                if (orgName2 instanceof String) {
                    orgUnitId_nameMap.remove(orgUnitId);
                    elimNumbers.remove(number);
                    handleOrgUnitIds.add(orgUnitId);
                    if (format == null) {
                        format = new MessageFormat(errorMsg);
                    }
                    msg.append(format.format(new Object[]{orgName2})).append("\r\n");
                    continue;
                }
                elimNumbers.add(number);
            }
        }
        return true;
    }

    public Map<String, Object> checkPermission(String permission, Map<String, String> orgUnitId_nameMap) throws Exception {
        if (this.checkInput()) {
            HashMap<String, Object> orgUnitPerms = new HashMap<String, Object>();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            for (String curOrgUnitId : orgUnitId_nameMap.keySet()) {
                try {
                    PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(curOrgUnitId), (String)permission);
                    orgUnitPerms.put(curOrgUnitId, true);
                }
                catch (Exception e) {
                    orgUnitPerms.put(curOrgUnitId, orgUnitId_nameMap.get(curOrgUnitId));
                    logger.error((Object)"checkPermission", (Throwable)e);
                }
            }
            return orgUnitPerms;
        }
        this.abort();
        return null;
    }

    public void builderTree(String orgTreeId, String orgUnitId, String orgUnitNumber) {
        try {
            OrgStructureCollection orgStructure = null;
            if (!StringUtils.isEmpty((CharSequence)orgTreeId) && StringUtils.isEmpty((CharSequence)orgUnitId) && StringUtils.isEmpty((CharSequence)orgUnitNumber)) {
                orgUnitNumber = this.getSelectOrgUnitNumber();
            }
            if (!(StringUtils.isEmpty((CharSequence)orgTreeId) || StringUtils.isEmpty((CharSequence)orgUnitId) && StringUtils.isEmpty((CharSequence)orgUnitNumber))) {
                HashMap<String, String> condition = new HashMap<String, String>();
                condition.put("orgTreeId", orgTreeId);
                if (!StringUtils.isEmpty((CharSequence)orgUnitId)) {
                    condition.put("orgUnitId", orgUnitId);
                }
                if (!StringUtils.isEmpty((CharSequence)orgUnitNumber)) {
                    condition.put("orgUnitNumber", orgUnitNumber);
                }
                condition.put("isForOrgTreeF7", "true");
                condition.put("isUnion", "true");
                condition.put("permissionItem", "csl_checkageCreateElim_view");
                orgStructure = CslWorkTableFacadeFactory.getRemoteInstance().getOrgUnitTree(condition);
            }
            if (orgStructure != null) {
                CslWorkTableUIUtil.buildTree(this.treeMain, orgStructure, null);
            } else {
                ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
                if (this.tblMain != null) {
                    this.tblMain.removeRows();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"buildTree error.", (Throwable)ex);
            super.handleException(ex);
        }
    }

    protected String getSelectOrgUnitId() {
        KDTreeNode node = this.getSelectedTreeNode();
        String[] units = this.getNodeUnitId(node);
        if (units != null && units.length > 0) {
            return units[0];
        }
        return null;
    }

    protected String[] getNodeUnitId(KDTreeNode node) {
        OrgStructureInfo info;
        if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null && info.getUnit().getId() != null) {
            return new String[]{info.getUnit().getId().toString(), info.getUnit().getName()};
        }
        return null;
    }

    public String getSelectOrgUnitNumber() {
        OrgStructureInfo info;
        KDTreeNode node = this.getSelectedTreeNode();
        if (node != null && (info = (OrgStructureInfo)node.getUserObject()) != null && info.getUnit() != null && info.getUnit().getNumber() != null) {
            return info.getUnit().getNumber();
        }
        return null;
    }

    public String getRootUnitNumber() {
        OrgStructureInfo info;
        Object root;
        if (this.treeMain.getModel() != null && (root = this.treeMain.getModel().getRoot()) != null && root instanceof KDTreeNode && (info = (OrgStructureInfo)((KDTreeNode)root).getUserObject()) != null && info.getUnit() != null && info.getUnit().getNumber() != null) {
            return info.getUnit().getNumber();
        }
        return null;
    }

    public KDTreeNode getSelectedTreeNode() {
        Object node;
        if (this.treeMain.getSelectionPath() != null && (node = this.treeMain.getSelectionPath().getLastPathComponent()) instanceof KDTreeNode) {
            return (KDTreeNode)node;
        }
        return null;
    }

    protected void getIncludeChildOrgUnits(Set<String> orgUnits) {
        if (orgUnits != null && this.chkIncludeChild.isSelected()) {
            KDTreeNode curNode = this.getSelectedTreeNode();
            HashMap<String, String> orgUnitMap = new HashMap<String, String>();
            this.getIncludeChildOrgUnits(curNode, orgUnitMap);
            orgUnits.addAll(orgUnitMap.keySet());
        }
    }

    protected void getIncludeChildOrgUnits(KDTreeNode node, Map<String, String> orgUnits) {
        block5: {
            if (node == null) break block5;
            if (this.isNodeEnable(node)) {
                String[] unitId = this.getNodeUnitId(node);
                if (unitId != null && !StringUtils.isEmpty((CharSequence)unitId[0])) {
                    orgUnits.put(unitId[0], unitId[1]);
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    TreeNode curNode = node.getChildAt(i);
                    if (!(curNode instanceof KDTreeNode)) continue;
                    this.getIncludeChildOrgUnits((KDTreeNode)curNode, orgUnits);
                }
            } else {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    TreeNode curNode = node.getChildAt(i);
                    if (!(curNode instanceof KDTreeNode)) continue;
                    this.getIncludeChildOrgUnits((KDTreeNode)curNode, orgUnits);
                }
            }
        }
    }

    protected boolean isNodeEnable(KDTreeNode curNode) {
        if (curNode != null && curNode.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo info = (OrgStructureInfo)curNode.getUserObject();
            return info != null && (info.get("isEnable") == null || (Boolean)info.get("isEnable") != false);
        }
        return false;
    }

    protected void initTree() throws Exception {
        this.actionGroupAddNew.setVisible(false);
        this.actionGroupView.setVisible(false);
        this.actionGroupEdit.setVisible(false);
        this.actionGroupRemove.setVisible(false);
        this.actionGroupMoveTree.setVisible(false);
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        int count = this.treeView.getControlPane().getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (i != 3 && i != 2) continue;
            this.treeView.getControlPane().getComponent(i).setVisible(true);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        OrgStructureInfo info;
        KDTreeNode curNode = this.getSelectedTreeNode();
        if (curNode != null && curNode.getUserObject() instanceof OrgStructureInfo && (info = (OrgStructureInfo)curNode.getUserObject()) != null && info.get("isEnable") != null && !((Boolean)info.get("isEnable")).booleanValue() && !this.chkIncludeChild.isSelected()) {
            this.isError = true;
            this.tblMain.removeRows();
            return;
        }
        this.actionRefresh_actionPerformed(null);
    }

    public List<String> getFieldSumList() {
        ArrayList<String> fieldSumList = new ArrayList<String>();
        fieldSumList.add("debit");
        fieldSumList.add("credit");
        return fieldSumList;
    }

    public void setField(int colIndex, String field) {
        try {
            KDTColumn column;
            if (this.tblMain.getColumn(colIndex) != null && (column = this.tblMain.getColumn(colIndex).getKDTColumn()) != null) {
                Method method = column.getClass().getDeclaredMethod("getBindInfo", new Class[0]);
                NewRptUtil.makeAccessible(method);
                BindInfo info = (BindInfo)method.invoke((Object)column, new Object[0]);
                if (info != null) {
                    info.setFieldName(field);
                } else {
                    info = new BindInfo();
                    info.setFieldName(field);
                    method = column.getClass().getDeclaredMethod("setBindInfo", BindInfo.class);
                    NewRptUtil.makeAccessible(method);
                    method.invoke((Object)column, info);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"setField", (Throwable)ex);
        }
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }
}

