/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.ShowUIMessageAction;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CompareCharEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractImmediateExecutionUI;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ImmediateExecutionUI
extends AbstractImmediateExecutionUI {
    private static final Logger logger = CoreUIObject.getLogger(ImmediateExecutionUI.class);
    private AutoCheckSchmInfo schmInfo = null;
    private boolean isSelectCompany = false;
    private boolean isSelectOrgUnit = false;
    private Date realDate = null;

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    public void onLoad() throws Exception {
        this.schmInfo = (AutoCheckSchmInfo)this.getUIContext().get("schm");
        this.realDate = SysUtil.getAppServerTime(null);
        this.bindBtnAction();
        this.init();
        super.onLoad();
        if (this.schmInfo != null) {
            this.dataBinder.setValueObject((IObjectValue)this.schmInfo);
        }
        super.loadFields();
        this.initSpinnerVal(false);
        KDToolBar[] bars = this.getUIMultiToolBar();
        for (int i = 0; i < bars.length; ++i) {
            bars[i].setVisible(false);
        }
    }

    private void bindBtnAction() {
        this.comboPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ImmediateExecutionUI.this.schmInfo.setPeriodType((RptPeriodTypeEnum)ImmediateExecutionUI.this.comboPeriodType.getSelectedItem());
                ImmediateExecutionUI.this.setSpinnerMinMaxVal();
            }
        });
        this.spCurYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImmediateExecutionUI.this.initDatePick();
            }
        });
        this.spCurPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImmediateExecutionUI.this.initDatePick();
            }
        });
        this.chkIsGetCheckData.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    boolean isEnable = ImmediateExecutionUI.this.chkIsGetCheckData.getSelected() == 32;
                    ImmediateExecutionUI.this.radioCoverGetChkData.setEnabled(isEnable);
                    ImmediateExecutionUI.this.schmInfo.setIsGetCheckData(isEnable);
                }
                catch (Exception exc) {
                    logger.error((Object)"chkIsGetCheckData.itemStateChanged() ", (Throwable)exc);
                }
            }
        });
        this.chkIsConfirm.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    boolean isEnable = ImmediateExecutionUI.this.chkIsConfirm.getSelected() == 32;
                    ImmediateExecutionUI.this.comboSDiffCmpChar.setEnabled(isEnable);
                    ImmediateExecutionUI.this.comboDDiffCmpChar.setEnabled(isEnable);
                    ImmediateExecutionUI.this.txtConfirmSDffCmpValue.setEnabled(isEnable);
                    ImmediateExecutionUI.this.txtConfirmDDffCmpValue.setEnabled(isEnable);
                    ImmediateExecutionUI.this.schmInfo.setIsConfirm(isEnable);
                }
                catch (Exception exc) {
                    logger.error((Object)"chkIsConfirm.itemStateChanged() ", (Throwable)exc);
                }
            }
        });
        this.chkIsDiffHandle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    boolean isEnable = ImmediateExecutionUI.this.chkIsDiffHandle.getSelected() == 32;
                    ImmediateExecutionUI.this.comboSingleDiffMode.setEnabled(isEnable);
                    ImmediateExecutionUI.this.comboDoubleDiffMode.setEnabled(isEnable);
                    ImmediateExecutionUI.this.schmInfo.setIsDiffHandle(isEnable);
                }
                catch (Exception exc) {
                    logger.error((Object)"chkIsDiffHandle.itemStateChanged() ", (Throwable)exc);
                }
            }
        });
        this.chkIsAudit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    boolean isEnable = ImmediateExecutionUI.this.chkIsAudit.getSelected() == 32;
                    ImmediateExecutionUI.this.comboAuditSDiffCmpChar.setEnabled(isEnable);
                    ImmediateExecutionUI.this.comboAuditDDiffCmpChar.setEnabled(isEnable);
                    ImmediateExecutionUI.this.txtAuditSDiffCmpValue.setEnabled(isEnable);
                    ImmediateExecutionUI.this.txtAuditDDiffCmpValue.setEnabled(isEnable);
                    ImmediateExecutionUI.this.schmInfo.setIsAudit(isEnable);
                }
                catch (Exception exc) {
                    logger.error((Object)"chkIsAudit.itemStateChanged() ", (Throwable)exc);
                }
            }
        });
        this.chkIsCreateElim.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    boolean isCreateElim = ImmediateExecutionUI.this.chkIsCreateElim.getSelected() == 32;
                    ImmediateExecutionUI.this.radioLoanUnevenGenerate.setEnabled(isCreateElim);
                    ImmediateExecutionUI.this.radioLoanUnevenNoGenerate.setEnabled(isCreateElim);
                    ImmediateExecutionUI.this.schmInfo.setIsCreateElim(isCreateElim);
                }
                catch (Exception exc) {
                    logger.error((Object)"chkIsConfirm.itemStateChanged() ", (Throwable)exc);
                }
            }
        });
    }

    private void initDatePick() {
        int period = this.spCurPeriod.getIntegerVlaue();
        int year = this.spCurYear.getIntegerVlaue();
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        this.realDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodTypeEnum);
    }

    private void setSpinnerMinMaxVal() {
        CslWorkTableUIUtil.setSpineRangeByPeriodType(this.spCurPeriod, (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem(), this.spCurYear.getIntegerVlaue(), false, true);
        this.modifyPeriodRange();
        this.initSpinnerVal(false);
    }

    private void initSpinnerVal(boolean fireListener) {
        RptPeriodTypeEnum periodTypeEnum = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (periodTypeEnum == null) {
            return;
        }
        if (periodTypeEnum == RptPeriodTypeEnum.MONTHLY || periodTypeEnum == RptPeriodTypeEnum.SEMIYEARLY) {
            this.labelPeriod.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"MONTHLY"));
            this.spCurPeriod.setVisible(true);
            this.labelPeriod.setVisible(true);
        } else if (periodTypeEnum == RptPeriodTypeEnum.QUARTERLY) {
            this.labelPeriod.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"QUARTERLY"));
            this.spCurPeriod.setVisible(true);
            this.labelPeriod.setVisible(true);
        } else {
            this.spCurPeriod.setVisible(false);
            this.labelPeriod.setVisible(false);
        }
        int[] yearperiod = new int[2];
        yearperiod = RPTDateUtil.getPeriod((Date)this.realDate, (RptPeriodTypeEnum)periodTypeEnum);
        this.spCurYear.setValue((Object)yearperiod[0], fireListener);
        this.spCurPeriod.setValue((Object)yearperiod[1], fireListener);
    }

    private void init() throws EASBizException {
        this.comboPeriodType.addItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.comboPeriodType.addItem((Object)RptPeriodTypeEnum.QUARTERLY);
        this.comboPeriodType.addItem((Object)RptPeriodTypeEnum.SEMIYEARLY);
        this.comboPeriodType.addItem((Object)RptPeriodTypeEnum.YEARLY);
        CurrencyCollection currencyCollection = this.getCurrencyCollection();
        if (currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                this.comboCurreny.addItem((Object)currencyCollection.get(i));
            }
        }
        this.comboSingleDiffMode.addItem((Object)new String());
        this.comboDoubleDiffMode.addItem((Object)new String());
        this.comboSingleDiffMode.addItems(DiffModeEnum.getEnumList().toArray());
        this.comboSingleDiffMode.removeItem((Object)DiffModeEnum.FetchHandCraft);
        this.comboDoubleDiffMode.addItems(DiffModeEnum.getEnumList().toArray());
        this.comboDoubleDiffMode.removeItem((Object)DiffModeEnum.FetchHandCraft);
        this.txtConfirmSDffCmpValue.setSupportedEmpty(false);
        this.txtConfirmDDffCmpValue.setSupportedEmpty(false);
        this.radioCoverGetChkData.setEnabled(this.chkIsGetCheckData.getSelected() == 32);
        boolean isConfirm = this.chkIsConfirm.getSelected() == 32;
        this.comboSDiffCmpChar.setEnabled(isConfirm);
        this.comboDDiffCmpChar.setEnabled(isConfirm);
        this.txtConfirmSDffCmpValue.setEnabled(isConfirm);
        this.txtConfirmDDffCmpValue.setEnabled(isConfirm);
        this.comboSingleDiffMode.setEnabled(this.chkIsDiffHandle.getSelected() == 32);
        this.comboDoubleDiffMode.setEnabled(this.chkIsDiffHandle.getSelected() == 32);
        boolean isAudit = this.chkIsAudit.getSelected() == 32;
        this.comboAuditSDiffCmpChar.setEnabled(isAudit);
        this.comboAuditDDiffCmpChar.setEnabled(isAudit);
        this.txtAuditSDiffCmpValue.setEnabled(isAudit);
        this.txtAuditDDiffCmpValue.setEnabled(isAudit);
        boolean isCreateElim = this.chkIsCreateElim.getSelected() == 32;
        this.radioLoanUnevenGenerate.setEnabled(isCreateElim);
        this.radioLoanUnevenNoGenerate.setEnabled(isCreateElim);
        this.txtConfirmSDffCmpValue.setText("0");
        this.txtConfirmDDffCmpValue.setText("0");
        this.txtAuditSDiffCmpValue.setText("0");
        this.txtAuditDDiffCmpValue.setText("0");
        CslRptUIUtil.setSpineRange((KDSpinner)this.spCurYear, (int)1900, (int)2999, (boolean)true, (boolean)true);
        int[] yearPeriod = RPTDateUtil.getPeriod((Date)SysUtil.getAppServerTime(null), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem()));
        this.spCurYear.setValue((Object)yearPeriod[0], false);
        CslWorkTableUIUtil.setSpineRangeByPeriodType(this.spCurPeriod, (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem(), this.spCurYear.getIntegerVlaue(), true, true);
        this.spCurPeriod.setValue((Object)yearPeriod[1], false);
        this.txtAuditSDiffCmpValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        this.txtAuditSDiffCmpValue.setMinimumValue((Comparable)new BigDecimal("-999999999999999.999999"));
        this.txtAuditDDiffCmpValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        this.txtAuditDDiffCmpValue.setMinimumValue((Comparable)new BigDecimal("-999999999999999.999999"));
        this.txtConfirmSDffCmpValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        this.txtConfirmSDffCmpValue.setMinimumValue((Comparable)new BigDecimal("-999999999999999.999999"));
        this.txtConfirmDDffCmpValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
        this.txtConfirmDDffCmpValue.setMinimumValue((Comparable)new BigDecimal("-999999999999999.999999"));
        if (this.schmInfo.getCompanyEntries() != null && this.schmInfo.getCompanyEntries().size() > 0) {
            this.isSelectCompany = true;
            this.chkIsGetCheckData.setEnabled(true);
            this.chkIsConfirm.setEnabled(true);
        }
        if (this.schmInfo.getOrgUnitEntries() != null && this.schmInfo.getOrgUnitEntries().size() > 0) {
            this.isSelectOrgUnit = true;
            this.chkIsDiffHandle.setEnabled(true);
            this.chkIsAudit.setEnabled(true);
            this.chkIsCreateElim.setEnabled(true);
        }
        if (this.comboPeriodType.getSelectedIndex() == 0) {
            if (this.chkIsIncludAdjustPeriod.isSelected()) {
                CslRptUIUtil.setSpineRange((KDSpinner)this.spCurPeriod, (int)1, (int)13, (boolean)false, (boolean)true);
            } else {
                CslRptUIUtil.setSpineRange((KDSpinner)this.spCurPeriod, (int)1, (int)12, (boolean)false, (boolean)true);
            }
        }
    }

    protected CurrencyCollection getCurrencyCollection() {
        CurrencyCollection currencyCollection = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            currencyCollection = iCurrency.getCurrencyCollection(this.getEntityViewInfo());
        }
        catch (Exception e) {
            logger.error((Object)"getCurrencyCollection() error", (Throwable)e);
        }
        return currencyCollection;
    }

    private EntityViewInfo getEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        FilterInfo filterCurrency = new FilterInfo();
        filterCurrency.getFilterItems().add(new FilterItemInfo("number", (Object)"GLC", CompareType.NOTEQUALS));
        filterCurrency.getFilterItems().add(new FilterItemInfo("number", (Object)"GRC", CompareType.NOTEQUALS));
        viewInfo.setFilter(filterCurrency);
        return viewInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        String schmId = this.schmInfo.getId().toString();
        ShowUIMessageAction showMessageHandler = (ShowUIMessageAction)this.getUIContext().get("showMessageHandler");
        Uuid mutexUuidForStartExecute = null;
        try {
            BOSUuid bosUuid = BOSUuid.read((String)schmId);
            mutexUuidForStartExecute = MutexUtil.setMutex((String)"SchmStartExecute", (BOSUuid)bosUuid, (String)"ActionEdit");
        }
        catch (MutexException ex) {
            logger.warn((Object)"", (Throwable)ex);
            showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"EXECUTE_WARNING_CANNOT_DUP_EXECUTE"), true, true);
            return;
        }
        try {
            super.actionOk_actionPerformed(e);
            showMessageHandler.showMessage(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"SHOW_MSG_EXECUTING"), false, true);
            this.getNewSchmInfo();
            Map params = this.getAutoCheckParam();
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            AutoCheckSchmFactory.getRemoteInstance().executeAutoCheckSchm(schmId, userId, params);
            this.disposeUIWindow();
        }
        catch (Exception ex) {
            logger.warn((Object)"executeAutoCheckSchm: ", (Throwable)ex);
            showMessageHandler.showMessage(ex.getMessage(), true, true);
        }
        finally {
            MutexUtil.releaseMutex((Uuid)mutexUuidForStartExecute);
        }
    }

    private void verifyInput() {
        if (this.isSelectCompany && this.isSelectOrgUnit && this.chkIsDiffHandle.getSelected() == 16 && this.chkIsAudit.getSelected() == 16 && this.chkIsCreateElim.getSelected() == 16 && this.chkIsGetCheckData.getSelected() == 16 && this.chkIsConfirm.getSelected() == 16) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"PleaseChoseNew"));
            SysUtil.abort();
        }
    }

    private void getNewSchmInfo() {
        this.schmInfo.setCurrency(this.comboCurreny.getSelectedItem() != null ? (CurrencyInfo)this.comboCurreny.getSelectedItem() : null);
        this.schmInfo.setIsIncludAdjustPeriod(this.chkIsIncludAdjustPeriod.getSelected() == 32);
        this.schmInfo.setAuditDDiffCmpChar((CompareCharEnum)((Object)this.comboAuditDDiffCmpChar.getSelectedItem()));
        this.schmInfo.setAuditDDiffCmpValue(this.txtAuditDDiffCmpValue.getBigDecimalValue());
        this.schmInfo.setAuditSDiffCmpChar((CompareCharEnum)((Object)this.comboAuditSDiffCmpChar.getSelectedItem()));
        this.schmInfo.setAuditSDiffCmpValue(this.txtAuditSDiffCmpValue.getBigDecimalValue());
        this.schmInfo.setConfirmDDiffCmpChar((CompareCharEnum)((Object)this.comboDDiffCmpChar.getSelectedItem()));
        this.schmInfo.setConfirmDDiffCmpValue(this.txtConfirmDDffCmpValue.getBigDecimalValue());
        this.schmInfo.setConfirmSDiffCmpChar((CompareCharEnum)((Object)this.comboSDiffCmpChar.getSelectedItem()));
        this.schmInfo.setConfirmSDffCmpValue(this.txtConfirmSDffCmpValue.getBigDecimalValue());
        if (this.comboSingleDiffMode.getSelectedItem() != null) {
            this.schmInfo.setSingleDiffMode((DiffModeEnum)this.comboSingleDiffMode.getSelectedItem());
        } else {
            this.schmInfo.setSingleDiffMode(DiffModeEnum.FetchHandCraft);
        }
        if (this.comboDoubleDiffMode.getSelectedItem() != null) {
            this.schmInfo.setDoubleDiffMode((DiffModeEnum)this.comboDoubleDiffMode.getSelectedItem());
        } else {
            this.schmInfo.setDoubleDiffMode(DiffModeEnum.FetchHandCraft);
        }
        this.schmInfo.setIsLoanUnevenGenerate(this.radioLoanUnevenGenerate.isSelected());
    }

    private Map getAutoCheckParam() {
        int year = this.spCurYear.getIntegerVlaue();
        int period = this.spCurPeriod.getIntegerVlaue();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("periodType", this.schmInfo.getPeriodType());
        params.put("isIncludAdjustPeriod", this.schmInfo.isIsIncludAdjustPeriod());
        params.put("currency", this.schmInfo.getCurrency());
        params.put("year", year);
        params.put("period", period);
        params.put("isGetCheckData", this.schmInfo.isIsGetCheckData());
        params.put("isConfirm", this.schmInfo.isIsConfirm());
        params.put("isCoverGetChkData", this.schmInfo.isIsCoverGetChkData());
        params.put("confirmSDiffCmpChar", (Object)this.schmInfo.getConfirmSDiffCmpChar());
        params.put("confirmSDffCmpValue", this.schmInfo.getConfirmSDffCmpValue());
        params.put("confirmDDiffCmpChar", (Object)this.schmInfo.getConfirmDDiffCmpChar());
        params.put("confirmDDiffCmpValue", this.schmInfo.getConfirmDDiffCmpValue());
        params.put("isDiffHandle", this.schmInfo.isIsDiffHandle());
        params.put("isAudit", this.schmInfo.isIsAudit());
        params.put("isCreateElim", this.schmInfo.isIsCreateElim());
        params.put("singleDiffMode", this.schmInfo.getSingleDiffMode());
        params.put("doubleDiffMode", this.schmInfo.getDoubleDiffMode());
        params.put("auditSDiffCmpChar", (Object)this.schmInfo.getAuditSDiffCmpChar());
        params.put("auditSDiffCmpValue", this.schmInfo.getAuditSDiffCmpValue());
        params.put("auditDDiffCmpChar", (Object)this.schmInfo.getAuditDDiffCmpChar());
        params.put("auditDDiffCmpValue", this.schmInfo.getAuditDDiffCmpValue());
        params.put("isLoanUnevenGenerate", this.schmInfo.isIsLoanUnevenGenerate());
        return params;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void chkIsIncludAdjustPeriod_itemStateChanged(ItemEvent e) throws Exception {
        this.modifyPeriodRange();
    }

    private void modifyPeriodRange() {
        if (this.comboPeriodType.getSelectedIndex() == 0) {
            if (this.chkIsIncludAdjustPeriod.isSelected()) {
                CslRptUIUtil.setSpineRange((KDSpinner)this.spCurPeriod, (int)1, (int)13, (boolean)false, (boolean)true);
            } else {
                CslRptUIUtil.setSpineRange((KDSpinner)this.spCurPeriod, (int)1, (int)12, (boolean)false, (boolean)true);
            }
        }
    }
}

