/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractLinkQueryCheckageDataListUI;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LinkQueryCheckageDataListUI
extends AbstractLinkQueryCheckageDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(LinkQueryCheckageDataListUI.class);
    protected Map<String, Class> key_Enum = new HashMap<String, Class>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.key_Enum.put("checkType", ElimTypeEnum.class);
        this.key_Enum.put("balType", BalTypeEnum.class);
        this.key_Enum.put("checkItemType", ItemTypeEnum.class);
        this.key_Enum.put("dataSource", DataSourceEnum.class);
        this.initPopupMenu();
        this.initData();
        this.initFindLedgerEnable();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.initFindLedgerEnable();
    }

    protected void initFindLedgerEnable() {
        Object itemTypeValue;
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow < 0) {
            selectRow = 0;
        }
        if (this.tblMain.getRowCount3() > selectRow && (itemTypeValue = this.tblMain.getRow(selectRow).getCell("checkItemType").getValue()) != null && itemTypeValue instanceof ItemTypeEnum) {
            this.btnFindLedger.setEnabled(ItemTypeEnum.account.equals((Object)((ItemTypeEnum)((Object)itemTypeValue))));
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    protected void initPopupMenu() throws Exception {
        KDTMenuManager tm = this.getMenuManager(this.tblMain);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        Object copy = null;
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    private void setBigDecimalFormat() {
        this.tblMain.getColumn("debit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("credit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("confirmDebit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("confirmCredit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("momeny").getStyleAttributes().setNumberFormat("#,##0.00");
    }

    protected void initData() throws Exception {
        Map context = this.getUIContext();
        CheckageFilterInfo filterInfo = (CheckageFilterInfo)context.get("filterInfo");
        Map params = (Map)context.get("params");
        List rowsdata = CheckageBillFactory.getRemoteInstance().linkQueryCheckageDatas(filterInfo, params);
        BigDecimal total = BigDecimal.ZERO;
        if (rowsdata != null && !rowsdata.isEmpty()) {
            KDTColumns columns = this.tblMain.getColumns();
            ICell cell = null;
            for (Object rowData : rowsdata) {
                IRow row = this.tblMain.addRow();
                int itemType = Integer.valueOf(((Map)rowData).get("CHECKITEMTYPE").toString());
                for (int c = 0; c < columns.size(); ++c) {
                    String columnKey = columns.getColumnKey(c);
                    cell = row.getCell(columnKey);
                    Object value = ((Map)rowData).get(columnKey.toUpperCase(Locale.ENGLISH));
                    if (itemType == 1 && columnKey.equals("balType")) {
                        value = ((Map)rowData).get("DATAELEMENT");
                        cell.setValue((Object)DataElementProvider.getDataElementInfo((int)Integer.valueOf(value.toString())));
                        continue;
                    }
                    if (this.key_Enum.containsKey(columnKey) && value != null) {
                        cell.setValue((Object)CslWorkTableUIUtil.getEnum(this.key_Enum.get(columnKey), Integer.valueOf(value.toString())));
                    } else {
                        cell.setValue(value);
                    }
                    if (!columnKey.equals("momeny") || value == null || !(value instanceof BigDecimal)) continue;
                    total = total.add((BigDecimal)value);
                }
            }
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        IRow footRow = null;
        if (footRowManager == null) {
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total"));
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        footRow.getCell(13).setValue((Object)total);
        footRow.getCell(13).getStyleAttributes().setNumberFormat("#,##0.00");
        this.setBigDecimalFormat();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("itemNumber").setGroup(true);
        this.tblMain.getColumn("itemName").setGroup(true);
        this.tblMain.getColumn("itemNumber").setMergeable(true);
        this.tblMain.getColumn("itemName").setMergeable(true);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void actionFindLedger_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.isSubTotal()) {
            return;
        }
        CheckageBillInfo checkageBillInfo = this.getCheckageBillInfoById();
        AccountViewInfo account = this.getAccountViewInfo(checkageBillInfo);
        GLRptSubLedgerCondition cond = AccountCheckUtil.getGLRptSubLedgerCondition(checkageBillInfo.getCompany(), checkageBillInfo.getYear(), checkageBillInfo.getPeriod(), checkageBillInfo.getCurrency(), checkageBillInfo.isIsIncludingUnPosted(), account);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
        uiContext.put((Object)"UIClassParam", (Object)cond.toMap().toString());
        uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
        uiContext.put((Object)"JoinQuery_Outer_Params_asstActList", (Object)this.getAcctAsstItems(checkageBillInfo, account));
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI", (Map)uiContext, null);
        ui.show();
    }

    public String getAcctAsstItems(CheckageBillInfo checkageBillInfo, AccountViewInfo account) throws EASBizException, BOSException {
        String accountNumber = account.getNumber();
        String tarCompanyId = checkageBillInfo.getTargetCompany().getId().toString();
        BalTypeEnum balTypeEnum = checkageBillInfo.getBalType();
        return AccountCheckUtil.getAcctAsstItems(accountNumber, tarCompanyId, balTypeEnum, account.getAccountTableID().getNumber());
    }

    private boolean isSubTotal() {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(index);
        String billId = row.getCell("id").getValue().toString();
        return billId == null;
    }

    private CheckageBillInfo getCheckageBillInfoById() throws EASBizException, BOSException {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(index);
        String billId = row.getCell("id").getValue().toString();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("itemNumber");
        coll.add("checkAccount.accountTableid");
        coll.add("company.id");
        coll.add("company.accountPeriodType");
        coll.add("company.CU");
        coll.add("isIncludingUnPosted");
        coll.add("targetCompany");
        coll.add("balType");
        coll.add("checkAccount.asstActTypes");
        coll.add("year");
        coll.add("period");
        coll.add("currency");
        return CheckageBillFactory.getRemoteInstance().getCheckageBillInfo((IObjectPK)new ObjectUuidPK(billId), coll);
    }

    private AccountViewInfo getAccountViewInfo(CheckageBillInfo checkageBillInfo) throws EASBizException, BOSException {
        return AccountViewFactory.getRemoteInstance().getAccountViewInfo("select id,number,level,accountTableID.id,accountTableID.number where number='" + checkageBillInfo.getItemNumber() + "' and accountTableID.id='" + checkageBillInfo.getCheckAccount().getAccountTableid() + "' and companyID='" + checkageBillInfo.getCompany().getId().toString() + "'");
    }

    private CompanyOrgUnitInfo getCompanyInfo(CheckageBillInfo checkageBillInfo) throws EASBizException, BOSException {
        String companyId = checkageBillInfo.getCompany().getId().toString();
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
    }

    private CurrencyInfo getCurrencyInfo(CheckageBillInfo checkageBillInfo) throws EASBizException, BOSException {
        String currencyId = checkageBillInfo.getCurrency().getId().toString();
        return CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
    }
}

