/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessRecordCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessRecordFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessRecordInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractLinkQueryFormulaCheckageDataListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.CslRptGLRptSubLedgerUI;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FindLedger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class LinkQueryFormulaCheckageDataListUI
extends AbstractLinkQueryFormulaCheckageDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(LinkQueryFormulaCheckageDataListUI.class);
    private CheckageBillInfo billInfo = null;
    private int isSupport13Period = -1;
    private String acctFormula = null;
    private String nullStr = "&#&";
    CslRptGLRptSubLedgerUI acctDetailUI = null;
    private Map commParams = new HashMap();
    private Map sheetVariables = new HashMap();
    private List formulas = new ArrayList();

    public LinkQueryFormulaCheckageDataListUI() throws Exception {
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.checkParsed();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDFormulaPanel.setEditable(false);
        String billId = (String)this.getUIContext().get("id");
        if (!StringUtils.isEmpty((String)billId)) {
            this.billInfo = CheckageBillFactory.getRemoteInstance().getCheckageBillInfo("select company.id,company.number,company.name,company.isOnlyUnion,year,period,creator.name,lastUpdateUser.name,targetCompany.id,targetCompany.number,currency.id,currency.number,currency.name,isIncludingUnPosted,itemNumber,dataElement,debit,credit,company.accountPeriodType,company.CU,company.accountTable where id='" + billId + "'");
            this.initData();
            this.initUIListener();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.formularChange();
    }

    protected void formularChange() throws Exception {
        String formula;
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex >= 0 && (formula = (String)this.tblMain.getRow(activeRowIndex).getCell("formula").getValue()) != null) {
            this.loadAcctDetail(formula);
        }
    }

    public void initUIListener() {
        this.kDFormulaPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        String formula = e.getDescription();
                        if (!StringUtils.isEmpty((String)formula)) {
                            formula = formula.replaceAll(LinkQueryFormulaCheckageDataListUI.this.nullStr, " ");
                            for (int i = 0; i < LinkQueryFormulaCheckageDataListUI.this.tblMain.getRowCount(); ++i) {
                                if (!formula.equals(LinkQueryFormulaCheckageDataListUI.this.tblMain.getCell(i, "formula").getValue())) continue;
                                LinkQueryFormulaCheckageDataListUI.this.tblMain.getSelectManager().select(i, 0, i, LinkQueryFormulaCheckageDataListUI.this.tblMain.getColumnCount() - 1);
                                LinkQueryFormulaCheckageDataListUI.this.tblMain.getSelectManager().setActiveRowIndex(i);
                                LinkQueryFormulaCheckageDataListUI.this.formularChange();
                                return;
                            }
                            Object value = LinkQueryFormulaCheckageDataListUI.this.calcFormula(formula);
                            IRow row = LinkQueryFormulaCheckageDataListUI.this.tblMain.addRow();
                            int rowIndex = row.getRowIndex();
                            row.getCell("formula").setValue((Object)formula);
                            row.getCell("fvalue").setValue(value);
                            row.getCell("id").setValue((Object)rowIndex);
                            LinkQueryFormulaCheckageDataListUI.this.tblMain.setRowCount(rowIndex + 1);
                            LinkQueryFormulaCheckageDataListUI.this.tblMain.repaint();
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)"hyperlinkUpdate error.", (Throwable)ex);
                    }
                }
            }
        });
    }

    public void loadAllFormulas() throws Exception {
        this.tblMain.removeRows();
        List values = this.calcFormulas(this.formulas);
        if (values != null) {
            int rowCount = -1;
            for (int i = 0; i < this.formulas.size(); ++i) {
                IRow row = this.tblMain.addRow();
                int rowIndex = row.getRowIndex();
                row.getCell("formula").setValue(this.formulas.get(i));
                row.getCell("fvalue").setValue(values.get(i));
                row.getCell("id").setValue((Object)rowIndex);
                rowCount = rowIndex;
            }
            if (rowCount >= 0) {
                this.tblMain.setRowCount(rowCount + 1);
            }
            this.tblMain.repaint();
        }
    }

    public void loadAcctDetail(String acct) throws Exception {
        String curFormula = null;
        if (!StringUtils.isEmpty((String)acct)) {
            String tmp = acct.trim().toLowerCase(Locale.ENGLISH);
            if (!tmp.startsWith("acct")) {
                this.kDScrollPaneDetail.getViewport().removeAll();
                this.acctFormula = null;
                this.kDScrollPaneDetail.getViewport().repaint();
                return;
            }
            acct = "=" + acct;
            if (this.acctFormula != null && this.acctFormula.equals(acct)) {
                return;
            }
            this.kDScrollPaneDetail.getViewport().removeAll();
            List formulaList = null;
            try {
                formulaList = TableToolkit.parseExcelFormula((String)acct, (boolean)true);
            }
            catch (ParserException e) {
                MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"FormulaError"));
                SysUtil.abort();
            }
            if (formulaList != null && formulaList.size() >= 1) {
                FormulaHint hint = (FormulaHint)formulaList.get(0);
                if (hint.name.equalsIgnoreCase("ACCTAC") || hint.name.equalsIgnoreCase("ACCT")) {
                    FindLedger findLedger = new FindLedger();
                    ArrayList<FormulaHint> formulas = new ArrayList<FormulaHint>();
                    formulas.add(hint);
                    ReportBaseInfo rpt = new ReportBaseInfo();
                    rpt.setCurrency(this.billInfo.getCurrency());
                    rpt.setCompany(this.billInfo.getCompany());
                    rpt.setOrgType(OrgType.Company);
                    rpt.setYear(this.billInfo.getYear());
                    rpt.setPeriod((short)this.billInfo.getPeriod());
                    rpt.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    findLedger.getUIContext().put("Owner", this.getUIContext().get("Owner"));
                    findLedger.getUIContext().put("expressions", formulas);
                    findLedger.getUIContext().put("report", rpt);
                    findLedger.getUIContext().put("type", "2");
                    RptSheetParamInfo rptSheetParam = new RptSheetParamInfo();
                    rptSheetParam.setIsIncludingUnposted(this.billInfo.isIsIncludingUnPosted());
                    findLedger.getUIContext().put("rptSheetParam", rptSheetParam);
                    findLedger.getUIContext().put("Viewport", this.kDScrollPaneDetail.getViewport());
                    if (hint.name.equalsIgnoreCase("ACCT")) {
                        if (this.acctDetailUI == null) {
                            this.acctDetailUI = new CslRptGLRptSubLedgerUI();
                        }
                        findLedger.getUIContext().put("detailUI", this.acctDetailUI);
                    }
                    this.kDScrollPaneDetail.getViewport().removeAll();
                    this.kDScrollPaneDetail.getViewport().repaint();
                    findLedger.onLoad();
                    curFormula = acct;
                }
            }
        } else {
            this.kDScrollPaneDetail.getViewport().removeAll();
        }
        this.acctFormula = curFormula;
        this.kDScrollPaneDetail.getViewport().repaint();
    }

    public List<String> getCompanyNumber(String companyNumbers) throws Exception {
        String[] companyNumberArr = companyNumbers.split(";");
        ArrayList<String> curCompanyNumbers = new ArrayList<String>();
        for (String companyNumber : companyNumberArr) {
            if (StringUtils.isEmpty((String)companyNumber)) continue;
            curCompanyNumbers.add(companyNumber.trim());
        }
        return curCompanyNumbers;
    }

    public Object calcFormula(String formula) throws Exception {
        ArrayList<String> formulaList = new ArrayList<String>();
        formulaList.add(formula);
        List values = this.calcFormulas(formulaList);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public List calcFormulas(List formulaList) throws Exception {
        if (formulaList == null || formulaList.isEmpty()) {
            return null;
        }
        if (this.commParams.isEmpty()) {
            this.commParams.put("Report.SourceType", 7);
            this.commParams.put("Company.Number", this.billInfo.getCompany().getNumber());
            this.commParams.put("Company.Name", this.billInfo.getCompany().getName());
            this.commParams.put("Company.ID", this.billInfo.getCompany().getId().toString());
            this.commParams.put("OrgUnit.Name", this.billInfo.getCompany().getName());
            this.commParams.put("OrgUnit.Number", this.billInfo.getCompany().getNumber());
            this.commParams.put("OrgUnit.Id", this.billInfo.getCompany().getId().toString());
            this.commParams.put("PeriodType", 3);
            this.commParams.put("Report.Year", this.billInfo.getYear());
            this.commParams.put("Report.Period", this.billInfo.getPeriod());
            this.commParams.put("Currency.Number", this.billInfo.getCurrency().getNumber());
            this.commParams.put("LastUpdater.Name", this.billInfo.getLastUpdateUser().getName());
            this.commParams.put("Creater.Name", this.billInfo.getCreator().getName());
            this.commParams.put("Report_StartDate", RPTDateUtil.getPeriodFirstDate((int)this.billInfo.getYear(), (int)this.billInfo.getPeriod(), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY));
            this.commParams.put("Report_EndDate", RPTDate13Util.getPeriodLastDate((int)this.billInfo.getYear(), (int)this.billInfo.getPeriod(), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY));
        }
        if (this.sheetVariables.isEmpty()) {
            this.sheetVariables.put("IncludePosted", this.billInfo.isIsIncludingUnPosted());
        }
        List values = CheckageBillFactory.getRemoteInstance().calcFormulas(this.commParams, this.sheetVariables, formulaList);
        return values;
    }

    public void initData() throws Exception {
        if (this.billInfo != null) {
            AccessRecordInfo info;
            String formula;
            StringBuffer oql = new StringBuffer();
            oql.append("select formula where companyId='").append(this.billInfo.getCompany().getId().toString()).append("' ");
            oql.append(" and tarCompanyId='").append(this.billInfo.getTargetCompany().getId().toString()).append("' ");
            oql.append(" and year=").append(this.billInfo.getYear()).append(" and period=").append(this.billInfo.getPeriod());
            oql.append(" and currencyId='").append(this.billInfo.getCurrency().getId().toString()).append("' ");
            oql.append(" and itemNumber='").append(this.billInfo.getItemNumber()).append("' ");
            oql.append(" and dataElement=").append(this.billInfo.getDataElement());
            AccessRecordCollection coll = AccessRecordFactory.getRemoteInstance().getAccessRecordCollection(oql.toString());
            if (coll != null && coll.size() > 0 && !StringUtils.isEmpty((String)(formula = (info = coll.get(0)).getFormula()))) {
                formula = formula.trim();
                formula = StringEscapeUtils.escapeHtml((String)formula);
                String curFormula = this.paraseFormula(formula);
                BigDecimal value = this.billInfo.getDebit();
                if (value == null) {
                    value = this.billInfo.getCredit();
                }
                if (curFormula.startsWith("=")) {
                    curFormula = curFormula.substring(1);
                }
                this.kDFormulaPanel.setContentType("text/html");
                this.kDFormulaPanel.setText(curFormula + "=" + value);
            }
        }
    }

    public List getParamLis(FormulaHint hint) throws Exception {
        String[] params = hint.params;
        String formula = hint.text;
        ArrayList<String> paramList = new ArrayList<String>();
        int index = 0;
        String[] stringArray = params;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String param;
            String curParam = param = stringArray[i];
            if (!StringUtils.isEmpty((String)param) && (index = formula.indexOf(param, index)) > 0) {
                int end;
                int start = formula.lastIndexOf(",", index);
                if (start < 0) {
                    start = formula.lastIndexOf("(", index);
                }
                if ((end = formula.indexOf(",", index)) < 0) {
                    end = formula.indexOf(")", index);
                }
                if (start > 0 && end > 0) {
                    curParam = formula.substring(start + 1, end);
                }
                index = end;
            }
            paramList.add(curParam);
        }
        return AccountCheckUtil.calcExcelFormula(paramList);
    }

    public String paraseFormula(String formula) throws Exception {
        StringBuffer curFormula = new StringBuffer();
        for (int i = 0; i < formula.length(); ++i) {
            FormulaInfo formulaInfo;
            char curChar = formula.charAt(i);
            if (curChar == '(' && (formulaInfo = this.getFormula(formula, i)) != null) {
                int start = curFormula.length() - (i - formulaInfo.formulaStartIndex);
                curFormula.insert(start, "<a href=" + formulaInfo.formula + ">").append("</a>");
            }
            curFormula.append(curChar);
        }
        return curFormula.toString();
    }

    protected FormulaInfo getFormula(String formula, int startIndex) throws Exception {
        if (startIndex > 0) {
            int formulaStartIndex = -1;
            StringBuffer formulaName = new StringBuffer();
            for (int i = startIndex - 1; i >= 0; --i) {
                char curChar = formula.charAt(i);
                if (formulaName.length() == 0) {
                    if (curChar == ' ') continue;
                    if (Character.isLetter(curChar)) {
                        formulaName.append(curChar);
                        continue;
                    }
                    return null;
                }
                if (Character.isLetter(curChar)) {
                    formulaName.append(curChar);
                    continue;
                }
                formulaStartIndex = i + 1;
                break;
            }
            if (formulaName.length() > 0 && formulaStartIndex == -1) {
                formulaStartIndex = 0;
            }
            int formulaEndIndex = -1;
            StringBuffer formulaParams = new StringBuffer();
            formulaParams.append("(");
            int count = 0;
            if (formulaName.length() > 0) {
                formulaName.reverse();
                for (int i = startIndex + 1; i < formula.length(); ++i) {
                    char curChar = formula.charAt(i);
                    formulaParams.append(curChar);
                    if (curChar == '(') {
                        ++count;
                        continue;
                    }
                    if (curChar != ')') continue;
                    if (count > 0) {
                        --count;
                        continue;
                    }
                    formulaEndIndex = i;
                    break;
                }
            }
            if (formulaEndIndex > 0 && formulaStartIndex >= 0) {
                FormulaInfo info = new FormulaInfo();
                info.formulaName = formulaName.toString();
                info.formula = formulaName.toString() + formulaParams.toString();
                String curFormula = StringEscapeUtils.unescapeHtml((String)info.formula);
                if (!this.formulas.contains(curFormula)) {
                    this.formulas.add(curFormula);
                }
                info.formula = info.formula.replaceAll(" ", this.nullStr);
                info.formulaStartIndex = formulaStartIndex;
                info.formulaEndIndex = formulaEndIndex;
                return info;
            }
        }
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
    }

    protected void setThelper() {
        this.setQueryPreference(false);
    }

    @Override
    public void actionListAllFormulas_actionPerformed(ActionEvent e) throws Exception {
        this.loadAllFormulas();
    }

    public static void main(String[] args) {
        try {
            LinkQueryFormulaCheckageDataListUI ui = new LinkQueryFormulaCheckageDataListUI();
            String formula = "=IF(G14=\"\",IF(E14=0.00," + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"90_LinkQueryFormulaCheckageDataListUI") + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"91_LinkQueryFormulaCheckageDataListUI") + ",\"\")";
            String curFormula = ui.paraseFormula(formula);
            System.out.print(curFormula);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class FormulaInfo {
        public String formulaName;
        public String formula;
        public int formulaStartIndex;
        public int formulaEndIndex;
    }
}

