/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractLinkQueryItemMapCheckageDataListUI;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LinkQueryItemMapCheckageDataListUI
extends AbstractLinkQueryItemMapCheckageDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(LinkQueryItemMapCheckageDataListUI.class);
    private CheckageBillInfo billInfo = null;
    protected Map<String, Class> key_Enum = new HashMap<String, Class>();

    protected void refresh(ActionEvent e) throws Exception {
    }

    public int getSelectedRowCount(KDTable table) {
        int mode = 0;
        ArrayList blockList = table.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1 && (mode = ((IBlock)table.getSelectManager().getBlocks().get(0)).getMode()) == 8) {
            table.getSelectManager().select(0, 0, table.getRowCount(), table.getColumnCount());
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        return selectRows.length;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.key_Enum.put("balType", BalTypeEnum.class);
        String billId = (String)this.getUIContext().get("id");
        if (!StringUtils.isEmpty((CharSequence)billId)) {
            this.billInfo = CheckageBillFactory.getRemoteInstance().getCheckageBillInfo("select company.id,company.number,company.accountPeriodType,company.CU,company.accountTable,year,period,targetCompany.id,targetCompany.number,currency.id,currency.name,currency.number,isIncludingUnPosted,itemNumber,dataElement where id='" + billId + "'");
            this.initData();
        }
    }

    public void initData() throws Exception {
        if (this.billInfo != null) {
            List rowsdata = CheckageBillFactory.getRemoteInstance().linkQueryItemMapCheckageDatas(this.billInfo);
            BigDecimal total = BigDecimal.ZERO;
            if (rowsdata != null && !rowsdata.isEmpty()) {
                KDTColumns columns = this.tblMain.getColumns();
                ICell cell = null;
                for (Object rowData : rowsdata) {
                    IRow row = this.tblMain.addRow();
                    for (int c = 0; c < columns.size(); ++c) {
                        String columnKey = columns.getColumnKey(c);
                        cell = row.getCell(columnKey);
                        Object value = ((Map)rowData).get(columnKey.toUpperCase(Locale.ENGLISH));
                        if (columnKey.equalsIgnoreCase("accountId")) {
                            row.getCell("id").setValue(value);
                        }
                        if (this.key_Enum.containsKey(columnKey) && value != null) {
                            cell.setValue((Object)CslWorkTableUIUtil.getEnum(this.key_Enum.get(columnKey), Integer.valueOf(value.toString())));
                        } else {
                            cell.setValue(value);
                        }
                        if (!columnKey.equals("fvalue") || value == null || !(value instanceof BigDecimal)) continue;
                        total = total.add((BigDecimal)value);
                    }
                }
            }
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
            KDTFootManager footRowManager = this.tblMain.getFootManager();
            IRow footRow = null;
            if (footRowManager == null) {
                footRowManager = new KDTFootManager(this.tblMain);
                footRowManager.addFootView();
                this.tblMain.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
                this.tblMain.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total"));
            } else {
                footRow = footRowManager.getFootRow(0);
            }
            footRow.getCell(7).setValue((Object)total);
            footRow.getCell(7).getStyleAttributes().setNumberFormat("#,##0.00");
            this.setBigDecimalFormat();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void setBigDecimalFormat() {
        this.tblMain.getColumn("debit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("credit").getStyleAttributes().setNumberFormat("#,##0.00");
        this.tblMain.getColumn("fvalue").getStyleAttributes().setNumberFormat("#,##0.00");
    }

    @Override
    public void actionFindLedger_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows;
        if (this.billInfo != null && (selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)) != null && selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            String accountNumber = (String)row.getCell("accountNumber").getValue();
            BalTypeEnum balTypeEnum = (BalTypeEnum)((Object)row.getCell("balType").getValue());
            if (!StringUtils.isEmpty((CharSequence)accountNumber) && this.billInfo != null) {
                AccountViewInfo accountView = AccountCheckUtil.getAccountViewInfo(this.billInfo.getCompany().getId().toString(), accountNumber, this.billInfo.getCompany().getAccountTable().getId().toString());
                GLRptSubLedgerCondition codition = AccountCheckUtil.getGLRptSubLedgerCondition(this.billInfo.getCompany(), this.billInfo.getYear(), this.billInfo.getPeriod(), this.billInfo.getCurrency(), this.billInfo.isIsIncludingUnPosted(), accountView);
                String asstActList = AccountCheckUtil.getAcctAsstItems(accountNumber, this.billInfo.getTargetCompany().getId().toString(), balTypeEnum, accountView.getAccountTableID().getNumber());
                UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
                uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
                uiContext.put((Object)"UIClassParam", (Object)codition.toMap().toString());
                uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)codition);
                uiContext.put((Object)"JoinQuery_Outer_Params_asstActList", (Object)asstActList);
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI", (Map)uiContext, null);
                ui.show();
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

