/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgRelTemplateCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgRelTemplateFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgRelTemplateInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractOrgnizationAssociateTemplateUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ChooseAssociateTemplateUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ReconciliationOrgSettingsListUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgnizationAssociateTemplateUI
extends AbstractOrgnizationAssociateTemplateUI {
    private static final long serialVersionUID = 5452743846412011626L;
    private static final Logger logger = CoreUIObject.getLogger(OrgnizationAssociateTemplateUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    private Set<String> orgIds = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblOrg.checkParsed();
        this.tblOrg.getStyleAttributes().setLocked(true);
        this.tblOrg.getSelectManager().setSelectMode(2);
        this.tblTmpl.checkParsed();
        this.tblTmpl.getStyleAttributes().setLocked(true);
        this.tblTmpl.getSelectManager().setSelectMode(2);
        this.initOrgTable();
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    private void initOrgTable() {
        if (this.getUIContext().containsKey("org") && this.getUIContext().get("org") != null) {
            this.orgIds = new HashSet<String>();
            List orgs = (List)this.getUIContext().get("org");
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)orgs.get(i);
                String orgId = org.getId().toString();
                this.orgIds.add(orgId);
                String orgNumber = org.getNumber();
                String orgName = org.getName();
                IRow row = this.tblOrg.addRow(i);
                row.getCell("id").setValue((Object)orgId);
                row.getCell("number").setValue((Object)orgNumber);
                row.getCell("name").setValue((Object)orgName);
            }
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        List<TemplateInfo> tmpls = this.getSelectedTmplInfo();
        if (tmpls != null && !tmpls.isEmpty()) {
            HashSet<String> updateChkOrgStatus = new HashSet<String>();
            List<String> keys = this.getchkOrgRelTmplKeyByCompany();
            List orgs = (List)this.getUIContext().get("org");
            CoreBaseCollection colls = new CoreBaseCollection();
            CheckageOrgRelTemplateInfo chkOrgRelTmpl = null;
            for (CompanyOrgUnitInfo company : orgs) {
                String companyId = company.getId().toString();
                for (TemplateInfo tmpl : tmpls) {
                    chkOrgRelTmpl = new CheckageOrgRelTemplateInfo();
                    String tmplId = tmpl.getId().toString();
                    String groupId = tmpl.getGroup();
                    String key = companyId + groupId;
                    if (keys.contains(key)) continue;
                    chkOrgRelTmpl.setCheckageCompanyId(companyId);
                    chkOrgRelTmpl.setRptTemplateId(tmplId);
                    chkOrgRelTmpl.setTemplateGroup(groupId);
                    colls.add((CoreBaseInfo)chkOrgRelTmpl);
                    updateChkOrgStatus.add(companyId);
                }
            }
            if (colls != null && !colls.isEmpty()) {
                CheckageOrgRelTemplateFactory.getRemoteInstance().submit(colls);
                this.updateCheckCompanyStatus(updateChkOrgStatus);
                ReconciliationOrgSettingsListUI ui = (ReconciliationOrgSettingsListUI)((Object)this.getUIContext().get("parent"));
                ui.setMessageText(EASResource.getString((String)RES, (String)"487_relaSuccess"));
                ui.showMessage();
            }
        }
        this.destroyWindow();
    }

    private void updateCheckCompanyStatus(Set<String> updateChkOrgStatus) throws BOSException, EASBizException {
        CheckageCompanyCollection chkCompanys = this.getCheckageCompanyForUpdate(updateChkOrgStatus);
        if (chkCompanys != null && !chkCompanys.isEmpty()) {
            Iterator it = chkCompanys.iterator();
            while (it.hasNext()) {
                CheckageCompanyInfo chkCompanyInfo = (CheckageCompanyInfo)it.next();
                chkCompanyInfo.setIsAssociateTemplate(true);
            }
            SelectorItemCollection seletors = new SelectorItemCollection();
            seletors.add(new SelectorItemInfo("isAssociateTemplate"));
            CheckageCompanyFactory.getRemoteInstance().updatePartialBatchData((IObjectCollection)chkCompanys, seletors);
        }
    }

    private CheckageCompanyCollection getCheckageCompanyForUpdate(Set<String> updateChkOrgStatus) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", updateChkOrgStatus, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isAssociateTemplate"));
        CheckageCompanyCollection coll = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyCollection(view);
        return coll;
    }

    private List<String> getchkOrgRelTmplKeyByCompany() throws BOSException {
        ArrayList<String> keys = new ArrayList<String>();
        Set<String> orgIdSet = this.getOrgIdSet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("checkageCompanyId", orgIdSet, CompareType.INCLUDE));
        CheckageOrgRelTemplateCollection colls = CheckageOrgRelTemplateFactory.getRemoteInstance().getCheckageOrgRelTemplateCollection(view);
        if (colls != null && !colls.isEmpty()) {
            Iterator it = colls.iterator();
            while (it.hasNext()) {
                CheckageOrgRelTemplateInfo checkageOrgRelTemplate = (CheckageOrgRelTemplateInfo)it.next();
                String orgId = checkageOrgRelTemplate.getCheckageCompanyId();
                String groupId = checkageOrgRelTemplate.getTemplateGroup();
                String key = orgId + groupId;
                keys.add(key);
            }
        }
        return keys;
    }

    private Set<String> getOrgIdSet() {
        List orgs = (List)this.getUIContext().get("org");
        HashSet<String> orgIdSet = new HashSet<String>();
        for (CompanyOrgUnitInfo org : orgs) {
            String id = org.getId().toString();
            orgIdSet.add(id);
        }
        return orgIdSet;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        Object owner = this.getUIContext().get("Owner");
        if (b && owner instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return b;
    }

    @Override
    protected void btnChooseTmpl_actionPerformed(ActionEvent e) throws Exception {
        List<TemplateInfo> newTmpls;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"orgIds", this.orgIds);
        List<TemplateInfo> tmpls = this.getSelectedTmplInfo();
        if (tmpls != null && !tmpls.isEmpty()) {
            uiContext.put((Object)"tmpls", tmpls);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChooseAssociateTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        ((ChooseAssociateTemplateUI)uiWindow.getUIObject()).getUIMenuBar().setVisible(false);
        ((ChooseAssociateTemplateUI)uiWindow.getUIObject()).getUIToolBar().setVisible(false);
        uiWindow.show();
        boolean isCancel = ((ChooseAssociateTemplateUI)uiWindow.getUIObject()).isCancel();
        if (!isCancel && (newTmpls = ((ChooseAssociateTemplateUI)uiWindow.getUIObject()).getResult()) != null && !newTmpls.isEmpty()) {
            int size = this.tblTmpl.getRowCount();
            for (int i = 0; i < size; ++i) {
                TemplateInfo tmpl = (TemplateInfo)this.tblTmpl.getRow(i).getUserObject();
                newTmpls.remove(tmpl);
            }
            if (!newTmpls.isEmpty()) {
                for (TemplateInfo tmpl : newTmpls) {
                    this.initTemplateTable(tmpl);
                }
            }
        }
    }

    private List<TemplateInfo> getSelectedTmplInfo() {
        ArrayList<TemplateInfo> selectedTmpls = new ArrayList<TemplateInfo>();
        int size = this.tblTmpl.getRowCount();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblTmpl.getRow(i);
                TemplateInfo tmpl = (TemplateInfo)row.getUserObject();
                selectedTmpls.add(tmpl);
            }
        }
        return selectedTmpls;
    }

    private void initTemplateTable(TemplateInfo tmpl) {
        String tmplId = tmpl.getId().toString();
        String groupId = tmpl.getGroup();
        String number = tmpl.getNumber();
        String name = tmpl.getName();
        RptTmpTypeEnum tmplType = tmpl.getTemplateType();
        RptPeriodTypeEnum periodType = tmpl.getPeriodType();
        IRow row = this.tblTmpl.addRow();
        row.setUserObject((Object)tmpl);
        row.getCell("id").setValue((Object)tmplId);
        row.getCell("groupId").setValue((Object)groupId);
        row.getCell("number").setValue((Object)number);
        row.getCell("name").setValue((Object)name);
        row.getCell("type").setValue((Object)tmplType);
        row.getCell("periodType").setValue((Object)periodType);
    }
}

