/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgRelTemplateCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgRelTemplateFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgRelTemplateInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractOrgnizationDisAssociateTemplateUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class OrgnizationDisAssociateTemplateUI
extends AbstractOrgnizationDisAssociateTemplateUI {
    private static final long serialVersionUID = -5299660706251816807L;
    private static final Logger logger = CoreUIObject.getLogger(OrgnizationDisAssociateTemplateUI.class);
    private static final String RES = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";

    public void onLoad() throws Exception {
        super.onLoad();
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        this.btnFilter.setIcon((Icon)new ImageIcon(icon_off));
        this.initCombFilter();
        EntityViewInfo vInfo = this.getMainQuery();
        vInfo.setFilter(this.getFilter());
    }

    private void initCombFilter() {
        String chkOrgNumber = EASResource.getString((String)RES, (String)"488_chkOrgNumber");
        String chkOrgName = EASResource.getString((String)RES, (String)"489_chkOrgName");
        String tmplNumber = EASResource.getString((String)RES, (String)"490_tmplNumber");
        String tmplName = EASResource.getString((String)RES, (String)"491_tmplName");
        String creator = EASResource.getString((String)RES, (String)"492_creator");
        this.combFilter.removeAllItems();
        this.combFilter.addItem((Object)chkOrgNumber);
        this.combFilter.addItem((Object)chkOrgName);
        this.combFilter.addItem((Object)tmplNumber);
        this.combFilter.addItem((Object)tmplName);
        this.combFilter.addItem((Object)creator);
    }

    private EntityViewInfo getMainQuery() {
        if (this.orgnizationDisAssociateTemplateQuery == null) {
            this.orgnizationDisAssociateTemplateQuery = new EntityViewInfo();
        }
        return this.orgnizationDisAssociateTemplateQuery;
    }

    private FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        Set orgIds = (Set)this.getUIContext().get("orgIds");
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgIds, CompareType.INCLUDE));
        return filter;
    }

    @Override
    protected void btnFilter_actionPerformed(ActionEvent e) throws Exception {
        String filterTxt = this.txtFilter.getText();
        String filterColumn = this.getFilterColumn();
        FilterInfo filter = this.getFilter();
        if (!StringUtils.isEmpty((String)filterTxt)) {
            filterTxt = "%" + filterTxt + "%";
            filter.getFilterItems().add(new FilterItemInfo(filterColumn, (Object)filterTxt, CompareType.LIKE));
        }
        this.getMainQuery().setFilter(filter);
        this.actionRefresh_actionPerformed(e);
    }

    private String getFilterColumn() {
        int index = this.combFilter.getSelectedIndex();
        switch (index) {
            case 0: {
                return "company.number";
            }
            case 1: {
                return "company.name";
            }
            case 2: {
                return "tmpl.number";
            }
            case 3: {
                return "tmpl.name";
            }
            case 4: {
                return "creator.name";
            }
        }
        return null;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        Object owner = this.getUIContext().get("Owner");
        if (b && owner instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return b;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
    }

    @Override
    public void actionSelAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.TRUE);
    }

    @Override
    public void actionDelAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.tblMain, (String)"select", (Boolean)Boolean.FALSE);
    }

    @Override
    public void actionDisassociate_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> comIds = new HashSet<String>();
        Set<String> ids = this.getSelectedIds(comIds);
        if (ids != null && ids.isEmpty()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        CheckageOrgRelTemplateFactory.getRemoteInstance().delete(filter);
        EntityViewInfo view = new EntityViewInfo();
        filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("checkageCompanyId", comIds, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("checkageCompanyId"));
        CheckageOrgRelTemplateCollection chkOrgRelTmpls = CheckageOrgRelTemplateFactory.getRemoteInstance().getCheckageOrgRelTemplateCollection(view);
        if (chkOrgRelTmpls != null && !chkOrgRelTmpls.isEmpty()) {
            Iterator it = chkOrgRelTmpls.iterator();
            HashSet<String> associatedCompanyIds = new HashSet<String>();
            while (it.hasNext()) {
                CheckageOrgRelTemplateInfo chkOrgRelTmpl = (CheckageOrgRelTemplateInfo)it.next();
                String companyId = chkOrgRelTmpl.getCheckageCompanyId();
                associatedCompanyIds.add(companyId);
            }
            comIds.removeAll(associatedCompanyIds);
            if (comIds != null && !comIds.isEmpty()) {
                this.updateChcekageCompanyStatus(comIds);
            }
        } else {
            this.updateChcekageCompanyStatus(comIds);
        }
        this.actionRefresh_actionPerformed(e);
    }

    private void updateChcekageCompanyStatus(Set<String> comIds) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company", comIds, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isAssociateTemplate"));
        CheckageCompanyCollection chkCompanys = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyCollection(view);
        if (chkCompanys != null && !chkCompanys.isEmpty()) {
            Iterator it = chkCompanys.iterator();
            while (it.hasNext()) {
                CheckageCompanyInfo chkCompany = (CheckageCompanyInfo)it.next();
                chkCompany.setIsAssociateTemplate(false);
            }
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isAssociateTemplate"));
        CheckageCompanyFactory.getRemoteInstance().updatePartialBatchData((IObjectCollection)chkCompanys, selector);
    }

    private Set<String> getSelectedIds(Set<String> comIds) {
        HashSet<String> ids = new HashSet<String>();
        int size = this.tblMain.getRowCount();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblMain.getRow(i);
                boolean isSel = (Boolean)row.getCell("select").getValue();
                if (!isSel) continue;
                String id = (String)row.getCell("id").getValue();
                String comId = (String)row.getCell("orgId").getValue();
                ids.add(id);
                comIds.add(comId);
            }
        }
        if (size == 0 || ids.isEmpty()) {
            String msg = EASResource.getString((String)RES, (String)"493_selAssociatted");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
        }
        return ids;
    }
}

