/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.IRPTItemMap;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractRPTItemMapEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountSelectorNewUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class RPTItemMapEditUI
extends AbstractRPTItemMapEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RPTItemMapEditUI.class);
    protected int itemType = 0;

    protected IObjectValue createNewData() {
        return new RPTItemMapInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RPTItemMapFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.kDTableEntries.checkParsed();
        this.kDTableEntries.setEditable(true);
        super.onLoad();
        this.init();
        if (!(this.prmtDataElement.getValue() instanceof DataElementInfo) && this.prmtDataElement.getValue() != null && this.prmtDataElement.getValue().toString().equals("0")) {
            this.prmtDataElement.setValue(null);
        }
    }

    private void init() throws Exception {
        this.kdItemTypeCombox.setSelectedItem((Object)ItemTypeEnum.getEnum(this.itemType));
        this.prmtRptItem.setQueryInfo("com.kingdee.eas.fi.newrpt.accountcheck.RPTItemQuery_UnFreezed");
        this.prmtRptItem.setEditFormat("$number$");
        this.prmtRptItem.setDisplayFormat("$name$");
        this.prmtRptItem.setEditable(true);
        this.prmtRptItem.setCommitFormat("$number$");
        this.prmtRptItem.setMyCommonUseEnabled(false);
        this.prmtDataElement.setQueryInfo("com.kingdee.eas.fi.newrpt.accountcheck.DataElementQuery");
        this.prmtDataElement.setEditFormat("$number$");
        this.prmtDataElement.setDisplayFormat("$name$");
        this.prmtDataElement.setEditable(true);
        this.prmtDataElement.setRequired(true);
        this.prmtDataElement.setCommitFormat("$number$");
        this.prmtDataElement.setMyCommonUseEnabled(false);
        CslGradeManageUtil.setDataElementF7GMFilter(this.prmtDataElement, null, false);
        KDComboBox cmbDataElement = new KDComboBox();
        cmbDataElement.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.basedata.master.account.BalanceDirectionEnum").toArray());
        this.kDTableEntries.getColumn("AccountDC").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        this.kDTableEntries.getColumn("AccountDC").getStyleAttributes().setLocked(false);
        this.kDTableEntries.getColumn("accountTable").getStyleAttributes().setLocked(true);
        this.kDTableEntries.getColumn("itemNumber").getStyleAttributes().setLocked(true);
        this.kDTableEntries.getColumn("itemName").getStyleAttributes().setLocked(true);
        this.kDTableEntries.getColumn("balType").getStyleAttributes().setLocked(true);
        this.kDTableEntries.getColumn("dataElementName").getStyleAttributes().setLocked(true);
        boolean isAccountType = this.itemType == 0;
        this.kDTableEntries.getColumn("dataElementName").getStyleAttributes().setHided(isAccountType);
        this.kDTableEntries.getColumn("accountTable").getStyleAttributes().setHided(!isAccountType);
        this.kDTableEntries.getColumn("balType").getStyleAttributes().setHided(!isAccountType);
        this.chkAccess.setVisible(isAccountType);
        if (!isAccountType) {
            this.setBounds(new Rectangle(10, 10, 555, 360));
        }
    }

    @Override
    public void actionAddAccount_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        if (this.editData.getRPTItemAccount() != null) {
            uiContext.put((Object)"Account", (Object)this.editData.getRPTItemAccount());
        }
        uiContext.put((Object)"itemType", (Object)this.itemType);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(AccountSelectorNewUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        AccountSelectorNewUI accountSelectorUI = (AccountSelectorNewUI)curUIWindow.getUIObject();
        curUIWindow.show();
    }

    protected boolean canEdit() {
        return !"VIEW".equals(this.getOprtState());
    }

    @Override
    public void actionRemoveAccount_actionPerformed(ActionEvent e) throws Exception {
        if (!this.canEdit()) {
            return;
        }
        int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kDTableEntries);
        RPTItemAccountInfo info = null;
        int rowIndex = 0;
        for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
            rowIndex = selectRowIndexes[i];
            info = (RPTItemAccountInfo)this.kDTableEntries.getRow(rowIndex).getUserObject();
            this.kDTableEntries.removeRow(rowIndex);
            this.editData.getRPTItemAccount().remove(info);
        }
    }

    public void fillTable(RPTItemAccountCollection coll) {
        this.kDTableEntries.removeRows();
        this.getDataBinder().bindDataToTable(this.kDTableEntries, (IObjectCollection)coll);
        this.editData.put("RPTItemAccount", (Object)coll);
        this.setDataElement();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean isSetNull = false;
        if (this.editData.getId() == null) {
            isSetNull = true;
        }
        super.actionSubmit_actionPerformed(e);
        if (isSetNull) {
            this.prmtDataElement.setValue(null);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.prmtDataElement.setValue(null);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        boolean isAccountType;
        String existNumber;
        RPTItemAccountCollection coll;
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NumberIsNull"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtNumber.getText()));
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)this.itemType));
        if (this.getBizInterface().exists(filter)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NumberIsExist"));
            SysUtil.abort();
        }
        if (this.prmtRptItem.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"RPTItemIsNull"));
            SysUtil.abort();
        }
        if (this.prmtDataElement.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"DataElementIsNull"));
            SysUtil.abort();
        }
        if ((coll = this.editData.getRPTItemAccount()) != null && coll.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AccountNoNull"));
            SysUtil.abort();
        }
        if ((existNumber = ((IRPTItemMap)this.getBizInterface()).getExistNumber(this.editData)) != null) {
            MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ExistAccount"), existNumber));
            SysUtil.abort();
        }
        boolean bl = isAccountType = this.itemType == 0;
        if (isAccountType && this.chkAccess.isSelected()) {
            RPTItemInfo rptItemInfo = (RPTItemInfo)this.prmtRptItem.getData();
            String itemNumber = rptItemInfo.getNumber();
            DataElementInfo dataElementInfo = (DataElementInfo)this.prmtDataElement.getData();
            int dataElement = dataElementInfo.getInterSeq();
            boolean isExist = CheckageAccountFactory.getRemoteInstance().exists("where itemType = 1 and itemNumber = '" + itemNumber + "' and dataElement = " + dataElement + " and isFree = 0");
            if (!isExist) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"266_maintainFirst"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        Map uiContext = this.getUIContext();
        if (uiContext.containsKey("itemType")) {
            this.itemType = (Integer)uiContext.get("itemType");
        }
        this.editData.setItemType(ItemTypeEnum.getEnum(this.itemType));
        if (this.editData != null && this.editData.getId() != null) {
            this.prmtDataElement.setValue((Object)DataElementProvider.getDataElementInfo((int)this.editData.getDataElement()));
        }
        this.setDataElement();
    }

    protected void setDataElement() {
        if (this.itemType == 1) {
            for (int i = 0; i < this.kDTableEntries.getRowCount(); ++i) {
                DataElementInfo info;
                Object dataElement;
                IRow row = this.kDTableEntries.getRow(i);
                Object rowObj = row.getUserObject();
                Object dataElementName = null;
                if (rowObj != null && rowObj instanceof RPTItemAccountInfo) {
                    dataElementName = ((RPTItemAccountInfo)rowObj).getCheckAccount().get("dataElementName");
                }
                if (dataElementName == null && (dataElement = row.getCell("dataElementInseq").getValue()) != null && (info = DataElementProvider.getDataElementInfo((int)((Integer)dataElement))) != null) {
                    dataElementName = info.getName();
                }
                if (dataElementName == null) continue;
                row.getCell("dataElementName").setValue(dataElementName);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.prmtDataElement.getValue() != null) {
            this.editData.setDataElement(((DataElementInfo)this.prmtDataElement.getValue()).getInterSeq());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("RPTItemAccount.checkAccount.accountDC"));
        sic.add(new SelectorItemInfo("RPTItemAccount.checkAccount.asstActTypes"));
        return sic;
    }

    public Object getTablePreferenceSchemaKey() {
        return this.itemType;
    }
}

