/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractRPTItemMapFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RPTItemMapFilterUI
extends AbstractRPTItemMapFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RPTItemMapFilterUI.class);
    private String selectAll = null;
    boolean needChangeItemType = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompents();
    }

    @Override
    protected void kDItemTypeCom_actionPerformed(ActionEvent e) throws Exception {
        this.itemTypeChanged();
    }

    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        StringBuffer maskStr = new StringBuffer();
        ItemTypeEnum itemType = (ItemTypeEnum)((Object)this.kDItemTypeCom.getSelectedItem());
        this.filterInfo.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemType.getValue()));
        int index = 0;
        maskStr.append("#").append(index++);
        if (this.kDRptItemTypeProm.getData() != null) {
            int interSeq = ((DataElementInfo)this.kDRptItemTypeProm.getData()).getInterSeq();
            this.filterInfo.getFilterItems().add(new FilterItemInfo("dataElement", (Object)interSeq));
            maskStr.append(" and #").append(index++);
        }
        if (itemType.equals((Object)ItemTypeEnum.account)) {
            Object accountTable;
            Object balType;
            if (this.kDBalTypeCombo.getSelectedIndex() > 0 && (balType = this.kDBalTypeCombo.getSelectedItem()) != null) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("CHECKACCOUNT.balType", (Object)((BalTypeEnum)((Object)balType)).getValue()));
                maskStr.append(" and #").append(index++);
            }
            if (this.kDAccountTableCom.getSelectedIndex() > 0 && (accountTable = this.kDAccountTableCom.getSelectedItem()) != null) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("CHECKACCOUNT.accountTableid", (Object)((AccountTableInfo)accountTable).getId().toString()));
                maskStr.append(" and #").append(index++);
            }
        } else {
            Object dataElement = this.kDDataElementProm.getData();
            if (dataElement != null) {
                this.filterInfo.getFilterItems().add(new FilterItemInfo("CHECKACCOUNT.dataElement", (Object)((DataElementInfo)dataElement).getInterSeq()));
                maskStr.append(" and #").append(index++);
            }
        }
        if (!this.kDIsInCludeFree.isSelected()) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("RPTITEMMAP.isFree", (Object)0));
            maskStr.append(" and #").append(index++);
        }
        this.filterInfo.setMaskString(maskStr.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        super.loadData(entityViewInfo);
        try {
            FilterItemCollection filterItems = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
            this.kDIsInCludeFree.setSelected(true);
            block2: for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo filterItemInfo = filterItems.get(i);
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemType")) {
                    this.needChangeItemType = false;
                    this.kDItemTypeCom.setSelectedItem((Object)ItemTypeEnum.getEnum((Integer)filterItemInfo.getCompareValue()));
                    this.needChangeItemType = true;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataElement")) {
                    this.kDRptItemTypeProm.setData((Object)DataElementProvider.getDataElementInfo((int)((Integer)filterItemInfo.getCompareValue())));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("CHECKACCOUNT.balType")) {
                    this.kDBalTypeCombo.setSelectedItem((Object)BalTypeEnum.getEnum((Integer)filterItemInfo.getCompareValue()));
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("CHECKACCOUNT.accountTableid")) {
                    String accountTblId = (String)filterItemInfo.getCompareValue();
                    for (int index = 1; index < this.kDAccountTableCom.getItemCount(); ++index) {
                        if (!accountTblId.equals(((AccountTableInfo)this.kDAccountTableCom.getItemAt(index)).getId().toString())) continue;
                        this.kDAccountTableCom.setSelectedIndex(index);
                        continue block2;
                    }
                    continue;
                }
                if (filterItemInfo.getPropertyName().equalsIgnoreCase("CHECKACCOUNT.dataElement")) {
                    this.kDDataElementProm.setData((Object)DataElementProvider.getDataElementInfo((int)((Integer)filterItemInfo.getCompareValue())));
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equalsIgnoreCase("RPTITEMMAP.isFree") || (Integer)filterItemInfo.getCompareValue() != 0) continue;
                this.kDIsInCludeFree.setSelected(false);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    protected void initCompents() throws Exception {
        this.selectAll = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"SelectAll");
        AccountCheckUtil.initItemTypeDefaultValue(this.kDItemTypeCom);
        AccountTableCollection accountTable = AccountCheckUtil.getAccountTable(null);
        this.kDAccountTableCom.removeAllItems();
        this.kDAccountTableCom.addItem((Object)this.selectAll);
        this.kDAccountTableCom.addItems(accountTable.toArray());
        this.kDAccountTableCom.setSelectedIndex(0);
        this.kDBalTypeCombo.insertItemAt((Object)this.selectAll, 0);
        this.kDBalTypeCombo.setSelectedIndex(0);
    }

    protected void itemTypeChanged() throws Exception {
        ItemTypeEnum itemType = (ItemTypeEnum)((Object)this.kDItemTypeCom.getSelectedItem());
        boolean isAccount = itemType.equals((Object)ItemTypeEnum.account);
        this.kDBalTypeCon.setVisible(isAccount);
        this.kDAccountTableCon.setVisible(isAccount);
        this.kDDataElementCon.setVisible(!isAccount);
        Rectangle bounds = null;
        if (isAccount) {
            int kDBalTypeConY = this.kDBalTypeCon.getBounds().y;
            bounds = this.kDAccountTableCon.getBounds();
            bounds.y = kDBalTypeConY + 30;
            this.kDAccountTableCon.setBounds(bounds);
            bounds = this.kDIsInCludeFree.getBounds();
            bounds.y = kDBalTypeConY + 70;
            this.kDIsInCludeFree.setBounds(bounds);
        } else {
            int kDRptItemTypeConY = this.kDRptItemTypeCon.getBounds().y;
            bounds = this.kDDataElementCon.getBounds();
            bounds.y = kDRptItemTypeConY + 30;
            this.kDDataElementCon.setBounds(bounds);
            bounds = this.kDIsInCludeFree.getBounds();
            bounds.y = kDRptItemTypeConY + 70;
            this.kDIsInCludeFree.setBounds(bounds);
        }
        if (this.needChangeItemType) {
            this.kDRptItemTypeProm.setData(null);
            if (this.kDBalTypeCombo.getItemCount() > 0) {
                this.kDBalTypeCombo.setSelectedIndex(0);
            }
            this.kDDataElementProm.setData(null);
            if (this.kDAccountTableCom.getItemCount() > 0) {
                this.kDAccountTableCom.setSelectedIndex(0);
            }
            this.kDIsInCludeFree.setSelected(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        AccountCheckUtil.initItemTypeDefaultValue(this.kDItemTypeCom);
        this.kDRptItemTypeProm.setData(null);
        if (this.kDBalTypeCombo.getItemCount() > 0) {
            this.kDBalTypeCombo.setSelectedIndex(0);
        }
        this.kDDataElementProm.setData(null);
        if (this.kDAccountTableCom.getItemCount() > 0) {
            this.kDAccountTableCom.setSelectedIndex(0);
        }
        this.kDIsInCludeFree.setSelected(false);
    }
}

