/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.IRPTItemMap;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractRPTItemMapListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.RPTItemMapEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.RPTItemMapFilterUI;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RPTItemMapListUI
extends AbstractRPTItemMapListUI {
    private static final Logger logger = CoreUIObject.getLogger(RPTItemMapListUI.class);
    private int index = 0;
    protected int itemType = 0;
    protected RPTItemMapFilterUI conditionPanel = null;
    protected CommonQueryDialog conditionDialog = null;
    protected boolean isInitMerge = false;

    protected String getEditUIName() {
        return RPTItemMapEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RPTItemMapFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KDTMenuManager tm = this.getMenuManager(this.tblMain);
        if (tm != null) {
            KDPopupMenu pop = tm.getMenu();
            pop.getComponent(3).setVisible(false);
            pop.getComponent(4).setVisible(false);
        }
    }

    protected void initColHide() {
        String[] accountCols = new String[]{"accountTableName", "checkageAccount.balType", "isAccess"};
        String[] itemCols = new String[]{"checkDataElement"};
        boolean isAccountType = this.itemType == 0;
        for (String accountCol : accountCols) {
            this.tblMain.getColumn(accountCol).getStyleAttributes().setHided(!isAccountType);
        }
        for (String itemCol : itemCols) {
            this.tblMain.getColumn(itemCol).getStyleAttributes().setHided(isAccountType);
        }
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "rptItem.number", "rptItem.name", "accountTableName", "itemNumber", "itemName", this.itemType == 0 ? "checkageAccount.balType" : "checkDataElement", "remark"};
        return locateNames;
    }

    protected void initMerge() {
        this.tblMain.checkParsed();
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setMergeable(false);
        }
        this.tblMain.getGroupManager().setGroup(true);
        String[] columns = this.getMergeColumnKeys();
        for (int i = 0; i < columns.length; ++i) {
            this.tblMain.getColumn(columns[i]).setGroup(true);
            this.tblMain.getColumn(columns[i]).setMergeable(true);
        }
        this.isInitMerge = true;
    }

    public String[] getMergeColumnKeys() {
        ArrayList<String> mergeColumnKeys = new ArrayList<String>();
        mergeColumnKeys.add("id");
        mergeColumnKeys.add("number");
        mergeColumnKeys.add("rptItem.number");
        mergeColumnKeys.add("rptItem.name");
        mergeColumnKeys.add("dataElement");
        mergeColumnKeys.add("isFree");
        mergeColumnKeys.add("isAccess");
        mergeColumnKeys.add("remark");
        mergeColumnKeys.add("creator.number");
        mergeColumnKeys.add("createTime");
        mergeColumnKeys.add("lastUpdateUser.number");
        mergeColumnKeys.add("lastUpdateTime");
        String[] columns = new String[mergeColumnKeys.size()];
        mergeColumnKeys.toArray(columns);
        return columns;
    }

    @Override
    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.selectItemIsFrz();
    }

    private void selectItemIsFrz() {
        boolean isFreezed = false;
        boolean isUnFreezed = false;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex;
            this.index = rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row != null) {
                Boolean bFreezed = (Boolean)row.getCell("isFree").getValue();
                if (bFreezed.booleanValue()) {
                    isUnFreezed = true;
                } else {
                    isFreezed = true;
                }
            }
        }
        this.btnCancelCancel.setEnabled(isUnFreezed);
        this.btnCancel.setEnabled(isFreezed);
        this.menuItemCancel.setEnabled(isFreezed);
        this.menuItemCancelCancel.setEnabled(isUnFreezed);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(false);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(true);
    }

    private void enableOrDisEnable(boolean isEnable) throws BOSException, Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        ArrayList freeList = new ArrayList();
        if (isEnable) {
            Iterator rptItemid;
            int i;
            int count = list.size();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("RPTItemAccount.checkAccount.id"));
            sic.add(new SelectorItemInfo("RPTItemAccount.DC"));
            sic.add(new SelectorItemInfo("isFree"));
            sic.add(new SelectorItemInfo("number"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(sic);
            RPTItemMapCollection coll = RPTItemMapFactory.getRemoteInstance().getRPTItemMapCollection(view);
            HashMap<String, RPTItemMapInfo> tempMap = new HashMap<String, RPTItemMapInfo>();
            for (i = 0; i < coll.size(); ++i) {
                RPTItemMapInfo info = coll.get(i);
                tempMap.put(info.getId().toString(), info);
            }
            for (i = 0; i < list.size(); ++i) {
                rptItemid = (String)list.get(i);
                RPTItemMapInfo info = (RPTItemMapInfo)tempMap.get(rptItemid);
                if (info == null || !info.isIsFree()) continue;
                freeList.add(info.getId().toString());
            }
            Map map = ((IRPTItemMap)this.getBizInterface()).getEnableExistNumber(freeList);
            if (map.size() > 0) {
                if (count == 1) {
                    rptItemid = map.entrySet().iterator();
                    if (rptItemid.hasNext()) {
                        Map.Entry entry = (Map.Entry)rptItemid.next();
                        String[] numbers = (String[])entry.getValue();
                        MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ExistRptItemMap"), numbers[1]));
                        SysUtil.abort();
                        return;
                    }
                } else {
                    StringBuffer result = new StringBuffer();
                    for (Map.Entry entry : map.entrySet()) {
                        String[] numbers = (String[])entry.getValue();
                        result.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ExistRptItemMapNew"), numbers[0], numbers[1])).append("\n");
                        freeList.remove(numbers[2]);
                        if (numbers.length <= 3) continue;
                        freeList.remove(numbers[3]);
                    }
                    if (freeList.size() == 0) {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"allDefault"), (String)new String(result), (int)8188);
                        SysUtil.abort();
                    } else {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"partDefault"), (String)new String(result), (int)8188);
                    }
                }
            }
        }
        ((IRPTItemMap)this.getBizInterface()).enableOrDisEnable(isEnable ? freeList : list, isEnable);
        this.refreshList();
    }

    public RPTItemMapFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new RPTItemMapFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            CustomerParams cp = new CustomerParams();
            cp.addCustomerParam("parent", this.getMetaDataPK().getFullName());
            this.conditionPanel.setCustomerParams(cp);
        }
        return this.conditionPanel;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPk = MetaDataPK.create((String)"com.kingdee.eas.fi.newrpt.accountcheck", (String)"RPTItemMapQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPk);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(220);
            this.conditionDialog.setTitle(AccountCheckUtil.getResourceString(null, "RPTItemAccountMap", null) + "-" + EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Find_Condition"));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        return this.conditionDialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery;
        if (!this.isInitMerge) {
            this.initMerge();
        }
        if (!this.isPerformDefaultQuery(iQuery = QuerySolutionFacadeFactory.getRemoteInstance(), queryName = "com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapQuery")) {
            if (this.getConditionDialog().show()) {
                EntityViewInfo view = this.getConditionDialog().getEntityViewInfoResult();
                this.initItmeType(view);
                this.initColHide();
                this.mainQuery = view;
                this.tblMain.removeRows();
            } else {
                SysUtil.abort();
            }
        } else {
            this.initItmeType(this.mainQuery);
            this.initColHide();
            this.tblMain.removeRows();
        }
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int defaultValue = CSLParamUtil.getAccountCheckItemTypeDefaultValue(null);
        if (defaultValue != 0 && defaultValue != 1) {
            defaultValue = 1;
        }
        fic.add(new FilterItemInfo("itemType", (Object)defaultValue));
        fic.add(new FilterItemInfo("RPTITEMMAP.isFree", (Object)0));
        view.setFilter(filter);
        return view;
    }

    protected void initItmeType(EntityViewInfo view) throws Exception {
        if (view != null) {
            FilterItemCollection filterItems = view.getFilter().getFilterItems();
            for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo filter = filterItems.get(i);
                if (!"itemType".equals(filter.getPropertyName())) continue;
                this.itemType = (Integer)filter.getCompareValue();
            }
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (uiContext != null) {
            uiContext.put((Object)"itemType", (Object)this.itemType);
        }
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected void setPreSelecteRow() {
        this.tblMain.getSelectManager().select(this.index, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(this.index);
    }

    public Object getTablePreferenceSchemaKey() {
        return this.itemType;
    }

    protected ArrayList getExportParam() {
        String solutionName = "eas.fi.gr.ppRptItemMap";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = AccountCheckUtil.getResourceString(null, "rptItemMap_import_title", null);
        param.datataskMode = 1;
        EntityViewInfo mainQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)(0 == this.itemType ? 0 : 1)));
        mainQuery.setFilter(filter);
        param.putContextParam((Object)"mainQuery", (Object)mainQuery);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapForExportQuery"));
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.importData();
    }

    private void importData() throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        ArrayList importParam = this.getImportParam();
        if (importParam != null) {
            task.invoke(importParam, 0);
        }
    }

    protected ArrayList getImportParam() {
        String solutionName = "eas.fi.gr.pp.ppRptItemMap";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = AccountCheckUtil.getResourceString(null, "rptItemMap_import_title", null);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

