/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AsstActTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageAccount;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractReconciliationAccountSettingsEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountF7UI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.PreLoadFormulaNames;
import com.kingdee.eas.fi.newrpt.investworkpaper.util.InvestElimManuScriptUtil;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class ReconciliationAccountSettingsEditUI
extends AbstractReconciliationAccountSettingsEditUI {
    private static final long serialVersionUID = -1275324270396122369L;
    private static final Logger logger = CoreUIObject.getLogger(ReconciliationAccountSettingsEditUI.class);
    private boolean isModify = false;
    private boolean isFirst = true;
    private String uiTitle = null;
    private boolean isLoadAccountTableData = true;
    private HashMap asstActTypeMap = new HashMap();
    private CheckageAccountInfo editDataCopy = new CheckageAccountInfo();
    private boolean isAccountType = false;
    private CheckageAccountInfo checkageAccountInfo = null;
    private ItemTypeEnum itemType = null;
    private List<String> formulaNames = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        RPTItemInfo rptItemInfo;
        AccountTableInfo accountTableInfo;
        this.editData.setSyncOldValue(true);
        if (this.isAccountType && this.comboAcctTable.getSelectedItem() instanceof AccountTableInfo && (accountTableInfo = (AccountTableInfo)this.comboAcctTable.getSelectedItem()) != null) {
            this.editData.setAccountTableid(accountTableInfo.getId().toString());
            this.editData.setAccountTableName(accountTableInfo.getName());
            this.editData.setAccountTableNumber(accountTableInfo.getNumber());
        }
        if (this.prmtAccount.getValue() instanceof AccountViewInfo) {
            AccountViewInfo accountViewInfo = (AccountViewInfo)this.prmtAccount.getValue();
            if (accountViewInfo != null) {
                this.editData.setItemName(accountViewInfo.getName());
                this.editData.setItemNumber(accountViewInfo.getNumber());
                this.editData.setItemDC(accountViewInfo.getDC());
            }
        } else if (this.prmtAccount.getValue() instanceof RPTItemInfo && (rptItemInfo = (RPTItemInfo)this.prmtAccount.getValue()) != null) {
            this.editData.setItemName(rptItemInfo.getName());
            this.editData.setItemNumber(rptItemInfo.getNumber());
            if (0 == rptItemInfo.getDc().getValue()) {
                this.editData.setItemDC(BalanceDirectionEnum.CREDIT);
            } else if (1 == rptItemInfo.getDc().getValue()) {
                this.editData.setItemDC(BalanceDirectionEnum.DEBIT);
            }
        }
        ItemTypeEnum itemTypeEnum = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
        this.editData.setItemType(itemTypeEnum);
        if (this.isAccountType) {
            if (this.comboAsstActTypes.getSelectedItem() != null) {
                AsstActTypeEnum asstActTypeEnum = (AsstActTypeEnum)((Object)this.comboAsstActTypes.getSelectedItem());
                this.editData.setAsstActTypes(asstActTypeEnum);
            }
            if (this.comboBalType.getSelectedItem() != null) {
                BalTypeEnum balTypeEnum = (BalTypeEnum)((Object)this.comboBalType.getSelectedItem());
                this.editData.setBalType(balTypeEnum);
                this.editData.setDataElement(balTypeEnum.getValue());
            }
        } else if (this.prmtDataElement.getValue() != null) {
            DataElementInfo dataElementInfo = (DataElementInfo)this.prmtDataElement.getValue();
            this.editData.setDataElement(dataElementInfo.getInterSeq());
        }
        String number = this.txtNumber.getText();
        this.editData.setNumber(number);
        String formula = this.txtFormula.getText();
        this.editData.setFormula(formula);
        this.editData.setSyncOldValue(false);
    }

    protected IObjectValue createNewData() {
        return new CheckageAccountInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckageAccountFactory.getRemoteInstance();
    }

    @Override
    protected void prmtAccount_willShow(SelectorEvent e) throws Exception {
        if (this.isAccountType) {
            if (this.comboAcctTable.getSelectedItem() == null || ((AccountTableInfo)this.comboAcctTable.getSelectedItem()).getId() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AccountTableNoNull"));
                e.setCanceled(true);
            }
            if (this.prmtAccount.getValue() == null && this.prmtAccount.getSelector() != null && this.prmtAccount.getSelector() instanceof AccountF7UI) {
                ((AccountF7UI)this.prmtAccount.getSelector()).accountViewInfo = null;
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.itemType = (ItemTypeEnum)((Object)this.getUIContext().get("itemType"));
        boolean bl = this.isAccountType = this.itemType.getValue() == 0;
        if (!"ADDNEW".equals(this.getOprtState())) {
            String id = (String)this.getUIContext().get("ID");
            this.checkageAccountInfo = CheckageAccountFactory.getRemoteInstance().getCheckageAccountInfo((IObjectPK)new ObjectUuidPK(id));
        }
        this.uiTitle = this.getUITitle();
        this.init();
        this.modifyTitle();
        this.isFirst = false;
        this.editDataCopy = (CheckageAccountInfo)this.editData.clone();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.modifyTitle();
        this.clearUI();
    }

    @Override
    protected void comboAcctTable_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAccountType && this.comboAcctTable.getItemCount() > 0) {
            if (this.comboAcctTable.getSelectedItem() != null && ((AccountTableInfo)this.comboAcctTable.getSelectedItem()).getId() != null && !this.isLoadAccountTableData) {
                AccountTableInfo accountTableInfo = (AccountTableInfo)this.comboAcctTable.getSelectedItem();
                this.initAccountF7(accountTableInfo);
            }
            if (!this.isFirst) {
                this.prmtAccount.setValue(null);
                this.isModify = true;
            }
        }
    }

    @Override
    protected void prmtAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isAccountType) {
            if (this.prmtAccount.getValue() != null) {
                if (!(this.prmtAccount.getValue() instanceof String)) {
                    this.txtDC.setText(((AccountViewInfo)this.prmtAccount.getValue()).getDC().toString());
                    String cAAName = (String)((AccountViewInfo)this.prmtAccount.getValue()).get("CAAName");
                    if (cAAName != null) {
                        String[] array = cAAName.split("\\+");
                        for (int i = 0; i < array.length; ++i) {
                            if (this.asstActTypeMap.get(array[i]) != null) {
                                this.comboAsstActTypes.setSelectedIndex(((Integer)this.asstActTypeMap.get(array[i])).intValue());
                                break;
                            }
                            this.comboAsstActTypes.setSelectedIndex(-1);
                        }
                    } else {
                        this.comboAsstActTypes.setSelectedIndex(-1);
                    }
                }
            } else {
                this.txtDC.setText(null);
                this.comboAsstActTypes.setSelectedIndex(-1);
                this.comboBalType.setSelectedIndex(-1);
            }
        } else if (this.prmtAccount.getValue() != null) {
            this.txtDC.setText(((RPTItemInfo)this.prmtAccount.getValue()).getDc().getAlias());
        } else {
            this.txtDC.setText(null);
        }
        if (!this.isFirst) {
            this.isModify = true;
        }
    }

    private void loadAccountTableData() throws Exception {
        this.comboAcctTable.removeAllItems();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("accountTable"));
        evi.getSelector().add(new SelectorItemInfo("accountTable.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTable", null, CompareType.NOTEQUALS));
        evi.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        AccountTableCollection accountTableCollection = new AccountTableCollection();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getAccountTable() == null || coll.get(i).getAccountTable().getCompany() == null) continue;
                accountTableCollection.add(coll.get(i).getAccountTable());
            }
        }
        this.comboAcctTable.addItems(accountTableCollection.toArray());
        this.isLoadAccountTableData = false;
        this.comboAcctTable.setSelectedIndex(-1);
        try {
            String acctTableID;
            if (this.checkageAccountInfo != null && (acctTableID = this.checkageAccountInfo.getAccountTableid()) != null) {
                for (int i = 0; i < this.comboAcctTable.getItemCount(); ++i) {
                    if (!acctTableID.equals(((AccountTableInfo)this.comboAcctTable.getItemAt(i)).getId().toString())) continue;
                    this.comboAcctTable.setSelectedIndex(i);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"loadAccountTableData", (Throwable)e);
        }
    }

    private void initAccountF7(AccountTableInfo accountTableInfo) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isFromComeAndGo", (Object)true);
        uiContext.put((Object)"prmtAccount", (Object)this.prmtAccount);
        uiContext.put((Object)"accountTableInfo", (Object)accountTableInfo);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountF7UI.class.getName(), (Map)uiContext);
            AccountF7UI f7 = (AccountF7UI)uiWindow.getUIObject();
            ((JDialog)uiWindow).setResizable(true);
            this.prmtAccount.setSelector((KDPromptSelector)f7);
            this.prmtAccount.addCommitListener((CommitListener)f7);
            this.prmtAccount.setEditFormat("$number$");
            this.prmtAccount.setDisplayFormat("$number$");
        }
        catch (UIException e1) {
            this.handleException((Exception)((Object)e1));
        }
        this.prmtAccount.setEditable(true);
        this.prmtAccount.setCommitFormat("$number$");
    }

    private void init() throws Exception {
        if (this.isAccountType) {
            this.loadAccountTableData();
            for (int i = 0; i < this.comboAsstActTypes.getItemCount(); ++i) {
                this.asstActTypeMap.put(this.comboAsstActTypes.getItemAt(i).toString(), i);
            }
            this.comboAsstActTypes.setSelectedIndex(-1);
            this.comboBalType.setSelectedIndex(-1);
            this.contDataElement.setVisible(false);
            this.lblFormula.setVisible(false);
            this.btnFormula.setVisible(false);
            this.lblRemark.setVisible(false);
            this.lblRemark2.setVisible(false);
            this.kDScrollPane1.setVisible(false);
            this.setBounds(new Rectangle(10, 10, 295, 195));
        } else {
            this.initPrmtAccount();
            this.initPrmtDataElement();
            this.contAccountTable.setVisible(false);
            this.contAsstActTypes.setVisible(false);
            this.contBalType.setVisible(false);
            this.contAccount.setBounds(new Rectangle(10, 58, 280, 19));
            this.contDC.setBounds(new Rectangle(10, 82, 280, 19));
            this.contDataElement.setBounds(new Rectangle(10, 106, 280, 19));
            this.lblFormula.setBounds(new Rectangle(10, 130, 100, 19));
            this.btnFormula.setBounds(new Rectangle(268, 130, 22, 19));
            this.kDScrollPane1.setBounds(new Rectangle(7, 154, 286, 90));
            this.lblRemark.setBounds(new Rectangle(10, 249, 278, 19));
            this.lblRemark2.setBounds(new Rectangle(10, 266, 278, 19));
            this.setBounds(new Rectangle(10, 10, 295, 280));
            this.btnFormula.setIcon(EASResource.getIcon((String)"imgTbtn_formulaguide"));
        }
        this.loadEditData();
    }

    private void loadEditData() throws EASBizException, BOSException {
        this.combItemType.setSelectedItem((Object)this.itemType);
        if (!"ADDNEW".equals(this.getOprtState())) {
            String number = this.checkageAccountInfo.getNumber();
            this.txtNumber.setText(number);
            if (this.isAccountType) {
                String accountNumber = this.checkageAccountInfo.getItemNumber();
                this.prmtAccount.setData((Object)accountNumber);
                BalanceDirectionEnum balanceDirectionEnum = this.checkageAccountInfo.getItemDC();
                this.txtDC.setText(balanceDirectionEnum.getAlias());
                AsstActTypeEnum asstActTypeEnum = this.checkageAccountInfo.getAsstActTypes();
                this.comboAsstActTypes.setSelectedItem((Object)asstActTypeEnum);
                int value = this.checkageAccountInfo.getDataElement();
                BalTypeEnum balTypeEnum = BalTypeEnum.getEnum(value);
                this.comboBalType.setSelectedItem((Object)balTypeEnum);
            } else {
                String itemNumber = this.checkageAccountInfo.getItemNumber();
                RPTItemInfo rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo("where number = '" + itemNumber + "'");
                this.prmtAccount.setData((Object)rptItemInfo);
                DebitOrCreditEnum debitOrCreditEnum = rptItemInfo.getDc();
                this.txtDC.setText(debitOrCreditEnum.getAlias());
                int interSeq = this.checkageAccountInfo.getDataElement();
                DataElementInfo dataElementInfo = DataElementFactory.getRemoteInstance().getDataElementByInterSeq(interSeq);
                this.prmtDataElement.setData((Object)dataElementInfo);
                String formula = this.checkageAccountInfo.getFormula();
                this.txtFormula.setText(formula);
            }
        }
        this.storeFields();
    }

    private void initPrmtDataElement() throws Exception {
        this.prmtDataElement.setQueryInfo("com.kingdee.eas.fi.newrpt.accountcheck.DataElementQuery");
        this.prmtDataElement.setEditFormat("$number$");
        this.prmtDataElement.setDisplayFormat("$name$");
        this.prmtDataElement.setEditable(true);
        this.prmtDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter(this.prmtDataElement, null, false);
    }

    private void initPrmtAccount() throws Exception {
        this.prmtAccount.setQueryInfo("com.kingdee.eas.fi.newrpt.accountcheck.RPTItemQuery_UnFreezed");
        this.prmtAccount.setEditFormat("$number$");
        this.prmtAccount.setDisplayFormat("$number$");
        this.prmtAccount.setEditable(true);
        this.prmtAccount.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter(this.prmtAccount, null);
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.editDataCopy = (CheckageAccountInfo)this.editData.clone();
        this.clearUI();
        this.isModify = false;
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"264_checkageAccountNumberIsNull"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        ItemTypeEnum itemTypeEnum = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemTypeEnum.getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.getBizInterface().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"265_numberRepeat"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.isAccountType) {
            if (this.comboAcctTable.getSelectedIndex() < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AccountTableNoNull"));
                this.comboAcctTable.requestFocus();
                SysUtil.abort();
            }
            if (this.prmtAccount.getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ItemIsNull"));
                this.prmtAccount.requestFocus();
                SysUtil.abort();
            }
            if (this.comboAsstActTypes.getSelectedIndex() < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AsstActTypeNoNull"));
                this.comboAsstActTypes.requestFocus();
                SysUtil.abort();
            }
            if (this.comboBalType.getSelectedIndex() < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"deIsNull"));
                this.comboBalType.requestFocus();
                SysUtil.abort();
            }
            String accountNumber = null;
            accountNumber = this.prmtAccount.getValue() instanceof String ? (String)this.prmtAccount.getValue() : ((AccountViewInfo)this.prmtAccount.getValue()).getNumber();
            String accountTableID = null;
            accountTableID = ((AccountTableInfo)this.comboAcctTable.getSelectedItem()).getId().toString();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemTypeEnum.getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accountTableid", (Object)accountTableID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("itemNumber", (Object)accountNumber, CompareType.EQUALS));
            if (this.editData.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("dataElement", (Object)((BalTypeEnum)((Object)this.comboBalType.getSelectedItem())).getValue()));
            filter.getFilterItems().add(new FilterItemInfo("isFree", (Object)0, CompareType.EQUALS));
            if (this.getBizInterface().exists(filter)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ItemExist"));
                SysUtil.abort();
            }
            if (this.editData.getId() != null && this.getOprtState() == OprtState.EDIT) {
                CheckageAccountInfo infoCopy = (CheckageAccountInfo)this.editDataCopy.clone();
                CheckageAccountInfo info = (CheckageAccountInfo)this.editData.clone();
                infoCopy.remove("asstacttypes");
                info.remove("asstacttypes");
                if (!infoCopy.equals(info) && this.isExistQuote()) {
                    SysUtil.abort();
                }
            }
        } else {
            String formulaString;
            if (this.prmtAccount.getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ItemIsNull"));
                this.prmtAccount.requestFocus();
                SysUtil.abort();
            }
            if (this.prmtDataElement.getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"deIsNull"));
                this.prmtDataElement.requestFocus();
                SysUtil.abort();
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemTypeEnum.getValue(), CompareType.EQUALS));
            String itemNumber = ((RPTItemInfo)this.prmtAccount.getValue()).getNumber();
            filter.getFilterItems().add(new FilterItemInfo("itemNumber", (Object)itemNumber, CompareType.EQUALS));
            int interSeq = ((DataElementInfo)this.prmtDataElement.getValue()).getInterSeq();
            filter.getFilterItems().add(new FilterItemInfo("dataElement", (Object)interSeq, CompareType.EQUALS));
            if (this.editData.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("isFree", (Object)0, CompareType.EQUALS));
            if (this.getBizInterface().exists(filter)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ItemExist"));
                SysUtil.abort();
            }
            if (this.editData.getId() != null && this.getOprtState() == OprtState.EDIT) {
                CheckageAccountInfo infoCopy = (CheckageAccountInfo)this.editDataCopy.clone();
                CheckageAccountInfo info = (CheckageAccountInfo)this.editData.clone();
                if ((!infoCopy.getItemNumber().equals(info.getItemNumber()) || infoCopy.getDataElement() != info.getDataElement()) && this.isExistQuote()) {
                    SysUtil.abort();
                }
            }
            if (!StringUtils.isEmpty((String)(formulaString = this.editData.getFormula()))) {
                try {
                    formulaString = AccountCheckUtil.replace(formulaString);
                    if (this.formulaNames == null && this.getUIContext().get("preLoadFormulaNames") != null) {
                        PreLoadFormulaNames preLoadFormulaNames = (PreLoadFormulaNames)this.getUIContext().get("preLoadFormulaNames");
                        this.formulaNames = preLoadFormulaNames.getFormulaNames();
                    }
                    Expression expression = InvestElimManuScriptUtil.checkFormulaFormat(formulaString, this.formulaNames);
                    AccountCheckUtil.checkFormula(formulaString);
                    AccountCheckUtil.checkFormulaParams(expression);
                }
                catch (CheckFormulaException e1) {
                    String exceptionStr = e1.getMessage();
                    if (!StringUtils.isEmpty((String)e1.getMessage())) {
                        exceptionStr = MessageFormat.format(exceptionStr, this.editData.getFormula());
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)new CheckFormulaException(CheckFormulaException.CHECKFORMULAERROR, (Throwable)e1).getMessage(), (String)exceptionStr, (int)0);
                    SysUtil.abort();
                }
            }
        }
    }

    private boolean isExistQuote() throws BOSException, Exception {
        ArrayList resultList = this.getResult();
        if (resultList.size() > 1) {
            if (((Boolean)resultList.get(1)).booleanValue() && ((Boolean)resultList.get(2)).booleanValue()) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ALLQuoteNoEdit"), (String)resultList.get(0).toString(), (int)8188);
                return true;
            }
            if (((Boolean)resultList.get(1)).booleanValue() || ((Boolean)resultList.get(2)).booleanValue()) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)((Boolean)resultList.get(1) != false ? "AccountQuoteNoEdit" : "RPTItemQuoteNoEdit")), (String)resultList.get(0).toString(), (int)8188);
                return true;
            }
        }
        return false;
    }

    private void modifyTitle() {
        if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"View"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"Update"));
        } else {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AddNew"));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isFirst = true;
        super.actionEdit_actionPerformed(e);
        this.modifyTitle();
        this.isFirst = false;
    }

    public boolean isModify() {
        if (this.editData == null || OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        if (this.isModify) {
            return true;
        }
        String number = this.txtNumber.getText();
        String oldNumber = this.editData.getNumber();
        if (!StringUtils.isEmpty((String)number) && !number.equals(oldNumber)) {
            return true;
        }
        String formula = this.txtFormula.getText();
        String oldFormula = this.editData.getFormula();
        if (!StringUtils.isEmpty((String)formula) && !formula.equals(oldFormula) || !StringUtils.isEmpty((String)oldFormula) && !formula.equals(oldFormula)) {
            return true;
        }
        return super.isModify();
    }

    private ArrayList getResult() throws BOSException, Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.editData.getId().toString());
        Map resultMap = ((ICheckageAccount)this.getBizInterface()).removeOfNoQuote(list);
        ArrayList NoCanDeleteList = (ArrayList)resultMap.get("noRemoveIDList");
        StringBuffer result = new StringBuffer();
        ArrayList<Comparable<StringBuffer>> resultList = new ArrayList<Comparable<StringBuffer>>();
        if (NoCanDeleteList.size() > 0) {
            Map checkageAccountMap = (Map)resultMap.get("checkageAccountMap");
            Map accountMapNumberMap = (Map)resultMap.get("accountMapNumberMap");
            Map rptItemMapNumberMap = (Map)resultMap.get("rptItemMapNumberMap");
            boolean isAccountMapQuote = (Boolean)resultMap.get("isAccountMapQuote");
            boolean isRptItemMapQuote = (Boolean)resultMap.get("isRptItemMapQuote");
            for (Map.Entry entry : checkageAccountMap.entrySet()) {
                int i;
                ArrayList tempList = (ArrayList)entry.getValue();
                if (accountMapNumberMap.get(entry.getKey()) != null) {
                    ArrayList accountNumberList = (ArrayList)accountMapNumberMap.get(entry.getKey());
                    result.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"label164")).append("\n");
                    for (i = 0; i < accountNumberList.size(); ++i) {
                        result.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"label161"));
                        result.append(accountNumberList.get(i)).append("\n");
                    }
                }
                if (rptItemMapNumberMap.get(entry.getKey()) != null) {
                    ArrayList rptItemMapNumberList = (ArrayList)rptItemMapNumberMap.get(entry.getKey());
                    result.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"label165")).append("\n");
                    for (i = 0; i < rptItemMapNumberList.size(); ++i) {
                        result.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"label163"));
                        result.append(rptItemMapNumberList.get(i)).append("\n");
                    }
                }
                result.append("\n");
            }
            resultList.add(result);
            resultList.add(Boolean.valueOf(isAccountMapQuote));
            resultList.add(Boolean.valueOf(isRptItemMapQuote));
        }
        return resultList;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        try {
            ArrayList resultList = this.getResult();
            if (resultList.isEmpty()) {
                super.actionRemove_actionPerformed(e);
                SysUtil.abort();
            }
            if (((Boolean)resultList.get(1)).booleanValue() && ((Boolean)resultList.get(2)).booleanValue()) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"Cited_Default"), (String)resultList.get(0).toString(), (int)8188);
                SysUtil.abort();
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)((Boolean)resultList.get(1) != false ? "OnlyCitedByAccountMap" : "OnlyCitedByRptItemMap")), (String)resultList.get(0).toString(), (int)8188);
                SysUtil.abort();
            }
        }
        catch (Exception e1) {
            logger.error((Object)"actionRemove_actionPerformed", (Throwable)e1);
        }
    }

    private void clearUI() {
        this.combItemType.setSelectedItem((Object)this.itemType, false);
        this.txtNumber.setText(null);
        this.txtNumber.setEnabled(true);
        if (this.isAccountType) {
            this.comboAcctTable.setSelectedIndex(-1);
            this.prmtAccount.setData(null);
            this.comboAsstActTypes.setSelectedIndex(-1);
            this.comboBalType.setSelectedIndex(-1);
        } else {
            this.prmtAccount.setData(null);
            this.prmtDataElement.setData(null);
            this.txtFormula.setText(null);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.reInit();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.reInit();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.reInit();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.reInit();
    }

    private void reInit() throws BOSException, EASBizException {
        String acctTableID;
        String id = (String)this.getUIContext().get("ID");
        this.checkageAccountInfo = CheckageAccountFactory.getRemoteInstance().getCheckageAccountInfo((IObjectPK)new ObjectUuidPK(id));
        if (this.checkageAccountInfo != null && (acctTableID = this.checkageAccountInfo.getAccountTableid()) != null) {
            for (int i = 0; i < this.comboAcctTable.getItemCount(); ++i) {
                if (!acctTableID.equals(((AccountTableInfo)this.comboAcctTable.getItemAt(i)).getId().toString())) continue;
                this.comboAcctTable.setSelectedIndex(i);
            }
        }
        this.loadEditData();
        this.editDataCopy = (CheckageAccountInfo)this.editData.clone();
    }

    @Override
    protected void comboAsstActTypes_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isFirst) {
            this.isModify = true;
        }
    }

    @Override
    protected void comboBalType_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isFirst) {
            this.isModify = true;
        }
    }

    @Override
    protected void prmtDataElement_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isFirst) {
            this.isModify = true;
        }
    }

    @Override
    public void actionFormula_actionPerformed(ActionEvent e) throws Exception {
        String formulaLine;
        FormulaSelector selector = new FormulaSelector((CoreUIObject)this, 10);
        selector.show();
        if (selector.getData() != null && !StringUtils.isEmpty((String)(formulaLine = (String)selector.getData()))) {
            this.txtFormula.setText(formulaLine);
        }
        if (selector.getFormulaPickerUI() != null) {
            this.formulaNames = selector.getFormulaPickerUI().getFormulaNames();
        }
    }

    public Object getClientValue(Object key) {
        return this.txtFormula.getText();
    }
}

