/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AsstActTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractReconciliationAccountSettingsFilterUI;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ReconciliationAccountSettingsFilterUI
extends AbstractReconciliationAccountSettingsFilterUI {
    private static final long serialVersionUID = 2022617899029025610L;
    private static final Logger logger = CoreUIObject.getLogger(ReconciliationAccountSettingsFilterUI.class);
    String selectAll = CslRptUtil.getString((String)"CslRptItemDataNameAll");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPrmtDataElement();
        this.initCombDataElement();
        this.initPrmtAccountTable();
        this.initCombAssistType();
        AccountCheckUtil.initItemTypeDefaultValue(this.combItemType);
    }

    private void initPrmtDataElement() throws Exception {
        this.prmtDataElement.setQueryInfo("com.kingdee.eas.fi.newrpt.accountcheck.DataElementQuery");
        this.prmtDataElement.setEditFormat("$number$");
        this.prmtDataElement.setDisplayFormat("$name$");
        this.prmtDataElement.setEditable(true);
        this.prmtDataElement.setCommitFormat("$number$");
        CslGradeManageUtil.setDataElementF7GMFilter(this.prmtDataElement, null, false);
    }

    private void initPrmtAccountTable() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("accountTable"));
        evi.getSelector().add(new SelectorItemInfo("accountTable.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTable", null, CompareType.NOTEQUALS));
        evi.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
        AccountTableCollection accountTableCollection = new AccountTableCollection();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getAccountTable() == null || coll.get(i).getAccountTable().getCompany() == null) continue;
                accountTableCollection.add(coll.get(i).getAccountTable());
            }
        }
        this.combAccountTable.addItem((Object)this.selectAll);
        this.combAccountTable.addItems(accountTableCollection.toArray());
    }

    private void initCombDataElement() {
        this.combDataElement.addItem((Object)this.selectAll);
        this.combDataElement.addItems(BalTypeEnum.getEnumList().toArray());
    }

    private void initCombAssistType() {
        this.combAssistType.addItem((Object)this.selectAll);
        this.combAssistType.addItems(AsstActTypeEnum.getEnumList().toArray());
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItemItemType;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        if (this.combItemType.getSelectedItem() != null) {
            ItemTypeEnum itemType = (ItemTypeEnum)((Object)this.combItemType.getSelectedItem());
            FilterItemInfo filterItemItemType2 = new FilterItemInfo("itemType", (Object)new Integer(itemType.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemItemType2);
            ++formulaIndex;
        }
        if (this.lableAccountDE.isVisible()) {
            if (this.combDataElement.getSelectedItem() != null && !this.combDataElement.getSelectedItem().equals(this.selectAll)) {
                BalTypeEnum balTypeEnum = (BalTypeEnum)((Object)this.combDataElement.getSelectedItem());
                int balTypeValue = balTypeEnum.getValue();
                filterItemItemType = new FilterItemInfo("dataElement", (Object)new Integer(balTypeValue), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemItemType);
                ++formulaIndex;
            }
            if (this.combAccountTable.getSelectedItem() != null && !this.combAccountTable.getSelectedItem().equals(this.selectAll)) {
                AccountTableInfo accountTableInfo = (AccountTableInfo)this.combAccountTable.getSelectedItem();
                String accountTableid = accountTableInfo.getId().toString();
                filterItemItemType = new FilterItemInfo("accountTableid", (Object)accountTableid, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemItemType);
                ++formulaIndex;
            }
            if (this.combAssistType.getSelectedItem() != null && !this.combAssistType.getSelectedItem().equals(this.selectAll)) {
                AsstActTypeEnum asstActTypeEnum = (AsstActTypeEnum)((Object)this.combAssistType.getSelectedItem());
                String asstActTypeValue = asstActTypeEnum.getValue();
                filterItemItemType = new FilterItemInfo("asstActTypes", (Object)asstActTypeValue, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemItemType);
                ++formulaIndex;
            }
        } else if (this.lableItemDE.isVisible() && this.prmtDataElement.getData() != null) {
            DataElementInfo dataElementInfo = (DataElementInfo)this.prmtDataElement.getData();
            int interSeq = dataElementInfo.getInterSeq();
            filterItemItemType = new FilterItemInfo("dataElement", (Object)new Integer(interSeq), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemItemType);
            ++formulaIndex;
        }
        if (this.chkIncludeFreeze.isSelected()) {
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(0);
            set.add(1);
            FilterItemInfo filterItemName = new FilterItemInfo("isFree", set, CompareType.INCLUDE);
            this.filterInfo.getFilterItems().add(filterItemName);
            ++formulaIndex;
        } else {
            FilterItemInfo filterItemName = new FilterItemInfo("isFree", (Object)0, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemName);
            ++formulaIndex;
        }
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < formulaIndex; ++i) {
            if (i == 0) {
                sbFormula.append(" (#0)");
                continue;
            }
            sbFormula.append(" and (#" + i + ")");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo view) {
        this.clearUI();
        super.loadData(view);
        FilterItemCollection fic = view.getFilter() == null ? new FilterItemCollection() : view.getFilter().getFilterItems();
        for (int i = 0; i < fic.size(); ++i) {
            FilterItemInfo filterItemInfo = fic.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemType")) {
                Integer itemTypeInt = (Integer)filterItemInfo.getCompareValue();
                this.combItemType.setSelectedItem((Object)ItemTypeEnum.getEnum(itemTypeInt));
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("dataElement")) {
                Integer DataElementInt = (Integer)filterItemInfo.getCompareValue();
                BalTypeEnum balTypeEnum = BalTypeEnum.getEnum(DataElementInt);
                if (balTypeEnum != null) {
                    this.combDataElement.setSelectedItem((Object)balTypeEnum);
                }
                try {
                    boolean isExist = DataElementFactory.getRemoteInstance().exists("where interSeq = " + DataElementInt + "");
                    if (isExist) {
                        DataElementInfo dataElement = DataElementFactory.getRemoteInstance().getDataElementByInterSeq(DataElementInt.intValue());
                        this.prmtDataElement.setData((Object)dataElement);
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)"getDataElement Error: ", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getDataElement Error: ", (Throwable)e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("accountTableid")) {
                String accountTableid = (String)filterItemInfo.getCompareValue();
                try {
                    boolean isExist = AccountTableFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(accountTableid));
                    if (isExist) {
                        int count = this.combAccountTable.getItemCount();
                        for (int j = 1; j < count; ++j) {
                            AccountTableInfo acctable = (AccountTableInfo)this.combAccountTable.getItemAt(j);
                            String id = acctable.getId().toString();
                            if (!accountTableid.equals(id)) continue;
                            this.combAccountTable.setSelectedItem((Object)acctable);
                        }
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)"getAccountTable Error: ", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"getAccountTable Error: ", (Throwable)e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("asstActTypes")) {
                String asstActType = (String)filterItemInfo.getCompareValue();
                AsstActTypeEnum asstActTypeEnum = AsstActTypeEnum.getEnum(asstActType);
                this.combAssistType.setSelectedItem((Object)asstActTypeEnum);
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("isFree")) continue;
            if (filterItemInfo.getCompareValue() instanceof Integer) {
                this.chkIncludeFreeze.setSelected(false);
                continue;
            }
            this.chkIncludeFreeze.setSelected(true);
        }
    }

    private void clearUI() {
        AccountCheckUtil.initItemTypeDefaultValue(this.combItemType);
        this.prmtDataElement.setData(null);
        this.combDataElement.setSelectedIndex(0);
        this.combAccountTable.setSelectedIndex(0);
        this.combAssistType.setSelectedIndex(0);
        this.chkIncludeFreeze.setSelected(false);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    @Override
    protected void combItemType_actionPerformed(ActionEvent e) throws Exception {
        super.combItemType_actionPerformed(e);
        if (e.getSource() instanceof KDComboBox) {
            ItemTypeEnum itemType = (ItemTypeEnum)((Object)((KDComboBox)e.getSource()).getSelectedItem());
            if (itemType.getValue() == 1) {
                this.lableAccountDE.setVisible(false);
                this.lableAccountTable.setVisible(false);
                this.lableAssistType.setVisible(false);
                this.chkIncludeFreeze.setBounds(new Rectangle(10, 68, 140, 19));
                this.lableItemDE.setVisible(true);
                this.prmtDataElement.setData(null);
                this.chkIncludeFreeze.setSelected(false);
            } else {
                this.lableAccountDE.setVisible(true);
                this.combDataElement.setSelectedIndex(0);
                this.lableAccountTable.setVisible(true);
                this.combAccountTable.setSelectedIndex(0);
                this.lableAssistType.setVisible(true);
                this.combAssistType.setSelectedIndex(0);
                this.lableItemDE.setVisible(false);
                this.chkIncludeFreeze.setBounds(new Rectangle(10, 126, 140, 19));
                this.chkIncludeFreeze.setSelected(false);
            }
        }
    }
}

