/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageCompany;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractReconciliationOrgSettingsEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ReconciliationOrgSettingsListUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ReconciliationOrgSettingsEditUI
extends AbstractReconciliationOrgSettingsEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReconciliationOrgSettingsEditUI.class);
    private HashSet companyIDSet = null;
    FullOrgUnitCollection companyCollection = new FullOrgUnitCollection();
    boolean isModify = false;
    private OrgTreeCollection otc = null;

    public ReconciliationOrgSettingsEditUI() throws Exception {
        this.kdtCompanyEntries.checkParsed(false);
        this.kdtCompanyEntries.getStyleAttributes().setLocked(true);
        this.kdtCompanyEntries.getSelectManager().setSelectMode(10);
        this.otc = this.getAllOrgTrees();
    }

    private OrgTreeCollection getAllOrgTrees() throws EASBizException, BOSException {
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection();
        if (otc == null) {
            return null;
        }
        if ((otc = CslRptUtil.getOrgTreeCollectionOrderByNumberNew(null, (OrgTreeCollection)otc)) == null) {
            return null;
        }
        return otc;
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    protected IObjectValue createNewData() {
        CheckageCompanyInfo checkageCompanyInfo = new CheckageCompanyInfo();
        return checkageCompanyInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckageCompanyFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContect(this.pmptFirstContect);
        this.initContect(this.pmptSecondContect);
        this.bindBtnAction();
        this.btnAddCompany.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveCompany.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        final KDInfoTip cellTip = new KDInfoTip((JComponent)this.txtCell, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CELL_FORMAT"));
        final KDInfoTip cellTip2 = new KDInfoTip((JComponent)this.txtCell2, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CELL_FORMAT"));
        cellTip.setMaxRenderWidth(260.0f);
        cellTip2.setMaxRenderWidth(260.0f);
        this.txtCell.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    cellTip.setShowing(false);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsEditUI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    cellTip.setShowing(true);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsEditUI.this.handUIException(exc);
                }
            }
        });
        this.txtCell2.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    cellTip2.setShowing(false);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsEditUI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    cellTip2.setShowing(true);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsEditUI.this.handUIException(exc);
                }
            }
        });
        this.setUITitle(this.getUITitle() + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AddNew"));
    }

    private void bindBtnAction() {
        this.btnAddCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReconciliationOrgSettingsEditUI.this.initAddCompanyF7();
            }
        });
        this.btnRemoveCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ReconciliationOrgSettingsEditUI.this.canEdit()) {
                    return;
                }
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)ReconciliationOrgSettingsEditUI.this.kdtCompanyEntries);
                FullOrgUnitInfo entryInfo = null;
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    entryInfo = (FullOrgUnitInfo)ReconciliationOrgSettingsEditUI.this.kdtCompanyEntries.getRow(rowIndex).getUserObject();
                    ReconciliationOrgSettingsEditUI.this.companyIDSet.remove(entryInfo.getId().toString());
                    ReconciliationOrgSettingsEditUI.this.companyCollection.remove(entryInfo);
                    ReconciliationOrgSettingsEditUI.this.kdtCompanyEntries.removeRow(rowIndex);
                    ReconciliationOrgSettingsEditUI.this.isModify = true;
                }
            }
        });
    }

    private void initAddCompanyF7() {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
        f7.setOrgTrees(this.otc);
        OrgViewType[] orgViewTypes = new OrgViewType[]{OrgViewType.COMPANY, OrgViewType.UNIONDEBT};
        f7.setOrgViewType(orgViewTypes);
        f7.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"553_orgF7Title"));
        f7.filterUnitSql(this.getFilterSql());
        this.addCompany(f7);
    }

    private String getFilterSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select range.forgid FROM t_pm_orgrange range ");
        sql.append(" inner join t_org_company com On com.fid = range.forgid ");
        sql.append(" where com.fisBizUnit = 1 and com.fisSealUp = 0 and range.ftype = 10 and range.fuserid='");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("' ");
        return sql.toString();
    }

    protected boolean canEdit() {
        return !"VIEW".equals(this.getOprtState());
    }

    protected void addCompany(UnionF7Helper.UnionF7 f7) {
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        f7.setMultiSelect(true);
        f7.setPermissionItem(null);
        if (this.companyIDSet == null) {
            this.companyIDSet = new HashSet();
        }
        f7.setSelectedOrgIds((Set)this.companyIDSet);
        f7.show();
        Object[] orgs = (Object[])f7.getData();
        if (!this.canEdit() || orgs == null) {
            return;
        }
        CompanyOrgUnitInfo org = null;
        for (int i = 0; i < orgs.length; ++i) {
            org = (CompanyOrgUnitInfo)orgs[i];
            this.companyIDSet.add(org.getId().toString());
            this.companyCollection.add(org.castToFullOrgUnitInfo());
            this.isModify = true;
        }
        this.deleteOldCompanyEntriesData();
        this.getDataBinder().bindDataToTable(this.kdtCompanyEntries, (IObjectCollection)this.companyCollection);
    }

    private void deleteOldCompanyEntriesData() {
        for (int i = this.kdtCompanyEntries.getRowCount() - 1; i >= 0; --i) {
            this.kdtCompanyEntries.removeRow(i);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initContect(KDBizPromptBox pmptContect) {
        pmptContect.setEditFormat("$name$");
        pmptContect.setCommitFormat("$name$");
        pmptContect.setDisplayFormat("$name$($number$)");
        pmptContect.setVisible(true);
        pmptContect.setEditable(false);
        pmptContect.setQueryInfo("com.kingdee.eas.fi.newrpt.accountcheck.PersonQuery");
        pmptContect.getComponent(0).setVisible(false);
        pmptContect.setMyCommonUseEnabled(false);
        EntityViewInfo view = pmptContect.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (view.getFilter() == null) {
            view.setFilter(new FilterInfo());
        }
        FilterInfo filter = view.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.name", null, CompareType.ISNOT));
        pmptContect.setEntityViewInfo(view);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.storeFields();
        HashMap existCompany = ((ICheckageCompany)this.getBizInterface()).getExistMap(this.companyIDSet);
        int count = this.kdtCompanyEntries.getRowCount();
        this.companyCollection.clear();
        for (int i = 0; i < count; ++i) {
            FullOrgUnitInfo entryInfo = (FullOrgUnitInfo)this.kdtCompanyEntries.getRow(i).getUserObject();
            this.companyCollection.add(entryInfo);
        }
        Iterator itor = this.companyCollection.iterator();
        CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
        boolean isAllExist = true;
        while (itor.hasNext()) {
            FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)itor.next();
            String companyID = fullOrgUnitInfo.getId().toString();
            if (companyID == null || existCompany.containsKey(companyID)) continue;
            info.setId(BOSUuid.read((String)companyID));
            info.setName(fullOrgUnitInfo.getName());
            this.editData.setCompany(info);
            this.getBizInterface().submit((CoreBaseInfo)this.editData);
            isAllExist = false;
        }
        this.editData.copyNewToOld();
        if (!existCompany.isEmpty()) {
            if (isAllExist) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AllExist"));
                SysUtil.abort();
            } else {
                StringBuffer errorDetail = new StringBuffer();
                for (Map.Entry entry : existCompany.entrySet()) {
                    List list = (List)entry.getValue();
                    errorDetail.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"Exist_company"), list.get(0), list.get(1))).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"SaveDefeat"), (String)errorDetail.toString(), (int)8188);
            }
        }
        this.showMessageForStatus();
        this.showSubmitSuccess();
        this.isModify = false;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String email2;
        String email;
        String cell2;
        String cell;
        String contect2;
        String contect;
        if (this.companyIDSet == null || this.companyIDSet.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NoSelectCompany"));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)(contect = this.txtFirst.getText())) && contect.length() > 120) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "checkageCompany_import_contectTooLong", null));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)(contect2 = this.txtSecond.getText())) && contect2.length() > 120) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "checkageCompany_import_contect2TooLong", null));
            SysUtil.abort();
        }
        if ((cell = this.txtCell.getText()) != null && cell.trim().length() > 0 && !Pattern.matches("^[+0-9][\\d-\\s]{" + (cell.trim().length() - 1) + "}", cell)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CellIsError"));
            SysUtil.abort();
        }
        if ((cell2 = this.txtCell2.getText()) != null && cell2.trim().length() > 0 && !Pattern.matches("^[+0-9][\\d-\\s]{" + (cell2.trim().length() - 1) + "}", cell2)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CellIsError"));
            SysUtil.abort();
        }
        if ((email = this.txtEmail.getText()) != null && email.trim().length() > 0) {
            if (email.trim().indexOf("@") < 0 || email.trim().endsWith("@")) {
                this.txtEmail.requestFocusInWindow();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"EMAIL_ERROR"));
                SysUtil.abort();
            }
            if (email.length() > 200) {
                MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "checkageCompany_import_emailTooLong", null));
                SysUtil.abort();
            }
        }
        if ((email2 = this.txtEmail2.getText()) != null && email2.trim().length() > 0) {
            if (email2.trim().indexOf("@") < 0 || email2.trim().endsWith("@")) {
                this.txtEmail2.requestFocusInWindow();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"EMAIL_ERROR"));
                SysUtil.abort();
            }
            if (email2.length() > 200) {
                MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "checkageCompany_import_email2TooLong", null));
                SysUtil.abort();
            }
        }
    }

    public boolean isModify() {
        if (this.editData == null || OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        if (this.isModify) {
            return true;
        }
        return super.isModify();
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        try {
            if (b) {
                ((ReconciliationOrgSettingsListUI)((Object)this.getUIContext().get("Owner"))).refreshList();
            }
        }
        catch (Exception e) {
            logger.error((Object)"checkBeforeWindowClosing()", (Throwable)e);
        }
        return b;
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (!b) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }

    @Override
    protected void pmptSecondContect_dataChanged(DataChangeEvent e) throws Exception {
        PersonInfo personInfo = (PersonInfo)this.pmptSecondContect.getValue();
        this.getPersonMessage(personInfo, false);
    }

    @Override
    protected void pmptFirstContect_dataChanged(DataChangeEvent e) throws Exception {
        PersonInfo personInfo = (PersonInfo)this.pmptFirstContect.getValue();
        this.getPersonMessage(personInfo, true);
    }

    private void getPersonMessage(PersonInfo personInfo, boolean isFirstContect) {
        if (personInfo != null && personInfo.getId() != null) {
            String cell = null;
            String email = null;
            cell = personInfo.getCell() != null ? personInfo.getCell() : (personInfo.getBackupCell() != null ? personInfo.getBackupCell() : (personInfo.getOfficePhone() != null ? personInfo.getOfficePhone() : personInfo.getHomePhone()));
            email = personInfo.getEmail() != null ? personInfo.getEmail() : personInfo.getBackupEMail();
            if (isFirstContect) {
                this.txtCell.setText(cell);
                this.txtEmail.setText(email);
                this.txtFirst.setText(personInfo.getName());
            } else {
                this.txtCell2.setText(cell);
                this.txtEmail2.setText(email);
                this.txtSecond.setText(personInfo.getName());
            }
        }
    }
}

