/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageCompany;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractReconciliationOrgSettingsListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.FreeDateUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.OrgnizationAssociateTemplateUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.OrgnizationDisAssociateTemplateUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ReconciliationOrgSettingsEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.ReconciliationOrgSettingsViewUI;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReconciliationOrgSettingsListUI
extends AbstractReconciliationOrgSettingsListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReconciliationOrgSettingsListUI.class);
    private boolean isAddNew = false;
    private HashSet orgIDSet = new HashSet();
    private boolean isConfirm = false;
    private ArrayList<String> NoCanDeleteList = null;
    private int index = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        if (this.isAddNew) {
            return ReconciliationOrgSettingsEditUI.class.getName();
        }
        return ReconciliationOrgSettingsViewUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckageCompanyFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.isAddNew = true;
        super.actionAddNew_actionPerformed(e);
        this.isAddNew = false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.orgIDSet == null || this.orgIDSet.size() < 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", null));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.orgIDSet, CompareType.INCLUDE));
        }
        return filterInfo;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(false);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.enableOrDisEnable(true);
    }

    private void enableOrDisEnable(boolean isEnable) throws BOSException, Exception {
        this.checkSelected();
        if (!isEnable) {
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"IsConfirmFree"));
            if (result != 0) {
                SysUtil.abort();
            }
            ArrayList list = ((ICheckageCompany)this.getBizInterface()).getQuoteTime(this.getSelectedKeyValue());
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            int selectIndex = selectRows[0];
            String accountPeriodTypeid = this.tblMain.getRow(selectIndex).getCell("accountPeriodType.id").getValue().toString();
            Map YearPeriodMap = ((ICheckageCompany)this.getBizInterface()).getYearAndPeriod(accountPeriodTypeid);
            this.openFreeTimeSelectUI(list, YearPeriodMap);
        } else {
            ArrayList list = super.getSelectedIdValues();
            ((ICheckageCompany)this.getBizInterface()).enable(list);
        }
        this.refreshList();
    }

    private void openFreeTimeSelectUI(ArrayList QuoteTimelist, Map YearPeriodMap) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Year", QuoteTimelist.size() > 0 && QuoteTimelist != null ? QuoteTimelist.get(0) : Integer.valueOf(0));
        uiContext.put((Object)"Period", (Object)(QuoteTimelist.size() > 1 && QuoteTimelist != null ? (Integer)QuoteTimelist.get(1) : 0));
        uiContext.put((Object)"YearPeriodMap", (Object)YearPeriodMap);
        uiContext.put((Object)"id", (Object)this.getSelectedKeyValue());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FreeDateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
    }

    @Override
    public void actionNoContainNotPosted_actionPerformed(ActionEvent e) throws Exception {
        this.ContainNotPosted(false);
    }

    @Override
    public void actionContainNotPosted_actionPerformed(ActionEvent e) throws Exception {
        this.ContainNotPosted(true);
    }

    private void ContainNotPosted(boolean isContainNotPosted) throws BOSException, Exception {
        this.checkSelected();
        ArrayList list = super.getSelectedIdValues();
        ((ICheckageCompany)this.getBizInterface()).ContainNotPosted(list, isContainNotPosted);
        this.refreshList();
    }

    @Override
    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.selectItemIsFrz();
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        IRow row;
        super.afterTableFillData(e);
        for (int i = 0; i < this.tblMain.getRowCount() && (row = this.tblMain.getRow(i)) != null; ++i) {
            ICell cell = row.getCell("freeTime");
            if (cell == null || cell.getValue() == null) continue;
            String date = String.valueOf(cell.getValue());
            if (date.length() == 6) {
                StringBuffer result = new StringBuffer();
                String periodStr = date.substring(4, 6);
                int period = Integer.parseInt(periodStr);
                if (period < 10) {
                    periodStr = date.substring(5, 6);
                }
                result.append(date.substring(0, 4)).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"year")).append(periodStr).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"period"));
                cell.setValue((Object)result.toString());
                continue;
            }
            if (!date.isEmpty() && !date.equals("0")) continue;
            cell.setValue(null);
        }
    }

    protected void setPreSelecteRow() {
        this.tblMain.getSelectManager().select(this.index, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(this.index);
    }

    public void onLoad() throws Exception {
        this.getAuthorizedOrg();
        super.onLoad();
        this.init();
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    private void init() {
        KDTMenuManager tm = this.getMenuManager(this.tblMain);
        if (tm != null) {
            KDPopupMenu pop = tm.getMenu();
            pop.getComponent(3).setVisible(false);
            pop.getComponent(4).setVisible(false);
        }
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    private void selectItemIsFrz() {
        boolean isFreezed = false;
        boolean isUnFreezed = false;
        boolean isContainNotPosted = false;
        boolean isNoContainNotPosted = false;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex;
            this.index = rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row != null) {
                Boolean bFreezed = (Boolean)row.getCell("isfree").getValue();
                Boolean bContainNotPosted = (Boolean)row.getCell("isContainNotPosted").getValue();
                if (bFreezed.booleanValue()) {
                    isUnFreezed = true;
                } else {
                    isFreezed = true;
                }
                if (bContainNotPosted.booleanValue()) {
                    isNoContainNotPosted = true;
                } else {
                    isContainNotPosted = true;
                }
            }
        }
        this.btnCancelCancel.setEnabled(isUnFreezed);
        this.btnCancel.setEnabled(isFreezed);
        this.menuItemCancel.setEnabled(isFreezed);
        this.menuItemCancelCancel.setEnabled(isUnFreezed);
        this.btnContainNotPosted.setEnabled(isContainNotPosted);
        this.btnNoContainNotPosted.setEnabled(isNoContainNotPosted);
        this.menuItemContainNotPosted.setEnabled(isContainNotPosted);
        this.menuItemNoContainNotPosted.setEnabled(isNoContainNotPosted);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"company.number", "company.name", "contect", "contect2"};
        return locateNames;
    }

    private void getAuthorizedOrg() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("org"));
        view.setSelector(seletor);
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)userID));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        view.setFilter(filter);
        OrgRangeCollection orgRangeCollection = null;
        try {
            orgRangeCollection = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"initMainQuery", (Throwable)e);
        }
        if (orgRangeCollection != null && orgRangeCollection.size() > 0) {
            for (int i = 0; i < orgRangeCollection.size(); ++i) {
                this.orgIDSet.add(orgRangeCollection.get(i).getOrg().getId().toString());
            }
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.initMainQuery();
        super.actionQuery_actionPerformed(e);
    }

    private void initMainQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            SysUtil.abort();
        }
        this.isConfirm = true;
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        try {
            Map listMap = ((ICheckageCompany)this.getBizInterface()).removeOfNoQuote(list);
            this.NoCanDeleteList = (ArrayList)listMap.get("noRemoveIDList");
            HashSet<String> norRevIds = new HashSet<String>();
            StringBuffer toleranceRelaOrg = this.getRelaToleranceData(list, norRevIds);
            StringBuffer result = new StringBuffer();
            String rela = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"541_orgDelFail");
            if (this.NoCanDeleteList.size() > 0) {
                ArrayList noRemoveNameList = (ArrayList)listMap.get("noRemoveNameList");
                for (String NoCanDeleteName : noRemoveNameList) {
                    String tempString = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NoCan_Delete_company"), NoCanDeleteName);
                    result.append(tempString).append("\n");
                }
                if (!norRevIds.isEmpty()) {
                    result.append(rela).append("\n").append(toleranceRelaOrg);
                }
            } else if (this.NoCanDeleteList.isEmpty() && !norRevIds.isEmpty()) {
                result.append(rela).append("\n").append(toleranceRelaOrg);
            }
            if (count > 1) {
                HashSet<String> cannotDelSet = new HashSet<String>();
                cannotDelSet.addAll(this.NoCanDeleteList);
                cannotDelSet.addAll(norRevIds);
                if (!cannotDelSet.isEmpty()) {
                    if (count == cannotDelSet.size()) {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AllRemoveDefault"), (String)new String(result), (int)8188);
                        SysUtil.abort();
                    } else {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"No_Can_Delete"), (String)new String(result), (int)8188);
                    }
                }
            } else if (!this.NoCanDeleteList.isEmpty() || !norRevIds.isEmpty()) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"isDeleteDefault"), (String)new String(result), (int)8188);
                SysUtil.abort();
            }
            super.actionRemove_actionPerformed(e);
        }
        catch (Exception e1) {
            logger.error((Object)"actionRemove_actionPerformed", (Throwable)e1);
        }
        finally {
            this.isConfirm = false;
        }
    }

    private StringBuffer getRelaToleranceData(ArrayList list, Set<String> norRevIds) throws BOSException {
        HashSet chkOrgIds = new HashSet(list);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", chkOrgIds, CompareType.INCLUDE));
        CheckageCompanyCollection chkComs = CheckageCompanyFactory.getRemoteInstance().getCheckageCompanyCollection(view);
        HashSet<String> orgIds = new HashSet<String>();
        if (chkComs != null && !chkComs.isEmpty()) {
            Iterator it = chkComs.iterator();
            while (it.hasNext()) {
                CheckageCompanyInfo chkCom = (CheckageCompanyInfo)it.next();
                orgIds.add(chkCom.getCompany().getId().toString());
            }
        }
        StringBuffer orgNames = new StringBuffer();
        if (!orgIds.isEmpty()) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", orgIds, CompareType.INCLUDE));
            view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
            view.getSelector().add(new SelectorItemInfo("orgUnit.name"));
            ToleranceCollection tolerances = ToleranceFactory.getRemoteInstance().getToleranceCollection(view);
            if (tolerances != null && !tolerances.isEmpty()) {
                Iterator it = tolerances.iterator();
                while (it.hasNext()) {
                    ToleranceInfo tolerance = (ToleranceInfo)it.next();
                    String orgId = tolerance.getOrgUnit().getId().toString();
                    if (!norRevIds.contains(orgId)) {
                        String orgName = tolerance.getOrgUnit().getName();
                        orgNames.append(orgName).append("\n");
                    }
                    norRevIds.add(orgId);
                }
            }
        }
        return orgNames;
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList list = super.getSelectedIdValues();
        if (this.NoCanDeleteList != null && this.NoCanDeleteList.size() > 0) {
            for (String NoCanDeleteNumber : this.NoCanDeleteList) {
                if (!list.contains(NoCanDeleteNumber)) continue;
                list.remove(NoCanDeleteNumber);
            }
        }
        return list;
    }

    protected boolean confirmRemove() {
        if (this.isConfirm) {
            return true;
        }
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected ArrayList getExportParam() {
        String solutionName = "eas.fi.gr.ppCheckageCompany";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = AccountCheckUtil.getResourceString(null, "checkageCompany_import_title", null);
        param.datataskMode = 1;
        EntityViewInfo mainQuery = new EntityViewInfo();
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("company.number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        sort.add(sorterItemInfo);
        mainQuery.setSorter(sort);
        if (this.orgIDSet != null && !this.orgIDSet.isEmpty()) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.orgIDSet, CompareType.INCLUDE));
            mainQuery.setFilter(filterInfo);
        }
        param.putContextParam((Object)"mainQuery", (Object)mainQuery);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyForExportQuery"));
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.importData();
    }

    private void importData() throws Exception {
    }

    protected ArrayList getImportParam() {
        String solutionName = "eas.fi.gr.pp.ppCheckageCompany";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = AccountCheckUtil.getResourceString(null, "checkageCompany_import_title", null);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionAssociateTemplate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List<CompanyOrgUnitInfo> selData = this.getSelectedOrgs();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"org", selData);
        uiContext.put((Object)"parent", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgnizationAssociateTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        ((OrgnizationAssociateTemplateUI)uiWindow.getUIObject()).getUIMenuBar().setVisible(false);
        ((OrgnizationAssociateTemplateUI)uiWindow.getUIObject()).getUIToolBar().setVisible(false);
        uiWindow.show();
    }

    private List<CompanyOrgUnitInfo> getSelectedOrgs() {
        ArrayList<CompanyOrgUnitInfo> selDatas = new ArrayList<CompanyOrgUnitInfo>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            CompanyOrgUnitInfo comInfo = null;
            int size = selectRows.length;
            for (int i = 0; i < size; ++i) {
                comInfo = new CompanyOrgUnitInfo();
                int index = selectRows[i];
                IRow row = this.tblMain.getRow(index);
                String comId = (String)row.getCell("company.id").getValue();
                String comNumber = (String)row.getCell("company.number").getValue();
                String comName = (String)row.getCell("company.name").getValue();
                comInfo.setId(BOSUuid.read((String)comId));
                comInfo.setNumber(comNumber);
                comInfo.setName(comName);
                selDatas.add(comInfo);
            }
        }
        return selDatas;
    }

    @Override
    public void actionDisassociateTemplate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        Set<String> orgIds = this.getSelectedOrgIds();
        uiContext.put((Object)"orgIds", orgIds);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgnizationDisAssociateTemplateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private Set<String> getSelectedOrgIds() {
        HashSet<String> orgIds = new HashSet<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            for (int index : selectRows) {
                IRow row = this.tblMain.getRow(index);
                String comId = (String)row.getCell("company.id").getValue();
                orgIds.add(comId);
            }
        }
        return orgIds;
    }
}

