/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractReconciliationOrgSettingsViewUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ReconciliationOrgSettingsViewUI
extends AbstractReconciliationOrgSettingsViewUI {
    private static final Logger logger = CoreUIObject.getLogger(ReconciliationOrgSettingsViewUI.class);
    private String uiTitle = null;
    private OrgTreeCollection otc = this.getAllOrgTrees();

    private OrgTreeCollection getAllOrgTrees() throws EASBizException, BOSException {
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection();
        if (otc == null) {
            return null;
        }
        if ((otc = CslRptUtil.getOrgTreeCollectionOrderByNumberNew(null, (OrgTreeCollection)otc)) == null) {
            return null;
        }
        return otc;
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return new CheckageCompanyInfo();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.uiTitle = this.getUITitle();
        this.initCompanyF7();
        this.initContect(this.pmptFirstContect);
        this.initContect(this.pmptSecondContect);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.prmtCompany.setEnabled(false);
            this.prmtCompany.getUI().getButton().setEnabled(false);
            this.pmptFirstContect.setEnabled(false);
            this.pmptFirstContect.getUI().getButton().setEnabled(false);
            this.pmptSecondContect.setEnabled(false);
            this.pmptSecondContect.getUI().getButton().setEnabled(false);
        }
        this.modifyTitle();
        final KDInfoTip cellTip = new KDInfoTip((JComponent)this.txtCell, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CELL_FORMAT"));
        final KDInfoTip cellTip2 = new KDInfoTip((JComponent)this.txtCell2, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CELL_FORMAT"));
        cellTip.setMaxRenderWidth(260.0f);
        cellTip2.setMaxRenderWidth(260.0f);
        this.txtCell.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    cellTip.setShowing(false);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsViewUI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    cellTip.setShowing(true);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsViewUI.this.handUIException(exc);
                }
            }
        });
        this.txtCell2.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    cellTip2.setShowing(false);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsViewUI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    cellTip2.setShowing(true);
                }
                catch (Exception exc) {
                    ReconciliationOrgSettingsViewUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initCompanyF7() {
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
        f7.setOrgTrees(this.otc);
        OrgViewType[] orgViewTypes = new OrgViewType[]{OrgViewType.COMPANY, OrgViewType.UNIONDEBT};
        f7.setOrgViewType(orgViewTypes);
        f7.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"553_orgF7Title"));
        f7.filterUnitSql(this.getFilterSql());
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        f7.setMultiSelect(false);
        f7.setPermissionItem(null);
        this.prmtCompany.setSelector((KDPromptSelector)f7);
    }

    private String getFilterSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select range.forgid FROM t_pm_orgrange range ");
        sql.append(" inner join t_org_company com On com.fid = range.forgid ");
        sql.append(" where com.fisBizUnit = 1 and com.fisSealUp = 0 and range.ftype = 10 and range.fuserid='");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("' ");
        return sql.toString();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.prmtCompany.setEnabled(true);
        this.prmtCompany.getUI().getButton().setEnabled(true);
        this.pmptFirstContect.setEnabled(true);
        this.pmptFirstContect.getUI().getButton().setEnabled(true);
        this.pmptSecondContect.setEnabled(true);
        this.pmptSecondContect.getUI().getButton().setEnabled(true);
        this.modifyTitle();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckageCompanyFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.editData != null) {
            CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
            info.setId(((OrgUnitInfo)this.prmtCompany.getValue()).getId());
            this.editData.setCompany(info);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void initContect(KDBizPromptBox pmptContect) {
        pmptContect.setEditFormat("$name$");
        pmptContect.setCommitFormat("$name$");
        pmptContect.setDisplayFormat("$name$($number$)");
        pmptContect.setVisible(true);
        pmptContect.setEditable(false);
        pmptContect.setQueryInfo("com.kingdee.eas.fi.newrpt.accountcheck.PersonQuery");
        pmptContect.getComponent(0).setVisible(false);
        pmptContect.setMyCommonUseEnabled(false);
        EntityViewInfo view = pmptContect.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (view.getFilter() == null) {
            view.setFilter(new FilterInfo());
        }
        FilterInfo filter = view.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.name", null, CompareType.ISNOT));
        pmptContect.setEntityViewInfo(view);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String email2;
        String email;
        String cell2;
        String cell;
        String contect2;
        String contect;
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NoSelectCompany"));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)(contect = this.txtFirstContect.getText())) && contect.length() > 120) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "checkageCompany_import_contectTooLong", null));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)(contect2 = this.textSecondContect.getText())) && contect2.length() > 120) {
            MsgBox.showInfo((Component)((Object)this), (String)AccountCheckUtil.getResourceString(null, "checkageCompany_import_contect2TooLong", null));
            SysUtil.abort();
        }
        if ((cell = this.txtCell.getText()) != null && cell.trim().length() > 0 && !Pattern.matches("^[+0-9][\\d-\\s]{" + (cell.trim().length() - 1) + "}", cell)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CellIsError"));
            SysUtil.abort();
        }
        if ((cell2 = this.txtCell2.getText()) != null && cell2.trim().length() > 0 && !Pattern.matches("^[+0-9][\\d-\\s]{" + (cell2.trim().length() - 1) + "}", cell2)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CellIsError"));
            SysUtil.abort();
        }
        if ((email = this.txtEmail.getText()) != null && email.trim().length() > 0 && (email.trim().indexOf("@") < 0 || email.trim().endsWith("@"))) {
            this.txtEmail.requestFocusInWindow();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"EMAIL_ERROR"));
            SysUtil.abort();
        }
        if ((email2 = this.txtEmail2.getText()) != null && email2.trim().length() > 0 && (email2.trim().indexOf("@") < 0 || email2.trim().endsWith("@"))) {
            this.txtEmail2.requestFocusInWindow();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"EMAIL_ERROR"));
            SysUtil.abort();
        }
        String companyID = ((OrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        if (this.getBizInterface().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CompanyExist"));
            SysUtil.abort();
        }
    }

    private void modifyTitle() {
        if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"View"));
        } else {
            this.setUITitle(this.uiTitle + "-" + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"Update"));
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.editData != null && this.prmtCompany.getValue() != null) {
            CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
            info.setId(((OrgUnitInfo)this.prmtCompany.getValue()).getId());
            this.editData.setCompany(info);
        }
    }

    public boolean isModify() {
        if (this.editData == null || OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    @Override
    protected void pmptSecondContect_dataChanged(DataChangeEvent e) throws Exception {
        PersonInfo personInfo = (PersonInfo)this.pmptSecondContect.getValue();
        this.getPersonMessage(personInfo, false);
    }

    @Override
    protected void pmptFirstContect_dataChanged(DataChangeEvent e) throws Exception {
        PersonInfo personInfo = (PersonInfo)this.pmptFirstContect.getValue();
        this.getPersonMessage(personInfo, true);
    }

    private void getPersonMessage(PersonInfo personInfo, boolean isFirstContect) {
        if (personInfo != null && personInfo.getId() != null) {
            String cell = null;
            String email = null;
            cell = personInfo.getCell() != null ? personInfo.getCell() : (personInfo.getBackupCell() != null ? personInfo.getBackupCell() : (personInfo.getOfficePhone() != null ? personInfo.getOfficePhone() : personInfo.getHomePhone()));
            email = personInfo.getEmail() != null ? personInfo.getEmail() : personInfo.getBackupEMail();
            if (isFirstContect) {
                this.txtCell.setText(cell);
                this.txtEmail.setText(email);
                this.txtFirstContect.setText(personInfo.getName());
            } else {
                this.txtCell2.setText(cell);
                this.txtEmail2.setText(email);
                this.textSecondContect.setText(personInfo.getName());
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        String companyID = this.editData.getCompany().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        filterInfo.getFilterItems().add(new FilterItemInfo("targetCompany", (Object)companyID));
        filterInfo.setMaskString("#0 or #1");
        if (CheckageBillFactory.getRemoteInstance().exists(filterInfo)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"No_Delete"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }
}

