/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AbstractReconciliationToleranceSettingEditUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.AccountMappingF7UI;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReconciliationToleranceSettingEditUI
extends AbstractReconciliationToleranceSettingEditUI {
    private static final long serialVersionUID = -1171458367101786562L;
    private static final Logger logger = CoreUIObject.getLogger(ReconciliationToleranceSettingEditUI.class);
    private boolean isSave = false;

    public void onLoad() throws Exception {
        this.initPrmtOrg();
        this.initPrmtMapping();
        this.initCombItemType();
        this.initCombElimType();
        this.initToleranceValue();
        super.onLoad();
        if (!"ADDNEW".equals(this.getOprtState())) {
            ToleranceTypeEnum toleranceType = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem());
            if (toleranceType.getValue() == 1) {
                this.prmtMapping.setEnabled(false);
            }
            this.setMappingData();
            this.setTarOrgData();
        }
    }

    private void initToleranceValue() {
        this.txtValue.setMinimumValue((Comparable)new BigDecimal("000000000000000.000000"));
        this.txtValue.setMaximumValue((Comparable)new BigDecimal("999999999999999.999999"));
    }

    private void setMappingData() throws EASBizException, BOSException {
        if (this.getUIContext().containsKey("mappingId")) {
            String mappingId = (String)this.getUIContext().get("mappingId");
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("elimType"));
            selector.add(new SelectorItemInfo("itemType"));
            selector.add(new SelectorItemInfo("id"));
            AccountMapInfo accountMapInfo = AccountMapFactory.getRemoteInstance().getAccountMapInfo((IObjectPK)new ObjectUuidPK(mappingId), selector);
            this.prmtMapping.setData((Object)accountMapInfo);
            this.editData.setAccountMap(accountMapInfo);
        }
    }

    private void setTarOrgData() throws EASBizException, BOSException {
        if (this.getUIContext().containsKey("tarOrgId")) {
            String tarOrgId = (String)this.getUIContext().get("tarOrgId");
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("id"));
            FullOrgUnitInfo tarOrg = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(tarOrgId));
            this.prmtTarOrg.setData((Object)tarOrg);
            this.editData.setTarOrgUnit(tarOrg);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    private void initPrmtOrg() {
        Set<String> orgIDSet = this.getAuthorizedOrg();
        if (orgIDSet != null && !orgIDSet.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", orgIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            this.prmtOrg.getQueryAgent().setEntityViewInfo(view);
        }
    }

    private void initPrmtMapping() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountMappingF7UI.class.getName(), (Map)uiContext);
        AccountMappingF7UI f7 = (AccountMappingF7UI)uiWindow.getUIObject();
        this.prmtMapping.setSelector((KDPromptSelector)f7);
        this.prmtMapping.addCommitListener((CommitListener)f7);
        this.prmtMapping.setEditFormat("$number$");
        this.prmtMapping.setDisplayFormat("$number$");
        this.prmtMapping.setEditable(true);
        this.prmtMapping.setCommitFormat("$number$");
    }

    private void initCombItemType() {
        this.combItemType.addItem((Object)"");
        this.combItemType.addItems(ItemTypeEnum.getEnumList().toArray());
    }

    private void initCombElimType() {
        this.combElimType.addItem((Object)"");
        this.combElimType.addItem((Object)ElimTypeEnum.ComeAndGo);
        this.combElimType.addItem((Object)ElimTypeEnum.exchange);
    }

    private Set<String> getAuthorizedOrg() {
        HashSet<String> orgIDSet = new HashSet<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("org"));
        view.setSelector(seletor);
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)userID));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        view.setFilter(filter);
        OrgRangeCollection orgRangeCollection = null;
        try {
            orgRangeCollection = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"initMainQuery", (Throwable)e);
        }
        if (orgRangeCollection != null && orgRangeCollection.size() > 0) {
            for (int i = 0; i < orgRangeCollection.size(); ++i) {
                orgIDSet.add(orgRangeCollection.get(i).getOrg().getId().toString());
            }
        }
        return orgIDSet;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ToleranceTypeEnum toleranceTypeEnum;
        super.verifyInput(e);
        if (this.prmtOrg.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"504_orgNull"));
            SysUtil.abort();
        }
        if (0 == (toleranceTypeEnum = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem())).getValue() && this.prmtMapping.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"505_mappingNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtValue.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"506_toleranceNull"));
            SysUtil.abort();
        }
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtOrg.getData();
        String orgId = orgUnit.getId().toString();
        int toleranceType = toleranceTypeEnum.getValue();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        int index = 0;
        String msg = null;
        if (toleranceType == 1) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgId));
            sbFormula.append("#").append(index++);
            filter.getFilterItems().add(new FilterItemInfo("accountMap", null));
            sbFormula.append(" and #").append(index++);
            msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"508_allRepeat");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgId));
            sbFormula.append("#").append(index++);
            if (this.prmtTarOrg.getData() != null) {
                sbFormula = new StringBuffer();
                index = 0;
                sbFormula.append("((#").append(index++);
                FullOrgUnitInfo tarOrg = (FullOrgUnitInfo)this.prmtTarOrg.getData();
                String tarOrgId = tarOrg.getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("tarOrgUnit", (Object)tarOrgId));
                sbFormula.append(" and #").append(index++).append(")");
                filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)tarOrgId));
                filter.getFilterItems().add(new FilterItemInfo("tarOrgUnit", (Object)orgId));
                sbFormula.append(" or (#").append(index++).append(" and #").append(index++).append("))");
                msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"545_oneRepeat");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("tarOrgUnit", null, CompareType.EQUALS));
                sbFormula.append(" and #").append(index++);
                msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"507_oneRepeat");
            }
            AccountMapInfo accountMap = (AccountMapInfo)this.prmtMapping.getData();
            String mappingId = accountMap.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("accountMap", (Object)mappingId));
            sbFormula.append(" and #").append(index++);
        }
        if (this.editData != null && this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
            sbFormula.append(" and #").append(index++);
        }
        filter.setMaskString(sbFormula.toString());
        if (ToleranceFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        return new ToleranceInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ToleranceFactory.getRemoteInstance();
    }

    @Override
    protected void prmtMapping_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtMapping.getData() != null) {
            AccountMapInfo accountMapInfo = (AccountMapInfo)this.prmtMapping.getData();
            ElimTypeEnum elimType = accountMapInfo.getElimType();
            ItemTypeEnum itemType = accountMapInfo.getItemType();
            this.combItemType.setSelectedItem((Object)itemType);
            this.combElimType.setSelectedItem((Object)elimType);
        } else {
            this.combItemType.setSelectedIndex(0);
            this.combElimType.setSelectedIndex(0);
        }
    }

    @Override
    protected void combDefine_itemStateChanged(ItemEvent e) throws Exception {
        ToleranceTypeEnum toleranceType = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem());
        if (toleranceType.getValue() == 1) {
            this.prmtMapping.setData(null);
            this.prmtMapping.setEnabled(false);
            this.prmtTarOrg.setData(null);
            this.prmtTarOrg.setEnabled(false);
        } else {
            this.prmtMapping.setEnabled(true);
            this.prmtTarOrg.setEnabled(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("value"));
        sic.add(new SelectorItemInfo("toleranceType"));
        sic.add(new SelectorItemInfo("remark"));
        return sic;
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setMapData();
        this.setTarOrgUnitData();
        this.prmtMapping.setRequired(false);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setMapData();
        this.setTarOrgUnitData();
        this.prmtMapping.setRequired(false);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setMapData();
        this.setTarOrgUnitData();
        this.prmtMapping.setRequired(false);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setMapData();
        this.setTarOrgUnitData();
        this.prmtMapping.setRequired(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if ("EDIT".equals(this.getOprtState())) {
            this.setMapData();
            this.setTarOrgUnitData();
            this.isSave = true;
        }
    }

    private void setMapData() throws BOSException, EASBizException {
        String id = this.editData.getId().toString();
        if (ToleranceFactory.getRemoteInstance().exists("where id = '" + id + "' and accountMap is not null")) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("accountMap.id"));
            selector.add(new SelectorItemInfo("accountMap.number"));
            selector.add(new SelectorItemInfo("accountMap.elimType"));
            selector.add(new SelectorItemInfo("accountMap.itemType"));
            ToleranceInfo tolerance = ToleranceFactory.getRemoteInstance().getToleranceInfo((IObjectPK)new ObjectUuidPK(id), selector);
            if (tolerance != null && !tolerance.isEmpty() && tolerance.getAccountMap() != null) {
                AccountMapInfo accountMapInfo = tolerance.getAccountMap();
                this.prmtMapping.setData((Object)accountMapInfo);
                this.editData.setAccountMap(accountMapInfo);
            }
        }
    }

    private void setTarOrgUnitData() throws EASBizException, BOSException {
        String id = this.editData.getId().toString();
        if (ToleranceFactory.getRemoteInstance().exists("where id = '" + id + "'")) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("tarOrgUnit.id"));
            selector.add(new SelectorItemInfo("tarOrgUnit.number"));
            selector.add(new SelectorItemInfo("tarOrgUnit.name"));
            ToleranceInfo tolerance = ToleranceFactory.getRemoteInstance().getToleranceInfo((IObjectPK)new ObjectUuidPK(id), selector);
            if (tolerance.getTarOrgUnit() != null) {
                FullOrgUnitInfo tarOrgUnit = tolerance.getTarOrgUnit();
                this.prmtTarOrg.setData((Object)tarOrgUnit);
                this.editData.setTarOrgUnit(tarOrgUnit);
            }
        }
    }

    public boolean isModify() {
        if ("EDIT".equals(this.getOprtState()) && this.isSave) {
            return false;
        }
        return super.isModify();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        ToleranceTypeEnum toleranceType = (ToleranceTypeEnum)((Object)this.combDefine.getSelectedItem());
        if (toleranceType.getValue() == 1) {
            this.prmtMapping.setEnabled(false);
        } else {
            this.prmtMapping.setRequired(true);
        }
    }
}

